/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.channel;

import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\b\u001a\u00020\u000fH\u0016J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/bread_experts_group/channel/ByteArrayChannel;", "Ljava/nio/channels/SeekableByteChannel;", "array", "", "<init>", "([B)V", "getArray", "()[B", "position", "", "read", "dst", "Ljava/nio/ByteBuffer;", "write", "src", "", "newPosition", "size", "truncate", "isOpen", "", "close", "", "bread_server_lib"})
public final class ByteArrayChannel
implements SeekableByteChannel {
    @NotNull
    private final byte[] array;
    private int position;

    public ByteArrayChannel(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        this.array = array;
    }

    @NotNull
    public final byte[] getArray() {
        return this.array;
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        if (this.position == this.array.length) {
            return -1;
        }
        int length = Math.min(this.array.length - this.position, dst.remaining());
        dst.put(this.array, this.position, length);
        this.position += length;
        return length;
    }

    @Override
    public int write(@Nullable ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    @NotNull
    public SeekableByteChannel position(long newPosition) {
        this.position = (int)RangesKt.coerceAtMost(newPosition, Integer.MAX_VALUE);
        return this;
    }

    @Override
    public long size() {
        return this.array.length;
    }

    @Override
    @NotNull
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }
}

