/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.channel;

import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0012\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/channel/ByteBufferChannel;", "Ljava/nio/channels/SeekableByteChannel;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "read", "", "dst", "write", "src", "position", "", "newPosition", "size", "truncate", "isOpen", "", "close", "", "bread_server_lib"})
public final class ByteBufferChannel
implements SeekableByteChannel {
    @NotNull
    private final ByteBuffer buffer;

    public ByteBufferChannel(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.buffer = buffer;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int saved = this.buffer.limit();
        int length = Math.min(this.buffer.remaining(), dst.remaining());
        this.buffer.limit(this.buffer.position() + length);
        dst.put(this.buffer);
        this.buffer.limit(saved);
        return length;
    }

    @Override
    public int write(@Nullable ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() {
        return this.buffer.position();
    }

    @Override
    @NotNull
    public SeekableByteChannel position(long newPosition) {
        this.buffer.position((int)RangesKt.coerceAtMost(newPosition, (long)this.buffer.limit()));
        return this;
    }

    @Override
    public long size() {
        return this.buffer.limit();
    }

    @Override
    @NotNull
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }
}

