/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.channel;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/bread_experts_group/channel/LockedReadableChannel;", "Ljava/nio/channels/ReadableByteChannel;", "buffer", "Ljava/nio/ByteBuffer;", "lock", "Ljava/util/concurrent/Semaphore;", "length", "", "<init>", "(Ljava/nio/ByteBuffer;Ljava/util/concurrent/Semaphore;J)V", "locked", "", "getLocked", "()Z", "setLocked", "(Z)V", "read", "", "dst", "isOpen", "close", "", "toString", "", "bread_server_lib"})
public final class LockedReadableChannel
implements ReadableByteChannel {
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private final Semaphore lock;
    private long length;
    private boolean locked;

    public LockedReadableChannel(@NotNull ByteBuffer buffer, @NotNull Semaphore lock, long length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(lock, "lock");
        this.buffer = buffer;
        this.lock = lock;
        this.length = length;
        if (this.length > 0L) {
            this.lock.acquire();
            this.locked = true;
        }
    }

    public final boolean getLocked() {
        return this.locked;
    }

    public final void setLocked(boolean bl) {
        this.locked = bl;
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        if (!this.locked) {
            return -1;
        }
        int saved = this.buffer.limit();
        int transfer = Math.min(dst.remaining(), (int)RangesKt.coerceAtMost(this.length, Integer.MAX_VALUE));
        this.buffer.limit(this.buffer.position() + transfer);
        dst.put(this.buffer);
        this.buffer.limit(saved);
        this.length -= (long)transfer;
        if (this.length == 0L) {
            this.close();
        }
        return transfer;
    }

    @Override
    public boolean isOpen() {
        return this.locked;
    }

    @Override
    public void close() {
        this.lock.release();
        this.locked = false;
    }

    @NotNull
    public String toString() {
        return "LockedReadableChannel[" + (String)(this.locked ? "Locked, #" + this.length + " bytes" : "Unlocked") + "]";
    }
}

