/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.channel;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/bread_experts_group/channel/SplitReadableChannel;", "T", "Ljava/nio/channels/ReadableByteChannel;", "channels", "", "<init>", "(Ljava/util/Collection;)V", "Lkotlin/collections/ArrayDeque;", "getChannels", "()Lkotlin/collections/ArrayDeque;", "closed", "", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "close", "", "bread_server_lib"})
public class SplitReadableChannel<T extends ReadableByteChannel>
implements ReadableByteChannel {
    @NotNull
    private final ArrayDeque<T> channels;
    private boolean closed;

    public SplitReadableChannel(@NotNull Collection<? extends T> channels) {
        Intrinsics.checkNotNullParameter(channels, "channels");
        this.channels = new ArrayDeque<T>(channels);
    }

    @NotNull
    public final ArrayDeque<T> getChannels() {
        return this.channels;
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        if (this.channels.isEmpty()) {
            return -1;
        }
        int acc = 0;
        while (true) {
            int len;
            if ((len = ((ReadableByteChannel)this.channels.first()).read(dst)) == -1) {
                this.channels.removeFirst();
                if (!this.channels.isEmpty()) continue;
                return acc;
            }
            acc += len;
            if (!dst.hasRemaining()) break;
        }
        return acc;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (ReadableByteChannel c2 : this.channels) {
            ((Channel)c2).close();
        }
    }
}

