/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.channel;

import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/bread_experts_group/channel/WindowedSeekableByteChannel;", "Ljava/nio/channels/SeekableByteChannel;", "base", "start", "", "end", "<init>", "(Ljava/nio/channels/SeekableByteChannel;JJ)V", "getStart", "()J", "getEnd", "position", "size", "newPos", "read", "", "dst", "Ljava/nio/ByteBuffer;", "write", "src", "truncate", "close", "", "isOpen", "", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowedSeekableByteChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowedSeekableByteChannel.kt\norg/bread_experts_group/channel/WindowedSeekableByteChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class WindowedSeekableByteChannel
implements SeekableByteChannel {
    @NotNull
    private final SeekableByteChannel base;
    private final long start;
    private final long end;
    private long position;

    public WindowedSeekableByteChannel(@NotNull SeekableByteChannel base, long start, long end) {
        Intrinsics.checkNotNullParameter(base, "base");
        this.base = base;
        this.start = start;
        this.end = end;
    }

    public final long getStart() {
        return this.start;
    }

    public final long getEnd() {
        return this.end;
    }

    @Override
    public long size() {
        return this.end - this.start;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    @NotNull
    public SeekableByteChannel position(long newPos) {
        if (!(newPos >= 0L && newPos <= this.size())) {
            boolean bl = false;
            String string = "Position out of slice range";
            throw new IllegalArgumentException(string.toString());
        }
        this.position = newPos;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(@NotNull ByteBuffer dst) {
        int n;
        Intrinsics.checkNotNullParameter(dst, "dst");
        SeekableByteChannel seekableByteChannel = this.base;
        synchronized (seekableByteChannel) {
            block4: {
                boolean bl = false;
                if (this.position < this.size()) break block4;
                int n2 = -1;
                return n2;
            }
            long returnTo = this.base.position();
            this.base.position(this.start + this.position);
            int savedLimit = dst.limit();
            int writable = (int)RangesKt.coerceAtMost(Math.min((long)dst.remaining(), this.size() - this.position), Integer.MAX_VALUE);
            dst.limit(dst.position() + writable);
            int read = this.base.read(dst);
            this.position += (long)read;
            dst.limit(savedLimit);
            this.base.position(returnTo);
            n = read;
        }
        return n;
    }

    @Override
    public synchronized int write(@NotNull ByteBuffer src) {
        Intrinsics.checkNotNullParameter(src, "src");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public boolean isOpen() {
        return this.base.isOpen();
    }
}

