/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.channel;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/bread_experts_group/channel/WritingByteBuffer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "to", "Ljava/nio/channels/WritableByteChannel;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/channels/WritableByteChannel;Ljava/nio/ByteBuffer;)V", "getTo", "()Ljava/nio/channels/WritableByteChannel;", "getBuffer", "()Ljava/nio/ByteBuffer;", "empty", "", "amount", "", "put", "src", "", "transferFrom", "from", "Ljava/nio/channels/ReadableByteChannel;", "flush", "close", "bread_server_lib"})
public final class WritingByteBuffer
implements AutoCloseable {
    @NotNull
    private final WritableByteChannel to;
    @NotNull
    private final ByteBuffer buffer;

    public WritingByteBuffer(@NotNull WritableByteChannel to, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.to = to;
        this.buffer = buffer;
    }

    @NotNull
    public final WritableByteChannel getTo() {
        return this.to;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final void empty(int amount) {
        if (this.buffer.remaining() < amount) {
            this.flush();
        }
    }

    public final void put(@NotNull byte[] src) {
        Intrinsics.checkNotNullParameter(src, "src");
        this.empty(src.length);
        this.buffer.put(src);
    }

    public final void transferFrom(@NotNull ReadableByteChannel from) {
        int read;
        Intrinsics.checkNotNullParameter(from, "from");
        do {
            this.empty(1);
        } while ((read = from.read(this.buffer)) != -1);
    }

    public final void flush() {
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            this.to.write(this.buffer);
        }
        this.buffer.clear();
    }

    @Override
    public void close() {
        this.to.close();
    }
}

