/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.decode.png;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import org.bread_experts_group.channel.SplitReadableChannel;
import org.bread_experts_group.coder.format.decode.Decoder;
import org.bread_experts_group.coder.format.decode.TimedBufferedImage;
import org.bread_experts_group.coder.format.decode.png.PNGLineDecoder;
import org.bread_experts_group.coder.format.parse.png.PNGBlendOperation;
import org.bread_experts_group.coder.format.parse.png.PNGDisposeOperation;
import org.bread_experts_group.coder.format.parse.png.PNGHeaderFlags;
import org.bread_experts_group.coder.format.parse.png.PNGInterlaceType;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGHeaderChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\f\u0010'\u001a\u00020(*\u00020(H\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\b\u00103\u001a\u00020\u0002H\u0016Ja\u00104\u001a\u00020.2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d052\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b6\u00107R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\n ,*\u0004\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/bread_experts_group/coder/format/decode/png/PNGImageDecoder;", "Lorg/bread_experts_group/coder/format/decode/Decoder;", "Lorg/bread_experts_group/coder/format/decode/TimedBufferedImage;", "from", "Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGHeaderChunk;", "palette", "", "Ljava/awt/Color;", "paletteTransparency", "", "gamma", "", "background", "<init>", "(Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGHeaderChunk;Ljava/util/List;Ljava/util/List;DLjava/awt/Color;)V", "x", "", "y", "width", "height", "dispose", "Lorg/bread_experts_group/coder/format/parse/png/PNGDisposeOperation;", "blend", "Lorg/bread_experts_group/coder/format/parse/png/PNGBlendOperation;", "delay", "Lkotlin/time/Duration;", "J", "data", "Lorg/bread_experts_group/channel/SplitReadableChannel;", "Ljava/nio/channels/ReadableByteChannel;", "inflater", "Ljava/util/zip/Inflater;", "lineDecoder", "Lorg/bread_experts_group/coder/format/decode/png/PNGLineDecoder;", "gammaLut", "Ljava/awt/image/ByteLookupTable;", "getGammaLut", "()Ljava/awt/image/ByteLookupTable;", "channels", "copy", "Ljava/awt/image/BufferedImage;", "canvas", "inflaterBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "inflate", "", "into", "", "filter", "readInto", "next", "setInput", "", "setInput-Kk497nc", "(Ljava/util/Collection;IIIILorg/bread_experts_group/coder/format/parse/png/PNGDisposeOperation;Lorg/bread_experts_group/coder/format/parse/png/PNGBlendOperation;J)V", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nPNGImageDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PNGImageDecoder.kt\norg/bread_experts_group/coder/format/decode/png/PNGImageDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class PNGImageDecoder
implements Decoder<TimedBufferedImage> {
    @NotNull
    private final PNGHeaderChunk from;
    @Nullable
    private final Color background;
    private int x;
    private int y;
    private int width;
    private int height;
    @NotNull
    private PNGDisposeOperation dispose;
    @NotNull
    private PNGBlendOperation blend;
    private long delay;
    @NotNull
    private SplitReadableChannel<ReadableByteChannel> data;
    @NotNull
    private final Inflater inflater;
    @NotNull
    private final PNGLineDecoder lineDecoder;
    @NotNull
    private final ByteLookupTable gammaLut;
    private final int channels;
    @NotNull
    private BufferedImage canvas;
    private final ByteBuffer inflaterBuffer;
    @NotNull
    private final byte[] filter;
    @NotNull
    private byte[] readInto;

    public PNGImageDecoder(@NotNull PNGHeaderChunk from, @NotNull List<? extends Color> palette, @NotNull List<Float> paletteTransparency, double gamma, @Nullable Color background) {
        BufferedImage bufferedImage;
        BufferedImage it;
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(palette, "palette");
        Intrinsics.checkNotNullParameter(paletteTransparency, "paletteTransparency");
        this.from = from;
        this.background = background;
        this.dispose = PNGDisposeOperation.APNG_DISPOSE_OP_NONE;
        this.blend = PNGBlendOperation.APNG_BLEND_OP_OVER;
        this.delay = Duration.Companion.getINFINITE-UwyO8pc();
        this.data = new SplitReadableChannel(CollectionsKt.emptyList());
        this.inflater = new Inflater();
        this.lineDecoder = new PNGLineDecoder(this.from, palette, paletteTransparency);
        int n = 0;
        byte[] byArray = new byte[256];
        PNGImageDecoder pNGImageDecoder = this;
        while (n < 256) {
            int n2 = n++;
            double corrected = 255.0 * Math.pow((double)n2 / 255.0, 1.0 / gamma);
            byArray[n2] = (byte)RangesKt.coerceIn((int)corrected, 0, 255);
        }
        boolean bl = false;
        Object object = new byte[][]{it, it, it};
        pNGImageDecoder.gammaLut = new ByteLookupTable(0, (byte[][])object);
        this.channels = this.from.getFlags().contains(PNGHeaderFlags.PALETTE) ? 1 : (this.from.getFlags().contains(PNGHeaderFlags.TRUE_COLOR) ? 3 : 1) + (this.from.getFlags().contains(PNGHeaderFlags.ALPHA) ? 1 : 0);
        it = bufferedImage = new BufferedImage(this.from.getWidth(), this.from.getHeight(), 2);
        pNGImageDecoder = this;
        boolean bl2 = false;
        byte[][] $this$canvas_u24lambda_u242_u24lambda_u241 = object = (Object)it.createGraphics();
        boolean bl3 = false;
        $this$canvas_u24lambda_u242_u24lambda_u241.setColor(this.background);
        $this$canvas_u24lambda_u242_u24lambda_u241.fillRect(0, 0, it.getWidth(), it.getHeight());
        $this$canvas_u24lambda_u242_u24lambda_u241.dispose();
        pNGImageDecoder.canvas = bufferedImage;
        this.inflaterBuffer = ByteBuffer.allocateDirect(8192);
        this.filter = new byte[1];
        this.readInto = new byte[0];
    }

    public /* synthetic */ PNGImageDecoder(PNGHeaderChunk pNGHeaderChunk, List list, List list2, double d, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            d = 1.0;
        }
        if ((n & 0x10) != 0) {
            color = null;
        }
        this(pNGHeaderChunk, list, list2, d, color);
    }

    @NotNull
    public final ByteLookupTable getGammaLut() {
        return this.gammaLut;
    }

    private final BufferedImage copy(BufferedImage $this$copy) {
        return new BufferedImage($this$copy.getColorModel(), $this$copy.copyData(null), $this$copy.isAlphaPremultiplied(), null);
    }

    public final void inflate(@NotNull byte[] into) {
        Intrinsics.checkNotNullParameter(into, "into");
        int inflated = 0;
        while (inflated < into.length) {
            int n = this.inflater.inflate(into, inflated, into.length - inflated);
            if (n == 0) {
                this.inflaterBuffer.clear();
                ByteBuffer byteBuffer = this.inflaterBuffer;
                Intrinsics.checkNotNullExpressionValue(byteBuffer, "inflaterBuffer");
                this.data.read(byteBuffer);
                this.inflaterBuffer.flip();
                this.inflater.setInput(this.inflaterBuffer);
                continue;
            }
            inflated += n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TimedBufferedImage next() {
        Graphics2D lY2;
        if (WhenMappings.$EnumSwitchMapping$0[this.from.getInterlaceType().ordinal()] != 1) throw new UnsupportedOperationException(this.from.getInterlaceType().toString());
        int strideSize = (this.width * this.from.getBitDepth() * this.channels + 7) / 8;
        if (this.readInto.length != strideSize) {
            this.readInto = new byte[strideSize];
        }
        BufferedImage precopy = null;
        if (this.dispose == PNGDisposeOperation.APNG_DISPOSE_OP_PREVIOUS) {
            precopy = this.copy(this.canvas);
        }
        BufferedImage blendImg = new BufferedImage(this.width, this.height, 2);
        int[] line = new int[this.width];
        this.lineDecoder.reset();
        int n = this.height;
        for (int lY2 = 0; lY2 < n; ++lY2) {
            this.inflate(this.filter);
            this.inflate(this.readInto);
            this.lineDecoder.setInput(this.filter[0] & 0xFF, this.readInto);
            this.lineDecoder.next(line);
            blendImg.setRGB(0, lY2, this.width, 1, line, 0, 0);
        }
        new LookupOp(this.gammaLut, null).filter(blendImg, blendImg);
        Graphics2D $this$next_u24lambda_u243 = lY2 = this.canvas.createGraphics();
        boolean bl = false;
        $this$next_u24lambda_u243.setComposite(switch (WhenMappings.$EnumSwitchMapping$1[this.blend.ordinal()]) {
            case 1 -> AlphaComposite.Src;
            case 2 -> AlphaComposite.SrcOver;
            default -> throw new NoWhenBranchMatchedException();
        });
        $this$next_u24lambda_u243.drawImage((Image)blendImg, this.x, this.y, null);
        $this$next_u24lambda_u243.dispose();
        BufferedImage bufferedImage = this.copy(this.canvas);
        switch (WhenMappings.$EnumSwitchMapping$2[this.dispose.ordinal()]) {
            case 1: {
                return new TimedBufferedImage(bufferedImage, this.delay, null);
            }
            case 2: {
                int[] zeroRow = new int[this.width];
                int yy = this.y;
                int n2 = this.y + this.height;
                while (yy < n2) {
                    this.canvas.setRGB(this.x, yy, this.width, 1, zeroRow, 0, 0);
                    ++yy;
                }
                return new TimedBufferedImage(bufferedImage, this.delay, null);
            }
            case 3: {
                BufferedImage bufferedImage2 = precopy;
                if (bufferedImage2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("precopy");
                    bufferedImage2 = null;
                }
                this.canvas = bufferedImage2;
                return new TimedBufferedImage(bufferedImage, this.delay, null);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final void setInput-Kk497nc(@NotNull Collection<? extends ReadableByteChannel> data, int x, int y, int width, int height, @NotNull PNGDisposeOperation dispose, @NotNull PNGBlendOperation blend, long delay) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(dispose, "dispose");
        Intrinsics.checkNotNullParameter(blend, "blend");
        this.data = new SplitReadableChannel<ReadableByteChannel>(data);
        this.inflater.reset();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.dispose = dispose;
        this.blend = blend;
        this.delay = delay;
    }

    public static /* synthetic */ void setInput-Kk497nc$default(PNGImageDecoder pNGImageDecoder, Collection collection, int n, int n2, int n3, int n4, PNGDisposeOperation pNGDisposeOperation, PNGBlendOperation pNGBlendOperation, long l, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n = 0;
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = pNGImageDecoder.from.getWidth();
        }
        if ((n5 & 0x10) != 0) {
            n4 = pNGImageDecoder.from.getHeight();
        }
        if ((n5 & 0x20) != 0) {
            pNGDisposeOperation = PNGDisposeOperation.APNG_DISPOSE_OP_NONE;
        }
        if ((n5 & 0x40) != 0) {
            pNGBlendOperation = pNGImageDecoder.blend;
        }
        if ((n5 & 0x80) != 0) {
            l = Duration.Companion.getINFINITE-UwyO8pc();
        }
        pNGImageDecoder.setInput-Kk497nc(collection, n, n2, n3, n4, pNGDisposeOperation, pNGBlendOperation, l);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[PNGInterlaceType.values().length];
            try {
                nArray[PNGInterlaceType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PNGBlendOperation.values().length];
            try {
                nArray[PNGBlendOperation.APNG_BLEND_OP_SOURCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PNGBlendOperation.APNG_BLEND_OP_OVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PNGDisposeOperation.values().length];
            try {
                nArray[PNGDisposeOperation.APNG_DISPOSE_OP_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PNGDisposeOperation.APNG_DISPOSE_OP_BACKGROUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PNGDisposeOperation.APNG_DISPOSE_OP_PREVIOUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

