/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/bread_experts_group/coder/format/parse/BitInputStream;", "Ljava/io/InputStream;", "from", "<init>", "(Ljava/io/InputStream;)V", "read", "", "maskOn", "", "maskPosition", "available", "nextBit", "", "bread_server_lib"})
public class BitInputStream
extends InputStream {
    @NotNull
    private final InputStream from;
    private int maskOn;
    private int maskPosition;

    public BitInputStream(@NotNull InputStream from) {
        Intrinsics.checkNotNullParameter(from, "from");
        this.from = from;
        this.maskOn = -1;
        this.maskPosition = -1;
    }

    @NotNull
    public Void read() {
        throw new UnsupportedOperationException("Use readBit() instead");
    }

    @Override
    public int available() {
        return this.from.available() * 8 + (this.maskOn != -1 ? this.maskPosition : 0);
    }

    public final boolean nextBit() {
        if (this.maskPosition == -1) {
            this.maskPosition = 7;
            this.maskOn = this.from.read();
        }
        int n = this.maskPosition;
        this.maskPosition = n + -1;
        int updatedMask = n;
        return (this.maskOn & 1 << updatedMask) >> updatedMask != 0;
    }
}

