/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.asn1;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.CodingException;
import org.bread_experts_group.coder.CompoundThrowable;
import org.bread_experts_group.coder.Mappable;
import org.bread_experts_group.coder.MappedEnumeration;
import org.bread_experts_group.coder.format.parse.Parser;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Boolean;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Element;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementClass;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementConstruction;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementIdentifier;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Integer;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Sequence;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Set;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1String;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Tag;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1UTCTime;
import org.bread_experts_group.stream.FailQuickInputStream;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u001a\u0010\t\u001a\u00020\u00032\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/bread_experts_group/coder/format/parse/asn1/ASN1Parser;", "Lorg/bread_experts_group/coder/format/parse/Parser;", "Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementIdentifier;", "Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1Element;", "Ljava/io/InputStream;", "<init>", "()V", "responsibleStream", "of", "readBase", "compound", "Lorg/bread_experts_group/coder/CompoundThrowable;", "Lorg/bread_experts_group/coder/CodingException;", "Lorg/bread_experts_group/coder/format/parse/CodingCompoundThrowable;", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nASN1Parser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASN1Parser.kt\norg/bread_experts_group/coder/format/parse/asn1/ASN1Parser\n+ 2 Mappable.kt\norg/bread_experts_group/coder/Mappable$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n14#2,2:83\n16#2:86\n18#2,2:88\n14#2,2:90\n16#2:93\n18#2,2:95\n14#2,2:97\n16#2:100\n18#2,2:102\n295#3:85\n296#3:87\n295#3:92\n296#3:94\n295#3:99\n296#3:101\n*S KotlinDebug\n*F\n+ 1 ASN1Parser.kt\norg/bread_experts_group/coder/format/parse/asn1/ASN1Parser\n*L\n20#1:83,2\n20#1:86\n20#1:88,2\n21#1:90,2\n21#1:93\n21#1:95,2\n22#1:97,2\n22#1:100\n22#1:102,2\n20#1:85\n20#1:87\n21#1:92\n21#1:94\n22#1:99\n22#1:101\n*E\n"})
public final class ASN1Parser
extends Parser<ASN1ElementIdentifier, ASN1Element, InputStream> {
    public ASN1Parser() {
        super("Abstract Syntax Notation One", Reflection.getOrCreateKotlinClass(InputStream.class));
        this.addPredicateParser(ASN1Parser::_init_$lambda$2, ASN1Parser::_init_$lambda$3);
        this.addPredicateParser(ASN1Parser::_init_$lambda$4, ASN1Parser::_init_$lambda$5);
        this.addPredicateParser(ASN1Parser::_init_$lambda$6, ASN1Parser::_init_$lambda$7);
        this.addPredicateParser(ASN1Parser::_init_$lambda$8, ASN1Parser::_init_$lambda$9);
        this.addPredicateParser(ASN1Parser::_init_$lambda$10, ASN1Parser::_init_$lambda$11);
        this.addPredicateParser(ASN1Parser::_init_$lambda$12, ASN1Parser::_init_$lambda$13);
        this.addPredicateParser(ASN1Parser::_init_$lambda$14, ASN1Parser::_init_$lambda$15);
        this.addPredicateParser(ASN1Parser::_init_$lambda$16, ASN1Parser::_init_$lambda$17);
    }

    @Override
    @NotNull
    protected InputStream responsibleStream(@NotNull ASN1Element of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return new ByteArrayInputStream(of.getData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ASN1Element readBase(@NotNull CompoundThrowable<CodingException> compound) {
        int n;
        void it;
        Object v4;
        ASN1ElementConstruction aSN1ElementConstruction;
        ASN1ElementClass aSN1ElementClass;
        Integer n$iv;
        int n2;
        block11: {
            Object v2;
            Mappable.Companion this_$iv;
            boolean bl;
            Enum it$iv;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv$iv;
            EnumEntries<Enum> $this$id$iv;
            boolean $i$f$id;
            int it2;
            block10: {
                Object v0;
                block9: {
                    Intrinsics.checkNotNullParameter(compound, "compound");
                    it2 = this.getFqIn().read();
                    n2 = 0;
                    Mappable.Companion companion = Mappable.Companion;
                    EnumEntries<ASN1ElementClass> enumEntries = ASN1ElementClass.getEntries();
                    n$iv = it2 >> 6;
                    $i$f$id = false;
                    $this$firstOrNull$iv$iv = $this$id$iv;
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                        it$iv = (Enum)element$iv$iv;
                        bl = false;
                        if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                        v0 = element$iv$iv;
                        break block9;
                    }
                    v0 = null;
                }
                Integer n3 = n$iv;
                Enum enum_ = v0;
                Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n3).getEnum();
                Intrinsics.checkNotNull(enum_2);
                this_$iv = Mappable.Companion;
                $this$id$iv = ASN1ElementConstruction.getEntries();
                n$iv = it2 >> 5 & 1;
                aSN1ElementClass = (ASN1ElementClass)enum_2;
                $i$f$id = false;
                $this$firstOrNull$iv$iv = $this$id$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Enum)element$iv$iv;
                    bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v2 = element$iv$iv;
                    break block10;
                }
                v2 = null;
            }
            Integer n4 = n$iv;
            Enum enum_ = v2;
            Enum enum_3 = new MappedEnumeration<Integer, Enum>(enum_, n4).getEnum();
            Intrinsics.checkNotNull(enum_3);
            this_$iv = Mappable.Companion;
            $this$id$iv = ASN1Tag.getEntries();
            n$iv = it2 & 0x1F;
            aSN1ElementConstruction = (ASN1ElementConstruction)enum_3;
            $i$f$id = false;
            $this$firstOrNull$iv$iv = $this$id$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                it$iv = (Enum)element$iv$iv;
                bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v4 = element$iv$iv;
                break block11;
            }
            v4 = null;
        }
        Integer n5 = n$iv;
        Enum enum_ = v4;
        MappedEnumeration<Integer, Enum> mappedEnumeration = new MappedEnumeration<Integer, Enum>(enum_, n5);
        Enum enum_4 = mappedEnumeration.getEnum();
        Intrinsics.checkNotNull(enum_4);
        ASN1Tag aSN1Tag = (ASN1Tag)enum_4;
        ASN1ElementConstruction aSN1ElementConstruction2 = aSN1ElementConstruction;
        ASN1ElementClass aSN1ElementClass2 = aSN1ElementClass;
        n2 = this.getFqIn().read();
        FailQuickInputStream failQuickInputStream = this.getFqIn();
        ASN1ElementIdentifier aSN1ElementIdentifier = new ASN1ElementIdentifier(aSN1ElementClass2, aSN1ElementConstruction2, aSN1Tag);
        boolean bl = false;
        if (it < 128) {
            n = it;
        } else {
            int bytes = it & 0xFFFFFF7F;
            switch (bytes) {
                case 1: {
                    n = this.getFqIn().read();
                    break;
                }
                case 2: {
                    n = SocketUtilKt.read16ui(this.getFqIn());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(bytes));
                }
            }
        }
        void var19_30 = n;
        byte[] byArray = failQuickInputStream.readNBytes((int)var19_30);
        Intrinsics.checkNotNullExpressionValue(byArray, "readNBytes(...)");
        byte[] byArray2 = byArray;
        ASN1ElementIdentifier aSN1ElementIdentifier2 = aSN1ElementIdentifier;
        return new ASN1Element(aSN1ElementIdentifier2, byArray2);
    }

    private static final boolean _init_$lambda$2(ASN1Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().getTag() == ASN1Tag.BOOLEAN;
    }

    private static final ASN1Element _init_$lambda$3(InputStream stream, ASN1Element aSN1Element, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(aSN1Element, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new ASN1Boolean(stream.read() == 255);
    }

    private static final boolean _init_$lambda$4(ASN1Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().getTag() == ASN1Tag.INTEGER;
    }

    private static final ASN1Element _init_$lambda$5(InputStream inputStream, ASN1Element element, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(inputStream, "<unused var>");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new ASN1Integer(new BigInteger(element.getData()));
    }

    private static final boolean _init_$lambda$6(ASN1Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().getTag() == ASN1Tag.UTF8_STRING;
    }

    private static final ASN1Element _init_$lambda$7(InputStream stream, ASN1Element element, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ASN1ElementIdentifier aSN1ElementIdentifier = element.getTag();
        byte[] byArray = stream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        return new ASN1String(aSN1ElementIdentifier, new String(byArray2, charset));
    }

    private static final boolean _init_$lambda$8(ASN1Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().getTag() == ASN1Tag.PRINTABLE_STRING;
    }

    private static final ASN1Element _init_$lambda$9(InputStream stream, ASN1Element element, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ASN1ElementIdentifier aSN1ElementIdentifier = element.getTag();
        byte[] byArray = stream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.ISO_8859_1;
        return new ASN1String(aSN1ElementIdentifier, new String(byArray2, charset));
    }

    private static final boolean _init_$lambda$10(ASN1Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().getTag() == ASN1Tag.IA5_STRING;
    }

    private static final ASN1Element _init_$lambda$11(InputStream stream, ASN1Element element, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ASN1ElementIdentifier aSN1ElementIdentifier = element.getTag();
        byte[] byArray = stream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.US_ASCII;
        return new ASN1String(aSN1ElementIdentifier, new String(byArray2, charset));
    }

    private static final boolean _init_$lambda$12(ASN1Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().getTag() == ASN1Tag.SEQUENCE;
    }

    private static final ASN1Element _init_$lambda$13(InputStream stream, ASN1Element element, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new ASN1Sequence(element.getTag(), element.getData());
    }

    private static final boolean _init_$lambda$14(ASN1Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().getTag() == ASN1Tag.SET;
    }

    private static final ASN1Element _init_$lambda$15(InputStream stream, ASN1Element element, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new ASN1Set(element.getTag(), element.getData());
    }

    private static final boolean _init_$lambda$16(ASN1Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().getTag() == ASN1Tag.UTC_TIME;
    }

    private static final ASN1Element _init_$lambda$17(InputStream stream, ASN1Element element, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new ASN1UTCTime(element.getTag(), new String(element.getData(), Charsets.US_ASCII));
    }
}

