/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.asn1.element;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementClass;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementConstruction;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementIdentifier;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Tag;
import org.bread_experts_group.stream.Tagged;
import org.bread_experts_group.stream.Writable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1Element;", "Lorg/bread_experts_group/stream/Writable;", "Lorg/bread_experts_group/stream/Tagged;", "Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementIdentifier;", "tag", "data", "", "<init>", "(Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementIdentifier;[B)V", "t", "", "d", "(I[B)V", "getTag", "()Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementIdentifier;", "getData", "()[B", "toString", "", "computeSize", "", "write", "", "stream", "Ljava/io/OutputStream;", "bread_server_lib"})
public class ASN1Element
implements Writable,
Tagged<ASN1ElementIdentifier> {
    @NotNull
    private final ASN1ElementIdentifier tag;
    @NotNull
    private final byte[] data;

    public ASN1Element(@NotNull ASN1ElementIdentifier tag, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(data, "data");
        this.tag = tag;
        this.data = data;
    }

    public /* synthetic */ ASN1Element(ASN1ElementIdentifier aSN1ElementIdentifier, byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            byArray = new byte[]{};
        }
        this(aSN1ElementIdentifier, byArray);
    }

    @Override
    @NotNull
    public ASN1ElementIdentifier getTag() {
        return this.tag;
    }

    @NotNull
    public byte[] getData() {
        return this.data;
    }

    public ASN1Element(int t, @NotNull byte[] d) {
        Intrinsics.checkNotNullParameter(d, "d");
        this(new ASN1ElementIdentifier(ASN1ElementClass.CONTEXT_SPECIFIC, ASN1ElementConstruction.PRIMITIVE, ASN1Tag.NULL), d);
    }

    @NotNull
    public String toString() {
        return "ASN1Element." + this.getTag() + "[#" + this.getData().length + "]";
    }

    @Override
    public long computeSize() {
        return this.getData().length;
    }

    @Override
    public final void write(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        this.getTag().write(stream);
        long size = this.computeSize();
        if (size < 128L) {
            stream.write((int)size);
        } else {
            long remainder;
            int bytes = 0;
            for (remainder = size; remainder > 0L; remainder >>= 8) {
                ++bytes;
            }
            stream.write(128 + bytes);
            for (remainder = size; remainder > 0L; remainder >>= 8) {
                stream.write((int)(remainder & 0xFFL));
            }
        }
        stream.write(this.getData());
    }

    @Override
    @NotNull
    public byte[] asBytes() {
        return Writable.super.asBytes();
    }
}

