/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.asn1.element;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementClass;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementConstruction;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Tag;
import org.bread_experts_group.stream.Writable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementIdentifier;", "Lorg/bread_experts_group/stream/Writable;", "clazz", "Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementClass;", "construction", "Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementConstruction;", "tag", "Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1Tag;", "<init>", "(Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementClass;Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementConstruction;Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1Tag;)V", "getClazz", "()Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementClass;", "getConstruction", "()Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementConstruction;", "getTag", "()Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1Tag;", "toString", "", "write", "", "stream", "Ljava/io/OutputStream;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "bread_server_lib"})
public final class ASN1ElementIdentifier
implements Writable {
    @NotNull
    private final ASN1ElementClass clazz;
    @NotNull
    private final ASN1ElementConstruction construction;
    @NotNull
    private final ASN1Tag tag;

    public ASN1ElementIdentifier(@NotNull ASN1ElementClass clazz, @NotNull ASN1ElementConstruction construction, @NotNull ASN1Tag tag) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(construction, "construction");
        Intrinsics.checkNotNullParameter(tag, "tag");
        this.clazz = clazz;
        this.construction = construction;
        this.tag = tag;
    }

    @NotNull
    public final ASN1ElementClass getClazz() {
        return this.clazz;
    }

    @NotNull
    public final ASN1ElementConstruction getConstruction() {
        return this.construction;
    }

    @NotNull
    public final ASN1Tag getTag() {
        return this.tag;
    }

    @NotNull
    public String toString() {
        return "[" + this.tag + " : " + this.clazz + " / " + this.construction + "]";
    }

    @Override
    public void write(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        int base = this.clazz.getId() << 6 | this.construction.getId() << 5 | RangesKt.coerceAtMost(this.tag.getId(), 31);
        if (this.tag.getId() > 31) {
            throw new IllegalArgumentException(String.valueOf(this.tag.getId()));
        }
        stream.write(base);
    }

    @NotNull
    public final ASN1ElementClass component1() {
        return this.clazz;
    }

    @NotNull
    public final ASN1ElementConstruction component2() {
        return this.construction;
    }

    @NotNull
    public final ASN1Tag component3() {
        return this.tag;
    }

    @NotNull
    public final ASN1ElementIdentifier copy(@NotNull ASN1ElementClass clazz, @NotNull ASN1ElementConstruction construction, @NotNull ASN1Tag tag) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(construction, "construction");
        Intrinsics.checkNotNullParameter(tag, "tag");
        return new ASN1ElementIdentifier(clazz, construction, tag);
    }

    public static /* synthetic */ ASN1ElementIdentifier copy$default(ASN1ElementIdentifier aSN1ElementIdentifier, ASN1ElementClass aSN1ElementClass, ASN1ElementConstruction aSN1ElementConstruction, ASN1Tag aSN1Tag, int n, Object object) {
        if ((n & 1) != 0) {
            aSN1ElementClass = aSN1ElementIdentifier.clazz;
        }
        if ((n & 2) != 0) {
            aSN1ElementConstruction = aSN1ElementIdentifier.construction;
        }
        if ((n & 4) != 0) {
            aSN1Tag = aSN1ElementIdentifier.tag;
        }
        return aSN1ElementIdentifier.copy(aSN1ElementClass, aSN1ElementConstruction, aSN1Tag);
    }

    public int hashCode() {
        int result = this.clazz.hashCode();
        result = result * 31 + this.construction.hashCode();
        result = result * 31 + this.tag.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ASN1ElementIdentifier)) {
            return false;
        }
        ASN1ElementIdentifier aSN1ElementIdentifier = (ASN1ElementIdentifier)other;
        if (this.clazz != aSN1ElementIdentifier.clazz) {
            return false;
        }
        if (this.construction != aSN1ElementIdentifier.construction) {
            return false;
        }
        return this.tag == aSN1ElementIdentifier.tag;
    }

    @Override
    public long computeSize() {
        return Writable.super.computeSize();
    }

    @Override
    @NotNull
    public byte[] asBytes() {
        return Writable.super.asBytes();
    }
}

