/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.asn1.element;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1Element;
import org.bread_experts_group.coder.format.parse.asn1.element.ASN1ElementIdentifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1UTCTime;", "Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1Element;", "id", "Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementIdentifier;", "time", "", "<init>", "(Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementIdentifier;Ljava/lang/String;)V", "Ljava/time/ZonedDateTime;", "(Lorg/bread_experts_group/coder/format/parse/asn1/element/ASN1ElementIdentifier;Ljava/time/ZonedDateTime;)V", "getTime", "()Ljava/lang/String;", "toString", "bread_server_lib"})
public final class ASN1UTCTime
extends ASN1Element {
    @NotNull
    private final String time;

    public ASN1UTCTime(@NotNull ASN1ElementIdentifier id, @NotNull String time) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(time, "time");
        byte[] byArray = time.getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        super(id, byArray);
        this.time = time;
    }

    @NotNull
    public final String getTime() {
        return this.time;
    }

    public ASN1UTCTime(@NotNull ASN1ElementIdentifier id, @NotNull ZonedDateTime time) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(time, "time");
        String string = DateTimeFormatter.ofPattern("yyMMddHHmmssxx").format(time);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        this(id, string);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getTag() + "[\"" + this.time + "\"]";
    }
}

