/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.elf;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArrayDeque;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.HexExtensionsKt;
import org.bread_experts_group.coder.CodingException;
import org.bread_experts_group.coder.CompoundThrowable;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.bread_experts_group.coder.format.parse.Parser;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeader;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeaderBits;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeaderEndian;
import org.bread_experts_group.coder.format.parse.elf.header.ELFProgramHeader;
import org.bread_experts_group.coder.format.parse.elf.header.ELFWrittenSectionHeader;
import org.bread_experts_group.coder.format.parse.elf.header.writer.ELFContextuallyWritable;
import org.bread_experts_group.stream.FailQuickInputStream;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0003H\u0014J\u001a\u0010\u000b\u001a\u00020\u00032\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/bread_experts_group/coder/format/parse/elf/ELFParser;", "Lorg/bread_experts_group/coder/format/parse/Parser;", "", "Lorg/bread_experts_group/coder/format/parse/elf/header/writer/ELFContextuallyWritable;", "Ljava/io/FileInputStream;", "<init>", "()V", "preread", "Lkotlin/collections/ArrayDeque;", "responsibleStream", "of", "readBase", "compound", "Lorg/bread_experts_group/coder/CompoundThrowable;", "Lorg/bread_experts_group/coder/CodingException;", "Lorg/bread_experts_group/coder/format/parse/CodingCompoundThrowable;", "inputInit", "", "Companion", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nELFParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ELFParser.kt\norg/bread_experts_group/coder/format/parse/elf/ELFParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1#2:156\n1869#3,2:157\n*S KotlinDebug\n*F\n+ 1 ELFParser.kt\norg/bread_experts_group/coder/format/parse/elf/ELFParser\n*L\n81#1:157,2\n*E\n"})
public final class ELFParser
extends Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayDeque<ELFContextuallyWritable> preread = new ArrayDeque();
    @NotNull
    private static final byte[] goodSignature;

    public ELFParser() {
        super("Executable and Linkable Format", Reflection.getOrCreateKotlinClass(FileInputStream.class));
    }

    @NotNull
    protected FileInputStream responsibleStream(@NotNull ELFContextuallyWritable of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return (FileInputStream)this.getFqIn().getFrom();
    }

    @NotNull
    protected ELFContextuallyWritable readBase(@NotNull CompoundThrowable<CodingException> compound) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        ELFContextuallyWritable eLFContextuallyWritable = this.preread.removeFirstOrNull();
        if (eLFContextuallyWritable == null) {
            throw new FailQuickInputStream.EndOfStream();
        }
        return eLFContextuallyWritable;
    }

    @Override
    public void inputInit() {
        byte[] signature = this.getFqIn().readNBytes(4);
        if (!Arrays.equals(signature, goodSignature)) {
            boolean $i$a$-require-ELFParser$inputInit$22 = false;
            Intrinsics.checkNotNull(signature);
            String $i$a$-require-ELFParser$inputInit$22 = "ELF signature mismatch; [" + HexExtensionsKt.toHexString$default(signature, null, 1, null) + " =/= " + HexExtensionsKt.toHexString$default(goodSignature, null, 1, null) + "]";
            throw new IllegalArgumentException($i$a$-require-ELFParser$inputInit$22.toString());
        }
        int bitsRaw = this.getFqIn().read();
        ELFHeaderBits bits = ELFHeaderBits.Companion.getMapping().get(bitsRaw);
        if (bits == null) {
            throw new InvalidInputException("Unknown ELF bits [" + bitsRaw + "]", null, 2, null);
        }
        int endianRaw = this.getFqIn().read();
        ELFHeaderEndian endian = ELFHeaderEndian.Companion.getMapping().get(endianRaw);
        if (endian == null) {
            throw new InvalidInputException("Unknown ELF endian [" + endianRaw + "]", null, 2, null);
        }
        int version = this.getFqIn().read();
        if (version != 1) {
            this.getLogger().warning("Unknown ELF version(1) [" + version + "]");
        }
        int abiRaw = this.getFqIn().read();
        int abiVersion = this.getFqIn().read();
        this.getFqIn().skip(7L);
        short objectTypeRaw = ELFParser.inputInit$re(SocketUtilKt.read16(this.getFqIn()), endian);
        short isaRaw = ELFParser.inputInit$re(SocketUtilKt.read16(this.getFqIn()), endian);
        int version2 = ELFParser.inputInit$re$1(SocketUtilKt.read32(this.getFqIn()), endian);
        if (version2 != 1) {
            this.getLogger().warning("Unknown ELF version(2) [" + version2 + "]");
        }
        long it = ELFParser.inputInit$readBits(this.getFqIn(), bits, endian);
        boolean bl = false;
        Long entryPoint = it == 0L ? null : Long.valueOf(it);
        long programHeaderOffset = ELFParser.inputInit$readBits(this.getFqIn(), bits, endian);
        long sectionHeaderOffset = ELFParser.inputInit$readBits(this.getFqIn(), bits, endian);
        int isaFlags = ELFParser.inputInit$re$1(SocketUtilKt.read32(this.getFqIn()), endian);
        this.getFqIn().skip(2L);
        short programHeaderEntrySize = ELFParser.inputInit$re(SocketUtilKt.read16(this.getFqIn()), endian);
        short programHeaderEntries = ELFParser.inputInit$re(SocketUtilKt.read16(this.getFqIn()), endian);
        short sectionHeaderEntrySize = ELFParser.inputInit$re(SocketUtilKt.read16(this.getFqIn()), endian);
        int sectionHeaderEntries = ELFParser.inputInit$re(SocketUtilKt.read16(this.getFqIn()), endian);
        short sectionNamesIndex = ELFParser.inputInit$re(SocketUtilKt.read16(this.getFqIn()), endian);
        this.preread.add(new ELFHeader(bits, endian, version, abiRaw, abiVersion, objectTypeRaw, isaRaw, version2, entryPoint, isaFlags));
        ((FileInputStream)this.getFqIn().getFrom()).getChannel().position(programHeaderOffset);
        Iterable $this$forEach$iv = RangesKt.until(0, (int)programHeaderEntries);
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            boolean bl2;
            long alignment;
            byte[] byArray;
            int element$iv = ((IntIterator)object).nextInt();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(this.getFqIn().readNBytes(programHeaderEntrySize), "readNBytes(...)");
            ByteArrayInputStream local = new ByteArrayInputStream(byArray);
            int rawType = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            if (bits == ELFHeaderBits.BIT_64) {
                int rawFlags = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
                long fileOffset = ELFParser.inputInit$re$2(SocketUtilKt.read64(local), endian);
                long virtualAddress = ELFParser.inputInit$re$2(SocketUtilKt.read64(local), endian);
                long physicalAddress = ELFParser.inputInit$re$2(SocketUtilKt.read64(local), endian);
                long fileSize = ELFParser.inputInit$re$2(SocketUtilKt.read64(local), endian);
                if (fileSize > Integer.MAX_VALUE) {
                    throw new NotImplementedError("Size too large!");
                }
                long memorySize = ELFParser.inputInit$re$2(SocketUtilKt.read64(local), endian);
                alignment = ELFParser.inputInit$re$2(SocketUtilKt.read64(local), endian);
                bl2 = this.preread.add(new ELFProgramHeader(rawType, rawFlags, virtualAddress, physicalAddress, fileOffset, fileSize, memorySize, alignment, false, 256, null));
                continue;
            }
            long fileOffset = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            long virtualAddress = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            long physicalAddress = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            long fileSize = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            if (fileSize > Integer.MAX_VALUE) {
                throw new NotImplementedError("Size too large!");
            }
            long memorySize = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            int rawFlags = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            alignment = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            bl2 = this.preread.add(new ELFProgramHeader(rawType, rawFlags, virtualAddress, physicalAddress, fileOffset, fileSize, memorySize, alignment, false, 256, null));
        }
        ((FileInputStream)this.getFqIn().getFrom()).getChannel().position(sectionHeaderOffset);
        for (int index = 0; index < sectionHeaderEntries; ++index) {
            byte[] byArray = this.getFqIn().readNBytes(sectionHeaderEntrySize);
            Intrinsics.checkNotNullExpressionValue(byArray, "readNBytes(...)");
            object = byArray;
            ByteArrayInputStream local = new ByteArrayInputStream((byte[])object);
            int nameOffset = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            int rawType = ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian);
            long rawFlags = ELFParser.inputInit$readBits(local, bits, endian);
            long virtualAddress = ELFParser.inputInit$readBits(local, bits, endian);
            long fileOffset = ELFParser.inputInit$readBits(local, bits, endian);
            long fileSize = ELFParser.inputInit$readBits(local, bits, endian);
            if (fileSize > Integer.MAX_VALUE) {
                throw new NotImplementedError("Size too large!");
            }
            this.preread.add(new ELFWrittenSectionHeader(index == sectionNamesIndex, nameOffset, rawType, rawFlags, virtualAddress, fileOffset, fileSize, ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian), ELFParser.inputInit$re$1(SocketUtilKt.read32(local), endian), ELFParser.inputInit$readBits(local, bits, endian), ELFParser.inputInit$readBits(local, bits, endian)));
        }
    }

    private static final short inputInit$re(short $this$inputInit_u24re, ELFHeaderEndian endian) {
        return endian == ELFHeaderEndian.LITTLE ? SocketUtilKt.le($this$inputInit_u24re) : $this$inputInit_u24re;
    }

    private static final int inputInit$re$1(int $this$inputInit_u24re_u241, ELFHeaderEndian endian) {
        return endian == ELFHeaderEndian.LITTLE ? SocketUtilKt.le($this$inputInit_u24re_u241) : $this$inputInit_u24re_u241;
    }

    private static final long inputInit$re$2(long $this$inputInit_u24re_u242, ELFHeaderEndian endian) {
        return endian == ELFHeaderEndian.LITTLE ? SocketUtilKt.le($this$inputInit_u24re_u242) : $this$inputInit_u24re_u242;
    }

    private static final long inputInit$readBits(InputStream $this$inputInit_u24readBits, ELFHeaderBits bits, ELFHeaderEndian endian) {
        return bits == ELFHeaderBits.BIT_32 ? (long)ELFParser.inputInit$re$1(SocketUtilKt.read32($this$inputInit_u24readBits), endian) : ELFParser.inputInit$re$2(SocketUtilKt.read64($this$inputInit_u24readBits), endian);
    }

    static {
        byte[] byArray = new byte[]{127, 69, 76, 70};
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
        goodSignature = byArray2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/bread_experts_group/coder/format/parse/elf/ELFParser$Companion;", "", "<init>", "()V", "goodSignature", "", "getGoodSignature", "()[B", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getGoodSignature() {
            return goodSignature;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

