/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.elf.header;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.coder.format.parse.elf.header.ELFApplicationBinaryInterface;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeaderBits;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeaderEndian;
import org.bread_experts_group.coder.format.parse.elf.header.ELFInstructionSetArchitecture;
import org.bread_experts_group.coder.format.parse.elf.header.ELFObjectType;
import org.bread_experts_group.coder.format.parse.elf.header.writer.ELFContextuallyWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u00101\u001a\u000202H\u0016J1\u00103\u001a\u000204H\u0016R\u000205R\u00020\u0000R\u00020\u000ej\u0006\u00106\u001a\u000205j\u0006\u00107\u001a\u00020\u0000j\u0006\u00108\u001a\u00020\u000e\u00a2\u0006\u0002\u00109R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017R\u0016\u0010!\u001a\u0004\u0018\u00010\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006:"}, d2={"Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;", "Lorg/bread_experts_group/coder/format/parse/elf/header/writer/ELFContextuallyWritable;", "bits", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeaderBits;", "endian", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeaderEndian;", "version", "", "abiRaw", "abiVersion", "objectTypeRaw", "isaRaw", "version2", "entryPoint", "", "isaFlags", "<init>", "(Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeaderBits;Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeaderEndian;IIIIIILjava/lang/Long;I)V", "getBits", "()Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeaderBits;", "getEndian", "()Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeaderEndian;", "getVersion", "()I", "getAbiRaw", "getAbiVersion", "getObjectTypeRaw", "getIsaRaw", "getVersion2", "getEntryPoint", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getIsaFlags", "tag", "", "getTag", "()Ljava/lang/Void;", "abi", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFApplicationBinaryInterface;", "getAbi", "()Lorg/bread_experts_group/coder/format/parse/elf/header/ELFApplicationBinaryInterface;", "objectType", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFObjectType;", "getObjectType", "()Lorg/bread_experts_group/coder/format/parse/elf/header/ELFObjectType;", "isa", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFInstructionSetArchitecture;", "getIsa", "()Lorg/bread_experts_group/coder/format/parse/elf/header/ELFInstructionSetArchitecture;", "toString", "", "write", "", "Ljava/io/OutputStream;", "stream", "header", "dataPosition", "(Ljava/io/OutputStream;Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;J)V", "bread_server_lib"})
public final class ELFHeader
implements ELFContextuallyWritable {
    @NotNull
    private final ELFHeaderBits bits;
    @NotNull
    private final ELFHeaderEndian endian;
    private final int version;
    private final int abiRaw;
    private final int abiVersion;
    private final int objectTypeRaw;
    private final int isaRaw;
    private final int version2;
    @Nullable
    private final Long entryPoint;
    private final int isaFlags;
    @Nullable
    private final Void tag;
    @Nullable
    private final ELFApplicationBinaryInterface abi;
    @Nullable
    private final ELFObjectType objectType;
    @Nullable
    private final ELFInstructionSetArchitecture isa;

    public ELFHeader(@NotNull ELFHeaderBits bits, @NotNull ELFHeaderEndian endian, int version, int abiRaw, int abiVersion, int objectTypeRaw, int isaRaw, int version2, @Nullable Long entryPoint, int isaFlags) {
        Intrinsics.checkNotNullParameter((Object)bits, "bits");
        Intrinsics.checkNotNullParameter((Object)endian, "endian");
        this.bits = bits;
        this.endian = endian;
        this.version = version;
        this.abiRaw = abiRaw;
        this.abiVersion = abiVersion;
        this.objectTypeRaw = objectTypeRaw;
        this.isaRaw = isaRaw;
        this.version2 = version2;
        this.entryPoint = entryPoint;
        this.isaFlags = isaFlags;
        this.abi = ELFApplicationBinaryInterface.Companion.getMapping().get(this.abiRaw);
        this.objectType = ELFObjectType.Companion.getMapping().get(this.objectTypeRaw);
        this.isa = ELFInstructionSetArchitecture.Companion.getMapping().get(this.isaRaw);
    }

    @NotNull
    public final ELFHeaderBits getBits() {
        return this.bits;
    }

    @NotNull
    public final ELFHeaderEndian getEndian() {
        return this.endian;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getAbiRaw() {
        return this.abiRaw;
    }

    public final int getAbiVersion() {
        return this.abiVersion;
    }

    public final int getObjectTypeRaw() {
        return this.objectTypeRaw;
    }

    public final int getIsaRaw() {
        return this.isaRaw;
    }

    public final int getVersion2() {
        return this.version2;
    }

    @Nullable
    public final Long getEntryPoint() {
        return this.entryPoint;
    }

    public final int getIsaFlags() {
        return this.isaFlags;
    }

    @Nullable
    public Void getTag() {
        return this.tag;
    }

    @Nullable
    public final ELFApplicationBinaryInterface getAbi() {
        return this.abi;
    }

    @Nullable
    public final ELFObjectType getObjectType() {
        return this.objectType;
    }

    @Nullable
    public final ELFInstructionSetArchitecture getIsa() {
        return this.isa;
    }

    @NotNull
    public String toString() {
        return "ELFHeader[" + this.bits + ", " + this.endian + ", " + this.version + "." + this.version2 + ", " + this.abi + " [" + this.abiRaw + "] " + this.abiVersion + ", " + this.objectType + " [" + this.objectTypeRaw + "], " + this.isa + " [" + this.isaRaw + "] " + this.isaFlags + (String)(this.entryPoint != null ? ", @" + FormattingKt.hex-VKZWuLQ(ULong.constructor-impl(this.entryPoint)) : "") + "]";
    }

    @Override
    public void write(@NotNull OutputStream stream, @NotNull ELFHeader header, long dataPosition) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(header, "header");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Void write(@NotNull OutputStream stream) {
        return ELFContextuallyWritable.super.write(stream);
    }

    @Override
    public long computeSize() {
        return ELFContextuallyWritable.super.computeSize();
    }

    @Override
    @NotNull
    public byte[] asBytes() {
        return ELFContextuallyWritable.super.asBytes();
    }
}

