/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.elf.header;

import java.io.OutputStream;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.coder.Flaggable;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeader;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeaderBits;
import org.bread_experts_group.coder.format.parse.elf.header.ELFProgramHeaderFlags;
import org.bread_experts_group.coder.format.parse.elf.header.ELFProgramHeaderType;
import org.bread_experts_group.coder.format.parse.elf.header.writer.ELFContextuallyWritable;
import org.bread_experts_group.coder.format.parse.elf.header.writer.ELFWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fBY\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u0013J\b\u0010*\u001a\u00020+H\u0016J1\u0010,\u001a\u00020-H\u0016R\u00020.R\u000200R\u00020\u0006j\u0006\u0010/\u001a\u00020.j\u0006\u00101\u001a\u000200j\u0006\u00102\u001a\u00020\u0006\u00a2\u0006\u0002\u00103R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u0016\u0010 \u001a\u0004\u0018\u00010!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00064"}, d2={"Lorg/bread_experts_group/coder/format/parse/elf/header/ELFProgramHeader;", "Lorg/bread_experts_group/coder/format/parse/elf/header/writer/ELFContextuallyWritable;", "rawType", "", "rawFlags", "virtualAddress", "", "physicalAddress", "contentsPosition", "contentsLength", "memorySize", "alignment", "contentsFileAbsolute", "", "<init>", "(IIJJJJJJZ)V", "flags", "Ljava/util/EnumSet;", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFProgramHeaderFlags;", "(ILjava/util/EnumSet;JJJJJJZ)V", "getRawType", "()I", "getRawFlags", "getVirtualAddress", "()J", "getPhysicalAddress", "getContentsPosition", "getContentsLength", "getMemorySize", "getContentsFileAbsolute", "()Z", "getAlignment", "tag", "", "getTag", "()Ljava/lang/Void;", "type", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFProgramHeaderType;", "getType", "()Lorg/bread_experts_group/coder/format/parse/elf/header/ELFProgramHeaderType;", "getFlags", "()Ljava/util/EnumSet;", "toString", "", "write", "", "Ljava/io/OutputStream;", "stream", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;", "header", "dataPosition", "(Ljava/io/OutputStream;Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;J)V", "bread_server_lib"})
public final class ELFProgramHeader
implements ELFContextuallyWritable {
    private final int rawType;
    private final int rawFlags;
    private final long virtualAddress;
    private final long physicalAddress;
    private final long contentsPosition;
    private final long contentsLength;
    private final long memorySize;
    private final boolean contentsFileAbsolute;
    private final long alignment;
    @Nullable
    private final Void tag;
    @NotNull
    private final ELFProgramHeaderType type;
    @NotNull
    private final EnumSet<ELFProgramHeaderFlags> flags;

    /*
     * WARNING - void declaration
     */
    public ELFProgramHeader(int rawType, int rawFlags, long virtualAddress, long physicalAddress, long contentsPosition, long contentsLength, long memorySize, long alignment, boolean contentsFileAbsolute) {
        ELFProgramHeaderType eLFProgramHeaderType;
        void it;
        long l;
        this.rawType = rawType;
        this.rawFlags = rawFlags;
        this.virtualAddress = virtualAddress;
        this.physicalAddress = physicalAddress;
        this.contentsPosition = contentsPosition;
        this.contentsLength = contentsLength;
        this.memorySize = memorySize;
        this.contentsFileAbsolute = contentsFileAbsolute;
        long l2 = l = alignment;
        ELFProgramHeader eLFProgramHeader = this;
        boolean bl = false;
        if (it != 0L && Long.bitCount((long)it) != 1) {
            throw new IllegalArgumentException("bad alignment [" + (long)it + "]");
        }
        eLFProgramHeader.alignment = l;
        if (this.rawType >= ELFProgramHeaderType.PT_PROCESSOR_RAW.getCode()) {
            eLFProgramHeaderType = ELFProgramHeaderType.PT_PROCESSOR_RAW;
        } else if (this.rawType >= ELFProgramHeaderType.PT_OPERATING_SYSTEM_RAW.getCode()) {
            eLFProgramHeaderType = ELFProgramHeaderType.PT_OPERATING_SYSTEM_RAW;
        } else {
            eLFProgramHeaderType = ELFProgramHeaderType.Companion.getMapping().get(this.rawType);
            if (eLFProgramHeaderType == null) {
                throw new InvalidInputException("Unknown ELF program header entry type [" + this.rawType + "]", null, 2, null);
            }
        }
        this.type = eLFProgramHeaderType;
        this.flags = Flaggable.Companion.from(ELFProgramHeaderFlags.getEntries(), this.rawFlags);
    }

    public /* synthetic */ ELFProgramHeader(int n, int n2, long l, long l2, long l3, long l4, long l5, long l6, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x100) != 0) {
            bl = false;
        }
        this(n, n2, l, l2, l3, l4, l5, l6, bl);
    }

    public final int getRawType() {
        return this.rawType;
    }

    public final int getRawFlags() {
        return this.rawFlags;
    }

    public final long getVirtualAddress() {
        return this.virtualAddress;
    }

    public final long getPhysicalAddress() {
        return this.physicalAddress;
    }

    public final long getContentsPosition() {
        return this.contentsPosition;
    }

    public final long getContentsLength() {
        return this.contentsLength;
    }

    public final long getMemorySize() {
        return this.memorySize;
    }

    public final boolean getContentsFileAbsolute() {
        return this.contentsFileAbsolute;
    }

    public final long getAlignment() {
        return this.alignment;
    }

    public ELFProgramHeader(int rawType, @NotNull EnumSet<ELFProgramHeaderFlags> flags, long virtualAddress, long physicalAddress, long contentsPosition, long contentsLength, long memorySize, long alignment, boolean contentsFileAbsolute) {
        Intrinsics.checkNotNullParameter(flags, "flags");
        this(rawType, (int)Flaggable.Companion.raw((Collection<? extends Flaggable>)flags), virtualAddress, physicalAddress, contentsPosition, contentsLength, memorySize, alignment, contentsFileAbsolute);
    }

    public /* synthetic */ ELFProgramHeader(int n, EnumSet enumSet, long l, long l2, long l3, long l4, long l5, long l6, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x100) != 0) {
            bl = false;
        }
        this(n, enumSet, l, l2, l3, l4, l5, l6, bl);
    }

    @Nullable
    public Void getTag() {
        return this.tag;
    }

    @NotNull
    public final ELFProgramHeaderType getType() {
        return this.type;
    }

    @NotNull
    public final EnumSet<ELFProgramHeaderFlags> getFlags() {
        return this.flags;
    }

    @NotNull
    public String toString() {
        return "ELFProgramHeader[" + this.type + " [" + this.rawType + "], [" + CollectionsKt.joinToString$default(this.flags, ",", null, null, 0, null, null, 62, null) + "] [" + this.rawFlags + "], f@" + this.contentsPosition + "[" + this.contentsLength + "], m@" + this.virtualAddress + "/" + this.physicalAddress + "[" + this.memorySize + "], :" + this.alignment + "]";
    }

    @Override
    public void write(@NotNull OutputStream stream, @NotNull ELFHeader header, long dataPosition) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(header, "header");
        ELFWriter.Companion.w32(stream, header, this.rawType);
        if (header.getBits() == ELFHeaderBits.BIT_32) {
            ELFWriter.Companion.w32(stream, header, (int)(dataPosition + this.contentsPosition));
            ELFWriter.Companion.w32(stream, header, (int)this.virtualAddress);
            ELFWriter.Companion.w32(stream, header, (int)this.physicalAddress);
            ELFWriter.Companion.w32(stream, header, (int)this.contentsLength);
            ELFWriter.Companion.w32(stream, header, (int)this.memorySize);
            ELFWriter.Companion.w32(stream, header, this.rawFlags);
            ELFWriter.Companion.w32(stream, header, (int)this.alignment);
        } else {
            ELFWriter.Companion.w32(stream, header, this.rawFlags);
            ELFWriter.Companion.w64(stream, header, dataPosition + this.contentsPosition);
            ELFWriter.Companion.w64(stream, header, this.virtualAddress);
            ELFWriter.Companion.w64(stream, header, this.physicalAddress);
            ELFWriter.Companion.w64(stream, header, this.contentsLength);
            ELFWriter.Companion.w64(stream, header, this.memorySize);
            ELFWriter.Companion.w64(stream, header, this.alignment);
        }
    }

    @Override
    @NotNull
    public Void write(@NotNull OutputStream stream) {
        return ELFContextuallyWritable.super.write(stream);
    }

    @Override
    public long computeSize() {
        return ELFContextuallyWritable.super.computeSize();
    }

    @Override
    @NotNull
    public byte[] asBytes() {
        return ELFContextuallyWritable.super.asBytes();
    }
}

