/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.elf.header;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeader;
import org.bread_experts_group.coder.format.parse.elf.header.ELFSectionHeaderFlags;
import org.bread_experts_group.coder.format.parse.elf.header.ELFSectionHeaderType;
import org.bread_experts_group.coder.format.parse.elf.header.writer.ELFContextuallyWritable;
import org.bread_experts_group.coder.format.parse.elf.header.writer.ELFWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010'\u001a\u00020(H\u0016J1\u0010)\u001a\u00020*H\u0016R\u00020+R\u00020-R\u00020\u0005j\u0006\u0010,\u001a\u00020+j\u0006\u0010.\u001a\u00020-j\u0006\u0010/\u001a\u00020\u0005\u00a2\u0006\u0002\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00061"}, d2={"Lorg/bread_experts_group/coder/format/parse/elf/header/ELFSectionHeader;", "Lorg/bread_experts_group/coder/format/parse/elf/header/writer/ELFContextuallyWritable;", "rawType", "", "rawFlags", "", "virtualAddress", "contentsPosition", "contentsLength", "link", "info", "alignment", "entrySize", "<init>", "(IJJJJIIJJ)V", "getRawType", "()I", "getRawFlags", "()J", "getVirtualAddress", "getContentsPosition", "getContentsLength", "getLink", "getInfo", "getEntrySize", "tag", "", "getTag", "()Ljava/lang/Void;", "getAlignment", "type", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFSectionHeaderType;", "getType", "()Lorg/bread_experts_group/coder/format/parse/elf/header/ELFSectionHeaderType;", "flags", "", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFSectionHeaderFlags;", "getFlags", "()Ljava/util/Set;", "toString", "", "write", "", "Ljava/io/OutputStream;", "stream", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;", "header", "dataPosition", "(Ljava/io/OutputStream;Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;J)V", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nELFSectionHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ELFSectionHeader.kt\norg/bread_experts_group/coder/format/parse/elf/header/ELFSectionHeader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n774#2:47\n865#2,2:48\n*S KotlinDebug\n*F\n+ 1 ELFSectionHeader.kt\norg/bread_experts_group/coder/format/parse/elf/header/ELFSectionHeader\n*L\n29#1:47\n29#1:48,2\n*E\n"})
public abstract class ELFSectionHeader
implements ELFContextuallyWritable {
    private final int rawType;
    private final long rawFlags;
    private final long virtualAddress;
    private final long contentsPosition;
    private final long contentsLength;
    private final int link;
    private final int info;
    private final long entrySize;
    @Nullable
    private final Void tag;
    private final long alignment;
    @NotNull
    private final ELFSectionHeaderType type;
    @NotNull
    private final Set<ELFSectionHeaderFlags> flags;

    /*
     * WARNING - void declaration
     */
    public ELFSectionHeader(int rawType, long rawFlags, long virtualAddress, long contentsPosition, long contentsLength, int link, int info, long alignment, long entrySize) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        ELFSectionHeaderType eLFSectionHeaderType;
        void it;
        long l;
        this.rawType = rawType;
        this.rawFlags = rawFlags;
        this.virtualAddress = virtualAddress;
        this.contentsPosition = contentsPosition;
        this.contentsLength = contentsLength;
        this.link = link;
        this.info = info;
        this.entrySize = entrySize;
        long l2 = l = alignment;
        ELFSectionHeader eLFSectionHeader = this;
        boolean bl = false;
        if (it != 0L && Long.bitCount((long)it) != 1) {
            throw new IllegalArgumentException("bad alignment [" + (long)it + "]");
        }
        eLFSectionHeader.alignment = l;
        if (this.rawType >= ELFSectionHeaderType.SHT_OPERATING_SYSTEM_RAW.getCode()) {
            eLFSectionHeaderType = ELFSectionHeaderType.SHT_OPERATING_SYSTEM_RAW;
        } else {
            eLFSectionHeaderType = ELFSectionHeaderType.Companion.getMapping().get(this.rawType);
            if (eLFSectionHeaderType == null) {
                throw new InvalidInputException("Unknown ELF section header entry type [" + this.rawType + "]", null, 2, null);
            }
        }
        this.type = eLFSectionHeaderType;
        Iterable iterable = ELFSectionHeaderFlags.getEntries();
        eLFSectionHeader = this;
        boolean $i$f$filter = false;
        void var19_17 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ELFSectionHeaderFlags it2 = (ELFSectionHeaderFlags)element$iv$iv;
            boolean bl2 = false;
            if (!((this.rawFlags & it2.getPosition()) != 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        eLFSectionHeader.flags = CollectionsKt.toSet((List)destination$iv$iv);
    }

    public final int getRawType() {
        return this.rawType;
    }

    public final long getRawFlags() {
        return this.rawFlags;
    }

    public final long getVirtualAddress() {
        return this.virtualAddress;
    }

    public final long getContentsPosition() {
        return this.contentsPosition;
    }

    public final long getContentsLength() {
        return this.contentsLength;
    }

    public final int getLink() {
        return this.link;
    }

    public final int getInfo() {
        return this.info;
    }

    public final long getEntrySize() {
        return this.entrySize;
    }

    @Nullable
    public Void getTag() {
        return this.tag;
    }

    public final long getAlignment() {
        return this.alignment;
    }

    @NotNull
    public final ELFSectionHeaderType getType() {
        return this.type;
    }

    @NotNull
    public final Set<ELFSectionHeaderFlags> getFlags() {
        return this.flags;
    }

    @NotNull
    public String toString() {
        return "ELFSectionHeader[" + this.type + " [" + this.rawType + "], [" + CollectionsKt.joinToString$default(this.flags, ",", null, null, 0, null, null, 62, null) + "], m@" + this.virtualAddress + ", f@" + this.contentsPosition + "[" + this.contentsLength + "], " + this.link + " | " + this.info + ", " + this.alignment + ", #[" + this.entrySize + "]]";
    }

    @Override
    public void write(@NotNull OutputStream stream, @NotNull ELFHeader header, long dataPosition) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(header, "header");
        ELFWriter.Companion.w32(stream, header, this.rawType);
        ELFWriter.Companion.wBits(stream, header, this.rawFlags);
        ELFWriter.Companion.wBits(stream, header, this.virtualAddress);
        ELFWriter.Companion.wBits(stream, header, dataPosition + this.contentsPosition);
        ELFWriter.Companion.wBits(stream, header, this.contentsLength);
        ELFWriter.Companion.w32(stream, header, this.link);
        ELFWriter.Companion.w32(stream, header, this.info);
        ELFWriter.Companion.wBits(stream, header, this.alignment);
        ELFWriter.Companion.wBits(stream, header, this.entrySize);
    }

    @Override
    @NotNull
    public Void write(@NotNull OutputStream stream) {
        return ELFContextuallyWritable.super.write(stream);
    }

    @Override
    public long computeSize() {
        return ELFContextuallyWritable.super.computeSize();
    }

    @Override
    @NotNull
    public byte[] asBytes() {
        return ELFContextuallyWritable.super.asBytes();
    }
}

