/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.elf.header.writer;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.coder.format.parse.DiscreteWriter;
import org.bread_experts_group.coder.format.parse.elf.ELFParser;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeader;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeaderBits;
import org.bread_experts_group.coder.format.parse.elf.header.ELFHeaderEndian;
import org.bread_experts_group.coder.format.parse.elf.header.ELFProgramHeader;
import org.bread_experts_group.coder.format.parse.elf.header.ELFSectionHeaderFlags;
import org.bread_experts_group.coder.format.parse.elf.header.ELFSectionHeaderType;
import org.bread_experts_group.coder.format.parse.elf.header.writer.ELFSectionHeaderWritable;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/bread_experts_group/coder/format/parse/elf/header/writer/ELFWriter;", "Lorg/bread_experts_group/coder/format/parse/DiscreteWriter;", "header", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;", "<init>", "(Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;)V", "programHeaders", "", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFProgramHeader;", "getProgramHeaders", "()Ljava/util/List;", "sectionHeaders", "Lorg/bread_experts_group/coder/format/parse/elf/header/writer/ELFSectionHeaderWritable;", "getSectionHeaders", "data", "", "getData", "()[B", "setData", "([B)V", "writeFull", "", "stream", "Ljava/io/OutputStream;", "Companion", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nELFWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ELFWriter.kt\norg/bread_experts_group/coder/format/parse/elf/header/writer/ELFWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1617#2,9:137\n1869#2:146\n1870#2:148\n1626#2:149\n1869#2,2:150\n1869#2:152\n1870#2:154\n1869#2,2:155\n1#3:147\n1#3:153\n*S KotlinDebug\n*F\n+ 1 ELFWriter.kt\norg/bread_experts_group/coder/format/parse/elf/header/writer/ELFWriter\n*L\n101#1:137,9\n101#1:146\n101#1:148\n101#1:149\n101#1:150,2\n127#1:152\n127#1:154\n130#1:155,2\n101#1:147\n*E\n"})
public final class ELFWriter
extends DiscreteWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ELFHeader header;
    @NotNull
    private final List<ELFProgramHeader> programHeaders;
    @NotNull
    private final List<ELFSectionHeaderWritable> sectionHeaders;
    @NotNull
    private byte[] data;

    public ELFWriter(@NotNull ELFHeader header) {
        Intrinsics.checkNotNullParameter(header, "header");
        this.header = header;
        this.programHeaders = new ArrayList();
        this.sectionHeaders = new ArrayList();
        this.data = new byte[0];
    }

    @NotNull
    public final List<ELFProgramHeader> getProgramHeaders() {
        return this.programHeaders;
    }

    @NotNull
    public final List<ELFSectionHeaderWritable> getSectionHeaders() {
        return this.sectionHeaders;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public final void setData(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.data = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void writeFull(@NotNull OutputStream stream) {
        long l;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object it;
        Intrinsics.checkNotNullParameter(stream, "stream");
        ELFHeader eLFHeader = this.header;
        OutputStream outputStream = stream;
        boolean bl = false;
        stream.write(ELFParser.Companion.getGoodSignature());
        stream.write(this.header.getBits().getCode());
        stream.write(this.header.getEndian().getCode());
        stream.write(this.header.getVersion());
        stream.write(this.header.getAbiRaw());
        stream.write(this.header.getAbiVersion());
        stream.write(new byte[7]);
        Companion.w16(outputStream, eLFHeader, this.header.getObjectTypeRaw());
        Companion.w16(outputStream, eLFHeader, this.header.getIsaRaw());
        Companion.w32(outputStream, eLFHeader, this.header.getVersion2());
        Long l2 = this.header.getEntryPoint();
        Companion.wBits(outputStream, eLFHeader, l2 != null ? l2 : 0L);
        long programHeaderStart = this.header.getBits() == ELFHeaderBits.BIT_64 ? 64L : 52L;
        Companion.wBits(outputStream, eLFHeader, programHeaderStart);
        int programHeaderEntrySize = this.header.getBits() == ELFHeaderBits.BIT_64 ? 56 : 32;
        int programHeaderLength = programHeaderEntrySize * this.programHeaders.size();
        long sectionHeaderStart = programHeaderStart + (long)programHeaderLength;
        Companion.wBits(outputStream, eLFHeader, !((Collection)this.sectionHeaders).isEmpty() ? sectionHeaderStart : 0L);
        Companion.w32(outputStream, eLFHeader, this.header.getIsaFlags());
        Companion.w16(outputStream, eLFHeader, (int)programHeaderStart);
        Companion.w16(outputStream, eLFHeader, programHeaderEntrySize);
        Companion.w16(outputStream, eLFHeader, this.programHeaders.size());
        int sectionHeaderEntrySize = this.header.getBits() == ELFHeaderBits.BIT_64 ? 64 : 40;
        Companion.w16(outputStream, eLFHeader, sectionHeaderEntrySize);
        int n = ELFSectionHeaderType.UNUSED.getCode();
        EnumSet<ELFSectionHeaderFlags> enumSet = EnumSet.noneOf(ELFSectionHeaderFlags.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, "noneOf(...)");
        this.sectionHeaders.addFirst(new ELFSectionHeaderWritable("", n, enumSet, 0L, 0L, 0L, 0, 0, 0L, 0L, true));
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            void $this$mapNotNullTo$iv$iv;
            it = (ByteArrayOutputStream)closeable;
            boolean bl2 = false;
            Map offsets = new LinkedHashMap();
            Iterable $this$mapNotNull$iv = this.sectionHeaders;
            boolean $i$f$mapNotNull = false;
            Iterator iterator2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl3 = false;
                ELFSectionHeaderWritable section = (ELFSectionHeaderWritable)element$iv$iv;
                boolean bl4 = false;
                if (section.getName() == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$forEach$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), ".shstrtab");
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name = (String)element$iv;
                boolean bl6 = false;
                offsets.put(name, ((ByteArrayOutputStream)it).size());
                SocketUtilKt.writeString$default((OutputStream)it, name, null, 2, null);
                ((ByteArrayOutputStream)it).write(0);
            }
            it = TuplesKt.to(((ByteArrayOutputStream)it).toByteArray(), offsets);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Object object = it;
        byte[] strings = (byte[])((Pair)object).component1();
        Map offsets = (Map)((Pair)object).component2();
        int stringsPosition = this.data.length;
        Intrinsics.checkNotNull(strings);
        this.data = ArraysKt.plus(this.data, strings);
        int n2 = ELFSectionHeaderType.SHT_STRTAB.getCode();
        EnumSet<ELFSectionHeaderFlags> enumSet2 = EnumSet.noneOf(ELFSectionHeaderFlags.class);
        Intrinsics.checkNotNullExpressionValue(enumSet2, "noneOf(...)");
        this.sectionHeaders.add(new ELFSectionHeaderWritable(".shstrtab", n2, enumSet2, 0L, stringsPosition, strings.length, 0, 0, 1L, 0L, false, 1024, null));
        Companion.w16(outputStream, eLFHeader, this.sectionHeaders.size());
        Companion.w16(outputStream, eLFHeader, Math.max(0, CollectionsKt.getLastIndex(this.sectionHeaders)));
        long dataStart = sectionHeaderStart + (long)(sectionHeaderEntrySize * this.sectionHeaders.size());
        $this$forEach$iv = this.programHeaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ELFProgramHeader it2 = (ELFProgramHeader)element$iv;
            boolean bl7 = false;
            l = it2.getContentsFileAbsolute() ? 0L : dataStart;
            boolean bl8 = false;
            it2.write(outputStream, eLFHeader, l);
        }
        $this$forEach$iv = this.sectionHeaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ELFSectionHeaderWritable it3 = (ELFSectionHeaderWritable)element$iv;
            boolean bl9 = false;
            Companion.w32(outputStream, eLFHeader, it3.getName() != null ? ((Number)MapsKt.getValue(offsets, it3.getName())).intValue() : 0);
            l = it3.getContentsFileAbsolute() ? 0L : dataStart;
            boolean bl10 = false;
            it3.write(outputStream, eLFHeader, l);
        }
        stream.write(this.data);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ+\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ+\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000fR\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J+\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000fR\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/bread_experts_group/coder/format/parse/elf/header/writer/ELFWriter$Companion;", "", "<init>", "()V", "w16", "", "Ljava/io/OutputStream;", "stream", "Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;", "header", "n", "", "(Ljava/io/OutputStream;Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;I)V", "w32", "w64", "", "(Ljava/io/OutputStream;Lorg/bread_experts_group/coder/format/parse/elf/header/ELFHeader;J)V", "wBits", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public final void w16(@NotNull OutputStream stream, @NotNull ELFHeader header, int n) {
            Intrinsics.checkNotNullParameter(stream, "stream");
            Intrinsics.checkNotNullParameter(header, "header");
            short it = (short)n;
            boolean bl = false;
            SocketUtilKt.write16(stream, header.getEndian() == ELFHeaderEndian.LITTLE ? SocketUtilKt.le(it) : it);
        }

        public final void w32(@NotNull OutputStream stream, @NotNull ELFHeader header, int n) {
            Intrinsics.checkNotNullParameter(stream, "stream");
            Intrinsics.checkNotNullParameter(header, "header");
            SocketUtilKt.write32(stream, header.getEndian() == ELFHeaderEndian.LITTLE ? SocketUtilKt.le(n) : n);
        }

        public final void w64(@NotNull OutputStream stream, @NotNull ELFHeader header, long n) {
            Intrinsics.checkNotNullParameter(stream, "stream");
            Intrinsics.checkNotNullParameter(header, "header");
            SocketUtilKt.write64(stream, header.getEndian() == ELFHeaderEndian.LITTLE ? SocketUtilKt.le(n) : n);
        }

        public final void wBits(@NotNull OutputStream stream, @NotNull ELFHeader header, long n) {
            Intrinsics.checkNotNullParameter(stream, "stream");
            Intrinsics.checkNotNullParameter(header, "header");
            if (header.getBits() == ELFHeaderBits.BIT_64) {
                this.w64(stream, header, n);
            } else {
                this.w32(stream, header, (int)n);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

