/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.flac;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.CodingException;
import org.bread_experts_group.coder.CompoundThrowable;
import org.bread_experts_group.coder.Mappable;
import org.bread_experts_group.coder.MappedEnumeration;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.bread_experts_group.coder.format.parse.Parser;
import org.bread_experts_group.coder.format.parse.flac.block.FLACBlock;
import org.bread_experts_group.coder.format.parse.flac.block.FLACBlockType;
import org.bread_experts_group.coder.format.parse.flac.block.FLACMetadataBlock;
import org.bread_experts_group.coder.format.parse.flac.block.FLACPictureMetadataBlock;
import org.bread_experts_group.coder.format.parse.flac.block.FLACPictureType;
import org.bread_experts_group.coder.format.parse.flac.block.FLACSeekPoint;
import org.bread_experts_group.coder.format.parse.flac.block.FLACSeekTableMetadataBlock;
import org.bread_experts_group.coder.format.parse.flac.block.FLACStreamInfoMetadataBlock;
import org.bread_experts_group.coder.format.parse.flac.block.FLACVorbisCommentMetadataBlock;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00032\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/bread_experts_group/coder/format/parse/flac/FLACParser;", "Lorg/bread_experts_group/coder/format/parse/Parser;", "Lorg/bread_experts_group/coder/format/parse/flac/block/FLACBlockType;", "Lorg/bread_experts_group/coder/format/parse/flac/block/FLACBlock;", "Ljava/io/InputStream;", "<init>", "()V", "audioData", "", "readBase", "compound", "Lorg/bread_experts_group/coder/CompoundThrowable;", "Lorg/bread_experts_group/coder/CodingException;", "Lorg/bread_experts_group/coder/format/parse/CodingCompoundThrowable;", "responsibleStream", "of", "inputInit", "", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nFLACParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FLACParser.kt\norg/bread_experts_group/coder/format/parse/flac/FLACParser\n+ 2 Mappable.kt\norg/bread_experts_group/coder/Mappable$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n14#2,2:93\n16#2:96\n18#2,2:98\n14#2,2:100\n16#2:103\n18#2,2:105\n295#3:95\n296#3:97\n295#3:102\n296#3:104\n*S KotlinDebug\n*F\n+ 1 FLACParser.kt\norg/bread_experts_group/coder/format/parse/flac/FLACParser\n*L\n19#1:93,2\n19#1:96\n19#1:98,2\n75#1:100,2\n75#1:103\n75#1:105,2\n19#1:95\n19#1:97\n75#1:102\n75#1:104\n*E\n"})
public final class FLACParser
extends Parser<FLACBlockType, FLACBlock, InputStream> {
    private boolean audioData;

    public FLACParser() {
        super("Free Lossless Audio Codec", Reflection.getOrCreateKotlinClass(InputStream.class));
        this.addParser(FLACBlockType.STREAM_INFO, FLACParser::_init_$lambda$0);
        this.addParser(FLACBlockType.SEEK_TABLE, FLACParser::_init_$lambda$2);
        this.addParser(FLACBlockType.VORBIS_COMMENT, FLACParser::_init_$lambda$4);
        this.addParser(FLACBlockType.PICTURE, FLACParser::_init_$lambda$5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected FLACBlock readBase(@NotNull CompoundThrowable<CodingException> compound) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        int header = SocketUtilKt.read32u(this.getFqIn());
        if (!this.audioData) {
            Object v0;
            void n$iv;
            block3: {
                void $this$id$iv;
                Mappable.Companion companion = Mappable.Companion;
                EnumEntries<FLACBlockType> enumEntries = FLACBlockType.getEntries();
                Integer n = UInt.constructor-impl(UInt.constructor-impl(header >>> 24) & 0x3F);
                boolean $i$f$id = false;
                Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Enum it$iv = (Enum)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v0 = element$iv$iv;
                    break block3;
                }
                v0 = null;
            }
            void var14_18 = n$iv;
            Enum enum_ = v0;
            Enum enum_2 = new MappedEnumeration<void, Enum>(enum_, var14_18).getEnum();
            Intrinsics.checkNotNull(enum_2);
            FLACBlockType blockType = (FLACBlockType)enum_2;
            byte[] blockData = this.getFqIn().readNBytes(UInt.constructor-impl(header & 0xFFFFFF));
            this.audioData = UInt.constructor-impl(header >>> 31) != 0;
            Intrinsics.checkNotNull(blockData);
            return new FLACMetadataBlock(blockType, blockData);
        }
        if (UInt.constructor-impl(header >>> 17) != 32764) {
            throw new InvalidInputException("FLAC alignment failure [" + UInt.toString-impl(header) + "]", null, 2, null);
        }
        int blockingStrategy = UInt.constructor-impl(UInt.constructor-impl(header >>> 16) & 1);
        int blockSize = UInt.constructor-impl(UInt.constructor-impl(header >>> 12) & 0xF);
        int sampleRate = UInt.constructor-impl(UInt.constructor-impl(header >>> 8) & 0xF);
        int channelAssignment = UInt.constructor-impl(UInt.constructor-impl(header >>> 4) & 0xF);
        int sampleSize = UInt.constructor-impl(UInt.constructor-impl(header >>> 1) & 7);
        String string = "!";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    protected InputStream responsibleStream(@NotNull FLACBlock of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return new ByteArrayInputStream(of.getData());
    }

    @Override
    public void inputInit() {
        String magic = SocketUtilKt.readString(this.getFqIn(), 4, Charsets.US_ASCII);
        if (!Intrinsics.areEqual(magic, "fLaC")) {
            throw new InvalidInputException("Magic incorrect [" + magic + "] != [fLaC]", null, 2, null);
        }
    }

    private static final FLACBlock _init_$lambda$0(InputStream stream, FLACBlock fLACBlock, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(fLACBlock, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        int minBlock = SocketUtilKt.read16ui(stream);
        int maxBlock = SocketUtilKt.read16ui(stream);
        int minFrame = SocketUtilKt.read24(stream);
        int maxFrame = SocketUtilKt.read24(stream);
        long packed = SocketUtilKt.read64(stream);
        int n = (int)(packed >> 44);
        int n2 = (int)(packed >> 41 & 7L) + 1;
        int n3 = (int)(packed >> 36 & 0x1FL) + 1;
        byte[] byArray = stream.readNBytes(16);
        Intrinsics.checkNotNullExpressionValue(byArray, "readNBytes(...)");
        return new FLACStreamInfoMetadataBlock(minBlock, maxBlock, minFrame, maxFrame, n, n2, n3, packed & 0xFFFFFFFFFL, byArray);
    }

    private static final FLACBlock _init_$lambda$2(InputStream stream, FLACBlock fLACBlock, CompoundThrowable compoundThrowable) {
        List<FLACSeekPoint> list;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(fLACBlock, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        List<FLACSeekPoint> $this$lambda_u242_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (stream.available() > 0) {
            $this$lambda_u242_u24lambda_u241.add(new FLACSeekPoint(SocketUtilKt.read64(stream), SocketUtilKt.read64(stream), SocketUtilKt.read16ui(stream)));
        }
        List<FLACSeekPoint> list2 = CollectionsKt.build(list);
        return new FLACSeekTableMetadataBlock(list2);
    }

    private static final FLACBlock _init_$lambda$4(InputStream stream, FLACBlock fLACBlock, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(fLACBlock, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        int n = SocketUtilKt.le(SocketUtilKt.read32(stream));
        String string = SocketUtilKt.readString$default(stream, SocketUtilKt.le(SocketUtilKt.read32(stream)), null, 2, null);
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(SocketUtilKt.readString$default(stream, SocketUtilKt.le(SocketUtilKt.read32(stream)), null, 2, null));
        }
        List list = arrayList;
        String string2 = string;
        return new FLACVorbisCommentMetadataBlock(string2, list);
    }

    /*
     * WARNING - void declaration
     */
    private static final FLACBlock _init_$lambda$5(InputStream stream, FLACBlock fLACBlock, CompoundThrowable compoundThrowable) {
        Object v0;
        Integer n$iv;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(stream, "stream");
            Intrinsics.checkNotNullParameter(fLACBlock, "<unused var>");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<FLACPictureType> enumEntries = FLACPictureType.getEntries();
            n$iv = SocketUtilKt.read32(stream);
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        FLACPictureType fLACPictureType = (FLACPictureType)enum_2;
        String string = SocketUtilKt.readString$default(stream, SocketUtilKt.read32(stream), null, 2, null);
        String string2 = SocketUtilKt.readString$default(stream, SocketUtilKt.read32(stream), null, 2, null);
        int n2 = SocketUtilKt.read32(stream);
        int n3 = SocketUtilKt.read32(stream);
        int n4 = SocketUtilKt.read32(stream);
        int n5 = SocketUtilKt.read32(stream);
        byte[] byArray = stream.readNBytes(SocketUtilKt.read32(stream));
        Intrinsics.checkNotNullExpressionValue(byArray, "readNBytes(...)");
        byte[] byArray2 = byArray;
        int n6 = n5;
        int n7 = n4;
        int n8 = n3;
        int n9 = n2;
        String string3 = string2;
        String string4 = string;
        FLACPictureType fLACPictureType2 = fLACPictureType;
        return new FLACPictureMetadataBlock(fLACPictureType2, string4, string3, n9, n8, n7, n6, byArray2);
    }
}

