/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.flac.block;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.coder.format.parse.flac.block.FLACBlockType;
import org.bread_experts_group.coder.format.parse.flac.block.FLACMetadataBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/bread_experts_group/coder/format/parse/flac/block/FLACStreamInfoMetadataBlock;", "Lorg/bread_experts_group/coder/format/parse/flac/block/FLACMetadataBlock;", "minimumBlockSize", "", "maximumBlockSize", "minimumFrameSize", "maximumFrameSize", "sampleRate", "channels", "bitsPerSample", "totalSamples", "", "md5", "", "<init>", "(IIIIIIIJ[B)V", "getMinimumBlockSize", "()I", "getMaximumBlockSize", "getMinimumFrameSize", "getMaximumFrameSize", "getSampleRate", "getChannels", "getBitsPerSample", "getTotalSamples", "()J", "getMd5", "()[B", "toString", "", "bread_server_lib"})
public final class FLACStreamInfoMetadataBlock
extends FLACMetadataBlock {
    private final int minimumBlockSize;
    private final int maximumBlockSize;
    private final int minimumFrameSize;
    private final int maximumFrameSize;
    private final int sampleRate;
    private final int channels;
    private final int bitsPerSample;
    private final long totalSamples;
    @NotNull
    private final byte[] md5;

    public FLACStreamInfoMetadataBlock(int minimumBlockSize, int maximumBlockSize, int minimumFrameSize, int maximumFrameSize, int sampleRate, int channels, int bitsPerSample, long totalSamples, @NotNull byte[] md5) {
        Intrinsics.checkNotNullParameter(md5, "md5");
        super(FLACBlockType.STREAM_INFO, new byte[0]);
        this.minimumBlockSize = minimumBlockSize;
        this.maximumBlockSize = maximumBlockSize;
        this.minimumFrameSize = minimumFrameSize;
        this.maximumFrameSize = maximumFrameSize;
        this.sampleRate = sampleRate;
        this.channels = channels;
        this.bitsPerSample = bitsPerSample;
        this.totalSamples = totalSamples;
        this.md5 = md5;
    }

    public final int getMinimumBlockSize() {
        return this.minimumBlockSize;
    }

    public final int getMaximumBlockSize() {
        return this.maximumBlockSize;
    }

    public final int getMinimumFrameSize() {
        return this.minimumFrameSize;
    }

    public final int getMaximumFrameSize() {
        return this.maximumFrameSize;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getChannels() {
        return this.channels;
    }

    public final int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public final long getTotalSamples() {
        return this.totalSamples;
    }

    @NotNull
    public final byte[] getMd5() {
        return this.md5;
    }

    @Override
    @NotNull
    public String toString() {
        return "FLACStreamInfoMetadataBlock[block size: [" + this.minimumBlockSize + ".." + this.maximumBlockSize + "], frame size: [" + this.minimumFrameSize + ".." + this.maximumFrameSize + "], " + FormattingKt.formatMetric$default(this.sampleRate, 0, 1, null) + "Hz, " + this.channels + " channel(s), " + this.bitsPerSample + "-bit, " + this.totalSamples + " samples, " + HexExtensionsKt.toHexString$default(this.md5, null, 1, null) + "]";
    }
}

