/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.id3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.CodingException;
import org.bread_experts_group.coder.CompoundThrowable;
import org.bread_experts_group.coder.Flaggable;
import org.bread_experts_group.coder.Mappable;
import org.bread_experts_group.coder.MappedEnumeration;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.bread_experts_group.coder.format.parse.Parser;
import org.bread_experts_group.coder.format.parse.id3.ID3GenericFlags;
import org.bread_experts_group.coder.format.parse.id3.ID3PictureType;
import org.bread_experts_group.coder.format.parse.id3.ID3TextEncoding;
import org.bread_experts_group.coder.format.parse.id3.frame.ID3CommentFrame;
import org.bread_experts_group.coder.format.parse.id3.frame.ID3Frame;
import org.bread_experts_group.coder.format.parse.id3.frame.ID3Header;
import org.bread_experts_group.coder.format.parse.id3.frame.ID3PictureFrame2;
import org.bread_experts_group.coder.format.parse.id3.frame.ID3PictureFrame3;
import org.bread_experts_group.coder.format.parse.id3.frame.ID3PopularimeterFrame;
import org.bread_experts_group.coder.format.parse.id3.frame.ID3TextFrame;
import org.bread_experts_group.coder.format.parse.id3.frame.ID3URLLinkFrame;
import org.bread_experts_group.stream.FailQuickInputStream;
import org.bread_experts_group.stream.SocketUtilKt;
import org.bread_experts_group.stream.Tagged;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u0002H\u0016J\u0006\u0010\u000e\u001a\u00020\nJ\u0014\u0010\u000f\u001a\u00020\u00042\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0014J \u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015H\u0014JQ\u0010\u0016\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00172\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u00152\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00032\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/bread_experts_group/coder/format/parse/id3/ID3Parser;", "Lorg/bread_experts_group/coder/format/parse/Parser;", "", "Lorg/bread_experts_group/coder/format/parse/id3/frame/ID3Frame;", "Ljava/io/InputStream;", "<init>", "()V", "unsupported", "", "version", "", "preFrame", "Lorg/bread_experts_group/coder/format/parse/id3/frame/ID3Header;", "toString", "readZeroPadded", "responsibleStream", "of", "readBase", "compound", "Lorg/bread_experts_group/coder/CompoundThrowable;", "Lorg/bread_experts_group/coder/CodingException;", "Lorg/bread_experts_group/coder/format/parse/CodingCompoundThrowable;", "refineBase", "Lkotlin/Pair;", "parameters", "", "", "(Lorg/bread_experts_group/coder/CompoundThrowable;Lorg/bread_experts_group/coder/format/parse/id3/frame/ID3Frame;[Ljava/lang/Object;)Lkotlin/Pair;", "inputInit", "", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nID3Parser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ID3Parser.kt\norg/bread_experts_group/coder/format/parse/id3/ID3Parser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Mappable.kt\norg/bread_experts_group/coder/Mappable$Companion\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,163:1\n1803#2,3:164\n295#2:170\n296#2:172\n295#2:181\n296#2:183\n295#2:188\n296#2:190\n295#2:195\n296#2:197\n295#2:202\n296#2:204\n295#2:209\n296#2:211\n295#2:216\n296#2:218\n1#3:167\n14#4,2:168\n16#4:171\n18#4,2:173\n14#4,2:179\n16#4:182\n18#4,2:184\n14#4,2:186\n16#4:189\n18#4,2:191\n14#4,2:193\n16#4:196\n18#4,2:198\n14#4,2:200\n16#4:203\n18#4,2:205\n14#4,2:207\n16#4:210\n18#4,2:212\n14#4,2:214\n16#4:217\n18#4,2:219\n37#5:175\n36#5,3:176\n*S KotlinDebug\n*F\n+ 1 ID3Parser.kt\norg/bread_experts_group/coder/format/parse/id3/ID3Parser\n*L\n25#1:164,3\n83#1:170\n83#1:172\n109#1:181\n109#1:183\n118#1:188\n118#1:190\n127#1:195\n127#1:197\n131#1:202\n131#1:204\n137#1:209\n137#1:211\n141#1:216\n141#1:218\n83#1:168,2\n83#1:171\n83#1:173,2\n109#1:179,2\n109#1:182\n109#1:184,2\n118#1:186,2\n118#1:189\n118#1:191,2\n127#1:193,2\n127#1:196\n127#1:198,2\n131#1:200,2\n131#1:203\n131#1:205,2\n137#1:207,2\n137#1:210\n137#1:212,2\n141#1:214,2\n141#1:217\n141#1:219,2\n91#1:175\n91#1:176,3\n*E\n"})
public final class ID3Parser
extends Parser<String, ID3Frame<?>, InputStream> {
    private boolean unsupported;
    private int version;
    @Nullable
    private ID3Header preFrame;

    public ID3Parser() {
        super("ID3", Reflection.getOrCreateKotlinClass(InputStream.class));
        this.addPredicateParser(ID3Parser::_init_$lambda$3, ID3Parser::_init_$lambda$5);
        this.addPredicateParser(ID3Parser::_init_$lambda$6, ID3Parser::_init_$lambda$7);
        this.addParser("POPM", ID3Parser::_init_$lambda$9);
        this.addParser("COMM", ID3Parser::_init_$lambda$10);
        this.addParser("USLT", ID3Parser::_init_$lambda$11);
        this.addParser("APIC", ID3Parser::_init_$lambda$12);
        this.addParser("PIC", ID3Parser::_init_$lambda$13);
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "[" + !this.unsupported + "/v" + this.version + "]";
    }

    /*
     * WARNING - void declaration
     */
    public final int readZeroPadded() {
        void $this$fold$iv;
        Iterable iterable = RangesKt.downTo(3, 0);
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator2).nextInt();
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc | this.getFqIn().read() << 7 * i;
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    protected InputStream responsibleStream(@NotNull ID3Frame<?> of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return new ByteArrayInputStream(of.getData());
    }

    @Override
    @Nullable
    protected ID3Frame<?> readBase(@NotNull CompoundThrowable<CodingException> compound) {
        ID3Frame<ID3GenericFlags> iD3Frame;
        ID3Header iD3Header;
        Intrinsics.checkNotNullParameter(compound, "compound");
        if (this.unsupported) {
            throw new InvalidInputException("ID3 major version is unsupported [" + this.version + "]", null, 2, null);
        }
        ID3Header it = iD3Header = this.preFrame;
        boolean bl = false;
        this.preFrame = null;
        ID3Header iD3Header2 = iD3Header;
        if (iD3Header2 != null) {
            it = iD3Header2;
            boolean bl2 = false;
            return it;
        }
        switch (this.version) {
            case 4: {
                String frameID = SocketUtilKt.readString$default(this.getFqIn(), 4, null, 2, null);
                int size = this.readZeroPadded();
                int flags = SocketUtilKt.read16ui(this.getFqIn());
                if (size < 1) {
                    return null;
                }
                EnumEntries<ID3GenericFlags> enumEntries = ID3GenericFlags.getEntries();
                byte[] byArray = this.getFqIn().readNBytes(size);
                Intrinsics.checkNotNullExpressionValue(byArray, "readNBytes(...)");
                iD3Frame = new ID3Frame<ID3GenericFlags>(frameID, enumEntries, flags, byArray);
                break;
            }
            case 3: {
                String frameID = SocketUtilKt.readString$default(this.getFqIn(), 4, null, 2, null);
                int size = SocketUtilKt.read32(this.getFqIn());
                int flags = SocketUtilKt.read16ui(this.getFqIn());
                if (size < 1) {
                    return null;
                }
                EnumEntries<ID3GenericFlags> enumEntries = ID3GenericFlags.getEntries();
                byte[] byArray = this.getFqIn().readNBytes(size);
                Intrinsics.checkNotNullExpressionValue(byArray, "readNBytes(...)");
                iD3Frame = new ID3Frame<ID3GenericFlags>(frameID, enumEntries, flags, byArray);
                break;
            }
            case 2: {
                String frameID = SocketUtilKt.readString$default(this.getFqIn(), 3, null, 2, null);
                int size = SocketUtilKt.read24(this.getFqIn());
                if (size < 1) {
                    return null;
                }
                EnumEntries<ID3GenericFlags> enumEntries = ID3GenericFlags.getEntries();
                byte[] byArray = this.getFqIn().readNBytes(size);
                Intrinsics.checkNotNullExpressionValue(byArray, "readNBytes(...)");
                iD3Frame = new ID3Frame<ID3GenericFlags>(frameID, enumEntries, 0, byArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported version [" + this.version + "]");
            }
        }
        return iD3Frame;
    }

    @Override
    @NotNull
    protected Pair<ID3Frame<?>, CodingException> refineBase(@NotNull CompoundThrowable<CodingException> compound, @NotNull ID3Frame<?> of, Object ... parameters) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(of, "of");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Object[] objectArray = new Object[]{this.version};
        return super.refineBase(compound, (Tagged)of, objectArray);
    }

    @Override
    public void inputInit() {
        String tag = SocketUtilKt.readString$default(this.getFqIn(), 3, null, 2, null);
        if (!Intrinsics.areEqual(tag, "ID3")) {
            throw new InvalidInputException("Not an ID3 stream", null, 2, null);
        }
        this.version = this.getFqIn().read();
        int minor = this.getFqIn().read();
        int flags = this.getFqIn().read();
        int size = this.readZeroPadded();
        int n = this.version;
        if (!(2 <= n ? n < 5 : false)) {
            this.unsupported = true;
            this.getFqIn().skip(size);
        } else {
            byte[] byArray = this.getFqIn().readNBytes(size);
            Intrinsics.checkNotNullExpressionValue(byArray, "readNBytes(...)");
            byte[] byArray2 = byArray;
            this.setFqIn(new FailQuickInputStream<InputStream>(new ByteArrayInputStream(byArray2)));
            this.preFrame = new ID3Header(this.version, minor, flags);
        }
    }

    private static final boolean _init_$lambda$3(ID3Frame it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().charAt(0) == 'T';
    }

    /*
     * WARNING - void declaration
     */
    private static final ID3Frame _init_$lambda$5(InputStream stream, ID3Frame frame, CompoundThrowable compoundThrowable) {
        Collection this_$iv;
        Object v0;
        List $this$id$iv;
        Integer n$iv;
        block4: {
            Intrinsics.checkNotNullParameter(stream, "stream");
            Intrinsics.checkNotNullParameter(frame, "frame");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<ID3TextEncoding> enumEntries = ID3TextEncoding.getEntries();
            n$iv = stream.read();
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = $this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block4;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        ID3TextEncoding encoding = (ID3TextEncoding)enum_2;
        $this$id$iv = this_$iv = CollectionsKt.createListBuilder();
        ID3TextEncoding iD3TextEncoding = encoding;
        int n2 = (int)Flaggable.Companion.raw(frame.getFlags());
        String string = frame.getTag();
        boolean bl = false;
        try {
            while (true) {
                void $this$lambda_u245_u24lambda_u244;
                $this$lambda_u245_u24lambda_u244.add(SocketUtilKt.readString(stream, encoding.getCharset()));
            }
        }
        catch (FailQuickInputStream.EndOfStream endOfStream) {
            void $this$toTypedArray$iv;
            Unit unit = Unit.INSTANCE;
            this_$iv = CollectionsKt.build(this_$iv);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            ID3TextEncoding iD3TextEncoding2 = iD3TextEncoding;
            int n3 = n2;
            String string2 = string;
            return new ID3TextFrame(string2, n3, iD3TextEncoding2, stringArray);
        }
    }

    private static final boolean _init_$lambda$6(ID3Frame it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTag().charAt(0) == 'W';
    }

    private static final ID3Frame _init_$lambda$7(InputStream stream, ID3Frame frame, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new ID3URLLinkFrame(frame.getTag(), (int)Flaggable.Companion.raw(frame.getFlags()), new URI(SocketUtilKt.readString(stream, Charsets.ISO_8859_1)));
    }

    /*
     * WARNING - void declaration
     */
    private static final ID3Frame _init_$lambda$9(InputStream stream, ID3Frame frame, CompoundThrowable compoundThrowable) {
        void it;
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        byte[] byArray = stream.readAllBytes();
        int n = stream.read();
        String string = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
        int n2 = (int)Flaggable.Companion.raw(frame.getFlags());
        String string2 = frame.getTag();
        boolean bl = false;
        BigInteger bigInteger2 = bigInteger = ((void)it).length == 0 ? BigInteger.ZERO : new BigInteger((byte[])it);
        Intrinsics.checkNotNullExpressionValue(bigInteger2, "let(...)");
        BigInteger bigInteger3 = bigInteger2;
        int n3 = n;
        String string3 = string;
        int n4 = n2;
        String string4 = string2;
        return new ID3PopularimeterFrame(string4, n4, string3, n3, bigInteger3);
    }

    /*
     * WARNING - void declaration
     */
    private static final ID3Frame _init_$lambda$10(InputStream stream, ID3Frame frame, CompoundThrowable compoundThrowable) {
        Object v0;
        Integer n$iv;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(stream, "stream");
            Intrinsics.checkNotNullParameter(frame, "frame");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<ID3TextEncoding> enumEntries = ID3TextEncoding.getEntries();
            n$iv = stream.read();
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        ID3TextEncoding encoding = (ID3TextEncoding)enum_2;
        String string = frame.getTag();
        int n2 = (int)Flaggable.Companion.raw(frame.getFlags());
        Locale locale = Locale.of(SocketUtilKt.readString$default(stream, 3, null, 2, null));
        Intrinsics.checkNotNullExpressionValue(locale, "of(...)");
        return new ID3CommentFrame(string, n2, encoding, locale, SocketUtilKt.readString(stream, encoding.getCharset()), SocketUtilKt.readString(stream, encoding.getCharset()));
    }

    /*
     * WARNING - void declaration
     */
    private static final ID3Frame _init_$lambda$11(InputStream stream, ID3Frame frame, CompoundThrowable compoundThrowable) {
        Object v0;
        Integer n$iv;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(stream, "stream");
            Intrinsics.checkNotNullParameter(frame, "frame");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<ID3TextEncoding> enumEntries = ID3TextEncoding.getEntries();
            n$iv = stream.read();
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        ID3TextEncoding encoding = (ID3TextEncoding)enum_2;
        String string = frame.getTag();
        int n2 = (int)Flaggable.Companion.raw(frame.getFlags());
        Locale locale = Locale.of(SocketUtilKt.readString$default(stream, 3, null, 2, null));
        Intrinsics.checkNotNullExpressionValue(locale, "of(...)");
        return new ID3CommentFrame(string, n2, encoding, locale, SocketUtilKt.readString(stream, encoding.getCharset()), SocketUtilKt.readString(stream, encoding.getCharset()));
    }

    private static final ID3Frame _init_$lambda$12(InputStream stream, ID3Frame frame, CompoundThrowable compoundThrowable) {
        Object v2;
        String string;
        int n;
        ID3TextEncoding iD3TextEncoding;
        String string2;
        ID3TextEncoding encoding;
        Integer n$iv;
        block3: {
            Object v0;
            boolean bl;
            Enum it$iv;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv$iv;
            EnumEntries<ID3PictureType> $this$id$iv;
            boolean $i$f$id;
            block2: {
                Intrinsics.checkNotNullParameter(stream, "stream");
                Intrinsics.checkNotNullParameter(frame, "frame");
                Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
                Mappable.Companion companion = Mappable.Companion;
                EnumEntries<ID3TextEncoding> enumEntries = ID3TextEncoding.getEntries();
                n$iv = stream.read();
                $i$f$id = false;
                $this$firstOrNull$iv$iv = $this$id$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Enum)element$iv$iv;
                    bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v0 = element$iv$iv;
                    break block2;
                }
                v0 = null;
            }
            Integer n2 = n$iv;
            Enum enum_ = v0;
            Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n2).getEnum();
            Intrinsics.checkNotNull(enum_2);
            encoding = (ID3TextEncoding)enum_2;
            Mappable.Companion this_$iv = Mappable.Companion;
            $this$id$iv = ID3PictureType.getEntries();
            n$iv = stream.read();
            string2 = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
            iD3TextEncoding = encoding;
            n = (int)Flaggable.Companion.raw(frame.getFlags());
            string = frame.getTag();
            $i$f$id = false;
            $this$firstOrNull$iv$iv = $this$id$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                it$iv = (Enum)element$iv$iv;
                bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v2 = element$iv$iv;
                break block3;
            }
            v2 = null;
        }
        Integer n3 = n$iv;
        Enum enum_ = v2;
        MappedEnumeration<Integer, Enum> mappedEnumeration = new MappedEnumeration<Integer, Enum>(enum_, n3);
        Enum enum_3 = mappedEnumeration.getEnum();
        Intrinsics.checkNotNull(enum_3);
        ID3PictureType iD3PictureType = (ID3PictureType)enum_3;
        String string3 = SocketUtilKt.readString(stream, encoding.getCharset());
        byte[] byArray = stream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        byte[] byArray2 = byArray;
        String string4 = string3;
        ID3PictureType iD3PictureType2 = iD3PictureType;
        String string5 = string2;
        ID3TextEncoding iD3TextEncoding2 = iD3TextEncoding;
        int n4 = n;
        String string6 = string;
        return new ID3PictureFrame3(string6, n4, iD3TextEncoding2, string5, iD3PictureType2, string4, byArray2);
    }

    private static final ID3Frame _init_$lambda$13(InputStream stream, ID3Frame frame, CompoundThrowable compoundThrowable) {
        Object v2;
        String string;
        int n;
        ID3TextEncoding iD3TextEncoding;
        String string2;
        ID3TextEncoding encoding;
        Integer n$iv;
        block3: {
            Object v0;
            boolean bl;
            Enum it$iv;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv$iv;
            EnumEntries<ID3PictureType> $this$id$iv;
            boolean $i$f$id;
            block2: {
                Intrinsics.checkNotNullParameter(stream, "stream");
                Intrinsics.checkNotNullParameter(frame, "frame");
                Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
                Mappable.Companion companion = Mappable.Companion;
                EnumEntries<ID3TextEncoding> enumEntries = ID3TextEncoding.getEntries();
                n$iv = stream.read();
                $i$f$id = false;
                $this$firstOrNull$iv$iv = $this$id$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Enum)element$iv$iv;
                    bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v0 = element$iv$iv;
                    break block2;
                }
                v0 = null;
            }
            Integer n2 = n$iv;
            Enum enum_ = v0;
            Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n2).getEnum();
            Intrinsics.checkNotNull(enum_2);
            encoding = (ID3TextEncoding)enum_2;
            Mappable.Companion this_$iv = Mappable.Companion;
            $this$id$iv = ID3PictureType.getEntries();
            n$iv = stream.read();
            string2 = SocketUtilKt.readString$default(stream, 3, null, 2, null);
            iD3TextEncoding = encoding;
            n = (int)Flaggable.Companion.raw(frame.getFlags());
            string = frame.getTag();
            $i$f$id = false;
            $this$firstOrNull$iv$iv = $this$id$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                it$iv = (Enum)element$iv$iv;
                bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v2 = element$iv$iv;
                break block3;
            }
            v2 = null;
        }
        Integer n3 = n$iv;
        Enum enum_ = v2;
        MappedEnumeration<Integer, Enum> mappedEnumeration = new MappedEnumeration<Integer, Enum>(enum_, n3);
        Enum enum_3 = mappedEnumeration.getEnum();
        Intrinsics.checkNotNull(enum_3);
        ID3PictureType iD3PictureType = (ID3PictureType)enum_3;
        String string3 = SocketUtilKt.readString(stream, encoding.getCharset());
        byte[] byArray = stream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        byte[] byArray2 = byArray;
        String string4 = string3;
        ID3PictureType iD3PictureType2 = iD3PictureType;
        String string5 = string2;
        ID3TextEncoding iD3TextEncoding2 = iD3TextEncoding;
        int n4 = n;
        String string6 = string;
        return new ID3PictureFrame2(string6, n4, iD3TextEncoding2, string5, iD3PictureType2, string4, byArray2);
    }
}

