/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.iso_bmff;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bread_experts_group.coder.CodingException;
import org.bread_experts_group.coder.CompoundThrowable;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.bread_experts_group.coder.format.parse.Parser;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOBMFFBox;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOBMFFContainerBox;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOBMFFContainerFullBox;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOBMFFCopyrightBoxV0;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOBMFFFileTypeCompatibilityBox;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOBMFFHandlerFullBoxV0;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOBMFFMediaHeaderFullBoxV0;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOBMFFTrackHeaderFullBoxV0;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOMBFFMovieHeaderBoxV0;
import org.bread_experts_group.coder.format.parse.iso_bmff.box.ISOMBFFMovieHeaderBoxV1;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u001a\u0010\t\u001a\u00020\u00032\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0014J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002J\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0004\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/coder/format/parse/iso_bmff/ISOBMFFParser;", "Lorg/bread_experts_group/coder/format/parse/Parser;", "", "Lorg/bread_experts_group/coder/format/parse/iso_bmff/box/ISOBMFFBox;", "Ljava/io/InputStream;", "<init>", "()V", "responsibleStream", "of", "readBase", "compound", "Lorg/bread_experts_group/coder/CompoundThrowable;", "Lorg/bread_experts_group/coder/CodingException;", "Lorg/bread_experts_group/coder/format/parse/CodingCompoundThrowable;", "containerBox", "", "name", "containerFullBox", "fullBox", "Lkotlin/Pair;", "", "stream", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nISOBMFFParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ISOBMFFParser.kt\norg/bread_experts_group/coder/format/parse/iso_bmff/ISOBMFFParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class ISOBMFFParser
extends Parser<String, ISOBMFFBox, InputStream> {
    public ISOBMFFParser() {
        super("ISO Base Media File Format", Reflection.getOrCreateKotlinClass(InputStream.class));
        this.containerBox("moov");
        this.containerBox("trak");
        this.containerBox("mdia");
        this.containerBox("udta");
        this.containerBox("minf");
        this.containerBox("dinf");
        this.containerBox("stbl");
        this.containerFullBox("meta");
        this.addParser("cprt", (arg_0, arg_1, arg_2) -> ISOBMFFParser._init_$lambda$6(this, arg_0, arg_1, arg_2));
        this.addParser("ftyp", ISOBMFFParser::_init_$lambda$8);
        this.addParser("mvhd", (arg_0, arg_1, arg_2) -> ISOBMFFParser._init_$lambda$9(this, arg_0, arg_1, arg_2));
        this.addParser("mdhd", (arg_0, arg_1, arg_2) -> ISOBMFFParser._init_$lambda$10(this, arg_0, arg_1, arg_2));
        this.addParser("tkhd", (arg_0, arg_1, arg_2) -> ISOBMFFParser._init_$lambda$11(this, arg_0, arg_1, arg_2));
        this.addParser("hdlr", (arg_0, arg_1, arg_2) -> ISOBMFFParser._init_$lambda$13(this, arg_0, arg_1, arg_2));
        this.containerBox("ilst");
    }

    @Override
    @NotNull
    protected InputStream responsibleStream(@NotNull ISOBMFFBox of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return new ByteArrayInputStream(of.getData());
    }

    @Override
    @NotNull
    protected ISOBMFFBox readBase(@NotNull CompoundThrowable<CodingException> compound) {
        long size64;
        Intrinsics.checkNotNullParameter(compound, "compound");
        long size32 = SocketUtilKt.read32ul(this.getFqIn());
        boolean bl = false;
        String name = SocketUtilKt.readString$default(this.getFqIn(), 4, null, 2, null);
        long l = size64 = size32 == 1L ? SocketUtilKt.read64(this.getFqIn()) : size32;
        if (size64 > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Size is too big [" + ULong.toString-impl(ULong.constructor-impl(size64)) + "]!");
        }
        Pair<String, byte[]> pair = TuplesKt.to(name, size32 == 0L ? this.getFqIn().readAllBytes() : this.getFqIn().readNBytes((int)size64 - 8));
        String name2 = pair.component1();
        byte[] data = pair.component2();
        Intrinsics.checkNotNull(data);
        return new ISOBMFFBox(name2, data);
    }

    public final void containerBox(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.addParser(name, ISOBMFFParser::containerBox$lambda$1);
    }

    public final void containerFullBox(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.addParser(name, (arg_0, arg_1, arg_2) -> ISOBMFFParser.containerFullBox$lambda$2(this, arg_0, arg_1, arg_2));
    }

    @NotNull
    public final Pair<Integer, Integer> fullBox(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        return TuplesKt.to(stream.read(), SocketUtilKt.read24(stream));
    }

    private static final ISOBMFFBox containerBox$lambda$1(InputStream stream, ISOBMFFBox box, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new ISOBMFFContainerBox(box.getTag(), new ISOBMFFParser().setInput(stream));
    }

    private static final ISOBMFFBox containerFullBox$lambda$2(ISOBMFFParser this$0, InputStream stream, ISOBMFFBox box, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        Pair<Integer, Integer> pair = this$0.fullBox(stream);
        int version = ((Number)pair.component1()).intValue();
        int flags = ((Number)pair.component2()).intValue();
        return new ISOBMFFContainerFullBox(box.getTag(), new ISOBMFFParser().setInputFq(this$0.getFqIn()), version, flags);
    }

    private static final Locale _init_$readLanguage(InputStream $this$_init__u24readLanguage) {
        Locale locale;
        block5: {
            int it = SocketUtilKt.read16ui($this$_init__u24readLanguage);
            boolean bl = false;
            int n = (it >> 10 & 0x1F) + 96;
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + n);
            }
            char c2 = (char)n;
            n = (it >> 5 & 0x1F) + 96;
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + n);
            }
            char c3 = (char)n;
            n = (it & 0x1F) + 96;
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + n);
            }
            String langCode = "" + c2 + c3 + (char)n;
            String[] stringArray = Locale.getISOLanguages();
            Intrinsics.checkNotNullExpressionValue(stringArray, "getISOLanguages(...)");
            Object[] objectArray = stringArray;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                String it2 = (String)objectArray[i];
                boolean bl2 = false;
                Locale locale2 = Locale.of(it2);
                locale = Intrinsics.areEqual(locale2.getISO3Language(), langCode) ? locale2 : null;
                if (locale == null) {
                    continue;
                }
                break block5;
            }
            locale = null;
        }
        return locale;
    }

    /*
     * WARNING - void declaration
     */
    private static final ISOBMFFBox _init_$lambda$6(ISOBMFFParser this$0, InputStream stream, ISOBMFFBox box, CompoundThrowable compoundThrowable) {
        void it;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        Pair<Integer, Integer> pair = this$0.fullBox(stream);
        int version = ((Number)pair.component1()).intValue();
        int flags = ((Number)pair.component2()).intValue();
        if (version != 0) {
            throw new InvalidInputException("Unsupported version: " + version, null, 2, null);
        }
        byte[] byArray = stream.readAllBytes();
        Locale locale = ISOBMFFParser._init_$readLanguage(stream);
        int n = flags;
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        byte[] byArray2 = ArraysKt.sliceArray((byte[])it, RangesKt.until(0, ((void)it).length - 1));
        String string = StringsKt.decodeToString(byArray2);
        Locale locale2 = locale;
        int n2 = n;
        return new ISOBMFFCopyrightBoxV0(n2, locale2, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final ISOBMFFBox _init_$lambda$8(InputStream stream, ISOBMFFBox box, CompoundThrowable compoundThrowable) {
        List list;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        List list2 = list = CollectionsKt.createListBuilder();
        int n = SocketUtilKt.read32(stream);
        String string = SocketUtilKt.readString$default(stream, 4, null, 2, null);
        boolean bl = false;
        while (stream.available() > 0) {
            void $this$lambda_u248_u24lambda_u247;
            $this$lambda_u248_u24lambda_u247.add(SocketUtilKt.readString$default(stream, 4, null, 2, null));
        }
        Unit unit = Unit.INSTANCE;
        List<String> list3 = CollectionsKt.build(list);
        int n2 = n;
        String string2 = string;
        return new ISOBMFFFileTypeCompatibilityBox(string2, n2, list3);
    }

    private static final ZonedDateTime _init_$zonedDateTime(long n, long y) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(n), ZoneId.of("UTC")).plusYears(y);
        Intrinsics.checkNotNullExpressionValue(zonedDateTime, "plusYears(...)");
        return zonedDateTime;
    }

    private static final ISOBMFFBox _init_$lambda$9(ISOBMFFParser this$0, InputStream stream, ISOBMFFBox box, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        Pair<Integer, Integer> pair = this$0.fullBox(stream);
        int version = ((Number)pair.component1()).intValue();
        int flags = ((Number)pair.component2()).intValue();
        return switch (version) {
            case 0 -> {
                ZonedDateTime v0 = ISOBMFFParser._init_$zonedDateTime(SocketUtilKt.read32ul(stream), -66L);
                ZonedDateTime v1 = ISOBMFFParser._init_$zonedDateTime(SocketUtilKt.read32ul(stream), -66L);
                int v2 = SocketUtilKt.read32(stream);
                int v3 = SocketUtilKt.read32(stream);
                double v4 = (double)SocketUtilKt.read16ui(stream) + (double)SocketUtilKt.read16ui(stream) / 65536.0;
                double v5 = (double)stream.read() + (double)stream.read() / 256.0;
                byte[] v6 = stream.readNBytes(10);
                Intrinsics.checkNotNullExpressionValue(v6, "readNBytes(...)");
                int var7_7 = 0;
                Integer[] var8_9 = new Integer[9];
                byte[] var19_11 = v6;
                double var17_12 = v5;
                double var15_13 = v4;
                int var14_14 = v3;
                int var13_16 = v2;
                ZonedDateTime var12_18 = v1;
                ZonedDateTime var11_20 = v0;
                int var10_22 = flags;
                while (var7_7 < 9) {
                    int var9_24 = var7_7++;
                    var8_9[var9_24] = SocketUtilKt.read32(stream);
                }
                int[] v7 = ArraysKt.toIntArray(var8_9);
                byte[] v8 = stream.readNBytes(24);
                Intrinsics.checkNotNullExpressionValue(v8, "readNBytes(...)");
                int var21_26 = SocketUtilKt.read32(stream);
                byte[] var22_27 = v8;
                int[] var23_28 = v7;
                byte[] var24_29 = var19_11;
                double var25_30 = var17_12;
                double var27_31 = var15_13;
                int var29_32 = var14_14;
                int var30_33 = var13_16;
                ZonedDateTime var31_34 = var12_18;
                ZonedDateTime var32_35 = var11_20;
                int var33_36 = var10_22;
                yield new ISOMBFFMovieHeaderBoxV0(var33_36, var32_35, var31_34, var30_33, var29_32, var27_31, var25_30, var24_29, var23_28, var22_27, var21_26);
            }
            case 1 -> {
                ZonedDateTime v10 = ISOBMFFParser._init_$zonedDateTime(SocketUtilKt.read64(stream), 70L);
                ZonedDateTime v11 = ISOBMFFParser._init_$zonedDateTime(SocketUtilKt.read64(stream), 70L);
                int v12 = SocketUtilKt.read32(stream);
                long v13 = SocketUtilKt.read64(stream);
                double v14 = (double)SocketUtilKt.read16ui(stream) + (double)SocketUtilKt.read16ui(stream) / 65536.0;
                double v15 = (double)stream.read() + (double)stream.read() / 256.0;
                byte[] v16 = stream.readNBytes(10);
                Intrinsics.checkNotNullExpressionValue(v16, "readNBytes(...)");
                int var7_8 = 0;
                Integer[] var8_10 = new Integer[9];
                byte[] var20_37 = v16;
                double var18_38 = v15;
                double var16_39 = v14;
                long var14_15 = v13;
                int var13_17 = v12;
                ZonedDateTime var12_19 = v11;
                ZonedDateTime var11_21 = v10;
                int var10_23 = flags;
                while (var7_8 < 9) {
                    int var9_25 = var7_8++;
                    var8_10[var9_25] = SocketUtilKt.read32(stream);
                }
                int[] v17 = ArraysKt.toIntArray(var8_10);
                byte[] v18 = stream.readNBytes(24);
                Intrinsics.checkNotNullExpressionValue(v18, "readNBytes(...)");
                int var34_40 = SocketUtilKt.read32(stream);
                byte[] var35_41 = v18;
                int[] var36_42 = v17;
                byte[] var37_43 = var20_37;
                double var38_44 = var18_38;
                double var40_45 = var16_39;
                long var42_46 = var14_15;
                int var44_47 = var13_17;
                ZonedDateTime var45_48 = var12_19;
                ZonedDateTime var46_49 = var11_21;
                int var47_50 = var10_23;
                yield new ISOMBFFMovieHeaderBoxV1(var47_50, var46_49, var45_48, var44_47, var42_46, var40_45, var38_44, var37_43, var36_42, var35_41, var34_40);
            }
            default -> throw new InvalidInputException("Unsupported version: " + version, null, 2, null);
        };
    }

    private static final ISOBMFFBox _init_$lambda$10(ISOBMFFParser this$0, InputStream stream, ISOBMFFBox box, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        Pair<Integer, Integer> pair = this$0.fullBox(stream);
        int version = ((Number)pair.component1()).intValue();
        int flags = ((Number)pair.component2()).intValue();
        if (version != 0) {
            throw new InvalidInputException("Unsupported version: " + version, null, 2, null);
        }
        return new ISOBMFFMediaHeaderFullBoxV0(flags, ISOBMFFParser._init_$zonedDateTime(SocketUtilKt.read32ul(stream), -66L), ISOBMFFParser._init_$zonedDateTime(SocketUtilKt.read32ul(stream), -66L), SocketUtilKt.read32(stream), SocketUtilKt.read32(stream), ISOBMFFParser._init_$readLanguage(stream), SocketUtilKt.read16ui(stream));
    }

    private static final ISOBMFFBox _init_$lambda$11(ISOBMFFParser this$0, InputStream stream, ISOBMFFBox box, CompoundThrowable compoundThrowable) {
        int[] nArray;
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        ZonedDateTime zonedDateTime;
        ZonedDateTime zonedDateTime2;
        int n5;
        int n6;
        int n7;
        Integer[] integerArray;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        Pair<Integer, Integer> pair = this$0.fullBox(stream);
        int version = ((Number)pair.component1()).intValue();
        int flags = ((Number)pair.component2()).intValue();
        if (version == 0) {
            int n8;
            int n9 = 0;
            integerArray = new Integer[2];
            n7 = SocketUtilKt.read32(stream);
            n6 = SocketUtilKt.read32(stream);
            n5 = SocketUtilKt.read32(stream);
            zonedDateTime2 = ISOBMFFParser._init_$zonedDateTime(SocketUtilKt.read32ul(stream), -66L);
            zonedDateTime = ISOBMFFParser._init_$zonedDateTime(SocketUtilKt.read32ul(stream), -66L);
            n4 = flags;
            while (n9 < 2) {
                n8 = n9++;
                integerArray[n8] = SocketUtilKt.read32(stream);
            }
            int[] nArray2 = ArraysKt.toIntArray(integerArray);
            n9 = 0;
            integerArray = new Integer[9];
            n3 = SocketUtilKt.read16ui(stream);
            d = (double)stream.read() + (double)stream.read() / 256.0;
            n2 = SocketUtilKt.read16ui(stream);
            n = SocketUtilKt.read16ui(stream);
            nArray = nArray2;
            while (n9 < 9) {
                n8 = n9++;
                integerArray[n8] = SocketUtilKt.read32(stream);
            }
        } else {
            throw new InvalidInputException("Unsupported version: " + version, null, 2, null);
        }
        double d2 = (double)SocketUtilKt.read16ui(stream) + (double)SocketUtilKt.read16ui(stream) / 65536.0;
        double d3 = (double)SocketUtilKt.read16ui(stream) + (double)SocketUtilKt.read16ui(stream) / 65536.0;
        int[] nArray3 = ArraysKt.toIntArray(integerArray);
        int n10 = n3;
        double d4 = d;
        int n11 = n2;
        int n12 = n;
        int[] nArray4 = nArray;
        int n13 = n7;
        int n14 = n6;
        int n15 = n5;
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        ZonedDateTime zonedDateTime4 = zonedDateTime;
        int n16 = n4;
        return new ISOBMFFTrackHeaderFullBoxV0(n16, zonedDateTime4, zonedDateTime3, n15, n14, n13, nArray4, n12, n11, d4, n10, nArray3, d3, d2);
    }

    /*
     * WARNING - void declaration
     */
    private static final ISOBMFFBox _init_$lambda$13(ISOBMFFParser this$0, InputStream stream, ISOBMFFBox box, CompoundThrowable compoundThrowable) {
        void it;
        int n;
        int n2;
        String string;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        Pair<Integer, Integer> pair = this$0.fullBox(stream);
        int version = ((Number)pair.component1()).intValue();
        int flags = ((Number)pair.component2()).intValue();
        if (version == 0) {
            int n3 = 0;
            objectArray = new Integer[3];
            string = SocketUtilKt.readString$default(stream, 4, null, 2, null);
            n2 = SocketUtilKt.read32(stream);
            n = flags;
            while (n3 < 3) {
                int n4 = n3++;
                objectArray[n4] = SocketUtilKt.read32(stream);
            }
        } else {
            throw new InvalidInputException("Unsupported version: " + version, null, 2, null);
        }
        int[] nArray = ArraysKt.toIntArray(objectArray);
        objectArray = stream.readAllBytes();
        int[] nArray2 = nArray;
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        byte[] byArray = ArraysKt.sliceArray((byte[])it, RangesKt.until(0, ((void)it).length - 1));
        String string2 = StringsKt.decodeToString(byArray);
        int[] nArray3 = nArray2;
        String string3 = string;
        int n5 = n2;
        int n6 = n;
        return new ISOBMFFHandlerFullBoxV0(n6, n5, string3, nArray3, string2);
    }
}

