/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.iso_bmff.box;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bread_experts_group.stream.SocketUtilKt;
import org.bread_experts_group.stream.Tagged;
import org.bread_experts_group.stream.Writable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/bread_experts_group/coder/format/parse/iso_bmff/box/ISOBMFFBox;", "Lorg/bread_experts_group/stream/Writable;", "Lorg/bread_experts_group/stream/Tagged;", "", "tag", "data", "", "<init>", "(Ljava/lang/String;[B)V", "getTag", "()Ljava/lang/String;", "getData", "()[B", "computeSize", "", "write", "", "stream", "Ljava/io/OutputStream;", "toString", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nISOBMFFBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ISOBMFFBox.kt\norg/bread_experts_group/coder/format/parse/iso_bmff/box/ISOBMFFBox\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public class ISOBMFFBox
implements Writable,
Tagged<String> {
    @NotNull
    private final String tag;
    @NotNull
    private final byte[] data;

    public ISOBMFFBox(@NotNull String tag, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(data, "data");
        this.tag = tag;
        this.data = data;
        if (!(this.getTag().length() == 4)) {
            boolean bl = false;
            String string = "Name must be exactly 4 characters long";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @Override
    public long computeSize() {
        return this.data.length;
    }

    @Override
    public void write(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        SocketUtilKt.write32(stream, this.computeSize());
        SocketUtilKt.writeString(stream, this.getTag(), Charsets.US_ASCII);
        stream.write(this.data);
    }

    @NotNull
    public String toString() {
        return "ISOBMFFBox.\"" + this.getTag() + "\"[" + this.data.length + "]";
    }

    @Override
    @NotNull
    public byte[] asBytes() {
        return Writable.super.asBytes();
    }
}

