/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.png;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.channel.BufferUtilKt;
import org.bread_experts_group.channel.WindowedSeekableByteChannel;
import org.bread_experts_group.coder.CodingException;
import org.bread_experts_group.coder.CompoundThrowable;
import org.bread_experts_group.coder.Flaggable;
import org.bread_experts_group.coder.Mappable;
import org.bread_experts_group.coder.MappedEnumeration;
import org.bread_experts_group.coder.SaveSingle;
import org.bread_experts_group.coder.format.parse.ByteParser;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.bread_experts_group.coder.format.parse.RefinementException;
import org.bread_experts_group.coder.format.parse.UnsupportedValueException;
import org.bread_experts_group.coder.format.parse.ValidationException;
import org.bread_experts_group.coder.format.parse.gif.GIFDisposalMethod;
import org.bread_experts_group.coder.format.parse.png.PNGBlendOperation;
import org.bread_experts_group.coder.format.parse.png.PNGCompressionType;
import org.bread_experts_group.coder.format.parse.png.PNGDisposeOperation;
import org.bread_experts_group.coder.format.parse.png.PNGFilterType;
import org.bread_experts_group.coder.format.parse.png.PNGHeaderFlags;
import org.bread_experts_group.coder.format.parse.png.PNGICPVSTIDColorPrimaries;
import org.bread_experts_group.coder.format.parse.png.PNGICPVSTIDMatrixCoefficients;
import org.bread_experts_group.coder.format.parse.png.PNGICPVSTIDTransferFunction;
import org.bread_experts_group.coder.format.parse.png.PNGInterlaceType;
import org.bread_experts_group.coder.format.parse.png.PNGPixelCalibrationEquationType;
import org.bread_experts_group.coder.format.parse.png.PNGPixelDimensions;
import org.bread_experts_group.coder.format.parse.png.PNGPrintOffsetUnit;
import org.bread_experts_group.coder.format.parse.png.PNGSRGBIntent;
import org.bread_experts_group.coder.format.parse.png.PNGStereoscopyMode;
import org.bread_experts_group.coder.format.parse.png.PNGSubjectPhysicalScaleUnit;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGAnimationControlChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGBackgroundChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGChromaticitiesChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGCompressedTextChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGContentLightLevelInfoChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGDataChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGEXIFChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGEmbeddedICCChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGFrameControlChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGFrameDataChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGGIFApplicationExtension;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGGIFGraphicControlExtensionChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGGammaChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGHeaderChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGHistogramChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGICPVSTIDChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGInternationalTextChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGMasteringDisplayColorVolumeChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGPaletteChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGPhysicalPixelDimensionsChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGPixelCalibrationChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGPrintOffsetChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGSRGBChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGSignificantBitsChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGStereoscopyChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGSubjectPhysicalScaleChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGSuggestedPaletteChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGTextChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGTimestampChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGTransparencyPaletteChunk;
import org.bread_experts_group.coder.format.parse.png.chunk.PNGTransparencySingleChunk;
import org.bread_experts_group.coder.format.parse.tiff.TIFFByteParser;
import org.bread_experts_group.io.reader.ReadingByteBuffer;
import org.bread_experts_group.numeric.geometry.Point2D;
import org.bread_experts_group.stream.FailQuickInputStream;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0014J;\u0010\u0017\u001a\u00020\u00032\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b2\u0006\u0010\b\u001a\u00020\u00032\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0014\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010&\u001a\u0004\u0018\u00010\u00032\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\u00032\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0014J\b\u0010,\u001a\u00020-H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/bread_experts_group/coder/format/parse/png/PNGByteParser;", "Lorg/bread_experts_group/coder/format/parse/ByteParser;", "", "Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGChunk;", "Ljava/nio/channels/SeekableByteChannel;", "<init>", "()V", "responsibleChannel", "of", "mustAppear", "", "unsafeToAppear", "<set-?>", "savedNext", "getSavedNext", "()Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGChunk;", "setSavedNext", "(Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGChunk;)V", "savedNext$delegate", "Lorg/bread_experts_group/coder/SaveSingle;", "shouldHaveEnded", "", "isUnknown", "fallbackBase", "compound", "Lorg/bread_experts_group/coder/CompoundThrowable;", "Lorg/bread_experts_group/coder/CodingException;", "Lorg/bread_experts_group/coder/format/parse/CodingCompoundThrowable;", "parameter", "", "", "(Lorg/bread_experts_group/coder/CompoundThrowable;Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGChunk;[Ljava/lang/Object;)Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGChunk;", "array4", "", "buffer12", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "crc32Buffer", "internalReadBase", "readBase", "header", "Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGHeaderChunk;", "palette", "Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGPaletteChunk;", "inputInit", "", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nPNGByteParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PNGByteParser.kt\norg/bread_experts_group/coder/format/parse/png/PNGByteParser\n+ 2 Mappable.kt\norg/bread_experts_group/coder/Mappable$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,681:1\n14#2,2:682\n16#2:685\n18#2,2:687\n14#2,2:689\n16#2:692\n18#2,2:694\n14#2,2:696\n16#2:699\n18#2,2:701\n14#2,2:704\n16#2:707\n18#2,2:709\n14#2,2:711\n16#2:714\n18#2,2:716\n14#2,2:718\n16#2:721\n18#2,2:723\n14#2,2:725\n16#2:728\n18#2,2:730\n14#2,2:732\n16#2:735\n18#2,2:737\n14#2,2:739\n16#2:742\n18#2,2:744\n14#2,2:746\n16#2:749\n18#2,2:751\n14#2,2:753\n16#2:756\n18#2,2:758\n14#2,2:760\n16#2:763\n18#2,2:765\n14#2,2:767\n16#2:770\n18#2,2:772\n14#2,2:774\n16#2:777\n18#2,2:779\n14#2,2:781\n16#2:784\n18#2,2:786\n14#2,2:788\n16#2:791\n18#2,2:793\n14#2,2:795\n16#2:798\n18#2,2:800\n14#2,2:802\n16#2:805\n18#2,2:807\n295#3:684\n296#3:686\n295#3:691\n296#3:693\n295#3:698\n296#3:700\n295#3:706\n296#3:708\n295#3:713\n296#3:715\n295#3:720\n296#3:722\n295#3:727\n296#3:729\n295#3:734\n296#3:736\n295#3:741\n296#3:743\n295#3:748\n296#3:750\n295#3:755\n296#3:757\n295#3:762\n296#3:764\n295#3:769\n296#3:771\n295#3:776\n296#3:778\n295#3:783\n296#3:785\n295#3:790\n296#3:792\n295#3:797\n296#3:799\n295#3:804\n296#3:806\n1#4:703\n*S KotlinDebug\n*F\n+ 1 PNGByteParser.kt\norg/bread_experts_group/coder/format/parse/png/PNGByteParser\n*L\n214#1:682,2\n214#1:685\n214#1:687,2\n215#1:689,2\n215#1:692\n215#1:694,2\n216#1:696,2\n216#1:699\n216#1:701,2\n301#1:704,2\n301#1:707\n301#1:709,2\n302#1:711,2\n302#1:714\n302#1:716,2\n429#1:718,2\n429#1:721\n429#1:723,2\n480#1:725,2\n480#1:728\n480#1:730,2\n500#1:732,2\n500#1:735\n500#1:737,2\n534#1:739,2\n534#1:742\n534#1:744,2\n555#1:746,2\n555#1:749\n555#1:751,2\n564#1:753,2\n564#1:756\n564#1:758,2\n565#1:760,2\n565#1:763\n565#1:765,2\n566#1:767,2\n566#1:770\n566#1:772,2\n601#1:774,2\n601#1:777\n601#1:779,2\n612#1:781,2\n612#1:784\n612#1:786,2\n619#1:788,2\n619#1:791\n619#1:793,2\n630#1:795,2\n630#1:798\n630#1:800,2\n646#1:802,2\n646#1:805\n646#1:807,2\n214#1:684\n214#1:686\n215#1:691\n215#1:693\n216#1:698\n216#1:700\n301#1:706\n301#1:708\n302#1:713\n302#1:715\n429#1:720\n429#1:722\n480#1:727\n480#1:729\n500#1:734\n500#1:736\n534#1:741\n534#1:743\n555#1:748\n555#1:750\n564#1:755\n564#1:757\n565#1:762\n565#1:764\n566#1:769\n566#1:771\n601#1:776\n601#1:778\n612#1:783\n612#1:785\n619#1:790\n619#1:792\n630#1:797\n630#1:799\n646#1:804\n646#1:806\n*E\n"})
public final class PNGByteParser
extends ByteParser<String, PNGChunk, SeekableByteChannel> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Set<String> mustAppear = new LinkedHashSet();
    @NotNull
    private final Set<String> unsafeToAppear = new LinkedHashSet();
    @NotNull
    private final SaveSingle savedNext$delegate = new SaveSingle(null, 1, null);
    private boolean shouldHaveEnded;
    @NotNull
    private final byte[] array4 = new byte[4];
    private final ByteBuffer buffer12 = ByteBuffer.allocate(12);
    private final ByteBuffer crc32Buffer = ByteBuffer.allocate(4096);
    private PNGHeaderChunk header;
    private PNGPaletteChunk palette;

    public PNGByteParser() {
        super("Portable Network Graphics");
        this.addParser("IHDR", (arg_0, arg_1, arg_2) -> PNGByteParser._init_$lambda$1(this, arg_0, arg_1, arg_2));
        this.addParser("PLTE", (arg_0, arg_1, arg_2) -> PNGByteParser._init_$lambda$3(this, arg_0, arg_1, arg_2));
        this.addParser("sPLT", PNGByteParser::_init_$lambda$5);
        this.addParser("acTL", PNGByteParser::_init_$lambda$6);
        this.addParser("fcTL", PNGByteParser::_init_$lambda$8);
        this.addParser("gAMA", PNGByteParser::_init_$lambda$9);
        this.addParser("sBIT", (arg_0, arg_1, arg_2) -> PNGByteParser._init_$lambda$11(this, arg_0, arg_1, arg_2));
        this.addParser("bKGD", (arg_0, arg_1, arg_2) -> PNGByteParser._init_$lambda$12(this, arg_0, arg_1, arg_2));
        this.addParser("tRNS", (arg_0, arg_1, arg_2) -> PNGByteParser._init_$lambda$14(this, arg_0, arg_1, arg_2));
        this.addParser("cHRM", PNGByteParser::_init_$lambda$15);
        this.addParser("pHYs", PNGByteParser::_init_$lambda$16);
        this.addParser("hIST", PNGByteParser::_init_$lambda$18);
        this.addParser("tIME", PNGByteParser::_init_$lambda$19);
        this.addParser("tEXt", PNGByteParser::_init_$lambda$20);
        this.addParser("zTXt", PNGByteParser::_init_$lambda$22);
        this.addParser("iTXt", PNGByteParser::_init_$lambda$24);
        this.addParser("eXIf", PNGByteParser::_init_$lambda$25);
        this.addParser("iCCP", PNGByteParser::_init_$lambda$27);
        this.addParser("sRGB", PNGByteParser::_init_$lambda$28);
        this.addParser("cICP", PNGByteParser::_init_$lambda$29);
        this.addParser("mDCV", PNGByteParser::_init_$lambda$30);
        this.addParser("cLLI", PNGByteParser::_init_$lambda$31);
        this.addParser("sTER", PNGByteParser::_init_$lambda$32);
        this.addParser("oFFs", PNGByteParser::_init_$lambda$33);
        this.addParser("sCAL", PNGByteParser::_init_$lambda$34);
        this.addParser("pCAL", PNGByteParser::_init_$lambda$36);
        this.addParser("gIFg", PNGByteParser::_init_$lambda$37);
        this.addParser("gIFx", PNGByteParser::_init_$lambda$38);
        this.addParser("IDAT", PNGByteParser::_init_$lambda$39);
        this.addParser("fdAT", PNGByteParser::_init_$lambda$40);
        this.addParser("IEND", PNGByteParser::_init_$lambda$41);
    }

    @Override
    @NotNull
    protected SeekableByteChannel responsibleChannel(@NotNull PNGChunk of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return of.getWindow();
    }

    private final PNGChunk getSavedNext() {
        return (PNGChunk)this.savedNext$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setSavedNext(PNGChunk pNGChunk) {
        this.savedNext$delegate.setValue(this, $$delegatedProperties[0], pNGChunk);
    }

    @Override
    protected boolean isUnknown(@NotNull PNGChunk of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return of.getSpecification();
    }

    @Override
    @NotNull
    protected PNGChunk fallbackBase(@NotNull CompoundThrowable<CodingException> compound, @NotNull PNGChunk of, Object ... parameter) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        Intrinsics.checkNotNullParameter(of, "of");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        if (Intrinsics.areEqual(of.getTag(), "IDAT") || Intrinsics.areEqual(of.getTag(), "IEND")) {
            return of;
        }
        if (of.getCritical()) {
            compound.addThrown((CodingException)((Throwable)new ValidationException("Unrecognized critical " + of)));
        }
        if (of.getSpecification()) {
            compound.addThrown((CodingException)((Throwable)new ValidationException("Unrecognized specification " + of)));
        }
        if (of.getReserved()) {
            compound.addThrown((CodingException)((Throwable)new ValidationException("Illegal reserved " + of)));
        }
        return of;
    }

    private final PNGChunk internalReadBase(CompoundThrowable<CodingException> compound) {
        int read;
        this.buffer12.limit(8);
        this.buffer12.rewind();
        ((SeekableByteChannel)this.getChannel()).read(this.buffer12);
        this.buffer12.rewind();
        int length = this.buffer12.getInt();
        if (length < 0 || (long)length > ((SeekableByteChannel)this.getChannel()).position() + ((SeekableByteChannel)this.getChannel()).size()) {
            compound.addThrown((CodingException)((Throwable)new InvalidInputException("Corrupted stream [" + length + "]", null, 2, null)));
            return null;
        }
        CRC32 crc32 = new CRC32();
        this.buffer12.get(this.array4);
        crc32.update(this.array4);
        String chunkType = new String(this.array4, Charsets.ISO_8859_1);
        boolean bl = this.mustAppear.contains("IHDR") && !Intrinsics.areEqual(chunkType, "IHDR") ? compound.addThrown((CodingException)((Throwable)new ValidationException("\"" + chunkType + "\" came before \"IHDR\""))) : this.mustAppear.remove("IHDR");
        if (this.unsafeToAppear.contains(chunkType)) {
            compound.addThrown((CodingException)((Throwable)new ValidationException("\"" + chunkType + "\" reappeared where it was not allowed; bad: " + this.unsafeToAppear)));
        }
        if (this.shouldHaveEnded) {
            compound.addThrown((CodingException)((Throwable)new ValidationException("\"" + chunkType + "\" came after \"IEND\"")));
        }
        long from = ((SeekableByteChannel)this.getChannel()).position();
        for (int computed = 0; computed < length; computed += read) {
            this.crc32Buffer.limit(Math.min(this.crc32Buffer.capacity(), length - computed));
            this.crc32Buffer.rewind();
            read = ((SeekableByteChannel)this.getChannel()).read(this.crc32Buffer);
            if (read == -1) {
                throw new EOFException();
            }
            crc32.update(this.crc32Buffer.array(), 0, read);
        }
        this.buffer12.limit(12);
        ((SeekableByteChannel)this.getChannel()).read(this.buffer12);
        this.buffer12.position(8);
        long chunkCRC32 = (long)this.buffer12.getInt() & 0xFFFFFFFFL;
        long computedCRC32 = crc32.getValue();
        if (chunkCRC32 != computedCRC32) {
            compound.addThrown((CodingException)((Throwable)new ValidationException("CRC32 incorrect; [" + FormattingKt.hex-WZ4Q5Ns(UInt.constructor-impl((int)chunkCRC32)) + " =/= " + FormattingKt.hex-WZ4Q5Ns(UInt.constructor-impl((int)computedCRC32)) + "]")));
        }
        this.buffer12.limit(8);
        this.buffer12.rewind();
        return new PNGChunk(chunkType, new WindowedSeekableByteChannel((SeekableByteChannel)this.getChannel(), from, from + (long)length));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected PNGChunk readBase(@NotNull CompoundThrowable<CodingException> compound) {
        block56: {
            block57: {
                Intrinsics.checkNotNullParameter(compound, "compound");
                v0 = this.getSavedNext();
                if (v0 != null) break block56;
                $this$readBase_u24lambda_u240 = this;
                $i$a$-run-PNGByteParser$readBase$1 = false;
                if (((SeekableByteChannel)$this$readBase_u24lambda_u240.getChannel()).position() == ((SeekableByteChannel)$this$readBase_u24lambda_u240.getChannel()).size()) {
                    throw new EOFException();
                }
                base = $this$readBase_u24lambda_u240.internalReadBase(compound);
                if (base != null) break block57;
                v0 = null;
                break block56;
            }
            var5_5 = base.getTag();
            tmp = -1;
            switch (var5_5.hashCode()) {
                case 3133390: {
                    if (var5_5.equals("gAMA")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3408658: {
                    if (var5_5.equals("pHYs")) {
                        tmp = 1;
                    }
                    break;
                }
                case 2458989: {
                    if (var5_5.equals("PLTE")) {
                        tmp = 2;
                    }
                    break;
                }
                case 3024774: {
                    if (var5_5.equals("cLLI")) {
                        tmp = 1;
                    }
                    break;
                }
                case 2993862: {
                    if (var5_5.equals("bKGD")) {
                        tmp = 1;
                    }
                    break;
                }
                case 2242190: {
                    if (var5_5.equals("IDAT")) {
                        tmp = 3;
                    }
                    break;
                }
                case 3021120: {
                    if (var5_5.equals("cHRM")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3507034: {
                    if (var5_5.equals("sRGB")) {
                        tmp = 4;
                    }
                    break;
                }
                case 2246125: {
                    if (var5_5.equals("IHDR")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3491738: {
                    if (var5_5.equals("sBIT")) {
                        tmp = 1;
                    }
                    break;
                }
                case 2243538: {
                    if (var5_5.equals("IEND")) {
                        tmp = 5;
                    }
                    break;
                }
                case 3171074: {
                    if (var5_5.equals("hIST")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3537059: {
                    if (var5_5.equals("tRNS")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3194599: {
                    if (var5_5.equals("iCCP")) {
                        tmp = 4;
                    }
                    break;
                }
                case 2987546: {
                    if (var5_5.equals("acTL")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3314730: {
                    if (var5_5.equals("mDCV")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3528365: {
                    if (var5_5.equals("tIME")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3021619: {
                    if (var5_5.equals("cICP")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3136881: {
                    if (var5_5.equals("fdAT")) {
                        tmp = 6;
                    }
                    break;
                }
                case 3095824: {
                    if (var5_5.equals("eXIf")) {
                        tmp = 1;
                    }
                    break;
                }
            }
            block22 : switch (tmp) {
                case 4: {
                    var6_6 = new String[]{"iCCP", "sRGB"};
                    CollectionsKt.addAll((Collection)$this$readBase_u24lambda_u240.unsafeToAppear, var6_6);
                    ** GOTO lbl185
                }
                case 2: {
                    var6_7 = new String[]{"PLTE", "cHRM", "cICP", "gAMA", "iCCP", "mDCV", "cLLI", "sBIT", "sRGB"};
                    CollectionsKt.addAll((Collection)$this$readBase_u24lambda_u240.unsafeToAppear, var6_7);
                    ** GOTO lbl185
                }
                case 1: {
                    $this$readBase_u24lambda_u240.unsafeToAppear.add(base.getTag());
                    ** GOTO lbl185
                }
                case 3: {
                    $this$readBase_u24lambda_u240.unsafeToAppear.remove("fdAT");
                    var7_11 = new SeekableByteChannel[]{base.getWindow()};
                    windows = CollectionsKt.mutableListOf(var7_11);
                    while (true) {
                        if ((next = $this$readBase_u24lambda_u240.internalReadBase(compound)) == null) {
                            v0 = null;
                            break block22;
                        }
                        if (!Intrinsics.areEqual(next.getTag(), base.getTag()) || ((SeekableByteChannel)$this$readBase_u24lambda_u240.getChannel()).position() == ((SeekableByteChannel)$this$readBase_u24lambda_u240.getChannel()).size()) break;
                        windows.add(next.getWindow());
                    }
                    $this$readBase_u24lambda_u240.setSavedNext(next);
                    $this$readBase_u24lambda_u240.mustAppear.remove("IDAT");
                    $this$readBase_u24lambda_u240.unsafeToAppear.add("IDAT");
                    base = new PNGDataChunk(windows);
                    ** GOTO lbl185
                }
                case 6: {
                    seqBuffer = ByteBuffer.allocate(4);
                    base.getWindow().read(seqBuffer);
                    seqBuffer.rewind();
                    var8_14 = new SeekableByteChannel[]{base.getWindow()};
                    windows = CollectionsKt.mutableListOf(var8_14);
                    while (true) {
                        if ((next = $this$readBase_u24lambda_u240.internalReadBase(compound)) == null) {
                            v0 = null;
                            break block22;
                        }
                        if (!Intrinsics.areEqual(next.getTag(), base.getTag())) break;
                        v1 = (SeekableByteChannel)$this$readBase_u24lambda_u240.getChannel();
                        v2 = next.getWindow();
                        Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type org.bread_experts_group.channel.WindowedSeekableByteChannel");
                        windows.add(new WindowedSeekableByteChannel(v1, ((WindowedSeekableByteChannel)v2).getStart() + (long)4, ((WindowedSeekableByteChannel)next.getWindow()).getEnd()));
                    }
                    $this$readBase_u24lambda_u240.setSavedNext(next);
                    base = new PNGFrameDataChunk(seqBuffer.getInt(), windows);
                    ** GOTO lbl185
                }
                case 5: {
                    $this$readBase_u24lambda_u240.unsafeToAppear.add(base.getTag());
                    $this$readBase_u24lambda_u240.shouldHaveEnded = true;
                    for (String dA : $this$readBase_u24lambda_u240.mustAppear) {
                        compound.addThrown((CodingException)((Throwable)new ValidationException("\"" + dA + "\" never appeared")));
                    }
                }
lbl185:
                // 7 sources

                default: {
                    return base;
                }
            }
        }
        return v0;
    }

    @Override
    public void inputInit() {
        this.mustAppear.clear();
        String[] stringArray = new String[]{"IHDR", "IDAT"};
        CollectionsKt.addAll((Collection)this.mustAppear, stringArray);
        this.unsafeToAppear.clear();
        this.unsafeToAppear.add("fdAT");
        this.setSavedNext(null);
        this.shouldHaveEnded = false;
        ByteBuffer buffer8 = ByteBuffer.allocate(8);
        ((SeekableByteChannel)this.getChannel()).read(buffer8);
        byte[] wrapped = buffer8.array();
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
        byte[] goodSignature = byArray2;
        if (!Arrays.equals(wrapped, goodSignature)) {
            Intrinsics.checkNotNull(wrapped);
            throw new InvalidInputException("PNG signature mismatch; [" + HexExtensionsKt.toHexString$default(wrapped, null, 1, null) + " =/= " + HexExtensionsKt.toHexString$default(goodSignature, null, 1, null) + "]", null, 2, null);
        }
    }

    private static final PNGChunk _init_$lambda$1(PNGByteParser this$0, SeekableByteChannel channel, PNGChunk chunk, CompoundThrowable compound) {
        Object v4;
        Object object;
        Object object2;
        Integer n$iv;
        int n;
        int n2;
        int n3;
        EnumSet<PNGHeaderFlags> enumSet;
        block28: {
            Object v2;
            Mappable.Companion this_$iv;
            boolean bl;
            Enum it$iv;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv$iv;
            EnumEntries<Enum> $this$id$iv;
            boolean $i$f$id;
            ByteBuffer bufferIHDR;
            block27: {
                Object v0;
                block26: {
                    Intrinsics.checkNotNullParameter(channel, "channel");
                    Intrinsics.checkNotNullParameter(chunk, "chunk");
                    Intrinsics.checkNotNullParameter(compound, "compound");
                    bufferIHDR = ByteBuffer.allocate(13);
                    channel.read(bufferIHDR);
                    bufferIHDR.rewind();
                    int width = bufferIHDR.getInt();
                    int height = bufferIHDR.getInt();
                    Intrinsics.checkNotNull(bufferIHDR);
                    int bitDepth = BufferUtilKt.getByteInt(bufferIHDR);
                    int colorType = BufferUtilKt.getByteInt(bufferIHDR);
                    block0 : switch (colorType) {
                        case 0: {
                            switch (bitDepth) {
                                case 1: 
                                case 2: 
                                case 4: 
                                case 8: 
                                case 16: {
                                    break block0;
                                }
                            }
                            compound.addThrown((Throwable)new InvalidInputException("Bad depth [Grayscale] [" + bitDepth + "]", null, 2, null));
                            break;
                        }
                        case 2: {
                            switch (bitDepth) {
                                case 8: 
                                case 16: {
                                    break block0;
                                }
                            }
                            compound.addThrown((Throwable)new InvalidInputException("Bad depth [RGB] [" + bitDepth + "]", null, 2, null));
                            break;
                        }
                        case 3: {
                            switch (bitDepth) {
                                case 1: 
                                case 2: 
                                case 4: 
                                case 8: {
                                    break block0;
                                }
                            }
                            compound.addThrown((Throwable)new InvalidInputException("Bad depth [Palette] [" + bitDepth + "]", null, 2, null));
                            break;
                        }
                        case 4: {
                            switch (bitDepth) {
                                case 8: 
                                case 16: {
                                    break block0;
                                }
                            }
                            compound.addThrown((Throwable)new InvalidInputException("Bad depth [Grayscale (Alpha)] [" + bitDepth + "]", null, 2, null));
                            break;
                        }
                        case 6: {
                            switch (bitDepth) {
                                case 8: 
                                case 16: {
                                    break block0;
                                }
                            }
                            compound.addThrown((Throwable)new InvalidInputException("Bad depth [RGB (Alpha)] [" + bitDepth + "]", null, 2, null));
                            break;
                        }
                        default: {
                            compound.addThrown((Throwable)new UnsupportedValueException("PNG color type [" + colorType + "]"));
                        }
                    }
                    Mappable.Companion companion = Mappable.Companion;
                    EnumEntries<PNGCompressionType> enumEntries = PNGCompressionType.getEntries();
                    Integer n4 = BufferUtilKt.getByteInt(bufferIHDR);
                    enumSet = Flaggable.Companion.from(PNGHeaderFlags.getEntries(), colorType);
                    n3 = bitDepth;
                    n2 = height;
                    n = width;
                    PNGByteParser pNGByteParser = this$0;
                    $i$f$id = false;
                    $this$firstOrNull$iv$iv = $this$id$iv;
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                        it$iv = (Enum)element$iv$iv;
                        bl = false;
                        if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                        v0 = element$iv$iv;
                        break block26;
                    }
                    v0 = null;
                }
                void var27_24 = n$iv;
                Enum enum_ = v0;
                object2 = new MappedEnumeration<void, Enum>(enum_, var27_24);
                Enum enum_2 = ((MappedEnumeration)object2).getEnum();
                Intrinsics.checkNotNull(enum_2);
                this_$iv = Mappable.Companion;
                $this$id$iv = PNGFilterType.getEntries();
                n$iv = BufferUtilKt.getByteInt(bufferIHDR);
                object2 = (PNGCompressionType)enum_2;
                $i$f$id = false;
                $this$firstOrNull$iv$iv = $this$id$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Enum)element$iv$iv;
                    bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v2 = element$iv$iv;
                    break block27;
                }
                v2 = null;
            }
            Integer n5 = n$iv;
            Enum enum_ = v2;
            object = new MappedEnumeration<Integer, Enum>(enum_, n5);
            Enum enum_3 = ((MappedEnumeration)object).getEnum();
            Intrinsics.checkNotNull(enum_3);
            this_$iv = Mappable.Companion;
            $this$id$iv = PNGInterlaceType.getEntries();
            n$iv = BufferUtilKt.getByteInt(bufferIHDR);
            object = (PNGFilterType)enum_3;
            $i$f$id = false;
            $this$firstOrNull$iv$iv = $this$id$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                it$iv = (Enum)element$iv$iv;
                bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v4 = element$iv$iv;
                break block28;
            }
            v4 = null;
        }
        Integer n6 = n$iv;
        Enum enum_ = v4;
        MappedEnumeration<Integer, Enum> mappedEnumeration = new MappedEnumeration<Integer, Enum>(enum_, n6);
        Enum enum_4 = mappedEnumeration.getEnum();
        Intrinsics.checkNotNull(enum_4);
        SeekableByteChannel seekableByteChannel = channel;
        PNGInterlaceType pNGInterlaceType = (PNGInterlaceType)enum_4;
        Object object3 = object;
        Object object4 = object2;
        EnumSet<PNGHeaderFlags> enumSet2 = enumSet;
        int n7 = n3;
        int n8 = n2;
        int n9 = n;
        pNGByteParser.header = new PNGHeaderChunk(n9, n8, n7, enumSet2, (PNGCompressionType)object4, (PNGFilterType)object3, pNGInterlaceType, seekableByteChannel);
        PNGHeaderChunk pNGHeaderChunk = this$0.header;
        if (pNGHeaderChunk == null) {
            Intrinsics.throwUninitializedPropertyAccessException("header");
            pNGHeaderChunk = null;
        }
        return pNGHeaderChunk;
    }

    private static final PNGChunk _init_$lambda$3(PNGByteParser this$0, SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ByteBuffer bufferPLTE = ByteBuffer.allocate(4);
        int n = (int)(channel.size() / (long)3);
        PNGByteParser pNGByteParser = this$0;
        ArrayList<Color> arrayList = new ArrayList<Color>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Color> arrayList2 = arrayList;
            boolean bl = false;
            bufferPLTE.position(1);
            channel.read(bufferPLTE);
            bufferPLTE.rewind();
            arrayList2.add(new Color(bufferPLTE.getInt()));
        }
        SeekableByteChannel seekableByteChannel = channel;
        List list = arrayList;
        pNGByteParser.palette = new PNGPaletteChunk(list, seekableByteChannel);
        PNGPaletteChunk pNGPaletteChunk = this$0.palette;
        if (pNGPaletteChunk == null) {
            Intrinsics.throwUninitializedPropertyAccessException("palette");
            pNGPaletteChunk = null;
        }
        return pNGPaletteChunk;
    }

    /*
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$5(SeekableByteChannel channel, PNGChunk chunk, CompoundThrowable compound) {
        List list;
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compound, "compound");
        ReadableByteChannel readableByteChannel = channel;
        ByteBuffer byteBuffer = ByteBuffer.allocate(100);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(...)");
        ReadingByteBuffer reader = new ReadingByteBuffer(readableByteChannel, byteBuffer, null);
        List list2 = list = CollectionsKt.createListBuilder();
        String string = ReadingByteBuffer.decodeString$default(reader, Charsets.ISO_8859_1, null, 2, null);
        boolean bl = false;
        int depth = reader.u8i32();
        try {
            while (true) {
                switch (depth) {
                    case 8: {
                        void $this$lambda_u245_u24lambda_u244;
                        boolean bl2 = $this$lambda_u245_u24lambda_u244.add(TuplesKt.to(new Color((float)reader.u8i32() / 255.0f, (float)reader.u8i32() / 255.0f, (float)reader.u8i32() / 255.0f, (float)reader.u8i32() / 255.0f), reader.u16i32()));
                        break;
                    }
                    case 16: {
                        void $this$lambda_u245_u24lambda_u244;
                        boolean bl2 = $this$lambda_u245_u24lambda_u244.add(TuplesKt.to(new Color((float)reader.u16i32() / 65535.0f, (float)reader.u16i32() / 65535.0f, (float)reader.u16i32() / 65535.0f, (float)reader.u16i32() / 65535.0f), reader.u16i32()));
                        break;
                    }
                    default: {
                        compound.addThrown((Throwable)new InvalidInputException("Invalid sPLT depth [" + depth + "]", null, 2, null));
                        return chunk;
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            SeekableByteChannel seekableByteChannel = channel;
            List list3 = CollectionsKt.build(list);
            String string2 = string;
            return new PNGSuggestedPaletteChunk(string2, list3, seekableByteChannel);
        }
    }

    private static final PNGChunk _init_$lambda$6(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ByteBuffer bufferACTL = ByteBuffer.allocate(8);
        channel.read(bufferACTL);
        bufferACTL.rewind();
        return new PNGAnimationControlChunk(bufferACTL.getInt(), bufferACTL.getInt(), channel);
    }

    private static final PNGChunk _init_$lambda$8(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Object v2;
        Object object;
        Integer n$iv;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        long l;
        block3: {
            Object v0;
            boolean bl;
            Enum it$iv;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv$iv;
            EnumEntries<PNGBlendOperation> $this$id$iv;
            boolean $i$f$id;
            ByteBuffer bufferFCTL;
            block2: {
                Intrinsics.checkNotNullParameter(channel, "channel");
                Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
                Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
                bufferFCTL = ByteBuffer.allocate(26);
                channel.read(bufferFCTL);
                bufferFCTL.rewind();
                int sequence = bufferFCTL.getInt();
                int width = bufferFCTL.getInt();
                int height = bufferFCTL.getInt();
                int x = bufferFCTL.getInt();
                int y = bufferFCTL.getInt();
                Intrinsics.checkNotNull(bufferFCTL);
                int numerator = BufferUtilKt.getShortInt(bufferFCTL);
                int it = BufferUtilKt.getShortInt(bufferFCTL);
                boolean $i$a$-let-PNGByteParser$5$denominator$22 = false;
                int denominator = it == 0 ? 100 : it;
                long delayMillis = numerator == 0 ? 0L : (long)((double)numerator / (double)denominator * (double)1000L);
                Mappable.Companion $i$a$-let-PNGByteParser$5$denominator$22 = Mappable.Companion;
                EnumEntries<PNGDisposeOperation> enumEntries = PNGDisposeOperation.getEntries();
                Integer n6 = BufferUtilKt.getByteInt(bufferFCTL);
                l = DurationKt.toDuration(delayMillis, DurationUnit.MILLISECONDS);
                n5 = y;
                n4 = x;
                n3 = height;
                n2 = width;
                n = sequence;
                $i$f$id = false;
                $this$firstOrNull$iv$iv = $this$id$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Enum)element$iv$iv;
                    bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v0 = element$iv$iv;
                    break block2;
                }
                v0 = null;
            }
            void var32_30 = n$iv;
            Enum enum_ = v0;
            object = new MappedEnumeration<void, Enum>(enum_, var32_30);
            Enum enum_2 = ((MappedEnumeration)object).getEnum();
            Intrinsics.checkNotNull(enum_2);
            Mappable.Companion this_$iv = Mappable.Companion;
            $this$id$iv = PNGBlendOperation.getEntries();
            n$iv = BufferUtilKt.getByteInt(bufferFCTL);
            object = (PNGDisposeOperation)enum_2;
            $i$f$id = false;
            $this$firstOrNull$iv$iv = $this$id$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                it$iv = (Enum)element$iv$iv;
                bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v2 = element$iv$iv;
                break block3;
            }
            v2 = null;
        }
        Integer n7 = n$iv;
        Enum enum_ = v2;
        MappedEnumeration<Integer, Enum> mappedEnumeration = new MappedEnumeration<Integer, Enum>(enum_, n7);
        Enum enum_3 = mappedEnumeration.getEnum();
        Intrinsics.checkNotNull(enum_3);
        DefaultConstructorMarker defaultConstructorMarker = null;
        SeekableByteChannel seekableByteChannel = channel;
        PNGBlendOperation pNGBlendOperation = (PNGBlendOperation)enum_3;
        Object object2 = object;
        long l2 = l;
        int n8 = n5;
        int n9 = n4;
        int n10 = n3;
        int n11 = n2;
        int n12 = n;
        return new PNGFrameControlChunk(n12, n11, n10, n9, n8, l2, (PNGDisposeOperation)object2, pNGBlendOperation, seekableByteChannel, defaultConstructorMarker);
    }

    private static final PNGChunk _init_$lambda$9(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ByteBuffer bufferGAMA = ByteBuffer.allocate(4);
        channel.read(bufferGAMA);
        bufferGAMA.rewind();
        Intrinsics.checkNotNull(bufferGAMA);
        return new PNGGammaChunk((double)BufferUtilKt.getIntLong(bufferGAMA) / 100000.0, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PNGChunk _init_$lambda$11(PNGByteParser this$0, SeekableByteChannel channel, PNGChunk chunk, CompoundThrowable compound) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compound, "compound");
        ByteBuffer bufferSBIT = ByteBuffer.allocate(4);
        channel.read(bufferSBIT);
        bufferSBIT.rewind();
        if (this$0.header == null) {
            compound.addThrown((Throwable)new RefinementException("IHDR not defined", null, 2, null));
            return chunk;
        }
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            PNGHeaderChunk pNGHeaderChunk;
            ByteArrayOutputStream out = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull(bufferSBIT);
            out.write(BufferUtilKt.getByteInt(bufferSBIT));
            PNGHeaderChunk pNGHeaderChunk2 = this$0.header;
            if (pNGHeaderChunk2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("header");
                pNGHeaderChunk2 = null;
            }
            if (pNGHeaderChunk2.getFlags().contains(PNGHeaderFlags.TRUE_COLOR)) {
                out.write(BufferUtilKt.getByteInt(bufferSBIT));
                out.write(BufferUtilKt.getByteInt(bufferSBIT));
            }
            if ((pNGHeaderChunk = this$0.header) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("header");
                pNGHeaderChunk = null;
            }
            if (pNGHeaderChunk.getFlags().contains(PNGHeaderFlags.ALPHA)) {
                out.write(BufferUtilKt.getByteInt(bufferSBIT));
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
        SeekableByteChannel seekableByteChannel = channel;
        byte[] byArray2 = byArray;
        return new PNGSignificantBitsChunk(byArray2, seekableByteChannel);
    }

    private static final PNGChunk _init_$lambda$12(PNGByteParser this$0, SeekableByteChannel channel, PNGChunk chunk, CompoundThrowable compound) {
        Color color;
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compound, "compound");
        ByteBuffer bufferBKGD = ByteBuffer.allocate(6);
        channel.read(bufferBKGD);
        bufferBKGD.rewind();
        if (this$0.header == null) {
            compound.addThrown((Throwable)new RefinementException("IHDR not defined", null, 2, null));
            return chunk;
        }
        PNGHeaderChunk pNGHeaderChunk = this$0.header;
        if (pNGHeaderChunk == null) {
            Intrinsics.throwUninitializedPropertyAccessException("header");
            pNGHeaderChunk = null;
        }
        int mask = SocketUtilKt.maskI(pNGHeaderChunk.getBitDepth());
        PNGHeaderChunk pNGHeaderChunk2 = this$0.header;
        if (pNGHeaderChunk2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("header");
            pNGHeaderChunk2 = null;
        }
        if (pNGHeaderChunk2.getFlags().contains(PNGHeaderFlags.PALETTE)) {
            boolean bl;
            if (this$0.palette == null) {
                compound.addThrown((Throwable)new RefinementException("PLTE not defined", null, 2, null));
                return chunk;
            }
            Intrinsics.checkNotNull(bufferBKGD);
            int index = BufferUtilKt.getByteInt(bufferBKGD);
            if (0 <= index) {
                PNGPaletteChunk pNGPaletteChunk = this$0.palette;
                if (pNGPaletteChunk == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("palette");
                    pNGPaletteChunk = null;
                }
                bl = index < ((Collection)pNGPaletteChunk.getColors()).size();
            } else {
                bl = false;
            }
            if (!bl) {
                compound.addThrown((Throwable)new RefinementException("[" + index + "] out of range in PLTE", null, 2, null));
                return chunk;
            }
            PNGPaletteChunk pNGPaletteChunk = this$0.palette;
            if (pNGPaletteChunk == null) {
                Intrinsics.throwUninitializedPropertyAccessException("palette");
                pNGPaletteChunk = null;
            }
            color = pNGPaletteChunk.getColors().get(index);
        } else {
            PNGHeaderChunk pNGHeaderChunk3 = this$0.header;
            if (pNGHeaderChunk3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("header");
                pNGHeaderChunk3 = null;
            }
            if (pNGHeaderChunk3.getFlags().contains(PNGHeaderFlags.TRUE_COLOR)) {
                Intrinsics.checkNotNull(bufferBKGD);
                color = new Color((float)(BufferUtilKt.getShortInt(bufferBKGD) & mask) / (float)mask, (float)(BufferUtilKt.getShortInt(bufferBKGD) & mask) / (float)mask, (float)(BufferUtilKt.getShortInt(bufferBKGD) & mask) / (float)mask);
            } else {
                Intrinsics.checkNotNull(bufferBKGD);
                float gray = (float)(BufferUtilKt.getShortInt(bufferBKGD) & mask) / (float)mask;
                color = new Color(gray, gray, gray);
            }
        }
        return new PNGBackgroundChunk(color, channel);
    }

    private static final PNGChunk _init_$lambda$14(PNGByteParser this$0, SeekableByteChannel channel, PNGChunk chunk, CompoundThrowable compound) {
        PNGChunk pNGChunk;
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compound, "compound");
        InputStream stream = Channels.newInputStream(channel);
        if (this$0.header == null) {
            compound.addThrown((Throwable)new RefinementException("IHDR not defined", null, 2, null));
            return chunk;
        }
        PNGHeaderChunk pNGHeaderChunk = this$0.header;
        if (pNGHeaderChunk == null) {
            Intrinsics.throwUninitializedPropertyAccessException("header");
            pNGHeaderChunk = null;
        }
        if (pNGHeaderChunk.getFlags().contains(PNGHeaderFlags.PALETTE)) {
            List<Float> list;
            List<Float> $this$lambda_u2414_u24lambda_u2413 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            while (stream.available() > 0) {
                $this$lambda_u2414_u24lambda_u2413.add(Float.valueOf((float)stream.read() / 255.0f));
            }
            SeekableByteChannel seekableByteChannel = channel;
            List<Float> list2 = CollectionsKt.build(list);
            pNGChunk = new PNGTransparencyPaletteChunk(list2, seekableByteChannel);
        } else {
            Color color;
            PNGHeaderChunk pNGHeaderChunk2 = this$0.header;
            if (pNGHeaderChunk2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("header");
                pNGHeaderChunk2 = null;
            }
            int mask = SocketUtilKt.maskI(pNGHeaderChunk2.getBitDepth());
            PNGHeaderChunk pNGHeaderChunk3 = this$0.header;
            if (pNGHeaderChunk3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("header");
                pNGHeaderChunk3 = null;
            }
            if (pNGHeaderChunk3.getFlags().contains(PNGHeaderFlags.TRUE_COLOR)) {
                Intrinsics.checkNotNull(stream);
                color = new Color((float)(SocketUtilKt.read16ui(stream) & mask) / (float)mask, (float)(SocketUtilKt.read16ui(stream) & mask) / (float)mask, (float)(SocketUtilKt.read16ui(stream) & mask) / (float)mask);
            } else {
                Intrinsics.checkNotNull(stream);
                float gray = (float)(SocketUtilKt.read16ui(stream) & mask) / (float)mask;
                color = new Color(gray, gray, gray);
            }
            pNGChunk = new PNGTransparencySingleChunk(color, channel);
        }
        return pNGChunk;
    }

    private static final PNGChunk _init_$lambda$15(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ByteBuffer bufferCHRM = ByteBuffer.allocate(32);
        channel.read(bufferCHRM);
        bufferCHRM.rewind();
        Intrinsics.checkNotNull(bufferCHRM);
        return new PNGChromaticitiesChunk(new Point2D((double)BufferUtilKt.getIntLong(bufferCHRM) / 100000.0, (double)BufferUtilKt.getIntLong(bufferCHRM) / 100000.0), new Point2D((double)BufferUtilKt.getIntLong(bufferCHRM) / 100000.0, (double)BufferUtilKt.getIntLong(bufferCHRM) / 100000.0), new Point2D((double)BufferUtilKt.getIntLong(bufferCHRM) / 100000.0, (double)BufferUtilKt.getIntLong(bufferCHRM) / 100000.0), new Point2D((double)BufferUtilKt.getIntLong(bufferCHRM) / 100000.0, (double)BufferUtilKt.getIntLong(bufferCHRM) / 100000.0), channel);
    }

    /*
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$16(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Object v0;
        void n$iv;
        long l;
        long l2;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            ByteBuffer bufferPHYS = ByteBuffer.allocate(9);
            channel.read(bufferPHYS);
            bufferPHYS.rewind();
            Intrinsics.checkNotNull(bufferPHYS);
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<PNGPixelDimensions> enumEntries = PNGPixelDimensions.getEntries();
            Integer n = BufferUtilKt.getByteInt(bufferPHYS);
            l2 = BufferUtilKt.getIntLong(bufferPHYS);
            l = BufferUtilKt.getIntLong(bufferPHYS);
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        void var19_16 = n$iv;
        Enum enum_ = v0;
        MappedEnumeration<void, Enum> mappedEnumeration = new MappedEnumeration<void, Enum>(enum_, var19_16);
        Enum enum_2 = mappedEnumeration.getEnum();
        Intrinsics.checkNotNull(enum_2);
        SeekableByteChannel seekableByteChannel = channel;
        PNGPixelDimensions pNGPixelDimensions = (PNGPixelDimensions)enum_2;
        long l3 = l2;
        long l4 = l;
        return new PNGPhysicalPixelDimensionsChunk(l4, l3, pNGPixelDimensions, seekableByteChannel);
    }

    private static final PNGChunk _init_$lambda$18(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        List<Integer> list;
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        InputStream stream = Channels.newInputStream(channel);
        List<Integer> $this$lambda_u2418_u24lambda_u2417 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (stream.available() > 0) {
            Intrinsics.checkNotNull(stream);
            $this$lambda_u2418_u24lambda_u2417.add(SocketUtilKt.read16ui(stream));
        }
        SeekableByteChannel seekableByteChannel = channel;
        List<Integer> list2 = CollectionsKt.build(list);
        return new PNGHistogramChunk(list2, seekableByteChannel);
    }

    private static final PNGChunk _init_$lambda$19(SeekableByteChannel channel, PNGChunk chunk, CompoundThrowable compound) {
        Object object;
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compound, "compound");
        ByteBuffer bufferTIME = ByteBuffer.allocate(7);
        channel.read(bufferTIME);
        bufferTIME.rewind();
        try {
            Intrinsics.checkNotNull(bufferTIME);
            object = ZonedDateTime.of(BufferUtilKt.getShortInt(bufferTIME), BufferUtilKt.getByteInt(bufferTIME), BufferUtilKt.getByteInt(bufferTIME), BufferUtilKt.getByteInt(bufferTIME), BufferUtilKt.getByteInt(bufferTIME), BufferUtilKt.getByteInt(bufferTIME), 0, ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue(object, "of(...)");
            object = new PNGTimestampChunk((ZonedDateTime)object, channel);
        }
        catch (DateTimeException e) {
            compound.addThrown((Throwable)new RefinementException("tIME parsing", e));
            object = chunk;
        }
        return object;
    }

    private static final PNGChunk _init_$lambda$20(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        InputStream inputStream = Channels.newInputStream(channel);
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        FailQuickInputStream<InputStream> stream = new FailQuickInputStream<InputStream>(inputStream);
        String string3 = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
        try {
            string2 = string3;
            string = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
        }
        catch (FailQuickInputStream.EndOfStream endOfStream) {
            string2 = string3;
            string = "";
        }
        SeekableByteChannel seekableByteChannel = channel;
        String string4 = string;
        String string5 = string2;
        return new PNGTextChunk(string5, string4, seekableByteChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$22(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compound) {
        PNGCompressionType pNGCompressionType;
        String string;
        Object object;
        Object v0;
        Integer n$iv;
        String keyword;
        InputStream stream;
        block10: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compound, "compound");
            stream = Channels.newInputStream(channel);
            Intrinsics.checkNotNull(stream);
            keyword = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<PNGCompressionType> enumEntries = PNGCompressionType.getEntries();
            n$iv = stream.read();
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block10;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        PNGCompressionType compressionMethod = (PNGCompressionType)enum_2;
        if (WhenMappings.$EnumSwitchMapping$0[compressionMethod.ordinal()] == 1) {
            PNGCompressionType pNGCompressionType2 = compressionMethod;
            String string2 = keyword;
            try {
                String string3;
                byte[] byArray = stream.readAllBytes();
                Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
                object = byArray;
                object = new FailQuickInputStream<InputStream>(new InflaterInputStream(new ByteArrayInputStream((byte[])object)));
                PNGCompressionType pNGCompressionType3 = pNGCompressionType2;
                String string4 = string2;
                Throwable $i$f$id = null;
                try {
                    FailQuickInputStream it = (FailQuickInputStream)object;
                    boolean bl = false;
                    string3 = SocketUtilKt.readString(it, Charsets.ISO_8859_1);
                }
                catch (Throwable throwable) {
                    $i$f$id = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, $i$f$id);
                }
                String string5 = string3;
                string = string4;
                pNGCompressionType = pNGCompressionType3;
                object = string5;
            }
            catch (IOException $i$f$id) {
                void e;
                string = string2;
                pNGCompressionType = pNGCompressionType2;
                compound.addThrown((Throwable)new InvalidInputException("Decompression failure", (Throwable)e));
                object = "";
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SeekableByteChannel seekableByteChannel = channel;
        Object object2 = object;
        PNGCompressionType pNGCompressionType4 = pNGCompressionType;
        String string6 = string;
        return new PNGCompressedTextChunk(string6, pNGCompressionType4, (String)object2, seekableByteChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$24(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compound) {
        Enum enum_;
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compound, "compound");
        InputStream inputStream = Channels.newInputStream(channel);
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        FailQuickInputStream<InputStream> stream = new FailQuickInputStream<InputStream>(inputStream);
        String keyword = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
        if (stream.read() == 1) {
            Object v1;
            Integer n$iv;
            block14: {
                void $this$id$iv;
                Mappable.Companion companion = Mappable.Companion;
                EnumEntries<PNGCompressionType> enumEntries = PNGCompressionType.getEntries();
                n$iv = stream.read();
                boolean $i$f$id = false;
                Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Enum it$iv = (Enum)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v1 = element$iv$iv;
                    break block14;
                }
                v1 = null;
            }
            Integer n = n$iv;
            Enum enum_2 = v1;
            Enum enum_3 = new MappedEnumeration<Integer, Enum>(enum_2, n).getEnum();
            Intrinsics.checkNotNull(enum_3);
            enum_ = (PNGCompressionType)enum_3;
        } else {
            stream.read();
            enum_ = null;
        }
        Enum compressionMethod = enum_;
        String string = keyword;
        Enum enum_4 = compressionMethod;
        Locale locale = Locale.forLanguageTag(SocketUtilKt.readString(stream, Charsets.ISO_8859_1));
        Locale locale2 = locale;
        Intrinsics.checkNotNullExpressionValue(locale, "forLanguageTag(...)");
        String string2 = SocketUtilKt.readString(stream, Charsets.UTF_8);
        Enum enum_5 = compressionMethod;
        String string3 = switch (enum_5 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[enum_5.ordinal()]) {
            case 1 -> {
                Object var8_7;
                String var20_20 = string2;
                Locale var19_21 = locale2;
                Enum var18_22 = enum_4;
                String var17_23 = string;
                try {
                    String var10_11;
                    var8_7 = new FailQuickInputStream<InputStream>(new InflaterInputStream(new ByteArrayInputStream(stream.readAllBytes())));
                    String var24_24 = var20_20;
                    Locale var23_25 = var19_21;
                    Enum var22_26 = var18_22;
                    String var21_27 = var17_23;
                    Throwable $i$f$id = null;
                    try {
                        FailQuickInputStream it = (FailQuickInputStream)var8_7;
                        boolean $i$a$-use-PNGByteParser$16$1 = false;
                        var10_11 = SocketUtilKt.readString(it, Charsets.UTF_8);
                    }
                    catch (Throwable var11_29) {
                        $i$f$id = var11_29;
                        throw var11_29;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var8_7, $i$f$id);
                    }
                    String var25_31 = var10_11;
                    string = var21_27;
                    enum_4 = var22_26;
                    locale2 = var23_25;
                    string2 = var24_24;
                    var8_7 = var25_31;
                }
                catch (IOException $i$f$id) {
                    void e;
                    string = var17_23;
                    enum_4 = var18_22;
                    locale2 = var19_21;
                    string2 = var20_20;
                    compound.addThrown((Throwable)new InvalidInputException("Decompression failure", (Throwable)e));
                    var8_7 = "";
                }
                yield var8_7;
            }
            case -1 -> SocketUtilKt.readString(stream, Charsets.UTF_8);
            default -> throw new NoWhenBranchMatchedException();
        };
        SeekableByteChannel seekableByteChannel = channel;
        String string4 = string3;
        String string5 = string2;
        Locale locale3 = locale2;
        Enum enum_6 = enum_4;
        String string6 = string;
        return new PNGInternationalTextChunk(string6, (PNGCompressionType)enum_6, locale3, string5, string4, seekableByteChannel);
    }

    private static final PNGChunk _init_$lambda$25(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new PNGEXIFChunk(new TIFFByteParser().setInput((ReadableByteChannel)channel), channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$27(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compound) {
        String string;
        Object object;
        Object v0;
        Integer n$iv;
        String profileName;
        InputStream stream;
        block10: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compound, "compound");
            stream = Channels.newInputStream(channel);
            Intrinsics.checkNotNull(stream);
            profileName = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<PNGCompressionType> enumEntries = PNGCompressionType.getEntries();
            n$iv = stream.read();
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block10;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        PNGCompressionType compressionMethod = (PNGCompressionType)enum_2;
        if (WhenMappings.$EnumSwitchMapping$0[compressionMethod.ordinal()] == 1) {
            String string2 = profileName;
            try {
                byte[] byArray;
                byte[] byArray2 = stream.readAllBytes();
                Intrinsics.checkNotNullExpressionValue(byArray2, "readAllBytes(...)");
                object = byArray2;
                object = new FailQuickInputStream<InputStream>(new InflaterInputStream(new ByteArrayInputStream((byte[])object)));
                String string3 = string2;
                Throwable $i$f$id = null;
                try {
                    FailQuickInputStream it = (FailQuickInputStream)object;
                    boolean bl = false;
                    byArray = it.readAllBytes();
                }
                catch (Throwable throwable) {
                    $i$f$id = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, $i$f$id);
                }
                string = string3;
                object = byArray;
            }
            catch (IOException $i$f$id) {
                void e;
                string = string2;
                compound.addThrown((Throwable)new InvalidInputException("Decompression failure", (Throwable)e));
                object = new byte[]{};
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SeekableByteChannel seekableByteChannel = channel;
        byte[] byArray = object;
        String string4 = string;
        return new PNGEmbeddedICCChunk(string4, byArray, seekableByteChannel);
    }

    /*
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$28(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Object v0;
        Integer n$iv;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            ByteBuffer bufferSRGB = ByteBuffer.allocate(1);
            channel.read(bufferSRGB);
            bufferSRGB.rewind();
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<PNGSRGBIntent> enumEntries = PNGSRGBIntent.getEntries();
            Intrinsics.checkNotNull(bufferSRGB);
            n$iv = BufferUtilKt.getByteInt(bufferSRGB);
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        SeekableByteChannel seekableByteChannel = channel;
        PNGSRGBIntent pNGSRGBIntent = (PNGSRGBIntent)enum_2;
        return new PNGSRGBChunk(pNGSRGBIntent, seekableByteChannel);
    }

    private static final PNGChunk _init_$lambda$29(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Object v4;
        PNGICPVSTIDTransferFunction pNGICPVSTIDTransferFunction;
        PNGICPVSTIDColorPrimaries pNGICPVSTIDColorPrimaries;
        Integer n$iv;
        ByteBuffer bufferCICP;
        block5: {
            Object v2;
            Mappable.Companion this_$iv;
            boolean bl;
            Enum it$iv;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv$iv;
            EnumEntries<Enum> $this$id$iv;
            boolean $i$f$id;
            block4: {
                Object v0;
                block3: {
                    Intrinsics.checkNotNullParameter(channel, "channel");
                    Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
                    Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
                    bufferCICP = ByteBuffer.allocate(4);
                    channel.read(bufferCICP);
                    bufferCICP.rewind();
                    Mappable.Companion companion = Mappable.Companion;
                    EnumEntries<PNGICPVSTIDColorPrimaries> enumEntries = PNGICPVSTIDColorPrimaries.getEntries();
                    Intrinsics.checkNotNull(bufferCICP);
                    n$iv = BufferUtilKt.getByteInt(bufferCICP);
                    $i$f$id = false;
                    $this$firstOrNull$iv$iv = $this$id$iv;
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                        it$iv = (Enum)element$iv$iv;
                        bl = false;
                        if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                        v0 = element$iv$iv;
                        break block3;
                    }
                    v0 = null;
                }
                Integer n = n$iv;
                Enum enum_ = v0;
                Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
                Intrinsics.checkNotNull(enum_2);
                this_$iv = Mappable.Companion;
                $this$id$iv = PNGICPVSTIDTransferFunction.getEntries();
                n$iv = BufferUtilKt.getByteInt(bufferCICP);
                pNGICPVSTIDColorPrimaries = (PNGICPVSTIDColorPrimaries)enum_2;
                $i$f$id = false;
                $this$firstOrNull$iv$iv = $this$id$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Enum)element$iv$iv;
                    bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v2 = element$iv$iv;
                    break block4;
                }
                v2 = null;
            }
            Integer n = n$iv;
            Enum enum_ = v2;
            Enum enum_3 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
            Intrinsics.checkNotNull(enum_3);
            this_$iv = Mappable.Companion;
            $this$id$iv = PNGICPVSTIDMatrixCoefficients.getEntries();
            n$iv = BufferUtilKt.getByteInt(bufferCICP);
            pNGICPVSTIDTransferFunction = (PNGICPVSTIDTransferFunction)enum_3;
            $i$f$id = false;
            $this$firstOrNull$iv$iv = $this$id$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                it$iv = (Enum)element$iv$iv;
                bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v4 = element$iv$iv;
                break block5;
            }
            v4 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v4;
        MappedEnumeration<Integer, Enum> mappedEnumeration = new MappedEnumeration<Integer, Enum>(enum_, n);
        Enum enum_4 = mappedEnumeration.getEnum();
        Intrinsics.checkNotNull(enum_4);
        SeekableByteChannel seekableByteChannel = channel;
        boolean bl = BufferUtilKt.getByteInt(bufferCICP) != 0;
        PNGICPVSTIDMatrixCoefficients pNGICPVSTIDMatrixCoefficients = (PNGICPVSTIDMatrixCoefficients)enum_4;
        PNGICPVSTIDTransferFunction pNGICPVSTIDTransferFunction2 = pNGICPVSTIDTransferFunction;
        PNGICPVSTIDColorPrimaries pNGICPVSTIDColorPrimaries2 = pNGICPVSTIDColorPrimaries;
        return new PNGICPVSTIDChunk(pNGICPVSTIDColorPrimaries2, pNGICPVSTIDTransferFunction2, pNGICPVSTIDMatrixCoefficients, bl, seekableByteChannel);
    }

    private static final PNGChunk _init_$lambda$30(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ByteBuffer bufferMDCV = ByteBuffer.allocate(24);
        channel.read(bufferMDCV);
        bufferMDCV.rewind();
        Intrinsics.checkNotNull(bufferMDCV);
        return new PNGMasteringDisplayColorVolumeChunk(new Point2D((double)BufferUtilKt.getShortInt(bufferMDCV) * 2.0E-5, (double)BufferUtilKt.getShortInt(bufferMDCV) * 2.0E-5), new Point2D((double)BufferUtilKt.getShortInt(bufferMDCV) * 2.0E-5, (double)BufferUtilKt.getShortInt(bufferMDCV) * 2.0E-5), new Point2D((double)BufferUtilKt.getShortInt(bufferMDCV) * 2.0E-5, (double)BufferUtilKt.getShortInt(bufferMDCV) * 2.0E-5), new Point2D((double)BufferUtilKt.getShortInt(bufferMDCV) * 2.0E-5, (double)BufferUtilKt.getShortInt(bufferMDCV) * 2.0E-5), (double)BufferUtilKt.getIntLong(bufferMDCV) * 1.0E-4, (double)BufferUtilKt.getIntLong(bufferMDCV) * 1.0E-4, channel);
    }

    private static final PNGChunk _init_$lambda$31(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        ByteBuffer bufferCLLI = ByteBuffer.allocate(8);
        channel.read(bufferCLLI);
        bufferCLLI.rewind();
        Intrinsics.checkNotNull(bufferCLLI);
        return new PNGContentLightLevelInfoChunk((double)BufferUtilKt.getIntLong(bufferCLLI) * 1.0E-4, (double)BufferUtilKt.getIntLong(bufferCLLI) * 1.0E-4, channel);
    }

    /*
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$32(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Object v0;
        Integer n$iv;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            ByteBuffer bufferSTER = ByteBuffer.allocate(1);
            channel.read(bufferSTER);
            bufferSTER.rewind();
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<PNGStereoscopyMode> enumEntries = PNGStereoscopyMode.getEntries();
            Intrinsics.checkNotNull(bufferSTER);
            n$iv = BufferUtilKt.getByteInt(bufferSTER);
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        SeekableByteChannel seekableByteChannel = channel;
        PNGStereoscopyMode pNGStereoscopyMode = (PNGStereoscopyMode)enum_2;
        return new PNGStereoscopyChunk(pNGStereoscopyMode, seekableByteChannel);
    }

    /*
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$33(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Object v0;
        void n$iv;
        long l;
        long l2;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            ByteBuffer bufferOFFS = ByteBuffer.allocate(9);
            channel.read(bufferOFFS);
            bufferOFFS.rewind();
            Intrinsics.checkNotNull(bufferOFFS);
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<PNGPrintOffsetUnit> enumEntries = PNGPrintOffsetUnit.getEntries();
            Integer n = BufferUtilKt.getByteInt(bufferOFFS);
            l2 = BufferUtilKt.getIntLong(bufferOFFS);
            l = BufferUtilKt.getIntLong(bufferOFFS);
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        void var19_16 = n$iv;
        Enum enum_ = v0;
        MappedEnumeration<void, Enum> mappedEnumeration = new MappedEnumeration<void, Enum>(enum_, var19_16);
        Enum enum_2 = mappedEnumeration.getEnum();
        Intrinsics.checkNotNull(enum_2);
        SeekableByteChannel seekableByteChannel = channel;
        PNGPrintOffsetUnit pNGPrintOffsetUnit = (PNGPrintOffsetUnit)enum_2;
        long l3 = l2;
        long l4 = l;
        return new PNGPrintOffsetChunk(l4, l3, pNGPrintOffsetUnit, seekableByteChannel);
    }

    /*
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$34(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Object v1;
        Integer n$iv;
        FailQuickInputStream<InputStream> stream;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            InputStream inputStream = Channels.newInputStream(channel);
            Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
            stream = new FailQuickInputStream<InputStream>(inputStream);
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<PNGSubjectPhysicalScaleUnit> enumEntries = PNGSubjectPhysicalScaleUnit.getEntries();
            n$iv = stream.read();
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v1 = element$iv$iv;
                break block1;
            }
            v1 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v1;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        SeekableByteChannel seekableByteChannel = channel;
        BigDecimal bigDecimal = new BigDecimal(SocketUtilKt.readString(stream, Charsets.US_ASCII));
        BigDecimal bigDecimal2 = new BigDecimal(SocketUtilKt.readString(stream, Charsets.US_ASCII));
        PNGSubjectPhysicalScaleUnit pNGSubjectPhysicalScaleUnit = (PNGSubjectPhysicalScaleUnit)enum_2;
        return new PNGSubjectPhysicalScaleChunk(pNGSubjectPhysicalScaleUnit, bigDecimal2, bigDecimal, seekableByteChannel);
    }

    /*
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$36(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        ArrayList<BigDecimal> arrayList;
        String unitName;
        Object v1;
        Integer n$iv;
        int x1;
        int x0;
        String calibrationName;
        FailQuickInputStream<InputStream> stream;
        block2: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            InputStream inputStream = Channels.newInputStream(channel);
            Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
            stream = new FailQuickInputStream<InputStream>(inputStream);
            calibrationName = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
            x0 = SocketUtilKt.read32(stream);
            x1 = SocketUtilKt.read32(stream);
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<PNGPixelCalibrationEquationType> enumEntries = PNGPixelCalibrationEquationType.getEntries();
            n$iv = stream.read();
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v1 = element$iv$iv;
                break block2;
            }
            v1 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v1;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        PNGPixelCalibrationEquationType equation = (PNGPixelCalibrationEquationType)enum_2;
        int parameters = stream.read();
        String string = unitName = SocketUtilKt.readString(stream, Charsets.ISO_8859_1);
        PNGPixelCalibrationEquationType pNGPixelCalibrationEquationType = equation;
        int n2 = x1;
        int n3 = x0;
        String string2 = calibrationName;
        ArrayList<BigDecimal> arrayList2 = new ArrayList<BigDecimal>(parameters);
        int n4 = 0;
        while (n4 < parameters) {
            int n5;
            int n6 = n5 = n4++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(new BigDecimal(SocketUtilKt.readString(stream, Charsets.US_ASCII)));
        }
        arrayList = arrayList2;
        SeekableByteChannel seekableByteChannel = channel;
        ArrayList<BigDecimal> arrayList3 = arrayList;
        String string3 = string;
        PNGPixelCalibrationEquationType pNGPixelCalibrationEquationType2 = pNGPixelCalibrationEquationType;
        int n7 = n2;
        int n8 = n3;
        String string4 = string2;
        return new PNGPixelCalibrationChunk(string4, n8, n7, pNGPixelCalibrationEquationType2, string3, arrayList3, seekableByteChannel);
    }

    /*
     * WARNING - void declaration
     */
    private static final PNGChunk _init_$lambda$37(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Object v0;
        Integer n$iv;
        ByteBuffer bufferGIFG;
        block1: {
            void $this$id$iv;
            Intrinsics.checkNotNullParameter(channel, "channel");
            Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
            Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
            bufferGIFG = ByteBuffer.allocate(4);
            channel.read(bufferGIFG);
            bufferGIFG.rewind();
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<GIFDisposalMethod> enumEntries = GIFDisposalMethod.getEntries();
            Intrinsics.checkNotNull(bufferGIFG);
            n$iv = BufferUtilKt.getByteInt(bufferGIFG);
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = n$iv;
        Enum enum_ = v0;
        Enum enum_2 = new MappedEnumeration<Integer, Enum>(enum_, n).getEnum();
        Intrinsics.checkNotNull(enum_2);
        Intrinsics.checkNotNull(enum_2);
        DefaultConstructorMarker defaultConstructorMarker = null;
        SeekableByteChannel seekableByteChannel = channel;
        long l = DurationKt.toDuration(BufferUtilKt.getShortInt(bufferGIFG) * 10, DurationUnit.MILLISECONDS);
        boolean bl = BufferUtilKt.getByteInt(bufferGIFG) != 0;
        GIFDisposalMethod gIFDisposalMethod = (GIFDisposalMethod)enum_2;
        return new PNGGIFGraphicControlExtensionChunk(gIFDisposalMethod, bl, l, seekableByteChannel, defaultConstructorMarker);
    }

    private static final PNGChunk _init_$lambda$38(SeekableByteChannel channel, PNGChunk pNGChunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pNGChunk, "<unused var>");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        InputStream inputStream = Channels.newInputStream(channel);
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        FailQuickInputStream<InputStream> stream = new FailQuickInputStream<InputStream>(inputStream);
        return new PNGGIFApplicationExtension(SocketUtilKt.readString(stream, 8, Charsets.US_ASCII), SocketUtilKt.readString(stream, 3, Charsets.US_ASCII), channel);
    }

    private static final PNGChunk _init_$lambda$39(SeekableByteChannel seekableByteChannel, PNGChunk chunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(seekableByteChannel, "<unused var>");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return chunk;
    }

    private static final PNGChunk _init_$lambda$40(SeekableByteChannel seekableByteChannel, PNGChunk chunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(seekableByteChannel, "<unused var>");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return chunk;
    }

    private static final PNGChunk _init_$lambda$41(SeekableByteChannel seekableByteChannel, PNGChunk chunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(seekableByteChannel, "<unused var>");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return chunk;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(PNGByteParser.class, "savedNext", "getSavedNext()Lorg/bread_experts_group/coder/format/parse/png/chunk/PNGChunk;", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PNGCompressionType.values().length];
            try {
                nArray[PNGCompressionType.DEFLATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

