/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.riff;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.CodingException;
import org.bread_experts_group.coder.CompoundThrowable;
import org.bread_experts_group.coder.format.parse.Parser;
import org.bread_experts_group.coder.format.parse.id3.ID3Parser;
import org.bread_experts_group.coder.format.parse.riff.chunk.RIFFAudioFormatChunk;
import org.bread_experts_group.coder.format.parse.riff.chunk.RIFFChunk;
import org.bread_experts_group.coder.format.parse.riff.chunk.RIFFContainerChunk;
import org.bread_experts_group.coder.format.parse.riff.chunk.RIFFID3Chunk;
import org.bread_experts_group.coder.format.parse.riff.chunk.RIFFTextChunk;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u001a\u0010\t\u001a\u00020\u00032\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0014J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002\u00a8\u0006\u0012"}, d2={"Lorg/bread_experts_group/coder/format/parse/riff/RIFFParser;", "Lorg/bread_experts_group/coder/format/parse/Parser;", "", "Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFChunk;", "Ljava/io/InputStream;", "<init>", "()V", "responsibleStream", "of", "readBase", "compound", "Lorg/bread_experts_group/coder/CompoundThrowable;", "Lorg/bread_experts_group/coder/CodingException;", "Lorg/bread_experts_group/coder/format/parse/CodingCompoundThrowable;", "containerChunk", "", "identifier", "textChunk", "bread_server_lib"})
public class RIFFParser
extends Parser<String, RIFFChunk, InputStream> {
    public RIFFParser() {
        super("Resource Interchange File Format", Reflection.getOrCreateKotlinClass(InputStream.class));
        this.containerChunk("RIFF");
        this.containerChunk("LIST");
        this.textChunk("ITRK");
        this.textChunk("IARL");
        this.textChunk("IART");
        this.textChunk("ICMS");
        this.textChunk("ICMT");
        this.textChunk("ICOP");
        this.textChunk("ICRD");
        this.textChunk("ICRP");
        this.textChunk("IDIM");
        this.textChunk("IDPI");
        this.textChunk("IENG");
        this.textChunk("IGNR");
        this.textChunk("IKEY");
        this.textChunk("ILGT");
        this.textChunk("IMED");
        this.textChunk("INAM");
        this.textChunk("IPLT");
        this.textChunk("IPRD");
        this.textChunk("ISBJ");
        this.textChunk("ISFT");
        this.textChunk("ISHP");
        this.textChunk("ISRC");
        this.textChunk("ISRF");
        this.textChunk("ITCH");
        this.addParser("fmt ", RIFFParser::_init_$lambda$3);
        this.addParser("id3 ", RIFFParser::_init_$lambda$4);
    }

    @Override
    @NotNull
    protected InputStream responsibleStream(@NotNull RIFFChunk of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return new ByteArrayInputStream(of.getData());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected RIFFChunk readBase(@NotNull CompoundThrowable<CodingException> compound) {
        void it;
        Intrinsics.checkNotNullParameter(compound, "compound");
        String tag = SocketUtilKt.readString$default(this.getFqIn(), 4, null, 2, null);
        int n = SocketUtilKt.le(SocketUtilKt.read32(this.getFqIn()));
        String string = tag;
        boolean bl = false;
        if (it < 0) {
            throw new UnsupportedOperationException("[" + tag + "] Size is too big [" + UInt.toString-impl(UInt.constructor-impl((int)it)) + "]!");
        }
        byte[] data = this.getFqIn().readNBytes((int)it);
        if ((long)it % 2L != 0L) {
            this.getFqIn().read();
        }
        byte[] byArray = data;
        Intrinsics.checkNotNullExpressionValue(byArray, "let(...)");
        byte[] byArray2 = byArray;
        String string2 = string;
        return new RIFFChunk(string2, byArray2);
    }

    public final void containerChunk(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        this.addParser(identifier, RIFFParser::containerChunk$lambda$1);
    }

    public final void textChunk(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        this.addParser(identifier, (arg_0, arg_1, arg_2) -> RIFFParser.textChunk$lambda$2(identifier, arg_0, arg_1, arg_2));
    }

    private static final RIFFChunk containerChunk$lambda$1(InputStream stream, RIFFChunk chunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        RIFFContainerChunk containerChunk = new RIFFContainerChunk(chunk.getTag(), SocketUtilKt.readString$default(stream, 4, null, 2, null), new RIFFParser().setInput(stream));
        return containerChunk;
    }

    private static final RIFFChunk textChunk$lambda$2(String $identifier, InputStream stream, RIFFChunk chunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new RIFFTextChunk($identifier, SocketUtilKt.readString(stream, Charsets.ISO_8859_1));
    }

    private static final RIFFChunk _init_$lambda$3(InputStream stream, RIFFChunk chunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        short s = SocketUtilKt.le(SocketUtilKt.read16(stream));
        int n = SocketUtilKt.le(SocketUtilKt.read32(stream));
        int n2 = SocketUtilKt.le(SocketUtilKt.read32(stream));
        short s2 = SocketUtilKt.le(SocketUtilKt.read16(stream));
        short s3 = SocketUtilKt.le(SocketUtilKt.read16(stream));
        byte[] byArray = stream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        return new RIFFAudioFormatChunk(MapsKt.getValue(RIFFAudioFormatChunk.AudioEncoding.Companion.getMapping(), Integer.valueOf(SocketUtilKt.le(SocketUtilKt.read16(stream)))), s, n, n2, s2, s3, byArray);
    }

    private static final RIFFChunk _init_$lambda$4(InputStream stream, RIFFChunk chunk, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        return new RIFFID3Chunk(new ID3Parser().setInput(stream));
    }
}

