/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.riff.chunk;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.coder.LazyPartialResult;
import org.bread_experts_group.coder.format.parse.riff.chunk.RIFFChunk;
import org.bread_experts_group.coder.format.parse.riff.chunk.RIFFContainerChunk;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk;", "Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFChunk;", "encoding", "Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk$AudioEncoding;", "numberOfChannels", "", "sampleRate", "byteRate", "blockAlign", "bitsPerSample", "misc", "", "<init>", "(Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk$AudioEncoding;IIIII[B)V", "getEncoding", "()Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk$AudioEncoding;", "getNumberOfChannels", "()I", "getSampleRate", "getByteRate", "getBlockAlign", "getBitsPerSample", "toString", "", "encoded", "getEncoded", "()[B", "computeSize", "", "write", "", "stream", "Ljava/io/OutputStream;", "AudioEncoding", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nRIFFAudioFormatChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RIFFAudioFormatChunk.kt\norg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n295#2,2:293\n*S KotlinDebug\n*F\n+ 1 RIFFAudioFormatChunk.kt\norg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk\n*L\n24#1:293,2\n*E\n"})
public final class RIFFAudioFormatChunk
extends RIFFChunk {
    @NotNull
    private final AudioEncoding encoding;
    private final int numberOfChannels;
    private final int sampleRate;
    private final int byteRate;
    private final int blockAlign;
    private final int bitsPerSample;
    @NotNull
    private final byte[] encoded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RIFFAudioFormatChunk(@NotNull AudioEncoding encoding, int numberOfChannels, int sampleRate, int byteRate, int blockAlign, int bitsPerSample, @NotNull byte[] misc) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
        Intrinsics.checkNotNullParameter(misc, "misc");
        super("fmt ", misc);
        this.encoding = encoding;
        this.numberOfChannels = numberOfChannels;
        this.sampleRate = sampleRate;
        this.byteRate = byteRate;
        this.blockAlign = blockAlign;
        this.bitsPerSample = bitsPerSample;
        Closeable closeable = new ByteArrayOutputStream();
        RIFFAudioFormatChunk rIFFAudioFormatChunk = this;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            SocketUtilKt.write16((OutputStream)it, (int)SocketUtilKt.le((short)this.encoding.getCode()));
            SocketUtilKt.write16((OutputStream)it, (int)SocketUtilKt.le((short)this.numberOfChannels));
            SocketUtilKt.write32((OutputStream)it, SocketUtilKt.le(this.sampleRate));
            SocketUtilKt.write32((OutputStream)it, SocketUtilKt.le(this.byteRate));
            SocketUtilKt.write16((OutputStream)it, (int)SocketUtilKt.le((short)this.blockAlign));
            SocketUtilKt.write16((OutputStream)it, (int)SocketUtilKt.le((short)this.bitsPerSample));
            it.write(this.getData());
            byArray = it.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        byte[] byArray2 = byArray;
        Intrinsics.checkNotNullExpressionValue(byArray2, "use(...)");
        rIFFAudioFormatChunk.encoded = byArray2;
    }

    @NotNull
    public final AudioEncoding getEncoding() {
        return this.encoding;
    }

    public final int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getByteRate() {
        return this.byteRate;
    }

    public final int getBlockAlign() {
        return this.blockAlign;
    }

    public final int getBitsPerSample() {
        return this.bitsPerSample;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        Object object;
        Object object2;
        int n;
        int n2;
        int n3;
        double d;
        int n4;
        AudioEncoding audioEncoding;
        String string;
        block8: {
            block7: {
                Object object3;
                Object v9;
                String string2;
                AudioEncoding audioEncoding2;
                int n5;
                double d2;
                int n6;
                int n7;
                int n8;
                Object object4;
                block6: {
                    void parent;
                    string = this.getTag();
                    audioEncoding = this.encoding;
                    n4 = this.numberOfChannels;
                    d = (double)this.sampleRate / 1000.0;
                    n3 = this.byteRate;
                    n2 = this.bitsPerSample;
                    n = this.blockAlign;
                    object2 = !(this.getData().length == 0) ? ", " + this.getData().length + " bytes misc data" : "";
                    object = this.getParent();
                    if (object == null) break block7;
                    RIFFContainerChunk rIFFContainerChunk = object;
                    object4 = object2;
                    n8 = n;
                    n7 = n2;
                    n6 = n3;
                    d2 = d;
                    n5 = n4;
                    audioEncoding2 = audioEncoding;
                    string2 = string;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = (Iterable)parent;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        LazyPartialResult it = (LazyPartialResult)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(((RIFFChunk)it.getResultSafe()).getTag(), "data")) continue;
                        v9 = element$iv;
                        break block6;
                    }
                    v9 = null;
                }
                LazyPartialResult lazyPartialResult = v9;
                if (lazyPartialResult == null) {
                    object3 = "";
                } else {
                    LazyPartialResult dataChunk = lazyPartialResult;
                    object3 = ", " + FormattingKt.formatTime-LRDsOJo(DurationKt.toDuration((double)((RIFFChunk)dataChunk.getResultSafe()).getData().length / (double)this.byteRate, DurationUnit.SECONDS));
                }
                String string3 = object3;
                string = string2;
                audioEncoding = audioEncoding2;
                n4 = n5;
                d = d2;
                n3 = n6;
                n2 = n7;
                n = n8;
                object2 = object4;
                String string4 = string3;
                object = string4;
                if (string4 != null) break block8;
            }
            object = "";
        }
        return "RIFFChunk.\"" + string + "\"[" + audioEncoding + ", " + n4 + " channel(s), " + d + " kHz, " + n3 + " bytes/s, " + n2 + "-bit, " + n + " block alignment" + (String)object2 + (String)object + "]";
    }

    @NotNull
    public final byte[] getEncoded() {
        return this.encoded;
    }

    @Override
    public long computeSize() {
        return this.encoded.length;
    }

    @Override
    public void write(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        super.write(stream);
        stream.write(this.encoded);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0003\b\u00f7\u0001\b\u0086\u0081\u0002\u0018\u0000 \u00f9\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u00f9\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bFj\u0002\bGj\u0002\bHj\u0002\bIj\u0002\bJj\u0002\bKj\u0002\bLj\u0002\bMj\u0002\bNj\u0002\bOj\u0002\bPj\u0002\bQj\u0002\bRj\u0002\bSj\u0002\bTj\u0002\bUj\u0002\bVj\u0002\bWj\u0002\bXj\u0002\bYj\u0002\bZj\u0002\b[j\u0002\b\\j\u0002\b]j\u0002\b^j\u0002\b_j\u0002\b`j\u0002\baj\u0002\bbj\u0002\bcj\u0002\bdj\u0002\bej\u0002\bfj\u0002\bgj\u0002\bhj\u0002\bij\u0002\bjj\u0002\bkj\u0002\blj\u0002\bmj\u0002\bnj\u0002\boj\u0002\bpj\u0002\bqj\u0002\brj\u0002\bsj\u0002\btj\u0002\buj\u0002\bvj\u0002\bwj\u0002\bxj\u0002\byj\u0002\bzj\u0002\b{j\u0002\b|j\u0002\b}j\u0002\b~j\u0002\b\u007fj\u0003\b\u0080\u0001j\u0003\b\u0081\u0001j\u0003\b\u0082\u0001j\u0003\b\u0083\u0001j\u0003\b\u0084\u0001j\u0003\b\u0085\u0001j\u0003\b\u0086\u0001j\u0003\b\u0087\u0001j\u0003\b\u0088\u0001j\u0003\b\u0089\u0001j\u0003\b\u008a\u0001j\u0003\b\u008b\u0001j\u0003\b\u008c\u0001j\u0003\b\u008d\u0001j\u0003\b\u008e\u0001j\u0003\b\u008f\u0001j\u0003\b\u0090\u0001j\u0003\b\u0091\u0001j\u0003\b\u0092\u0001j\u0003\b\u0093\u0001j\u0003\b\u0094\u0001j\u0003\b\u0095\u0001j\u0003\b\u0096\u0001j\u0003\b\u0097\u0001j\u0003\b\u0098\u0001j\u0003\b\u0099\u0001j\u0003\b\u009a\u0001j\u0003\b\u009b\u0001j\u0003\b\u009c\u0001j\u0003\b\u009d\u0001j\u0003\b\u009e\u0001j\u0003\b\u009f\u0001j\u0003\b\u00a0\u0001j\u0003\b\u00a1\u0001j\u0003\b\u00a2\u0001j\u0003\b\u00a3\u0001j\u0003\b\u00a4\u0001j\u0003\b\u00a5\u0001j\u0003\b\u00a6\u0001j\u0003\b\u00a7\u0001j\u0003\b\u00a8\u0001j\u0003\b\u00a9\u0001j\u0003\b\u00aa\u0001j\u0003\b\u00ab\u0001j\u0003\b\u00ac\u0001j\u0003\b\u00ad\u0001j\u0003\b\u00ae\u0001j\u0003\b\u00af\u0001j\u0003\b\u00b0\u0001j\u0003\b\u00b1\u0001j\u0003\b\u00b2\u0001j\u0003\b\u00b3\u0001j\u0003\b\u00b4\u0001j\u0003\b\u00b5\u0001j\u0003\b\u00b6\u0001j\u0003\b\u00b7\u0001j\u0003\b\u00b8\u0001j\u0003\b\u00b9\u0001j\u0003\b\u00ba\u0001j\u0003\b\u00bb\u0001j\u0003\b\u00bc\u0001j\u0003\b\u00bd\u0001j\u0003\b\u00be\u0001j\u0003\b\u00bf\u0001j\u0003\b\u00c0\u0001j\u0003\b\u00c1\u0001j\u0003\b\u00c2\u0001j\u0003\b\u00c3\u0001j\u0003\b\u00c4\u0001j\u0003\b\u00c5\u0001j\u0003\b\u00c6\u0001j\u0003\b\u00c7\u0001j\u0003\b\u00c8\u0001j\u0003\b\u00c9\u0001j\u0003\b\u00ca\u0001j\u0003\b\u00cb\u0001j\u0003\b\u00cc\u0001j\u0003\b\u00cd\u0001j\u0003\b\u00ce\u0001j\u0003\b\u00cf\u0001j\u0003\b\u00d0\u0001j\u0003\b\u00d1\u0001j\u0003\b\u00d2\u0001j\u0003\b\u00d3\u0001j\u0003\b\u00d4\u0001j\u0003\b\u00d5\u0001j\u0003\b\u00d6\u0001j\u0003\b\u00d7\u0001j\u0003\b\u00d8\u0001j\u0003\b\u00d9\u0001j\u0003\b\u00da\u0001j\u0003\b\u00db\u0001j\u0003\b\u00dc\u0001j\u0003\b\u00dd\u0001j\u0003\b\u00de\u0001j\u0003\b\u00df\u0001j\u0003\b\u00e0\u0001j\u0003\b\u00e1\u0001j\u0003\b\u00e2\u0001j\u0003\b\u00e3\u0001j\u0003\b\u00e4\u0001j\u0003\b\u00e5\u0001j\u0003\b\u00e6\u0001j\u0003\b\u00e7\u0001j\u0003\b\u00e8\u0001j\u0003\b\u00e9\u0001j\u0003\b\u00ea\u0001j\u0003\b\u00eb\u0001j\u0003\b\u00ec\u0001j\u0003\b\u00ed\u0001j\u0003\b\u00ee\u0001j\u0003\b\u00ef\u0001j\u0003\b\u00f0\u0001j\u0003\b\u00f1\u0001j\u0003\b\u00f2\u0001j\u0003\b\u00f3\u0001j\u0003\b\u00f4\u0001j\u0003\b\u00f5\u0001j\u0003\b\u00f6\u0001j\u0003\b\u00f7\u0001j\u0003\b\u00f8\u0001\u00a8\u0006\u00fa\u0001"}, d2={"Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk$AudioEncoding;", "", "code", "", "<init>", "(Ljava/lang/String;II)V", "getCode", "()I", "MICROSOFT_PCM", "MICROSOFT_ADPCM", "MICROSOFT_IEEE_FLOAT", "COMPAQ_VSELP", "IBM_CVSD", "MICROSOFT_A_LAW", "MICROSOFT_U_LAW", "MICROSOFT_DTS", "DRM", "WMA_9_SPEECH", "MICROSOFT_WINDOWS_MEDIA_RT_VOICE", "OKI_ADPCM", "INTEL_IMA_DVI_ADPCM", "VIDEOLOGIC_MEDIASPACE_ADPCM", "SIERRA_ADPCM", "ANTEX_G723_ADPCM", "DSP_SOLUTIONS_DIGISTD", "DSP_SOLUTION_DIGIFIX", "DIALOGIC_OKI_ADPCM", "MEDIA_VISION_ADPCM", "HP_CU", "HP_DYNAMIC_VOICE", "YAMAHA_ADPCM", "SONARC_SPEECH_COMPRESSION", "DSP_GROUP_TRUE_SPEECH", "ECHO_SPEECH_CORP", "VIRTUAL_MUSIC_AUDIOFILE_AF36", "AUDIO_PROCESSING_TECH", "VIRTUAL_MUSIC_AUDIOFILE_AF10", "ACULAB_PROSODY_1612", "MERGING_TECH_LRC", "DOLBY_AC2", "MICROSOFT_GSM610", "MSN_AUDIO", "ANTEX_ADPCME", "CONTROL_RESOURCES_VQLPC", "DSP_SOLUTIONS_DIGIREAL", "DSP_SOLUTIONS_DIGIADPCM", "CONTROL_RESOURCES_CR10", "NATURAL_MICRO_SYSTEMS_VBX_ADPCM", "CRYSTAL_SEMICONDUCTOR_IMA_ADPCM", "ECHO_SPEECH_ECHOSC3", "ROCKWELL_ADPCM", "ROCKWELL_DIGITALK", "XEBEC_MULTIMEDIA", "ANTEX_G721_ADPCM", "ANTEX_G728_CELP", "MICROSOFT_MSG723", "IBM_AVC_ADPCM", "ITU_G726", "MICROSOFT_MPEG", "RT23_PAC", "INSOFT_RT24", "INSOFT_PAC", "MP3", "CIRRUS", "CIRRUS_LOGIC", "ESS_TECH_PCM", "VOXWARE", "CANOPUS_ATRAC", "APICOM_G726_ADPCM", "APICOM_G722_ADPCM", "MICROSOFT_DSAT", "MICROSOFT_DSAT_DISPLAY", "VOXWARE_BYTE_ALIGNED", "VOXWARE_AC8", "VOXWARE_AC10", "VOXWARE_AC16", "VOXWARE_AC20", "VOXWARE_METAVOICE", "VOXWARE_METASOUND", "VOXWARE_RT29HW", "VOXWARE_VR12", "VOXWARE_VR18", "VOXWARE_TQ40", "VOXWARE_SC3_1", "VOXWARE_SC3_2", "SOUNDSOFT", "VOXWARE_TQ60", "MICROSOFT_MSRT24", "ATT_G729A", "MOTION_PIXELS_MVI", "DATAFUSION_G726", "DATAFUSION_GSM610", "ITERATED_AUDIO", "ONLIVE", "MULTITUDE_FT_SX20", "INFOCOM_G721_ADPCM", "CONVEDIA_G729", "CONGRUENCY", "SIEMENS_SBC24", "SONICFOUNDRY_AC3_SPDIF", "MEDIASONIC_G723", "ACULAB_PROSODY_8K", "ZYXEL_ADPCM", "PHILIPS_LPCBB", "STUDER_PACKED", "MALDEN_PHONYTALK", "RACAL_GSM", "RACAL_G720A", "RACAL_G723_1", "RACAL_TETRA_ACELP", "NEC_AAC", "AAC", "RHETOREX_ADPCM", "IBM_ULAW", "IBM_ALAW", "IBM_ADPCM", "VIVO_G723", "VIVO_SIREN", "PHILIPS_CELP", "PHILIPS_GRUNDIG", "DIGITAL_G723", "SANYO_LD_ADPCM", "SIPRO_ACELPNET", "SIPRO_ACELP4800", "SIPRO_ACELP8V3", "SIPRO_G729", "SIPRO_G729A", "SIPRO_KELVIN", "VOICEAGE_AMR", "DICTAPHONE_G726", "QUALCOMM_PUREVOICE", "QUALCOMM_HALFRATE", "RINGZERO_TUBGSM", "MICROSOFT_AUDIO1", "WMA", "WMA_PRO", "WMA_LOSSLESS", "WMA_PRO_SPDIF", "UNISYS_NAP_ADPCM", "UNISYS_NAP_ULAW", "UNISYS_NAP_ALAW", "UNISYS_NAP_16K", "SYCOM_SYC008", "SYCOM_G726L", "SYCOM_CELP54", "SYCOM_CELP68", "KNOWLEDGE_ADPCM", "FRAUNHOFER_MPEG2AAC", "DTS_DS", "CREATIVE_ADPCM", "CREATIVE_FASTSPEECH8", "CREATIVE_FASTSPEECH10", "UHER_ADPCM", "ULEAD_DV_ACM_1", "ULEAD_DV_ACM_2", "QUARTERDECK", "ILINK_VC", "AUREAL_RAW_SPORT", "ESST_AC3", "INTERACTIVE_HSX", "INTERACTIVE_RPELP", "CONSISTENT_CS2", "SONY_SCX", "SONY_SCY", "SONY_ATRAC3", "SONY_SPC", "TELUM", "TELUMIA", "NORCOM_ADPCM", "FUJITSU_TOWNS_SND", "FUJITSU_UNSPECIFIED_A", "FUJITSU_UNSPECIFIED_B", "FUJITSU_UNSPECIFIED_C", "FUJITSU_UNSPECIFIED_D", "FUJITSU_UNSPECIFIED_E", "FUJITSU_UNSPECIFIED_F", "FUJITSU_UNSPECIFIED_G", "FUJITSU_UNSPECIFIED_H", "MICRONAS_DEV", "MICRONAS_CELP833", "BROOKTREE_DIGITAL", "INTEL_IMC", "LIGOS_INDEO_AUDIO", "QDESIGN_MUSIC", "ON2_VP7", "ON2_VP6", "ATT_VMPCM", "ATT_TCP", "YMPEG_ALPHA", "CLEARJUMP_LITEWAVE", "OLIVETTI_GSM", "OLIVETTI_ADPCM", "OLIVETTI_CELP", "OLIVETTI_SBC", "OLIVETTI_OPR", "LH_CODEC", "LH_CELP", "LH_SBC1", "LH_SBC2", "LH_SBC3", "NORRIS", "ISIAUDIO", "ATT_SSPMC", "VOXWARE_RT24", "LUCENT_AX24000P", "SONICFOUNDRY_LOSSLESS", "INNINGS_ADPCM", "LUCENT_SX8300P", "LUCENT_SX5363S", "CUSEEME_DIGITALK", "NCT_SOFT_ALF2CD", "FAST_MULTIMEDIA_DVM", "DOLBY_DTS", "REALAUDIO_14_4", "REALAUDIO_28_8", "REALAUDIO_COOK", "REALAUDIO_DNET", "REALAUDIO_RAAC", "REALAUDIO_RACP", "MAKEAVIS", "DIVIO_MPEG4_AAC", "NOKIA_AMR", "DIVIO_G726", "LEAD_SPEECH", "LEAD_VORBIS", "WAVPACK", "OGG_VORBIS_MODE1", "OGG_VORBIS_MODE2", "OGG_VORBIS_MODE3", "OGG_VORBIS_MODE1P", "OGG_VORBIS_MODE2P", "OGG_VORBIS_MODE3P", "THREECOM_NBX", "FAAD_AAC", "GSM_AMR_CBR", "GSM_AMR_VBR", "COMVERSE_G723_1", "COMVERSE_AVQSBC", "COMVERSE_OLDSBC", "SYMBOL_G729A", "VOICEAGE_AMR_WB", "INGENIENT_G726", "ISO_MPEG4_AAC", "ENCORE_G726", "SPEEX", "DEBUGMODE_FRAMESERVER", "UNKNOWN_E708", "FLAC", "EXTENSIBLE", "Companion", "bread_server_lib"})
    @SourceDebugExtension(value={"SMAP\nRIFFAudioFormatChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RIFFAudioFormatChunk.kt\norg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk$AudioEncoding\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1208#2,2:293\n1236#2,4:295\n*S KotlinDebug\n*F\n+ 1 RIFFAudioFormatChunk.kt\norg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk$AudioEncoding\n*L\n289#1:293,2\n289#1:295,4\n*E\n"})
    public static final class AudioEncoding
    extends Enum<AudioEncoding> {
        @NotNull
        public static final Companion Companion;
        private final int code;
        @NotNull
        private static final Map<Integer, AudioEncoding> mapping;
        public static final /* enum */ AudioEncoding MICROSOFT_PCM;
        public static final /* enum */ AudioEncoding MICROSOFT_ADPCM;
        public static final /* enum */ AudioEncoding MICROSOFT_IEEE_FLOAT;
        public static final /* enum */ AudioEncoding COMPAQ_VSELP;
        public static final /* enum */ AudioEncoding IBM_CVSD;
        public static final /* enum */ AudioEncoding MICROSOFT_A_LAW;
        public static final /* enum */ AudioEncoding MICROSOFT_U_LAW;
        public static final /* enum */ AudioEncoding MICROSOFT_DTS;
        public static final /* enum */ AudioEncoding DRM;
        public static final /* enum */ AudioEncoding WMA_9_SPEECH;
        public static final /* enum */ AudioEncoding MICROSOFT_WINDOWS_MEDIA_RT_VOICE;
        public static final /* enum */ AudioEncoding OKI_ADPCM;
        public static final /* enum */ AudioEncoding INTEL_IMA_DVI_ADPCM;
        public static final /* enum */ AudioEncoding VIDEOLOGIC_MEDIASPACE_ADPCM;
        public static final /* enum */ AudioEncoding SIERRA_ADPCM;
        public static final /* enum */ AudioEncoding ANTEX_G723_ADPCM;
        public static final /* enum */ AudioEncoding DSP_SOLUTIONS_DIGISTD;
        public static final /* enum */ AudioEncoding DSP_SOLUTION_DIGIFIX;
        public static final /* enum */ AudioEncoding DIALOGIC_OKI_ADPCM;
        public static final /* enum */ AudioEncoding MEDIA_VISION_ADPCM;
        public static final /* enum */ AudioEncoding HP_CU;
        public static final /* enum */ AudioEncoding HP_DYNAMIC_VOICE;
        public static final /* enum */ AudioEncoding YAMAHA_ADPCM;
        public static final /* enum */ AudioEncoding SONARC_SPEECH_COMPRESSION;
        public static final /* enum */ AudioEncoding DSP_GROUP_TRUE_SPEECH;
        public static final /* enum */ AudioEncoding ECHO_SPEECH_CORP;
        public static final /* enum */ AudioEncoding VIRTUAL_MUSIC_AUDIOFILE_AF36;
        public static final /* enum */ AudioEncoding AUDIO_PROCESSING_TECH;
        public static final /* enum */ AudioEncoding VIRTUAL_MUSIC_AUDIOFILE_AF10;
        public static final /* enum */ AudioEncoding ACULAB_PROSODY_1612;
        public static final /* enum */ AudioEncoding MERGING_TECH_LRC;
        public static final /* enum */ AudioEncoding DOLBY_AC2;
        public static final /* enum */ AudioEncoding MICROSOFT_GSM610;
        public static final /* enum */ AudioEncoding MSN_AUDIO;
        public static final /* enum */ AudioEncoding ANTEX_ADPCME;
        public static final /* enum */ AudioEncoding CONTROL_RESOURCES_VQLPC;
        public static final /* enum */ AudioEncoding DSP_SOLUTIONS_DIGIREAL;
        public static final /* enum */ AudioEncoding DSP_SOLUTIONS_DIGIADPCM;
        public static final /* enum */ AudioEncoding CONTROL_RESOURCES_CR10;
        public static final /* enum */ AudioEncoding NATURAL_MICRO_SYSTEMS_VBX_ADPCM;
        public static final /* enum */ AudioEncoding CRYSTAL_SEMICONDUCTOR_IMA_ADPCM;
        public static final /* enum */ AudioEncoding ECHO_SPEECH_ECHOSC3;
        public static final /* enum */ AudioEncoding ROCKWELL_ADPCM;
        public static final /* enum */ AudioEncoding ROCKWELL_DIGITALK;
        public static final /* enum */ AudioEncoding XEBEC_MULTIMEDIA;
        public static final /* enum */ AudioEncoding ANTEX_G721_ADPCM;
        public static final /* enum */ AudioEncoding ANTEX_G728_CELP;
        public static final /* enum */ AudioEncoding MICROSOFT_MSG723;
        public static final /* enum */ AudioEncoding IBM_AVC_ADPCM;
        public static final /* enum */ AudioEncoding ITU_G726;
        public static final /* enum */ AudioEncoding MICROSOFT_MPEG;
        public static final /* enum */ AudioEncoding RT23_PAC;
        public static final /* enum */ AudioEncoding INSOFT_RT24;
        public static final /* enum */ AudioEncoding INSOFT_PAC;
        public static final /* enum */ AudioEncoding MP3;
        public static final /* enum */ AudioEncoding CIRRUS;
        public static final /* enum */ AudioEncoding CIRRUS_LOGIC;
        public static final /* enum */ AudioEncoding ESS_TECH_PCM;
        public static final /* enum */ AudioEncoding VOXWARE;
        public static final /* enum */ AudioEncoding CANOPUS_ATRAC;
        public static final /* enum */ AudioEncoding APICOM_G726_ADPCM;
        public static final /* enum */ AudioEncoding APICOM_G722_ADPCM;
        public static final /* enum */ AudioEncoding MICROSOFT_DSAT;
        public static final /* enum */ AudioEncoding MICROSOFT_DSAT_DISPLAY;
        public static final /* enum */ AudioEncoding VOXWARE_BYTE_ALIGNED;
        public static final /* enum */ AudioEncoding VOXWARE_AC8;
        public static final /* enum */ AudioEncoding VOXWARE_AC10;
        public static final /* enum */ AudioEncoding VOXWARE_AC16;
        public static final /* enum */ AudioEncoding VOXWARE_AC20;
        public static final /* enum */ AudioEncoding VOXWARE_METAVOICE;
        public static final /* enum */ AudioEncoding VOXWARE_METASOUND;
        public static final /* enum */ AudioEncoding VOXWARE_RT29HW;
        public static final /* enum */ AudioEncoding VOXWARE_VR12;
        public static final /* enum */ AudioEncoding VOXWARE_VR18;
        public static final /* enum */ AudioEncoding VOXWARE_TQ40;
        public static final /* enum */ AudioEncoding VOXWARE_SC3_1;
        public static final /* enum */ AudioEncoding VOXWARE_SC3_2;
        public static final /* enum */ AudioEncoding SOUNDSOFT;
        public static final /* enum */ AudioEncoding VOXWARE_TQ60;
        public static final /* enum */ AudioEncoding MICROSOFT_MSRT24;
        public static final /* enum */ AudioEncoding ATT_G729A;
        public static final /* enum */ AudioEncoding MOTION_PIXELS_MVI;
        public static final /* enum */ AudioEncoding DATAFUSION_G726;
        public static final /* enum */ AudioEncoding DATAFUSION_GSM610;
        public static final /* enum */ AudioEncoding ITERATED_AUDIO;
        public static final /* enum */ AudioEncoding ONLIVE;
        public static final /* enum */ AudioEncoding MULTITUDE_FT_SX20;
        public static final /* enum */ AudioEncoding INFOCOM_G721_ADPCM;
        public static final /* enum */ AudioEncoding CONVEDIA_G729;
        public static final /* enum */ AudioEncoding CONGRUENCY;
        public static final /* enum */ AudioEncoding SIEMENS_SBC24;
        public static final /* enum */ AudioEncoding SONICFOUNDRY_AC3_SPDIF;
        public static final /* enum */ AudioEncoding MEDIASONIC_G723;
        public static final /* enum */ AudioEncoding ACULAB_PROSODY_8K;
        public static final /* enum */ AudioEncoding ZYXEL_ADPCM;
        public static final /* enum */ AudioEncoding PHILIPS_LPCBB;
        public static final /* enum */ AudioEncoding STUDER_PACKED;
        public static final /* enum */ AudioEncoding MALDEN_PHONYTALK;
        public static final /* enum */ AudioEncoding RACAL_GSM;
        public static final /* enum */ AudioEncoding RACAL_G720A;
        public static final /* enum */ AudioEncoding RACAL_G723_1;
        public static final /* enum */ AudioEncoding RACAL_TETRA_ACELP;
        public static final /* enum */ AudioEncoding NEC_AAC;
        public static final /* enum */ AudioEncoding AAC;
        public static final /* enum */ AudioEncoding RHETOREX_ADPCM;
        public static final /* enum */ AudioEncoding IBM_ULAW;
        public static final /* enum */ AudioEncoding IBM_ALAW;
        public static final /* enum */ AudioEncoding IBM_ADPCM;
        public static final /* enum */ AudioEncoding VIVO_G723;
        public static final /* enum */ AudioEncoding VIVO_SIREN;
        public static final /* enum */ AudioEncoding PHILIPS_CELP;
        public static final /* enum */ AudioEncoding PHILIPS_GRUNDIG;
        public static final /* enum */ AudioEncoding DIGITAL_G723;
        public static final /* enum */ AudioEncoding SANYO_LD_ADPCM;
        public static final /* enum */ AudioEncoding SIPRO_ACELPNET;
        public static final /* enum */ AudioEncoding SIPRO_ACELP4800;
        public static final /* enum */ AudioEncoding SIPRO_ACELP8V3;
        public static final /* enum */ AudioEncoding SIPRO_G729;
        public static final /* enum */ AudioEncoding SIPRO_G729A;
        public static final /* enum */ AudioEncoding SIPRO_KELVIN;
        public static final /* enum */ AudioEncoding VOICEAGE_AMR;
        public static final /* enum */ AudioEncoding DICTAPHONE_G726;
        public static final /* enum */ AudioEncoding QUALCOMM_PUREVOICE;
        public static final /* enum */ AudioEncoding QUALCOMM_HALFRATE;
        public static final /* enum */ AudioEncoding RINGZERO_TUBGSM;
        public static final /* enum */ AudioEncoding MICROSOFT_AUDIO1;
        public static final /* enum */ AudioEncoding WMA;
        public static final /* enum */ AudioEncoding WMA_PRO;
        public static final /* enum */ AudioEncoding WMA_LOSSLESS;
        public static final /* enum */ AudioEncoding WMA_PRO_SPDIF;
        public static final /* enum */ AudioEncoding UNISYS_NAP_ADPCM;
        public static final /* enum */ AudioEncoding UNISYS_NAP_ULAW;
        public static final /* enum */ AudioEncoding UNISYS_NAP_ALAW;
        public static final /* enum */ AudioEncoding UNISYS_NAP_16K;
        public static final /* enum */ AudioEncoding SYCOM_SYC008;
        public static final /* enum */ AudioEncoding SYCOM_G726L;
        public static final /* enum */ AudioEncoding SYCOM_CELP54;
        public static final /* enum */ AudioEncoding SYCOM_CELP68;
        public static final /* enum */ AudioEncoding KNOWLEDGE_ADPCM;
        public static final /* enum */ AudioEncoding FRAUNHOFER_MPEG2AAC;
        public static final /* enum */ AudioEncoding DTS_DS;
        public static final /* enum */ AudioEncoding CREATIVE_ADPCM;
        public static final /* enum */ AudioEncoding CREATIVE_FASTSPEECH8;
        public static final /* enum */ AudioEncoding CREATIVE_FASTSPEECH10;
        public static final /* enum */ AudioEncoding UHER_ADPCM;
        public static final /* enum */ AudioEncoding ULEAD_DV_ACM_1;
        public static final /* enum */ AudioEncoding ULEAD_DV_ACM_2;
        public static final /* enum */ AudioEncoding QUARTERDECK;
        public static final /* enum */ AudioEncoding ILINK_VC;
        public static final /* enum */ AudioEncoding AUREAL_RAW_SPORT;
        public static final /* enum */ AudioEncoding ESST_AC3;
        public static final /* enum */ AudioEncoding INTERACTIVE_HSX;
        public static final /* enum */ AudioEncoding INTERACTIVE_RPELP;
        public static final /* enum */ AudioEncoding CONSISTENT_CS2;
        public static final /* enum */ AudioEncoding SONY_SCX;
        public static final /* enum */ AudioEncoding SONY_SCY;
        public static final /* enum */ AudioEncoding SONY_ATRAC3;
        public static final /* enum */ AudioEncoding SONY_SPC;
        public static final /* enum */ AudioEncoding TELUM;
        public static final /* enum */ AudioEncoding TELUMIA;
        public static final /* enum */ AudioEncoding NORCOM_ADPCM;
        public static final /* enum */ AudioEncoding FUJITSU_TOWNS_SND;
        public static final /* enum */ AudioEncoding FUJITSU_UNSPECIFIED_A;
        public static final /* enum */ AudioEncoding FUJITSU_UNSPECIFIED_B;
        public static final /* enum */ AudioEncoding FUJITSU_UNSPECIFIED_C;
        public static final /* enum */ AudioEncoding FUJITSU_UNSPECIFIED_D;
        public static final /* enum */ AudioEncoding FUJITSU_UNSPECIFIED_E;
        public static final /* enum */ AudioEncoding FUJITSU_UNSPECIFIED_F;
        public static final /* enum */ AudioEncoding FUJITSU_UNSPECIFIED_G;
        public static final /* enum */ AudioEncoding FUJITSU_UNSPECIFIED_H;
        public static final /* enum */ AudioEncoding MICRONAS_DEV;
        public static final /* enum */ AudioEncoding MICRONAS_CELP833;
        public static final /* enum */ AudioEncoding BROOKTREE_DIGITAL;
        public static final /* enum */ AudioEncoding INTEL_IMC;
        public static final /* enum */ AudioEncoding LIGOS_INDEO_AUDIO;
        public static final /* enum */ AudioEncoding QDESIGN_MUSIC;
        public static final /* enum */ AudioEncoding ON2_VP7;
        public static final /* enum */ AudioEncoding ON2_VP6;
        public static final /* enum */ AudioEncoding ATT_VMPCM;
        public static final /* enum */ AudioEncoding ATT_TCP;
        public static final /* enum */ AudioEncoding YMPEG_ALPHA;
        public static final /* enum */ AudioEncoding CLEARJUMP_LITEWAVE;
        public static final /* enum */ AudioEncoding OLIVETTI_GSM;
        public static final /* enum */ AudioEncoding OLIVETTI_ADPCM;
        public static final /* enum */ AudioEncoding OLIVETTI_CELP;
        public static final /* enum */ AudioEncoding OLIVETTI_SBC;
        public static final /* enum */ AudioEncoding OLIVETTI_OPR;
        public static final /* enum */ AudioEncoding LH_CODEC;
        public static final /* enum */ AudioEncoding LH_CELP;
        public static final /* enum */ AudioEncoding LH_SBC1;
        public static final /* enum */ AudioEncoding LH_SBC2;
        public static final /* enum */ AudioEncoding LH_SBC3;
        public static final /* enum */ AudioEncoding NORRIS;
        public static final /* enum */ AudioEncoding ISIAUDIO;
        public static final /* enum */ AudioEncoding ATT_SSPMC;
        public static final /* enum */ AudioEncoding VOXWARE_RT24;
        public static final /* enum */ AudioEncoding LUCENT_AX24000P;
        public static final /* enum */ AudioEncoding SONICFOUNDRY_LOSSLESS;
        public static final /* enum */ AudioEncoding INNINGS_ADPCM;
        public static final /* enum */ AudioEncoding LUCENT_SX8300P;
        public static final /* enum */ AudioEncoding LUCENT_SX5363S;
        public static final /* enum */ AudioEncoding CUSEEME_DIGITALK;
        public static final /* enum */ AudioEncoding NCT_SOFT_ALF2CD;
        public static final /* enum */ AudioEncoding FAST_MULTIMEDIA_DVM;
        public static final /* enum */ AudioEncoding DOLBY_DTS;
        public static final /* enum */ AudioEncoding REALAUDIO_14_4;
        public static final /* enum */ AudioEncoding REALAUDIO_28_8;
        public static final /* enum */ AudioEncoding REALAUDIO_COOK;
        public static final /* enum */ AudioEncoding REALAUDIO_DNET;
        public static final /* enum */ AudioEncoding REALAUDIO_RAAC;
        public static final /* enum */ AudioEncoding REALAUDIO_RACP;
        public static final /* enum */ AudioEncoding MAKEAVIS;
        public static final /* enum */ AudioEncoding DIVIO_MPEG4_AAC;
        public static final /* enum */ AudioEncoding NOKIA_AMR;
        public static final /* enum */ AudioEncoding DIVIO_G726;
        public static final /* enum */ AudioEncoding LEAD_SPEECH;
        public static final /* enum */ AudioEncoding LEAD_VORBIS;
        public static final /* enum */ AudioEncoding WAVPACK;
        public static final /* enum */ AudioEncoding OGG_VORBIS_MODE1;
        public static final /* enum */ AudioEncoding OGG_VORBIS_MODE2;
        public static final /* enum */ AudioEncoding OGG_VORBIS_MODE3;
        public static final /* enum */ AudioEncoding OGG_VORBIS_MODE1P;
        public static final /* enum */ AudioEncoding OGG_VORBIS_MODE2P;
        public static final /* enum */ AudioEncoding OGG_VORBIS_MODE3P;
        public static final /* enum */ AudioEncoding THREECOM_NBX;
        public static final /* enum */ AudioEncoding FAAD_AAC;
        public static final /* enum */ AudioEncoding GSM_AMR_CBR;
        public static final /* enum */ AudioEncoding GSM_AMR_VBR;
        public static final /* enum */ AudioEncoding COMVERSE_G723_1;
        public static final /* enum */ AudioEncoding COMVERSE_AVQSBC;
        public static final /* enum */ AudioEncoding COMVERSE_OLDSBC;
        public static final /* enum */ AudioEncoding SYMBOL_G729A;
        public static final /* enum */ AudioEncoding VOICEAGE_AMR_WB;
        public static final /* enum */ AudioEncoding INGENIENT_G726;
        public static final /* enum */ AudioEncoding ISO_MPEG4_AAC;
        public static final /* enum */ AudioEncoding ENCORE_G726;
        public static final /* enum */ AudioEncoding SPEEX;
        public static final /* enum */ AudioEncoding DEBUGMODE_FRAMESERVER;
        public static final /* enum */ AudioEncoding UNKNOWN_E708;
        public static final /* enum */ AudioEncoding FLAC;
        public static final /* enum */ AudioEncoding EXTENSIBLE;
        private static final /* synthetic */ AudioEncoding[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AudioEncoding(int code) {
            this.code = code;
        }

        public final int getCode() {
            return this.code;
        }

        public static AudioEncoding[] values() {
            return (AudioEncoding[])$VALUES.clone();
        }

        public static AudioEncoding valueOf(String value) {
            return Enum.valueOf(AudioEncoding.class, value);
        }

        @NotNull
        public static EnumEntries<AudioEncoding> getEntries() {
            return $ENTRIES;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            MICROSOFT_PCM = new AudioEncoding(1);
            MICROSOFT_ADPCM = new AudioEncoding(2);
            MICROSOFT_IEEE_FLOAT = new AudioEncoding(3);
            COMPAQ_VSELP = new AudioEncoding(4);
            IBM_CVSD = new AudioEncoding(5);
            MICROSOFT_A_LAW = new AudioEncoding(6);
            MICROSOFT_U_LAW = new AudioEncoding(7);
            MICROSOFT_DTS = new AudioEncoding(8);
            DRM = new AudioEncoding(9);
            WMA_9_SPEECH = new AudioEncoding(10);
            MICROSOFT_WINDOWS_MEDIA_RT_VOICE = new AudioEncoding(11);
            OKI_ADPCM = new AudioEncoding(16);
            INTEL_IMA_DVI_ADPCM = new AudioEncoding(17);
            VIDEOLOGIC_MEDIASPACE_ADPCM = new AudioEncoding(18);
            SIERRA_ADPCM = new AudioEncoding(19);
            ANTEX_G723_ADPCM = new AudioEncoding(20);
            DSP_SOLUTIONS_DIGISTD = new AudioEncoding(21);
            DSP_SOLUTION_DIGIFIX = new AudioEncoding(22);
            DIALOGIC_OKI_ADPCM = new AudioEncoding(23);
            MEDIA_VISION_ADPCM = new AudioEncoding(24);
            HP_CU = new AudioEncoding(25);
            HP_DYNAMIC_VOICE = new AudioEncoding(26);
            YAMAHA_ADPCM = new AudioEncoding(32);
            SONARC_SPEECH_COMPRESSION = new AudioEncoding(33);
            DSP_GROUP_TRUE_SPEECH = new AudioEncoding(34);
            ECHO_SPEECH_CORP = new AudioEncoding(35);
            VIRTUAL_MUSIC_AUDIOFILE_AF36 = new AudioEncoding(36);
            AUDIO_PROCESSING_TECH = new AudioEncoding(37);
            VIRTUAL_MUSIC_AUDIOFILE_AF10 = new AudioEncoding(38);
            ACULAB_PROSODY_1612 = new AudioEncoding(39);
            MERGING_TECH_LRC = new AudioEncoding(40);
            DOLBY_AC2 = new AudioEncoding(48);
            MICROSOFT_GSM610 = new AudioEncoding(49);
            MSN_AUDIO = new AudioEncoding(50);
            ANTEX_ADPCME = new AudioEncoding(51);
            CONTROL_RESOURCES_VQLPC = new AudioEncoding(52);
            DSP_SOLUTIONS_DIGIREAL = new AudioEncoding(53);
            DSP_SOLUTIONS_DIGIADPCM = new AudioEncoding(54);
            CONTROL_RESOURCES_CR10 = new AudioEncoding(55);
            NATURAL_MICRO_SYSTEMS_VBX_ADPCM = new AudioEncoding(56);
            CRYSTAL_SEMICONDUCTOR_IMA_ADPCM = new AudioEncoding(57);
            ECHO_SPEECH_ECHOSC3 = new AudioEncoding(58);
            ROCKWELL_ADPCM = new AudioEncoding(59);
            ROCKWELL_DIGITALK = new AudioEncoding(60);
            XEBEC_MULTIMEDIA = new AudioEncoding(61);
            ANTEX_G721_ADPCM = new AudioEncoding(64);
            ANTEX_G728_CELP = new AudioEncoding(65);
            MICROSOFT_MSG723 = new AudioEncoding(66);
            IBM_AVC_ADPCM = new AudioEncoding(67);
            ITU_G726 = new AudioEncoding(69);
            MICROSOFT_MPEG = new AudioEncoding(80);
            RT23_PAC = new AudioEncoding(81);
            INSOFT_RT24 = new AudioEncoding(82);
            INSOFT_PAC = new AudioEncoding(83);
            MP3 = new AudioEncoding(85);
            CIRRUS = new AudioEncoding(89);
            CIRRUS_LOGIC = new AudioEncoding(96);
            ESS_TECH_PCM = new AudioEncoding(97);
            VOXWARE = new AudioEncoding(98);
            CANOPUS_ATRAC = new AudioEncoding(99);
            APICOM_G726_ADPCM = new AudioEncoding(100);
            APICOM_G722_ADPCM = new AudioEncoding(101);
            MICROSOFT_DSAT = new AudioEncoding(102);
            MICROSOFT_DSAT_DISPLAY = new AudioEncoding(103);
            VOXWARE_BYTE_ALIGNED = new AudioEncoding(105);
            VOXWARE_AC8 = new AudioEncoding(112);
            VOXWARE_AC10 = new AudioEncoding(113);
            VOXWARE_AC16 = new AudioEncoding(114);
            VOXWARE_AC20 = new AudioEncoding(115);
            VOXWARE_METAVOICE = new AudioEncoding(116);
            VOXWARE_METASOUND = new AudioEncoding(117);
            VOXWARE_RT29HW = new AudioEncoding(118);
            VOXWARE_VR12 = new AudioEncoding(119);
            VOXWARE_VR18 = new AudioEncoding(120);
            VOXWARE_TQ40 = new AudioEncoding(121);
            VOXWARE_SC3_1 = new AudioEncoding(122);
            VOXWARE_SC3_2 = new AudioEncoding(123);
            SOUNDSOFT = new AudioEncoding(128);
            VOXWARE_TQ60 = new AudioEncoding(129);
            MICROSOFT_MSRT24 = new AudioEncoding(130);
            ATT_G729A = new AudioEncoding(131);
            MOTION_PIXELS_MVI = new AudioEncoding(132);
            DATAFUSION_G726 = new AudioEncoding(133);
            DATAFUSION_GSM610 = new AudioEncoding(134);
            ITERATED_AUDIO = new AudioEncoding(136);
            ONLIVE = new AudioEncoding(137);
            MULTITUDE_FT_SX20 = new AudioEncoding(138);
            INFOCOM_G721_ADPCM = new AudioEncoding(139);
            CONVEDIA_G729 = new AudioEncoding(140);
            CONGRUENCY = new AudioEncoding(141);
            SIEMENS_SBC24 = new AudioEncoding(145);
            SONICFOUNDRY_AC3_SPDIF = new AudioEncoding(146);
            MEDIASONIC_G723 = new AudioEncoding(147);
            ACULAB_PROSODY_8K = new AudioEncoding(148);
            ZYXEL_ADPCM = new AudioEncoding(151);
            PHILIPS_LPCBB = new AudioEncoding(152);
            STUDER_PACKED = new AudioEncoding(153);
            MALDEN_PHONYTALK = new AudioEncoding(160);
            RACAL_GSM = new AudioEncoding(161);
            RACAL_G720A = new AudioEncoding(162);
            RACAL_G723_1 = new AudioEncoding(163);
            RACAL_TETRA_ACELP = new AudioEncoding(164);
            NEC_AAC = new AudioEncoding(176);
            AAC = new AudioEncoding(255);
            RHETOREX_ADPCM = new AudioEncoding(256);
            IBM_ULAW = new AudioEncoding(257);
            IBM_ALAW = new AudioEncoding(258);
            IBM_ADPCM = new AudioEncoding(259);
            VIVO_G723 = new AudioEncoding(273);
            VIVO_SIREN = new AudioEncoding(274);
            PHILIPS_CELP = new AudioEncoding(288);
            PHILIPS_GRUNDIG = new AudioEncoding(289);
            DIGITAL_G723 = new AudioEncoding(291);
            SANYO_LD_ADPCM = new AudioEncoding(293);
            SIPRO_ACELPNET = new AudioEncoding(304);
            SIPRO_ACELP4800 = new AudioEncoding(305);
            SIPRO_ACELP8V3 = new AudioEncoding(306);
            SIPRO_G729 = new AudioEncoding(307);
            SIPRO_G729A = new AudioEncoding(308);
            SIPRO_KELVIN = new AudioEncoding(309);
            VOICEAGE_AMR = new AudioEncoding(310);
            DICTAPHONE_G726 = new AudioEncoding(320);
            QUALCOMM_PUREVOICE = new AudioEncoding(336);
            QUALCOMM_HALFRATE = new AudioEncoding(337);
            RINGZERO_TUBGSM = new AudioEncoding(341);
            MICROSOFT_AUDIO1 = new AudioEncoding(352);
            WMA = new AudioEncoding(353);
            WMA_PRO = new AudioEncoding(354);
            WMA_LOSSLESS = new AudioEncoding(355);
            WMA_PRO_SPDIF = new AudioEncoding(356);
            UNISYS_NAP_ADPCM = new AudioEncoding(368);
            UNISYS_NAP_ULAW = new AudioEncoding(369);
            UNISYS_NAP_ALAW = new AudioEncoding(370);
            UNISYS_NAP_16K = new AudioEncoding(371);
            SYCOM_SYC008 = new AudioEncoding(372);
            SYCOM_G726L = new AudioEncoding(373);
            SYCOM_CELP54 = new AudioEncoding(374);
            SYCOM_CELP68 = new AudioEncoding(375);
            KNOWLEDGE_ADPCM = new AudioEncoding(376);
            FRAUNHOFER_MPEG2AAC = new AudioEncoding(384);
            DTS_DS = new AudioEncoding(400);
            CREATIVE_ADPCM = new AudioEncoding(512);
            CREATIVE_FASTSPEECH8 = new AudioEncoding(514);
            CREATIVE_FASTSPEECH10 = new AudioEncoding(515);
            UHER_ADPCM = new AudioEncoding(528);
            ULEAD_DV_ACM_1 = new AudioEncoding(533);
            ULEAD_DV_ACM_2 = new AudioEncoding(534);
            QUARTERDECK = new AudioEncoding(544);
            ILINK_VC = new AudioEncoding(560);
            AUREAL_RAW_SPORT = new AudioEncoding(576);
            ESST_AC3 = new AudioEncoding(577);
            INTERACTIVE_HSX = new AudioEncoding(592);
            INTERACTIVE_RPELP = new AudioEncoding(593);
            CONSISTENT_CS2 = new AudioEncoding(608);
            SONY_SCX = new AudioEncoding(624);
            SONY_SCY = new AudioEncoding(625);
            SONY_ATRAC3 = new AudioEncoding(626);
            SONY_SPC = new AudioEncoding(627);
            TELUM = new AudioEncoding(640);
            TELUMIA = new AudioEncoding(641);
            NORCOM_ADPCM = new AudioEncoding(645);
            FUJITSU_TOWNS_SND = new AudioEncoding(768);
            FUJITSU_UNSPECIFIED_A = new AudioEncoding(769);
            FUJITSU_UNSPECIFIED_B = new AudioEncoding(770);
            FUJITSU_UNSPECIFIED_C = new AudioEncoding(771);
            FUJITSU_UNSPECIFIED_D = new AudioEncoding(772);
            FUJITSU_UNSPECIFIED_E = new AudioEncoding(773);
            FUJITSU_UNSPECIFIED_F = new AudioEncoding(774);
            FUJITSU_UNSPECIFIED_G = new AudioEncoding(775);
            FUJITSU_UNSPECIFIED_H = new AudioEncoding(776);
            MICRONAS_DEV = new AudioEncoding(848);
            MICRONAS_CELP833 = new AudioEncoding(849);
            BROOKTREE_DIGITAL = new AudioEncoding(1024);
            INTEL_IMC = new AudioEncoding(1025);
            LIGOS_INDEO_AUDIO = new AudioEncoding(1026);
            QDESIGN_MUSIC = new AudioEncoding(1104);
            ON2_VP7 = new AudioEncoding(1280);
            ON2_VP6 = new AudioEncoding(1281);
            ATT_VMPCM = new AudioEncoding(1664);
            ATT_TCP = new AudioEncoding(1665);
            YMPEG_ALPHA = new AudioEncoding(1792);
            CLEARJUMP_LITEWAVE = new AudioEncoding(2222);
            OLIVETTI_GSM = new AudioEncoding(4096);
            OLIVETTI_ADPCM = new AudioEncoding(4097);
            OLIVETTI_CELP = new AudioEncoding(4098);
            OLIVETTI_SBC = new AudioEncoding(4099);
            OLIVETTI_OPR = new AudioEncoding(4100);
            LH_CODEC = new AudioEncoding(4352);
            LH_CELP = new AudioEncoding(4353);
            LH_SBC1 = new AudioEncoding(4354);
            LH_SBC2 = new AudioEncoding(4355);
            LH_SBC3 = new AudioEncoding(4356);
            NORRIS = new AudioEncoding(5120);
            ISIAUDIO = new AudioEncoding(5121);
            ATT_SSPMC = new AudioEncoding(5376);
            VOXWARE_RT24 = new AudioEncoding(6172);
            LUCENT_AX24000P = new AudioEncoding(6174);
            SONICFOUNDRY_LOSSLESS = new AudioEncoding(6513);
            INNINGS_ADPCM = new AudioEncoding(6521);
            LUCENT_SX8300P = new AudioEncoding(7175);
            LUCENT_SX5363S = new AudioEncoding(7180);
            CUSEEME_DIGITALK = new AudioEncoding(7939);
            NCT_SOFT_ALF2CD = new AudioEncoding(8132);
            FAST_MULTIMEDIA_DVM = new AudioEncoding(8192);
            DOLBY_DTS = new AudioEncoding(8193);
            REALAUDIO_14_4 = new AudioEncoding(8194);
            REALAUDIO_28_8 = new AudioEncoding(8195);
            REALAUDIO_COOK = new AudioEncoding(8196);
            REALAUDIO_DNET = new AudioEncoding(8197);
            REALAUDIO_RAAC = new AudioEncoding(8198);
            REALAUDIO_RACP = new AudioEncoding(8199);
            MAKEAVIS = new AudioEncoding(13075);
            DIVIO_MPEG4_AAC = new AudioEncoding(16707);
            NOKIA_AMR = new AudioEncoding(16897);
            DIVIO_G726 = new AudioEncoding(16963);
            LEAD_SPEECH = new AudioEncoding(17228);
            LEAD_VORBIS = new AudioEncoding(22092);
            WAVPACK = new AudioEncoding(22358);
            OGG_VORBIS_MODE1 = new AudioEncoding(26447);
            OGG_VORBIS_MODE2 = new AudioEncoding(26448);
            OGG_VORBIS_MODE3 = new AudioEncoding(26449);
            OGG_VORBIS_MODE1P = new AudioEncoding(26479);
            OGG_VORBIS_MODE2P = new AudioEncoding(26480);
            OGG_VORBIS_MODE3P = new AudioEncoding(26481);
            THREECOM_NBX = new AudioEncoding(28672);
            FAAD_AAC = new AudioEncoding(28781);
            GSM_AMR_CBR = new AudioEncoding(31265);
            GSM_AMR_VBR = new AudioEncoding(31266);
            COMVERSE_G723_1 = new AudioEncoding(41216);
            COMVERSE_AVQSBC = new AudioEncoding(41217);
            COMVERSE_OLDSBC = new AudioEncoding(41218);
            SYMBOL_G729A = new AudioEncoding(41219);
            VOICEAGE_AMR_WB = new AudioEncoding(41220);
            INGENIENT_G726 = new AudioEncoding(41221);
            ISO_MPEG4_AAC = new AudioEncoding(41222);
            ENCORE_G726 = new AudioEncoding(41223);
            SPEEX = new AudioEncoding(41225);
            DEBUGMODE_FRAMESERVER = new AudioEncoding(57260);
            UNKNOWN_E708 = new AudioEncoding(59144);
            FLAC = new AudioEncoding(61868);
            EXTENSIBLE = new AudioEncoding(65534);
            $VALUES = audioEncodingArray = new AudioEncoding[]{AudioEncoding.MICROSOFT_PCM, AudioEncoding.MICROSOFT_ADPCM, AudioEncoding.MICROSOFT_IEEE_FLOAT, AudioEncoding.COMPAQ_VSELP, AudioEncoding.IBM_CVSD, AudioEncoding.MICROSOFT_A_LAW, AudioEncoding.MICROSOFT_U_LAW, AudioEncoding.MICROSOFT_DTS, AudioEncoding.DRM, AudioEncoding.WMA_9_SPEECH, AudioEncoding.MICROSOFT_WINDOWS_MEDIA_RT_VOICE, AudioEncoding.OKI_ADPCM, AudioEncoding.INTEL_IMA_DVI_ADPCM, AudioEncoding.VIDEOLOGIC_MEDIASPACE_ADPCM, AudioEncoding.SIERRA_ADPCM, AudioEncoding.ANTEX_G723_ADPCM, AudioEncoding.DSP_SOLUTIONS_DIGISTD, AudioEncoding.DSP_SOLUTION_DIGIFIX, AudioEncoding.DIALOGIC_OKI_ADPCM, AudioEncoding.MEDIA_VISION_ADPCM, AudioEncoding.HP_CU, AudioEncoding.HP_DYNAMIC_VOICE, AudioEncoding.YAMAHA_ADPCM, AudioEncoding.SONARC_SPEECH_COMPRESSION, AudioEncoding.DSP_GROUP_TRUE_SPEECH, AudioEncoding.ECHO_SPEECH_CORP, AudioEncoding.VIRTUAL_MUSIC_AUDIOFILE_AF36, AudioEncoding.AUDIO_PROCESSING_TECH, AudioEncoding.VIRTUAL_MUSIC_AUDIOFILE_AF10, AudioEncoding.ACULAB_PROSODY_1612, AudioEncoding.MERGING_TECH_LRC, AudioEncoding.DOLBY_AC2, AudioEncoding.MICROSOFT_GSM610, AudioEncoding.MSN_AUDIO, AudioEncoding.ANTEX_ADPCME, AudioEncoding.CONTROL_RESOURCES_VQLPC, AudioEncoding.DSP_SOLUTIONS_DIGIREAL, AudioEncoding.DSP_SOLUTIONS_DIGIADPCM, AudioEncoding.CONTROL_RESOURCES_CR10, AudioEncoding.NATURAL_MICRO_SYSTEMS_VBX_ADPCM, AudioEncoding.CRYSTAL_SEMICONDUCTOR_IMA_ADPCM, AudioEncoding.ECHO_SPEECH_ECHOSC3, AudioEncoding.ROCKWELL_ADPCM, AudioEncoding.ROCKWELL_DIGITALK, AudioEncoding.XEBEC_MULTIMEDIA, AudioEncoding.ANTEX_G721_ADPCM, AudioEncoding.ANTEX_G728_CELP, AudioEncoding.MICROSOFT_MSG723, AudioEncoding.IBM_AVC_ADPCM, AudioEncoding.ITU_G726, AudioEncoding.MICROSOFT_MPEG, AudioEncoding.RT23_PAC, AudioEncoding.INSOFT_RT24, AudioEncoding.INSOFT_PAC, AudioEncoding.MP3, AudioEncoding.CIRRUS, AudioEncoding.CIRRUS_LOGIC, AudioEncoding.ESS_TECH_PCM, AudioEncoding.VOXWARE, AudioEncoding.CANOPUS_ATRAC, AudioEncoding.APICOM_G726_ADPCM, AudioEncoding.APICOM_G722_ADPCM, AudioEncoding.MICROSOFT_DSAT, AudioEncoding.MICROSOFT_DSAT_DISPLAY, AudioEncoding.VOXWARE_BYTE_ALIGNED, AudioEncoding.VOXWARE_AC8, AudioEncoding.VOXWARE_AC10, AudioEncoding.VOXWARE_AC16, AudioEncoding.VOXWARE_AC20, AudioEncoding.VOXWARE_METAVOICE, AudioEncoding.VOXWARE_METASOUND, AudioEncoding.VOXWARE_RT29HW, AudioEncoding.VOXWARE_VR12, AudioEncoding.VOXWARE_VR18, AudioEncoding.VOXWARE_TQ40, AudioEncoding.VOXWARE_SC3_1, AudioEncoding.VOXWARE_SC3_2, AudioEncoding.SOUNDSOFT, AudioEncoding.VOXWARE_TQ60, AudioEncoding.MICROSOFT_MSRT24, AudioEncoding.ATT_G729A, AudioEncoding.MOTION_PIXELS_MVI, AudioEncoding.DATAFUSION_G726, AudioEncoding.DATAFUSION_GSM610, AudioEncoding.ITERATED_AUDIO, AudioEncoding.ONLIVE, AudioEncoding.MULTITUDE_FT_SX20, AudioEncoding.INFOCOM_G721_ADPCM, AudioEncoding.CONVEDIA_G729, AudioEncoding.CONGRUENCY, AudioEncoding.SIEMENS_SBC24, AudioEncoding.SONICFOUNDRY_AC3_SPDIF, AudioEncoding.MEDIASONIC_G723, AudioEncoding.ACULAB_PROSODY_8K, AudioEncoding.ZYXEL_ADPCM, AudioEncoding.PHILIPS_LPCBB, AudioEncoding.STUDER_PACKED, AudioEncoding.MALDEN_PHONYTALK, AudioEncoding.RACAL_GSM, AudioEncoding.RACAL_G720A, AudioEncoding.RACAL_G723_1, AudioEncoding.RACAL_TETRA_ACELP, AudioEncoding.NEC_AAC, AudioEncoding.AAC, AudioEncoding.RHETOREX_ADPCM, AudioEncoding.IBM_ULAW, AudioEncoding.IBM_ALAW, AudioEncoding.IBM_ADPCM, AudioEncoding.VIVO_G723, AudioEncoding.VIVO_SIREN, AudioEncoding.PHILIPS_CELP, AudioEncoding.PHILIPS_GRUNDIG, AudioEncoding.DIGITAL_G723, AudioEncoding.SANYO_LD_ADPCM, AudioEncoding.SIPRO_ACELPNET, AudioEncoding.SIPRO_ACELP4800, AudioEncoding.SIPRO_ACELP8V3, AudioEncoding.SIPRO_G729, AudioEncoding.SIPRO_G729A, AudioEncoding.SIPRO_KELVIN, AudioEncoding.VOICEAGE_AMR, AudioEncoding.DICTAPHONE_G726, AudioEncoding.QUALCOMM_PUREVOICE, AudioEncoding.QUALCOMM_HALFRATE, AudioEncoding.RINGZERO_TUBGSM, AudioEncoding.MICROSOFT_AUDIO1, AudioEncoding.WMA, AudioEncoding.WMA_PRO, AudioEncoding.WMA_LOSSLESS, AudioEncoding.WMA_PRO_SPDIF, AudioEncoding.UNISYS_NAP_ADPCM, AudioEncoding.UNISYS_NAP_ULAW, AudioEncoding.UNISYS_NAP_ALAW, AudioEncoding.UNISYS_NAP_16K, AudioEncoding.SYCOM_SYC008, AudioEncoding.SYCOM_G726L, AudioEncoding.SYCOM_CELP54, AudioEncoding.SYCOM_CELP68, AudioEncoding.KNOWLEDGE_ADPCM, AudioEncoding.FRAUNHOFER_MPEG2AAC, AudioEncoding.DTS_DS, AudioEncoding.CREATIVE_ADPCM, AudioEncoding.CREATIVE_FASTSPEECH8, AudioEncoding.CREATIVE_FASTSPEECH10, AudioEncoding.UHER_ADPCM, AudioEncoding.ULEAD_DV_ACM_1, AudioEncoding.ULEAD_DV_ACM_2, AudioEncoding.QUARTERDECK, AudioEncoding.ILINK_VC, AudioEncoding.AUREAL_RAW_SPORT, AudioEncoding.ESST_AC3, AudioEncoding.INTERACTIVE_HSX, AudioEncoding.INTERACTIVE_RPELP, AudioEncoding.CONSISTENT_CS2, AudioEncoding.SONY_SCX, AudioEncoding.SONY_SCY, AudioEncoding.SONY_ATRAC3, AudioEncoding.SONY_SPC, AudioEncoding.TELUM, AudioEncoding.TELUMIA, AudioEncoding.NORCOM_ADPCM, AudioEncoding.FUJITSU_TOWNS_SND, AudioEncoding.FUJITSU_UNSPECIFIED_A, AudioEncoding.FUJITSU_UNSPECIFIED_B, AudioEncoding.FUJITSU_UNSPECIFIED_C, AudioEncoding.FUJITSU_UNSPECIFIED_D, AudioEncoding.FUJITSU_UNSPECIFIED_E, AudioEncoding.FUJITSU_UNSPECIFIED_F, AudioEncoding.FUJITSU_UNSPECIFIED_G, AudioEncoding.FUJITSU_UNSPECIFIED_H, AudioEncoding.MICRONAS_DEV, AudioEncoding.MICRONAS_CELP833, AudioEncoding.BROOKTREE_DIGITAL, AudioEncoding.INTEL_IMC, AudioEncoding.LIGOS_INDEO_AUDIO, AudioEncoding.QDESIGN_MUSIC, AudioEncoding.ON2_VP7, AudioEncoding.ON2_VP6, AudioEncoding.ATT_VMPCM, AudioEncoding.ATT_TCP, AudioEncoding.YMPEG_ALPHA, AudioEncoding.CLEARJUMP_LITEWAVE, AudioEncoding.OLIVETTI_GSM, AudioEncoding.OLIVETTI_ADPCM, AudioEncoding.OLIVETTI_CELP, AudioEncoding.OLIVETTI_SBC, AudioEncoding.OLIVETTI_OPR, AudioEncoding.LH_CODEC, AudioEncoding.LH_CELP, AudioEncoding.LH_SBC1, AudioEncoding.LH_SBC2, AudioEncoding.LH_SBC3, AudioEncoding.NORRIS, AudioEncoding.ISIAUDIO, AudioEncoding.ATT_SSPMC, AudioEncoding.VOXWARE_RT24, AudioEncoding.LUCENT_AX24000P, AudioEncoding.SONICFOUNDRY_LOSSLESS, AudioEncoding.INNINGS_ADPCM, AudioEncoding.LUCENT_SX8300P, AudioEncoding.LUCENT_SX5363S, AudioEncoding.CUSEEME_DIGITALK, AudioEncoding.NCT_SOFT_ALF2CD, AudioEncoding.FAST_MULTIMEDIA_DVM, AudioEncoding.DOLBY_DTS, AudioEncoding.REALAUDIO_14_4, AudioEncoding.REALAUDIO_28_8, AudioEncoding.REALAUDIO_COOK, AudioEncoding.REALAUDIO_DNET, AudioEncoding.REALAUDIO_RAAC, AudioEncoding.REALAUDIO_RACP, AudioEncoding.MAKEAVIS, AudioEncoding.DIVIO_MPEG4_AAC, AudioEncoding.NOKIA_AMR, AudioEncoding.DIVIO_G726, AudioEncoding.LEAD_SPEECH, AudioEncoding.LEAD_VORBIS, AudioEncoding.WAVPACK, AudioEncoding.OGG_VORBIS_MODE1, AudioEncoding.OGG_VORBIS_MODE2, AudioEncoding.OGG_VORBIS_MODE3, AudioEncoding.OGG_VORBIS_MODE1P, AudioEncoding.OGG_VORBIS_MODE2P, AudioEncoding.OGG_VORBIS_MODE3P, AudioEncoding.THREECOM_NBX, AudioEncoding.FAAD_AAC, AudioEncoding.GSM_AMR_CBR, AudioEncoding.GSM_AMR_VBR, AudioEncoding.COMVERSE_G723_1, AudioEncoding.COMVERSE_AVQSBC, AudioEncoding.COMVERSE_OLDSBC, AudioEncoding.SYMBOL_G729A, AudioEncoding.VOICEAGE_AMR_WB, AudioEncoding.INGENIENT_G726, AudioEncoding.ISO_MPEG4_AAC, AudioEncoding.ENCORE_G726, AudioEncoding.SPEEX, AudioEncoding.DEBUGMODE_FRAMESERVER, AudioEncoding.UNKNOWN_E708, AudioEncoding.FLAC, AudioEncoding.EXTENSIBLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Iterable $this$associateBy$iv = AudioEncoding.getEntries();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void p0;
                AudioEncoding audioEncoding = (AudioEncoding)((Object)element$iv$iv);
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.code, element$iv$iv);
            }
            mapping = destination$iv$iv;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk$AudioEncoding$Companion;", "", "<init>", "()V", "mapping", "", "", "Lorg/bread_experts_group/coder/format/parse/riff/chunk/RIFFAudioFormatChunk$AudioEncoding;", "getMapping", "()Ljava/util/Map;", "bread_server_lib"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<Integer, AudioEncoding> getMapping() {
                return mapping;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

