/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.format.parse.tiff;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.collections.ArrayDeque;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.channel.WindowedSeekableByteChannel;
import org.bread_experts_group.coder.CodingException;
import org.bread_experts_group.coder.CompoundThrowable;
import org.bread_experts_group.coder.Mappable;
import org.bread_experts_group.coder.MappedEnumeration;
import org.bread_experts_group.coder.format.parse.ByteParser;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.bread_experts_group.coder.format.parse.ValidationException;
import org.bread_experts_group.coder.format.parse.tiff.TIFFDataType;
import org.bread_experts_group.coder.format.parse.tiff.TIFFStructureIdentifier;
import org.bread_experts_group.coder.format.parse.tiff.structure.TIFFExifOffset;
import org.bread_experts_group.coder.format.parse.tiff.structure.TIFFStructure;
import org.bread_experts_group.coder.format.parse.tiff.structure.TIFFTextStructure;
import org.bread_experts_group.stream.FailQuickInputStream;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0003H\u0014J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\bH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/bread_experts_group/coder/format/parse/tiff/TIFFByteParser;", "Lorg/bread_experts_group/coder/format/parse/ByteParser;", "Lorg/bread_experts_group/coder/format/parse/tiff/TIFFStructureIdentifier;", "Lorg/bread_experts_group/coder/format/parse/tiff/structure/TIFFStructure;", "Ljava/nio/channels/SeekableByteChannel;", "<init>", "()V", "order", "Ljava/nio/ByteOrder;", "responsibleChannel", "of", "structures", "Lkotlin/collections/ArrayDeque;", "buffer12", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "readBase", "compound", "Lorg/bread_experts_group/coder/CompoundThrowable;", "Lorg/bread_experts_group/coder/CodingException;", "Lorg/bread_experts_group/coder/format/parse/CodingCompoundThrowable;", "internalInit", "from", "fromOrder", "inputInit", "", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nTIFFByteParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TIFFByteParser.kt\norg/bread_experts_group/coder/format/parse/tiff/TIFFByteParser\n+ 2 Mappable.kt\norg/bread_experts_group/coder/Mappable$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n14#2,2:107\n16#2:110\n18#2,2:112\n14#2,2:114\n16#2:117\n18#2,2:119\n295#3:109\n296#3:111\n295#3:116\n296#3:118\n*S KotlinDebug\n*F\n+ 1 TIFFByteParser.kt\norg/bread_experts_group/coder/format/parse/tiff/TIFFByteParser\n*L\n50#1:107,2\n50#1:110\n50#1:112,2\n51#1:114,2\n51#1:117\n51#1:119,2\n50#1:109\n50#1:111\n51#1:116\n51#1:118\n*E\n"})
public final class TIFFByteParser
extends ByteParser<TIFFStructureIdentifier, TIFFStructure, SeekableByteChannel> {
    @NotNull
    private ByteOrder order;
    @NotNull
    private final ArrayDeque<TIFFStructure> structures;
    private final ByteBuffer buffer12;

    public TIFFByteParser() {
        super("Tag Image File Format");
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        Intrinsics.checkNotNullExpressionValue(byteOrder, "BIG_ENDIAN");
        this.order = byteOrder;
        this.structures = new ArrayDeque();
        this.buffer12 = ByteBuffer.allocate(12);
        this.addParser(TIFFStructureIdentifier.EXIF_OFFSET, (arg_0, arg_1, arg_2) -> TIFFByteParser._init_$lambda$1(this, arg_0, arg_1, arg_2));
        this.addPredicateParser(TIFFByteParser::_init_$lambda$2, TIFFByteParser::_init_$lambda$3);
    }

    @Override
    @NotNull
    protected SeekableByteChannel responsibleChannel(@NotNull TIFFStructure of) {
        Intrinsics.checkNotNullParameter(of, "of");
        return new WindowedSeekableByteChannel((SeekableByteChannel)this.getChannel(), 0L, ((SeekableByteChannel)this.getChannel()).size());
    }

    @Override
    @Nullable
    protected TIFFStructure readBase(@NotNull CompoundThrowable<CodingException> compound) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        if (!((Collection)this.structures).isEmpty()) {
            return this.structures.removeFirst();
        }
        this.buffer12.limit(4);
        ((SeekableByteChannel)this.getChannel()).read(this.buffer12);
        this.buffer12.rewind();
        long next = (long)this.buffer12.getInt() & 0xFFFFFFFFL;
        if (next == 0L) {
            return null;
        }
        ((SeekableByteChannel)this.getChannel()).position(next);
        this.buffer12.limit(2);
        this.buffer12.rewind();
        ((SeekableByteChannel)this.getChannel()).read(this.buffer12);
        this.buffer12.rewind();
        int n = this.buffer12.getShort() & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            Object v2;
            TIFFStructureIdentifier tIFFStructureIdentifier;
            Integer n$iv;
            ArrayDeque<TIFFStructure> arrayDeque;
            block6: {
                Object v0;
                boolean bl;
                Enum it$iv;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv$iv;
                EnumEntries<TIFFDataType> $this$id$iv;
                boolean $i$f$id;
                block5: {
                    int it = i;
                    boolean bl2 = false;
                    this.buffer12.clear();
                    ((SeekableByteChannel)this.getChannel()).read(this.buffer12);
                    this.buffer12.flip();
                    Mappable.Companion companion = Mappable.Companion;
                    EnumEntries<TIFFStructureIdentifier> enumEntries = TIFFStructureIdentifier.getEntries();
                    Integer n2 = this.buffer12.getShort() & 0xFFFF;
                    arrayDeque = this.structures;
                    $i$f$id = false;
                    $this$firstOrNull$iv$iv = $this$id$iv;
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                        it$iv = (Enum)element$iv$iv;
                        bl = false;
                        if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                        v0 = element$iv$iv;
                        break block5;
                    }
                    v0 = null;
                }
                void var21_20 = n$iv;
                Enum enum_ = v0;
                Enum enum_2 = new MappedEnumeration<void, Enum>(enum_, var21_20).getEnum();
                Intrinsics.checkNotNull(enum_2);
                Mappable.Companion this_$iv = Mappable.Companion;
                $this$id$iv = TIFFDataType.getEntries();
                n$iv = this.buffer12.getShort() & 0xFFFF;
                tIFFStructureIdentifier = (TIFFStructureIdentifier)enum_2;
                $i$f$id = false;
                $this$firstOrNull$iv$iv = $this$id$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Enum)element$iv$iv;
                    bl = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v2 = element$iv$iv;
                    break block6;
                }
                v2 = null;
            }
            Integer n3 = n$iv;
            Enum enum_ = v2;
            MappedEnumeration<Integer, Enum> mappedEnumeration = new MappedEnumeration<Integer, Enum>(enum_, n3);
            Enum enum_3 = mappedEnumeration.getEnum();
            Intrinsics.checkNotNull(enum_3);
            long l = ((SeekableByteChannel)this.getChannel()).position();
            long l2 = (long)this.buffer12.getInt() & 0xFFFFFFFFL;
            long l3 = (long)this.buffer12.getInt() & 0xFFFFFFFFL;
            TIFFDataType tIFFDataType = (TIFFDataType)enum_3;
            TIFFStructureIdentifier tIFFStructureIdentifier2 = tIFFStructureIdentifier;
            arrayDeque.add(new TIFFStructure(tIFFStructureIdentifier2, tIFFDataType, l3, l2, l));
        }
        this.buffer12.rewind();
        return this.structures.removeFirst();
    }

    private final TIFFByteParser internalInit(SeekableByteChannel from, ByteOrder fromOrder) {
        this.setChannel((ReadableByteChannel)from);
        this.buffer12.order(fromOrder);
        return this;
    }

    @Override
    public void inputInit() {
        ByteBuffer first4 = ByteBuffer.allocate(4);
        ((SeekableByteChannel)this.getChannel()).read(first4);
        first4.rewind();
        int orderSign = first4.getShort() & 0xFFFF;
        ByteOrder byteOrder = switch (orderSign) {
            case 18761 -> ByteOrder.LITTLE_ENDIAN;
            case 19789 -> ByteOrder.BIG_ENDIAN;
            default -> throw new InvalidInputException("Unknown byte-order format [" + FormattingKt.hex-xj2QHRw(UShort.constructor-impl((short)orderSign)) + "]", null, 2, null);
        };
        Intrinsics.checkNotNull(byteOrder);
        this.order = byteOrder;
        first4.order(this.order);
        this.buffer12.order(this.order);
        int magic = first4.getShort() & 0xFFFF;
        if (magic != 42) {
            throw new InvalidInputException("Bad magic number [" + FormattingKt.hex-xj2QHRw(UShort.constructor-impl((short)magic)) + "]", null, 2, null);
        }
    }

    private static final TIFFStructure _init_$lambda$1(TIFFByteParser this$0, SeekableByteChannel window, TIFFStructure structure, CompoundThrowable compound) {
        Intrinsics.checkNotNullParameter(window, "window");
        Intrinsics.checkNotNullParameter(structure, "structure");
        Intrinsics.checkNotNullParameter(compound, "compound");
        if (structure.getItems() > 1L) {
            compound.addThrown((Throwable)new ValidationException("Exif Offset with multiple entries"));
        }
        window.position(structure.getLocation() - (long)4);
        return new TIFFExifOffset(new TIFFByteParser().internalInit(window, this$0.order), structure.getItems(), structure.getOffset(), structure.getLocation());
    }

    private static final boolean _init_$lambda$2(TIFFStructure it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDataType() == TIFFDataType.STRING || it.getTag() == TIFFStructureIdentifier.USER_COMMENT;
    }

    private static final TIFFStructure _init_$lambda$3(SeekableByteChannel window, TIFFStructure structure, CompoundThrowable compoundThrowable) {
        Intrinsics.checkNotNullParameter(window, "window");
        Intrinsics.checkNotNullParameter(structure, "structure");
        Intrinsics.checkNotNullParameter(compoundThrowable, "<unused var>");
        InputStream inputStream = Channels.newInputStream(window);
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        FailQuickInputStream<InputStream> newStream = new FailQuickInputStream<InputStream>(inputStream);
        window.position(structure.getOffset());
        return new TIFFTextStructure(structure.getTag(), structure.getItems(), structure.getOffset(), structure.getLocation(), SocketUtilKt.readString$default(newStream, null, 1, null));
    }
}

