/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.wayland;

import java.lang.foreign.Arena;
import java.lang.foreign.Linker;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"handleArena", "Ljava/lang/foreign/Arena;", "kotlin.jvm.PlatformType", "waylandClientLookup", "Ljava/lang/foreign/SymbolLookup;", "linker", "Ljava/lang/foreign/Linker;", "nativeWLDisplayConnect", "Ljava/lang/invoke/MethodHandle;", "getNativeWLDisplayConnect", "()Ljava/lang/invoke/MethodHandle;", "nativeWLDisplayDisconnect", "getNativeWLDisplayDisconnect", "bread_server_lib"})
public final class WaylandHandlesKt {
    private static final Arena handleArena;
    @NotNull
    private static final SymbolLookup waylandClientLookup;
    @NotNull
    private static final Linker linker;
    @Nullable
    private static final MethodHandle nativeWLDisplayConnect;
    @Nullable
    private static final MethodHandle nativeWLDisplayDisconnect;

    @Nullable
    public static final MethodHandle getNativeWLDisplayConnect() {
        return nativeWLDisplayConnect;
    }

    @Nullable
    public static final MethodHandle getNativeWLDisplayDisconnect() {
        return nativeWLDisplayDisconnect;
    }

    static {
        Arena arena = handleArena = Arena.ofAuto();
        Intrinsics.checkNotNullExpressionValue(arena, "handleArena");
        waylandClientLookup = ForeignFunctionInterfaceKt.getLookup(arena, "libwayland-client.so");
        Linker linker = Linker.nativeLinker();
        Intrinsics.checkNotNullExpressionValue(linker, "nativeLinker(...)");
        WaylandHandlesKt.linker = linker;
        ValueLayout[] valueLayoutArray = new ValueLayout[2];
        Intrinsics.checkNotNullExpressionValue(ValueLayout.ADDRESS, "ADDRESS");
        Intrinsics.checkNotNullExpressionValue(ValueLayout.ADDRESS, "ADDRESS");
        nativeWLDisplayConnect = ForeignFunctionInterfaceKt.getDowncall(waylandClientLookup, WaylandHandlesKt.linker, "wl_display_connect", valueLayoutArray);
        valueLayoutArray = new ValueLayout[1];
        Intrinsics.checkNotNullExpressionValue(ValueLayout.ADDRESS, "ADDRESS");
        nativeWLDisplayDisconnect = ForeignFunctionInterfaceKt.getDowncallVoid(waylandClientLookup, WaylandHandlesKt.linker, "wl_display_disconnect", valueLayoutArray);
    }
}

