/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.Flaggable;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsCreationDisposition;
import org.bread_experts_group.ffi.windows.WindowsFileSharingTypes;
import org.bread_experts_group.ffi.windows.WindowsGenericAccessRights;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a:\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0%2\u0006\u0010)\u001a\u00020*\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012\"\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012\"\u0013\u0010+\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0012\"\u0013\u0010-\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0012\u00a8\u0006/"}, d2={"handleArena", "Ljava/lang/foreign/Arena;", "kotlin.jvm.PlatformType", "kernel32Lookup", "Ljava/lang/foreign/SymbolLookup;", "linker", "Ljava/lang/foreign/Linker;", "gleCapture", "Ljava/lang/foreign/Linker$Option;", "getGleCapture", "()Ljava/lang/foreign/Linker$Option;", "nativeGetLastError", "Ljava/lang/invoke/VarHandle;", "getNativeGetLastError", "()Ljava/lang/invoke/VarHandle;", "nativeFormatMessageW", "Ljava/lang/invoke/MethodHandle;", "getNativeFormatMessageW", "()Ljava/lang/invoke/MethodHandle;", "nativeLocalFree", "getNativeLocalFree", "nativeGetModuleHandleW", "getNativeGetModuleHandleW", "nativeLoadLibraryExW", "getNativeLoadLibraryExW", "nativeGetProcAddress", "getNativeGetProcAddress", "nativeCreateFile3", "getNativeCreateFile3", "nativeReadFile", "getNativeReadFile", "createFile3", "Ljava/lang/foreign/MemorySegment;", "arena", "lpFileName", "", "dwDesiredAccess", "Ljava/util/EnumSet;", "Lorg/bread_experts_group/ffi/windows/WindowsGenericAccessRights;", "dwShareMode", "Lorg/bread_experts_group/ffi/windows/WindowsFileSharingTypes;", "dwCreationDisposition", "Lorg/bread_experts_group/ffi/windows/WindowsCreationDisposition;", "nativeGetCommState", "getNativeGetCommState", "nativeSetCommState", "getNativeSetCommState", "bread_server_lib"})
public final class WindowsKernelHandlesKt {
    private static final Arena handleArena;
    @NotNull
    private static final SymbolLookup kernel32Lookup;
    @NotNull
    private static final Linker linker;
    @NotNull
    private static final Linker.Option gleCapture;
    @NotNull
    private static final VarHandle nativeGetLastError;
    @Nullable
    private static final MethodHandle nativeFormatMessageW;
    @Nullable
    private static final MethodHandle nativeLocalFree;
    @Nullable
    private static final MethodHandle nativeGetModuleHandleW;
    @Nullable
    private static final MethodHandle nativeLoadLibraryExW;
    @Nullable
    private static final MethodHandle nativeGetProcAddress;
    @Nullable
    private static final MethodHandle nativeCreateFile3;
    @Nullable
    private static final MethodHandle nativeReadFile;
    @Nullable
    private static final MethodHandle nativeGetCommState;
    @Nullable
    private static final MethodHandle nativeSetCommState;

    @NotNull
    public static final Linker.Option getGleCapture() {
        return gleCapture;
    }

    @NotNull
    public static final VarHandle getNativeGetLastError() {
        return nativeGetLastError;
    }

    @Nullable
    public static final MethodHandle getNativeFormatMessageW() {
        return nativeFormatMessageW;
    }

    @Nullable
    public static final MethodHandle getNativeLocalFree() {
        return nativeLocalFree;
    }

    @Nullable
    public static final MethodHandle getNativeGetModuleHandleW() {
        return nativeGetModuleHandleW;
    }

    @Nullable
    public static final MethodHandle getNativeLoadLibraryExW() {
        return nativeLoadLibraryExW;
    }

    @Nullable
    public static final MethodHandle getNativeGetProcAddress() {
        return nativeGetProcAddress;
    }

    @Nullable
    public static final MethodHandle getNativeCreateFile3() {
        return nativeCreateFile3;
    }

    @Nullable
    public static final MethodHandle getNativeReadFile() {
        return nativeReadFile;
    }

    @NotNull
    public static final MemorySegment createFile3(@NotNull Arena arena, @NotNull String lpFileName, @NotNull EnumSet<WindowsGenericAccessRights> dwDesiredAccess, @NotNull EnumSet<WindowsFileSharingTypes> dwShareMode, @NotNull WindowsCreationDisposition dwCreationDisposition) {
        Intrinsics.checkNotNullParameter(arena, "arena");
        Intrinsics.checkNotNullParameter(lpFileName, "lpFileName");
        Intrinsics.checkNotNullParameter(dwDesiredAccess, "dwDesiredAccess");
        Intrinsics.checkNotNullParameter(dwShareMode, "dwShareMode");
        Intrinsics.checkNotNullParameter(dwCreationDisposition, "dwCreationDisposition");
        MethodHandle methodHandle = nativeCreateFile3;
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment serialFile = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), arena.allocateFrom(lpFileName, Charsets.UTF_16LE), (int)Flaggable.Companion.raw((Collection<? extends Flaggable>)dwDesiredAccess), (int)Flaggable.Companion.raw((Collection<? extends Flaggable>)dwShareMode), dwCreationDisposition.getId-pVg5ArA(), MemorySegment.NULL);
        if (Intrinsics.areEqual(serialFile, WindowsUtilitiesKt.getINVALID_HANDLE_VALUE())) {
            WindowsUtilitiesKt.decodeLastError(arena);
        }
        return serialFile;
    }

    @Nullable
    public static final MethodHandle getNativeGetCommState() {
        return nativeGetCommState;
    }

    @Nullable
    public static final MethodHandle getNativeSetCommState() {
        return nativeSetCommState;
    }

    static {
        Arena arena = handleArena = Arena.ofAuto();
        Intrinsics.checkNotNullExpressionValue(arena, "handleArena");
        kernel32Lookup = ForeignFunctionInterfaceKt.getLookup(arena, "Kernel32.dll");
        Linker linker = Linker.nativeLinker();
        Intrinsics.checkNotNullExpressionValue(linker, "nativeLinker(...)");
        WindowsKernelHandlesKt.linker = linker;
        Object[] objectArray = new String[]{"GetLastError"};
        Linker.Option option = Linker.Option.captureCallState((String[])objectArray);
        Intrinsics.checkNotNullExpressionValue(option, "captureCallState(...)");
        gleCapture = option;
        objectArray = new MemoryLayout.PathElement[]{MemoryLayout.PathElement.groupElement("GetLastError")};
        VarHandle varHandle = ForeignFunctionInterfaceKt.getCapturedStateLayout().varHandle((MemoryLayout.PathElement[])objectArray);
        Intrinsics.checkNotNullExpressionValue(varHandle, "varHandle(...)");
        nativeGetLastError = varHandle;
        ValueLayout[] valueLayoutArray = new ValueLayout[8];
        valueLayoutArray[0] = WindowsUtilitiesKt.getDWORD();
        valueLayoutArray[1] = WindowsUtilitiesKt.getDWORD();
        valueLayoutArray[2] = WindowsUtilitiesKt.getLPCVOID();
        valueLayoutArray[3] = WindowsUtilitiesKt.getDWORD();
        valueLayoutArray[4] = WindowsUtilitiesKt.getDWORD();
        valueLayoutArray[5] = WindowsUtilitiesKt.getLPWSTR();
        valueLayoutArray[6] = WindowsUtilitiesKt.getDWORD();
        Intrinsics.checkNotNullExpressionValue(ValueLayout.ADDRESS, "ADDRESS");
        nativeFormatMessageW = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "FormatMessageW", valueLayoutArray);
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getHLOCAL(), WindowsUtilitiesKt.getHLOCAL()};
        nativeLocalFree = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "LocalFree", valueLayoutArray);
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getHMODULE(), WindowsUtilitiesKt.getLPCWSTR()};
        nativeGetModuleHandleW = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "GetModuleHandleW", valueLayoutArray);
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getHMODULE(), WindowsUtilitiesKt.getLPCWSTR(), WindowsUtilitiesKt.getHANDLE(), WindowsUtilitiesKt.getDWORD()};
        nativeLoadLibraryExW = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "LoadLibraryExW", valueLayoutArray, CollectionsKt.listOf(gleCapture));
        valueLayoutArray = new AddressLayout[]{WindowsUtilitiesKt.getFARPROC(), WindowsUtilitiesKt.getHMODULE(), WindowsUtilitiesKt.getLPCSTR()};
        nativeGetProcAddress = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "GetProcAddress", valueLayoutArray, CollectionsKt.listOf(gleCapture));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getHANDLE(), WindowsUtilitiesKt.getLPCWSTR(), WindowsUtilitiesKt.getDWORD(), WindowsUtilitiesKt.getDWORD(), WindowsUtilitiesKt.getDWORD(), ValueLayout.ADDRESS};
        nativeCreateFile3 = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "CreateFile3", valueLayoutArray, CollectionsKt.listOf(gleCapture));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getHANDLE(), WindowsUtilitiesKt.getLPVOID(), WindowsUtilitiesKt.getDWORD(), WindowsUtilitiesKt.getLPDWORD(), ValueLayout.ADDRESS};
        nativeReadFile = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "ReadFile", valueLayoutArray, CollectionsKt.listOf(gleCapture));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getHANDLE(), WindowsLayoutsKt.getLPDCB()};
        nativeGetCommState = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "GetCommState", valueLayoutArray, CollectionsKt.listOf(gleCapture));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getHANDLE(), WindowsLayoutsKt.getLPDCB()};
        nativeSetCommState = ForeignFunctionInterfaceKt.getDowncall(kernel32Lookup, WindowsKernelHandlesKt.linker, "SetCommState", valueLayoutArray, CollectionsKt.listOf(gleCapture));
    }
}

