/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.Linker;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"IID", "Ljava/lang/foreign/StructLayout;", "getIID", "()Ljava/lang/foreign/StructLayout;", "REFIID", "Ljava/lang/foreign/AddressLayout;", "getREFIID", "()Ljava/lang/foreign/AddressLayout;", "REFCLSID", "getREFCLSID", "handleArena", "Ljava/lang/foreign/Arena;", "kotlin.jvm.PlatformType", "ole32Lookup", "Ljava/lang/foreign/SymbolLookup;", "linker", "Ljava/lang/foreign/Linker;", "nativeCoCreateGuid", "Ljava/lang/invoke/MethodHandle;", "getNativeCoCreateGuid", "()Ljava/lang/invoke/MethodHandle;", "bread_server_lib"})
public final class WindowsOLEHandlesKt {
    @NotNull
    private static final StructLayout IID = WindowsLayoutsKt.getGUID();
    @NotNull
    private static final AddressLayout REFIID;
    @NotNull
    private static final AddressLayout REFCLSID;
    private static final Arena handleArena;
    @NotNull
    private static final SymbolLookup ole32Lookup;
    @NotNull
    private static final Linker linker;
    @Nullable
    private static final MethodHandle nativeCoCreateGuid;

    @NotNull
    public static final StructLayout getIID() {
        return IID;
    }

    @NotNull
    public static final AddressLayout getREFIID() {
        return REFIID;
    }

    @NotNull
    public static final AddressLayout getREFCLSID() {
        return REFCLSID;
    }

    @Nullable
    public static final MethodHandle getNativeCoCreateGuid() {
        return nativeCoCreateGuid;
    }

    static {
        AddressLayout addressLayout = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout, "ADDRESS");
        REFCLSID = REFIID = addressLayout;
        Arena arena = handleArena = Arena.ofAuto();
        Intrinsics.checkNotNullExpressionValue(arena, "handleArena");
        ole32Lookup = ForeignFunctionInterfaceKt.getLookup(arena, "Ole32.dll");
        Linker linker = Linker.nativeLinker();
        Intrinsics.checkNotNullExpressionValue(linker, "nativeLinker(...)");
        WindowsOLEHandlesKt.linker = linker;
        ValueLayout[] valueLayoutArray = new ValueLayout[2];
        valueLayoutArray[0] = WindowsUtilitiesKt.getHRESULT();
        Intrinsics.checkNotNullExpressionValue(ValueLayout.ADDRESS, "ADDRESS");
        nativeCoCreateGuid = ForeignFunctionInterfaceKt.getDowncall(ole32Lookup, WindowsOLEHandlesKt.linker, "CoCreateGuid", valueLayoutArray);
    }
}

