/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.Linker;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsGDIHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0013\u0010\u000f\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0013\u0010\u0011\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0013\u0010\u0013\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0015"}, d2={"HGLRC", "Ljava/lang/foreign/AddressLayout;", "getHGLRC", "()Ljava/lang/foreign/AddressLayout;", "handleArena", "Ljava/lang/foreign/Arena;", "kotlin.jvm.PlatformType", "opengl32Lookup", "Ljava/lang/foreign/SymbolLookup;", "linker", "Ljava/lang/foreign/Linker;", "nativeWGLCreateContext", "Ljava/lang/invoke/MethodHandle;", "getNativeWGLCreateContext", "()Ljava/lang/invoke/MethodHandle;", "nativeWGLDeleteContext", "getNativeWGLDeleteContext", "nativeWGLMakeCurrent", "getNativeWGLMakeCurrent", "nativeWGLGetProcAddress", "getNativeWGLGetProcAddress", "bread_server_lib"})
public final class WindowsOpenGLHandlesKt {
    @NotNull
    private static final AddressLayout HGLRC;
    private static final Arena handleArena;
    @NotNull
    private static final SymbolLookup opengl32Lookup;
    @NotNull
    private static final Linker linker;
    @Nullable
    private static final MethodHandle nativeWGLCreateContext;
    @Nullable
    private static final MethodHandle nativeWGLDeleteContext;
    @Nullable
    private static final MethodHandle nativeWGLMakeCurrent;
    @Nullable
    private static final MethodHandle nativeWGLGetProcAddress;

    @NotNull
    public static final AddressLayout getHGLRC() {
        return HGLRC;
    }

    @Nullable
    public static final MethodHandle getNativeWGLCreateContext() {
        return nativeWGLCreateContext;
    }

    @Nullable
    public static final MethodHandle getNativeWGLDeleteContext() {
        return nativeWGLDeleteContext;
    }

    @Nullable
    public static final MethodHandle getNativeWGLMakeCurrent() {
        return nativeWGLMakeCurrent;
    }

    @Nullable
    public static final MethodHandle getNativeWGLGetProcAddress() {
        return nativeWGLGetProcAddress;
    }

    static {
        AddressLayout addressLayout = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout, "ADDRESS");
        HGLRC = addressLayout;
        Arena arena = handleArena = Arena.ofAuto();
        Intrinsics.checkNotNullExpressionValue(arena, "handleArena");
        opengl32Lookup = ForeignFunctionInterfaceKt.getLookup(arena, "OpenGL32.dll");
        Linker linker = Linker.nativeLinker();
        Intrinsics.checkNotNullExpressionValue(linker, "nativeLinker(...)");
        WindowsOpenGLHandlesKt.linker = linker;
        ValueLayout[] valueLayoutArray = new AddressLayout[]{HGLRC, WindowsGDIHandlesKt.getHDC()};
        nativeWGLCreateContext = ForeignFunctionInterfaceKt.getDowncall(opengl32Lookup, WindowsOpenGLHandlesKt.linker, "wglCreateContext", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), HGLRC};
        nativeWGLDeleteContext = ForeignFunctionInterfaceKt.getDowncall(opengl32Lookup, WindowsOpenGLHandlesKt.linker, "wglDeleteContext", valueLayoutArray);
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsGDIHandlesKt.getHDC(), HGLRC};
        nativeWGLMakeCurrent = ForeignFunctionInterfaceKt.getDowncall(opengl32Lookup, WindowsOpenGLHandlesKt.linker, "wglMakeCurrent", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new AddressLayout[]{WindowsUtilitiesKt.getPROC(), WindowsUtilitiesKt.getLPCSTR()};
        nativeWGLGetProcAddress = ForeignFunctionInterfaceKt.getDowncall(opengl32Lookup, WindowsOpenGLHandlesKt.linker, "wglGetProcAddress", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
    }
}

