/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows.bcrypt;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptLayoutsKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderInterfaceDescription;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/bread_experts_group/ffi/windows/bcrypt/WindowsBCryptProviderImageDescription;", "", "ptr", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "moduleFile", "", "getModuleFile", "()Ljava/lang/String;", "interfaces", "", "Lorg/bread_experts_group/ffi/windows/bcrypt/WindowsBCryptProviderInterfaceDescription;", "getInterfaces", "()Ljava/util/List;", "toString", "bread_server_lib"})
public final class WindowsBCryptProviderImageDescription {
    @NotNull
    private final String moduleFile;
    @NotNull
    private final List<WindowsBCryptProviderInterfaceDescription> interfaces;

    public WindowsBCryptProviderImageDescription(@NotNull MemorySegment ptr) {
        Intrinsics.checkNotNullParameter(ptr, "ptr");
        String string = WindowsBCryptLayoutsKt.getCRYPT_IMAGE_REG_pszImage().get(ptr, 0).reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_16LE);
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        this.moduleFile = string;
        WindowsBCryptProviderImageDescription windowsBCryptProviderImageDescription = this;
        WindowsBCryptProviderImageDescription windowsBCryptProviderImageDescription2 = this;
        boolean bl = false;
        MemorySegment ptr2 = ptr.reinterpret(WindowsBCryptLayoutsKt.getCRYPT_IMAGE_REG().byteSize());
        int count = WindowsBCryptLayoutsKt.getCRYPT_IMAGE_REG_cInterfaces().get(ptr2, 0);
        MemorySegment interfaceArray = WindowsBCryptLayoutsKt.getCRYPT_IMAGE_REG_rgpInterfaces().get(ptr2, 0).reinterpret(ValueLayout.ADDRESS.byteSize() * (long)count);
        long offset = 0L;
        ArrayList<WindowsBCryptProviderInterfaceDescription> arrayList = new ArrayList<WindowsBCryptProviderInterfaceDescription>(count);
        int n = 0;
        while (n < count) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<WindowsBCryptProviderInterfaceDescription> arrayList2 = arrayList;
            boolean bl2 = false;
            MemorySegment interfacePtr = interfaceArray.get(ValueLayout.ADDRESS, offset).reinterpret(WindowsBCryptLayoutsKt.getCRYPT_INTERFACE_REG().byteSize());
            offset += ValueLayout.ADDRESS.byteSize();
            Intrinsics.checkNotNull(interfacePtr);
            arrayList2.add(new WindowsBCryptProviderInterfaceDescription(interfacePtr));
        }
        windowsBCryptProviderImageDescription2.interfaces = arrayList;
    }

    @NotNull
    public final String getModuleFile() {
        return this.moduleFile;
    }

    @NotNull
    public final List<WindowsBCryptProviderInterfaceDescription> getInterfaces() {
        return this.interfaces;
    }

    @NotNull
    public String toString() {
        return "Provider Image Description\n\tModule File: " + this.moduleFile + "\n\tInterfaces: " + StringsKt.replace$default(this.interfaces.toString(), "\n", "\n\t", false, 4, null);
    }
}

