/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.image.gif;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.coder.format.parse.InvalidInputException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/bread_experts_group/image/gif/GIFLZWDecoder;", "", "input", "Ljava/io/InputStream;", "minimumLZW", "", "<init>", "(Ljava/io/InputStream;I)V", "clearCode", "endCode", "decompress", "", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nGIFLZWDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GIFLZWDecoder.kt\norg/bread_experts_group/image/gif/GIFLZWDecoder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,82:1\n11238#2:83\n11573#2,3:84\n*S KotlinDebug\n*F\n+ 1 GIFLZWDecoder.kt\norg/bread_experts_group/image/gif/GIFLZWDecoder\n*L\n80#1:83\n80#1:84,3\n*E\n"})
public final class GIFLZWDecoder {
    @NotNull
    private final InputStream input;
    private final int minimumLZW;
    private final int clearCode;
    private final int endCode;

    public GIFLZWDecoder(@NotNull InputStream input, int minimumLZW) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.input = input;
        this.minimumLZW = minimumLZW;
        this.clearCode = 1 << this.minimumLZW;
        this.endCode = this.clearCode + 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] decompress() {
        void $this$mapTo$iv$iv;
        Ref.IntRef codeSize = new Ref.IntRef();
        codeSize.element = this.minimumLZW + 1;
        Ref.IntRef dictSize = new Ref.IntRef();
        dictSize.element = this.endCode + 1;
        byte[][] dictionary = new byte[8192][];
        Ref.ObjectRef<Integer> prevCode = new Ref.ObjectRef<Integer>();
        GIFLZWDecoder.decompress$resetDictionary(codeSize, this, dictSize, dictionary, prevCode);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(this.input.available());
        Ref.IntRef buffer = new Ref.IntRef();
        Ref.IntRef bitsInBuf = new Ref.IntRef();
        while (true) {
            byte[] prevEntry;
            byte[] byArray;
            int code;
            Integer n = GIFLZWDecoder.decompress$nextCode(bitsInBuf, codeSize, this, buffer);
            if (n == null) {
                break;
            }
            int n2 = code = n.intValue();
            if (n2 == this.endCode) break;
            if (n2 == this.clearCode) {
                GIFLZWDecoder.decompress$resetDictionary(codeSize, this, dictSize, dictionary, prevCode);
                continue;
            }
            if (code < dictSize.element) {
                byte[] byArray2 = dictionary[code];
                byArray = byArray2;
                Intrinsics.checkNotNull(byArray2);
            } else if (prevCode.element != null) {
                Object t = prevCode.element;
                Intrinsics.checkNotNull(t);
                Intrinsics.checkNotNull(dictionary[((Number)t).intValue()]);
                byArray = ArraysKt.plus(prevEntry, ArraysKt.first(prevEntry));
            } else {
                throw new InvalidInputException("unknown code " + code, null, 2, null);
            }
            byte[] entry = byArray;
            outputStream.write(entry);
            if (prevCode.element != null) {
                Object t = prevCode.element;
                Intrinsics.checkNotNull(t);
                Intrinsics.checkNotNull(dictionary[((Number)t).intValue()]);
                byte[] newEntry = ArraysKt.plus(prevEntry, ArraysKt.first(entry));
                int n3 = dictSize.element;
                dictSize.element = n3 + 1;
                dictionary[n3] = newEntry;
            }
            prevCode.element = code;
            if (dictSize.element != 1 << codeSize.element || codeSize.element >= 12) continue;
            int prevEntry2 = codeSize.element;
            codeSize.element = prevEntry2 + 1;
        }
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        byte[] $this$map$iv = byArray;
        boolean $i$f$map = false;
        byte[] prevEntry2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var16_20 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it & 0xFF);
        }
        return CollectionsKt.toIntArray((List)destination$iv$iv);
    }

    private static final void decompress$resetDictionary(Ref.IntRef codeSize, GIFLZWDecoder this$0, Ref.IntRef dictSize, byte[][] dictionary, Ref.ObjectRef<Integer> prevCode) {
        codeSize.element = this$0.minimumLZW + 1;
        dictSize.element = this$0.endCode + 1;
        int n = this$0.clearCode;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = new byte[]{(byte)i};
            dictionary[i] = byArray;
        }
        prevCode.element = null;
    }

    private static final Integer decompress$nextCode(Ref.IntRef bitsInBuf, Ref.IntRef codeSize, GIFLZWDecoder this$0, Ref.IntRef buffer) {
        Integer n;
        int next;
        while (bitsInBuf.element < codeSize.element && (next = this$0.input.read()) != -1) {
            buffer.element |= next << bitsInBuf.element;
            bitsInBuf.element += 8;
        }
        if (bitsInBuf.element >= codeSize.element) {
            int mask = (1 << codeSize.element) - 1;
            int code = buffer.element & mask;
            buffer.element >>>= codeSize.element;
            bitsInBuf.element -= codeSize.element;
            n = code;
        } else {
            n = null;
        }
        return n;
    }
}

