/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.io.reader;

import java.io.InputStream;
import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.KClassesJvm;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.fixed.json.JSONArray;
import org.bread_experts_group.coder.fixed.json.JSONElement;
import org.bread_experts_group.coder.fixed.json.JSONNumber;
import org.bread_experts_group.coder.fixed.json.JSONObject;
import org.bread_experts_group.coder.fixed.json.JSONString;
import org.bread_experts_group.io.BaseReadingIO;
import org.bread_experts_group.io.IOEndian;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020!H\u0016J\u000f\u0010'\u001a\u00020(H\u0016\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0004\b1\u00102J\b\u00103\u001a\u00020\u001bH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/bread_experts_group/io/reader/JSONReader;", "Lorg/bread_experts_group/io/BaseReadingIO;", "input", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "order", "Lorg/bread_experts_group/io/IOEndian;", "getOrder", "()Lorg/bread_experts_group/io/IOEndian;", "setOrder", "(Lorg/bread_experts_group/io/IOEndian;)V", "pass", "", "", "getPass", "()[Ljava/lang/Object;", "setPass", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "raw", "Lorg/bread_experts_group/coder/fixed/json/JSONElement;", "getRaw", "()Lorg/bread_experts_group/coder/fixed/json/JSONElement;", "position", "Ljava/util/ArrayDeque;", "enter", "", "name", "exit", "get", "", "n", "", "i8", "", "i16", "", "i32", "u8", "Lkotlin/UByte;", "u8-w2LRezQ", "()B", "u16", "Lkotlin/UShort;", "u16-Mh2AYeg", "()S", "u32", "Lkotlin/UInt;", "u32-pVg5ArA", "()I", "invalidateData", "bread_server_lib"})
public final class JSONReader
implements BaseReadingIO {
    @NotNull
    private IOEndian order;
    @Nullable
    private Object[] pass;
    @NotNull
    private final JSONElement raw;
    @NotNull
    private final ArrayDeque<JSONElement> position;

    public JSONReader(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.order = IOEndian.Companion.getBOTH_LE_BE();
        this.raw = JSONElement.Companion.json(input);
        this.position = new ArrayDeque();
    }

    @Override
    @NotNull
    public IOEndian getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(@NotNull IOEndian iOEndian) {
        Intrinsics.checkNotNullParameter(iOEndian, "<set-?>");
        this.order = iOEndian;
    }

    @Override
    @Nullable
    public Object[] getPass() {
        return this.pass;
    }

    @Override
    public void setPass(@Nullable Object[] objectArray) {
        this.pass = objectArray;
    }

    @NotNull
    public final JSONElement getRaw() {
        return this.raw;
    }

    @Override
    public void enter(@NotNull Object name) {
        JSONElement jSONElement;
        Intrinsics.checkNotNullParameter(name, "name");
        Object object = name;
        if (object instanceof String) {
            JSONElement jSONElement2 = (JSONElement)CollectionsKt.lastOrNull((Iterable)this.position);
            if (jSONElement2 == null) {
                jSONElement2 = this.raw;
            }
            jSONElement = jSONElement2.asObject(arg_0 -> JSONReader.enter$lambda$0(name, arg_0));
        } else if (object instanceof Integer) {
            JSONElement jSONElement3 = (JSONElement)CollectionsKt.lastOrNull((Iterable)this.position);
            if (jSONElement3 == null) {
                jSONElement3 = this.raw;
            }
            jSONElement = jSONElement3.asArray(arg_0 -> JSONReader.enter$lambda$1(name, arg_0));
        } else {
            throw new UnsupportedOperationException(KClassesJvm.getJvmName(Reflection.getOrCreateKotlinClass(name.getClass())));
        }
        JSONElement enter = jSONElement;
        this.position.addLast(enter);
    }

    @Override
    public void exit() {
        this.position.removeLast();
    }

    @Override
    @NotNull
    public byte[] get(int n) {
        JSONElement at = (JSONElement)CollectionsKt.last((Iterable)this.position);
        if (!(at instanceof JSONString)) {
            JSONElement jSONElement = at;
            Intrinsics.checkNotNull(jSONElement);
            String string = KClassesJvm.getJvmName(Reflection.getOrCreateKotlinClass(jSONElement.getClass()));
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        String string = ((JSONString)at).getValue();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return byArray;
    }

    @Override
    public byte i8() {
        JSONElement at;
        JSONElement jSONElement = at = (JSONElement)CollectionsKt.last((Iterable)this.position);
        Intrinsics.checkNotNull(jSONElement);
        String string = KClassesJvm.getJvmName(Reflection.getOrCreateKotlinClass(jSONElement.getClass()));
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public short i16() {
        JSONElement at;
        JSONElement jSONElement = at = (JSONElement)CollectionsKt.last((Iterable)this.position);
        Intrinsics.checkNotNull(jSONElement);
        String string = KClassesJvm.getJvmName(Reflection.getOrCreateKotlinClass(jSONElement.getClass()));
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public int i32() {
        JSONElement at;
        JSONElement jSONElement = at = (JSONElement)CollectionsKt.last((Iterable)this.position);
        Intrinsics.checkNotNull(jSONElement);
        String string = KClassesJvm.getJvmName(Reflection.getOrCreateKotlinClass(jSONElement.getClass()));
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public byte u8-w2LRezQ() {
        JSONElement at;
        JSONElement jSONElement = at = (JSONElement)CollectionsKt.last((Iterable)this.position);
        Intrinsics.checkNotNull(jSONElement);
        String string = KClassesJvm.getJvmName(Reflection.getOrCreateKotlinClass(jSONElement.getClass()));
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public short u16-Mh2AYeg() {
        JSONElement at;
        JSONElement jSONElement = at = (JSONElement)CollectionsKt.last((Iterable)this.position);
        Intrinsics.checkNotNull(jSONElement);
        String string = KClassesJvm.getJvmName(Reflection.getOrCreateKotlinClass(jSONElement.getClass()));
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public int u32-pVg5ArA() {
        JSONElement at = (JSONElement)CollectionsKt.last((Iterable)this.position);
        if (!(at instanceof JSONNumber)) {
            JSONElement jSONElement = at;
            Intrinsics.checkNotNull(jSONElement);
            String string = KClassesJvm.getJvmName(Reflection.getOrCreateKotlinClass(jSONElement.getClass()));
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        return UInt.constructor-impl(((JSONNumber)at).getValue().intValue());
    }

    @Override
    public void invalidateData() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private static final JSONElement enter$lambda$0(Object $name, JSONObject $this$asObject) {
        Intrinsics.checkNotNullParameter($this$asObject, "$this$asObject");
        return MapsKt.getValue($this$asObject.getEntries(), $name);
    }

    private static final JSONElement enter$lambda$1(Object $name, JSONArray $this$asArray) {
        Intrinsics.checkNotNullParameter($this$asArray, "$this$asArray");
        return $this$asArray.getEntries()[((Number)$name).intValue()];
    }
}

