/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.io.reader;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KCallable;
import kotlin.reflect.KMutableProperty;
import kotlin.text.Charsets;
import org.bread_experts_group.channel.ByteArrayChannel;
import org.bread_experts_group.io.BaseReadingIO;
import org.bread_experts_group.io.IOEndian;
import org.bread_experts_group.stream.SocketUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\b\u0016\u0018\u0000 V2\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001VB'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u001cH\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0012H\u0016J\u000e\u0010*\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0012J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020\nJ\b\u00106\u001a\u00020\u0012H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020:H\u0016J\r\u0010;\u001a\u00020<\u00a2\u0006\u0004\b=\u0010>J\u000f\u0010?\u001a\u00020@H\u0016\u00a2\u0006\u0004\bA\u0010\u0014J\u000f\u0010B\u001a\u00020CH\u0016\u00a2\u0006\u0004\bD\u0010EJ\u000f\u0010F\u001a\u00020GH\u0016\u00a2\u0006\u0004\bH\u0010IJ\u0006\u0010J\u001a\u00020\u0012J\u0006\u0010K\u001a\u00020\u0012J\u001a\u0010L\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020O2\b\b\u0002\u0010P\u001a\u00020QJ\u0016\u0010R\u001a\u00020\u00122\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u0012J\b\u0010U\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001bX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010+\u001a\u00020,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006W"}, d2={"Lorg/bread_experts_group/io/reader/ReadingByteBuffer;", "Lorg/bread_experts_group/io/BaseReadingIO;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "from", "Ljava/nio/channels/ReadableByteChannel;", "buffer", "Ljava/nio/ByteBuffer;", "lengthMarker", "Lkotlin/reflect/KMutableProperty;", "", "<init>", "(Ljava/nio/channels/ReadableByteChannel;Ljava/nio/ByteBuffer;Lkotlin/reflect/KMutableProperty;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getLengthMarker", "()Lkotlin/reflect/KMutableProperty;", "present", "", "getPresent", "()I", "setPresent", "(I)V", "refill", "", "amount", "pass", "", "", "getPass", "()[Ljava/lang/Object;", "setPass", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "get", "b", "", "enter", "name", "exit", "invalidateData", "n", "skip", "order", "Lorg/bread_experts_group/io/IOEndian;", "getOrder", "()Lorg/bread_experts_group/io/IOEndian;", "setOrder", "(Lorg/bread_experts_group/io/IOEndian;)V", "f64", "", "f32", "", "i64", "i32", "i16", "", "i8", "", "u64", "Lkotlin/ULong;", "u64-s-VKNKU", "()J", "u32", "Lkotlin/UInt;", "u32-pVg5ArA", "u16", "Lkotlin/UShort;", "u16-Mh2AYeg", "()S", "u8", "Lkotlin/UByte;", "u8-w2LRezQ", "()B", "u16i32", "u8i32", "decodeString", "", "c", "Ljava/nio/charset/Charset;", "pattern", "", "transferTo", "dst", "atMost", "close", "Companion", "bread_server_lib"})
public class ReadingByteBuffer
implements BaseReadingIO,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReadableByteChannel from;
    @NotNull
    private final ByteBuffer buffer;
    @Nullable
    private final KMutableProperty<Long> lengthMarker;
    private int present;
    @Nullable
    private Object[] pass;
    @NotNull
    private IOEndian order;

    public ReadingByteBuffer(@NotNull ReadableByteChannel from, @NotNull ByteBuffer buffer, @Nullable KMutableProperty<Long> lengthMarker) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.from = from;
        this.buffer = buffer;
        this.lengthMarker = lengthMarker;
        this.buffer.order(ByteOrder.nativeOrder());
        this.buffer.flip();
        this.order = IOEndian.Companion.getNATIVE();
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Nullable
    public final KMutableProperty<Long> getLengthMarker() {
        return this.lengthMarker;
    }

    protected final int getPresent() {
        return this.present;
    }

    protected final void setPresent(int n) {
        this.present = n;
    }

    public void refill(int amount) {
        KCallable<Long> kCallable = this.lengthMarker;
        if (kCallable != null && (kCallable = kCallable.getSetter()) != null) {
            Object[] objectArray = new Object[]{((Number)this.lengthMarker.getGetter().call(new Object[0])).longValue() - (long)amount};
            kCallable.call(objectArray);
        }
        int toFill = amount - this.present;
        if (toFill < 1) {
            return;
        }
        this.buffer.compact();
        while (toFill > this.present) {
            int read = this.from.read(this.buffer);
            if (read == -1) {
                throw new EOFException();
            }
            this.present += read;
        }
        this.buffer.flip();
    }

    @Override
    @Nullable
    public Object[] getPass() {
        return this.pass;
    }

    @Override
    public void setPass(@Nullable Object[] objectArray) {
        this.pass = objectArray;
    }

    public final void get(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.refill(b.length);
        this.present -= b.length;
        this.buffer.get(b);
    }

    @Override
    public void enter(@NotNull Object name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void exit() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void invalidateData() {
        this.buffer.clear();
        this.buffer.limit(0);
        this.present = 0;
    }

    @Override
    @NotNull
    public byte[] get(int n) {
        byte[] array = new byte[n];
        this.get(array);
        return array;
    }

    public final void skip(int n) {
        this.refill(n);
        this.present -= n;
        this.buffer.position(this.buffer.position() + n);
    }

    @Override
    @NotNull
    public IOEndian getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(@NotNull IOEndian iOEndian) {
        Intrinsics.checkNotNullParameter(iOEndian, "<set-?>");
        this.order = iOEndian;
    }

    public final double f64() {
        this.refill(8);
        this.present -= 8;
        return this.buffer.getDouble();
    }

    public final float f32() {
        this.refill(4);
        this.present -= 4;
        return this.buffer.getFloat();
    }

    public final long i64() {
        this.refill(8);
        this.present -= 8;
        return this.buffer.getLong();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int i32() {
        int n;
        IOEndian order = this.getOrder();
        if (Intrinsics.areEqual(order, IOEndian.Companion.getBIG()) || Intrinsics.areEqual(order, IOEndian.Companion.getLITTLE())) {
            this.refill(4);
            this.present -= 4;
            n = Intrinsics.areEqual(order, IOEndian.Companion.getNATIVE()) ? this.buffer.getInt() : Integer.reverseBytes(this.buffer.getInt());
            return n;
        } else {
            if (!Intrinsics.areEqual(order, IOEndian.Companion.getBOTH_LE_BE())) throw new UnsupportedOperationException("Order: " + this.getOrder());
            this.refill(8);
            this.present -= 8;
            IOEndian iOEndian = IOEndian.Companion.getNATIVE();
            if (Intrinsics.areEqual(iOEndian, IOEndian.Companion.getLITTLE())) {
                void var3_3;
                int readOff = this.buffer.getInt();
                this.buffer.getInt();
                n = var3_3;
                return n;
            } else {
                if (!Intrinsics.areEqual(iOEndian, IOEndian.Companion.getBIG())) throw new UnsupportedOperationException("CPU with LEBE architecture should not exist");
                this.buffer.getInt();
                n = this.buffer.getInt();
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public short i16() {
        short s;
        IOEndian order = this.getOrder();
        if (Intrinsics.areEqual(order, IOEndian.Companion.getBIG()) || Intrinsics.areEqual(order, IOEndian.Companion.getLITTLE())) {
            this.refill(2);
            this.present -= 2;
            s = Intrinsics.areEqual(order, IOEndian.Companion.getNATIVE()) ? this.buffer.getShort() : Short.reverseBytes(this.buffer.getShort());
            return s;
        } else {
            if (!Intrinsics.areEqual(order, IOEndian.Companion.getBOTH_LE_BE())) throw new UnsupportedOperationException("Order: " + this.getOrder());
            this.refill(4);
            this.present -= 4;
            IOEndian iOEndian = IOEndian.Companion.getNATIVE();
            if (Intrinsics.areEqual(iOEndian, IOEndian.Companion.getLITTLE())) {
                void var3_3;
                short readOff = this.buffer.getShort();
                this.buffer.getShort();
                s = var3_3;
                return s;
            } else {
                if (!Intrinsics.areEqual(iOEndian, IOEndian.Companion.getBIG())) throw new UnsupportedOperationException("CPU with LEBE architecture should not exist");
                this.buffer.getShort();
                s = this.buffer.getShort();
            }
        }
        return s;
    }

    @Override
    public byte i8() {
        this.refill(1);
        --this.present;
        return this.buffer.get();
    }

    public final long u64-s-VKNKU() {
        return ULong.constructor-impl(this.i64());
    }

    @Override
    public int u32-pVg5ArA() {
        return UInt.constructor-impl(this.i32());
    }

    @Override
    public short u16-Mh2AYeg() {
        return UShort.constructor-impl(this.i16());
    }

    @Override
    public byte u8-w2LRezQ() {
        return UByte.constructor-impl(this.i8());
    }

    public final int u16i32() {
        return this.u16-Mh2AYeg() & 0xFFFF;
    }

    public final int u8i32() {
        return this.u8-w2LRezQ() & 0xFF;
    }

    @NotNull
    public final String decodeString(@NotNull Charset c2, @NotNull int[] pattern) {
        ByteArrayOutputStream enc;
        block13: {
            Intrinsics.checkNotNullParameter(c2, "c");
            Intrinsics.checkNotNullParameter(pattern, "pattern");
            enc = new ByteArrayOutputStream();
            int[] bucket = new int[pattern.length];
            Ref.IntRef bucketPosition = new Ref.IntRef();
            Function0<Unit> read = null;
            Function1<Integer, Unit> write = null;
            Charset charset = c2;
            if (Intrinsics.areEqual(charset, Charsets.ISO_8859_1) || Intrinsics.areEqual(charset, Charsets.UTF_8) || Intrinsics.areEqual(charset, Charsets.US_ASCII)) {
                read = () -> ReadingByteBuffer.decodeString$lambda$0(bucket, bucketPosition, this);
                write = arg_0 -> ReadingByteBuffer.decodeString$lambda$1(enc, bucket, arg_0);
            } else if (Intrinsics.areEqual(charset, Charsets.UTF_16)) {
                read = () -> ReadingByteBuffer.decodeString$lambda$2(bucket, bucketPosition, this);
                write = arg_0 -> ReadingByteBuffer.decodeString$lambda$3(enc, bucket, arg_0);
            } else if (Intrinsics.areEqual(charset, Charsets.INSTANCE.UTF32())) {
                read = () -> ReadingByteBuffer.decodeString$lambda$4(bucket, bucketPosition, this);
                write = arg_0 -> ReadingByteBuffer.decodeString$lambda$5(enc, bucket, arg_0);
            } else {
                throw new UnsupportedOperationException(c2.displayName());
            }
            try {
                while (true) {
                    read.invoke();
                    if (bucket[bucketPosition.element] == pattern[bucketPosition.element]) {
                        if (bucketPosition.element != ArraysKt.getLastIndex(pattern)) {
                            int n = bucketPosition.element;
                            bucketPosition.element = n + 1;
                            continue;
                        }
                        break;
                    }
                    int i = 0;
                    int n = bucketPosition.element;
                    if (i <= n) {
                        while (true) {
                            write.invoke(i);
                            if (i == n) break;
                            ++i;
                        }
                    }
                    bucketPosition.element = 0;
                }
            }
            catch (BufferUnderflowException e) {
                if (enc.size() != 0) break block13;
                throw e;
            }
        }
        byte[] byArray = enc.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        byte[] byArray2 = byArray;
        return new String(byArray2, c2);
    }

    public static /* synthetic */ String decodeString$default(ReadingByteBuffer readingByteBuffer, Charset charset, int[] nArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeString");
        }
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 2) != 0) {
            int[] nArray2 = new int[]{0};
            nArray = nArray2;
        }
        return readingByteBuffer.decodeString(charset, nArray);
    }

    public final int transferTo(@NotNull ByteBuffer dst, int atMost) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        int transfer = Math.min(atMost, Math.min(dst.remaining(), this.buffer.capacity()));
        this.refill(transfer);
        int saved = this.buffer.limit();
        this.buffer.limit(transfer);
        dst.put(this.buffer);
        this.buffer.limit(saved);
        this.present -= transfer;
        return transfer;
    }

    @Override
    public void close() {
        this.from.close();
    }

    private static final Unit decodeString$lambda$0(int[] $bucket, Ref.IntRef $bucketPosition, ReadingByteBuffer this$0) {
        $bucket[$bucketPosition.element] = this$0.u8i32();
        return Unit.INSTANCE;
    }

    private static final Unit decodeString$lambda$1(ByteArrayOutputStream $enc, int[] $bucket, int it) {
        $enc.write($bucket[it]);
        return Unit.INSTANCE;
    }

    private static final Unit decodeString$lambda$2(int[] $bucket, Ref.IntRef $bucketPosition, ReadingByteBuffer this$0) {
        $bucket[$bucketPosition.element] = this$0.u16i32();
        return Unit.INSTANCE;
    }

    private static final Unit decodeString$lambda$3(ByteArrayOutputStream $enc, int[] $bucket, int it) {
        SocketUtilKt.write16((OutputStream)$enc, $bucket[it]);
        return Unit.INSTANCE;
    }

    private static final Unit decodeString$lambda$4(int[] $bucket, Ref.IntRef $bucketPosition, ReadingByteBuffer this$0) {
        $bucket[$bucketPosition.element] = this$0.i32();
        return Unit.INSTANCE;
    }

    private static final Unit decodeString$lambda$5(ByteArrayOutputStream $enc, int[] $bucket, int it) {
        SocketUtilKt.write32((OutputStream)$enc, $bucket[it]);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/bread_experts_group/io/reader/ReadingByteBuffer$Companion;", "", "<init>", "()V", "reading", "Lorg/bread_experts_group/io/reader/ReadingByteBuffer;", "", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReadingByteBuffer reading(@NotNull byte[] $this$reading) {
            Intrinsics.checkNotNullParameter($this$reading, "<this>");
            ReadableByteChannel readableByteChannel = new ByteArrayChannel($this$reading);
            ByteBuffer byteBuffer = ByteBuffer.allocate($this$reading.length);
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(...)");
            return new ReadingByteBuffer(readableByteChannel, byteBuffer, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

