/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.BreakIterator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.bread_experts_group.coder.format.parse.BitInputStream;
import org.bread_experts_group.coder.format.parse.BitOutputStream;
import org.bread_experts_group.coder.format.parse.huffman.HuffmanBranch;
import org.bread_experts_group.stream.ExtensibleLongsV1Kt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u00012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u0012\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020-H\u0016J\b\u00101\u001a\u00020-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0010\u0010 \u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/bread_experts_group/logging/BankedFileHandler;", "Ljava/util/logging/Handler;", "bankPath", "Ljava/nio/file/Path;", "contentPath", "timestampPath", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getBankPath", "()Ljava/nio/file/Path;", "getContentPath", "getTimestampPath", "bank", "Ljava/nio/channels/FileChannel;", "getBank", "()Ljava/nio/channels/FileChannel;", "content", "getContent", "timestamp", "getTimestamp", "memoryBank", "", "", "closed", "", "timeIndex", "Lkotlin/ULong;", "J", "bankedWord", "string", "bankedWord-I7RO_PI", "(Ljava/lang/String;)J", "recentSeconds", "seconds", "timestamp-PUiSbYQ", "(J)J", "recentNanos", "", "breaker", "Ljava/text/BreakIterator;", "kotlin.jvm.PlatformType", "specifiedLevelDetails", "", "writtenMessages", "publish", "", "record", "Ljava/util/logging/LogRecord;", "flush", "close", "Companion", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nBankedFileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BankedFileHandler.kt\norg/bread_experts_group/logging/BankedFileHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n1069#2,2:205\n1869#3,2:207\n*S KotlinDebug\n*F\n+ 1 BankedFileHandler.kt\norg/bread_experts_group/logging/BankedFileHandler\n*L\n103#1:205,2\n185#1:207,2\n*E\n"})
public final class BankedFileHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path bankPath;
    @NotNull
    private final Path contentPath;
    @NotNull
    private final Path timestampPath;
    @NotNull
    private final FileChannel bank;
    @NotNull
    private final FileChannel content;
    @NotNull
    private final FileChannel timestamp;
    @NotNull
    private final List<String> memoryBank;
    private boolean closed;
    private long timeIndex;
    private long recentSeconds;
    private int recentNanos;
    private final BreakIterator breaker;
    @NotNull
    private final Set<ULong> specifiedLevelDetails;
    @NotNull
    private final List<String> writtenMessages;
    @NotNull
    private static final Pair<HuffmanBranch<Character>, Integer> englishHuffman = TuplesKt.to(HuffmanBranch.Companion.import(new ByteArrayInputStream(HexExtensionsKt.hexToByteArray$default("6f1073116e12691374146115200b894080069c048106d2028206ff0283068a058406d1048506d40486068c058706e106880685448906b3048a06e2018b06ee018c06f1018d068d058e06ca028f06fc019006bc059106a7019206cd029306de019406f7039506cb029606ab029706eb029806f4019906ef019a06eb019b06bf039c06d0019d069d049e06c6019f06ca40a006b807a106f601a206fe01a3068b40a406d904a506e104a6068102a706e801a806e701a90621aa062bab06e901ac06d302ad063dae063eaf069205b0068a40b1065fb206e601b3068305b406f001b5069302b60640b706ea04b8063fb906e84fba06e94fbb0658bc0651bd0626be069440bf0624c006db04c106c805c20623c3065ac4063bc506d005c60659c70625c8064bc9066aca064acb0656cc0671cd0657ce0655cf062fd0064cd1064fd20652d30647d40644d5064ed60622d70627d80646d9069340da067adb0678dc0645dd0649de0650df0648e00637e10609e20643e3063ae40636e50638e60635e70639e80654e9064dea0642eb066bec0634ed0633ee0641ef062df00653f10628f20629f3065df4065bf50630f60676f70632f80631f9062efa0677fb0679fc062cfd0662fe0666ff060a70707167726d7375746475687663776c3c723d651f", null, 1, null))), 1);
    @NotNull
    private static final Pair<HuffmanBranch<Character>, Integer> japaneseHuffman = TuplesKt.to(HuffmanBranch.Companion.import(new ByteArrayInputStream(HexExtensionsKt.hexToByteArray$default("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", null, 1, null))), 2);
    @NotNull
    private static final List<Pair<HuffmanBranch<Character>, Integer>> huffmen;

    public BankedFileHandler(@NotNull Path bankPath, @NotNull Path contentPath, @NotNull Path timestampPath) {
        Intrinsics.checkNotNullParameter(bankPath, "bankPath");
        Intrinsics.checkNotNullParameter(contentPath, "contentPath");
        Intrinsics.checkNotNullParameter(timestampPath, "timestampPath");
        this.bankPath = bankPath;
        this.contentPath = contentPath;
        this.timestampPath = timestampPath;
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.READ};
        FileChannel fileChannel = FileChannel.open(this.bankPath, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(fileChannel, "open(...)");
        this.bank = fileChannel;
        openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
        FileChannel fileChannel2 = FileChannel.open(this.contentPath, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(fileChannel2, "open(...)");
        this.content = fileChannel2;
        openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE};
        FileChannel fileChannel3 = FileChannel.open(this.timestampPath, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(fileChannel3, "open(...)");
        this.timestamp = fileChannel3;
        this.memoryBank = Companion.readMemoryBank(this.bank);
        ByteBuffer timestampBacked = ByteBuffer.allocate(10);
        byte[] byArray = timestampBacked.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        byte[] byArray2 = byArray;
        ByteArrayInputStream timestampData = new ByteArrayInputStream(byArray2);
        this.timeIndex = ExtensibleLongsV1Kt.readExtensibleULongV1(timestampData);
        this.timestamp.position(10L);
        this.breaker = BreakIterator.getWordInstance();
        this.specifiedLevelDetails = new LinkedHashSet();
        this.writtenMessages = new ArrayList();
    }

    @NotNull
    public final Path getBankPath() {
        return this.bankPath;
    }

    @NotNull
    public final Path getContentPath() {
        return this.contentPath;
    }

    @NotNull
    public final Path getTimestampPath() {
        return this.timestampPath;
    }

    @NotNull
    public final FileChannel getBank() {
        return this.bank;
    }

    @NotNull
    public final FileChannel getContent() {
        return this.content;
    }

    @NotNull
    public final FileChannel getTimestamp() {
        return this.timestamp;
    }

    private final long bankedWord-I7RO_PI(String string) {
        if (!this.memoryBank.contains(string)) {
            Pair pair;
            Pair pair2;
            byte[] plaintext;
            String string2;
            block8: {
                this.memoryBank.add(string);
                string2 = string;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                plaintext = byArray;
                for (Pair pair3 : (Iterable)huffmen) {
                    Pair<byte[], Integer> pair4;
                    boolean bl;
                    int n;
                    int $i$f$all;
                    int type;
                    HuffmanBranch huffman;
                    block7: {
                        boolean bl2 = false;
                        huffman = (HuffmanBranch)pair3.component1();
                        type = ((Number)pair3.component2()).intValue();
                        CharSequence $this$all$iv = string;
                        $i$f$all = 0;
                        for (n = 0; n < $this$all$iv.length(); ++n) {
                            char element$iv;
                            char it = element$iv = $this$all$iv.charAt(n);
                            boolean bl3 = false;
                            if (huffman.getDirectMap().containsKey(Character.valueOf(it))) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                    if (bl) {
                        BitOutputStream<OutputStream> huffmanOutBits = new BitOutputStream<OutputStream>(new ByteArrayOutputStream());
                        n = string.length();
                        for ($i$f$all = 0; $i$f$all < n; ++$i$f$all) {
                            char c2 = string.charAt($i$f$all);
                            huffman.write(Character.valueOf(c2), huffmanOutBits);
                        }
                        int unused = huffmanOutBits.getPosition() % 7;
                        huffmanOutBits.flush();
                        byte[] huffmanOut = ((ByteArrayOutputStream)huffmanOutBits.getTo()).toByteArray();
                        pair4 = huffmanOut.length < plaintext.length ? TuplesKt.to(huffmanOut, type | unused << 5) : null;
                    } else {
                        pair4 = null;
                    }
                    if ((pair3 = pair4) == null) continue;
                    pair2 = pair3;
                    break block8;
                }
                pair2 = pair = null;
            }
            if (pair2 == null) {
                pair = TuplesKt.to(plaintext, 0);
            }
            string2 = pair;
            byte[] array = (byte[])((Pair)((Object)string2)).component1();
            int compression = ((Number)((Pair)((Object)string2)).component2()).intValue();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(output, ULong.constructor-impl(array.length));
            output.write(compression);
            output.write(array);
            this.bank.write(ByteBuffer.wrap(output.toByteArray()));
        }
        return ULong.constructor-impl(this.memoryBank.indexOf(string));
    }

    private final long timestamp-PUiSbYQ(long seconds) {
        if (this.recentSeconds != seconds) {
            this.recentSeconds = seconds;
            this.timestamp.position(0L);
            ByteArrayOutputStream idStream = new ByteArrayOutputStream();
            long l = this.timeIndex;
            this.timeIndex = ULong.constructor-impl(l + 1L);
            ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(idStream, l);
            this.timestamp.write(ByteBuffer.wrap(idStream.toByteArray()));
            this.timestamp.position(RangesKt.coerceAtLeast(this.timestamp.size(), 10L));
            ByteArrayOutputStream timeData = new ByteArrayOutputStream();
            ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(timeData, seconds);
            this.timestamp.write(ByteBuffer.wrap(timeData.toByteArray()));
        }
        return ULong.constructor-impl(this.timeIndex - ULong.constructor-impl(1L & 0xFFFFFFFFL));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void publish(@NotNull LogRecord record) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter(record, "record");
                if (this.closed) {
                    throw new IllegalStateException("BankedFileHandler closed");
                }
                output = new ByteArrayOutputStream();
                timeIndex = this.timestamp-PUiSbYQ(ULong.constructor-impl(record.getInstant().getEpochSecond()));
                ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(output, timeIndex);
                nanos = record.getInstant().getNano();
                ExtensibleLongsV1Kt.writeExtensibleLongV1(output, nanos - this.recentNanos);
                this.recentNanos = nanos;
                v0 = record.getLevel().getName();
                Intrinsics.checkNotNullExpressionValue(v0, "getName(...)");
                bankedLevelName = this.bankedWord-I7RO_PI(v0);
                if (!this.specifiedLevelDetails.contains(ULong.box-impl(bankedLevelName))) break block10;
                ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(output, ULong.constructor-impl(bankedLevelName << 1));
                break block11;
            }
            if (record.getLevel().getResourceBundleName() == null) ** GOTO lbl-1000
            try {
                var8_6 = ResourceBundle.getBundle(record.getLevel().getResourceBundleName()).containsKey(record.getLevel().getName());
            }
            catch (MissingResourceException <unused var>) {
                var8_6 = false;
            }
            if (var8_6) {
                v1 = output;
                v2 = record.getLevel().getResourceBundleName();
                Intrinsics.checkNotNullExpressionValue(v2, "getResourceBundleName(...)");
                var8_7 = this.bankedWord-I7RO_PI(v2);
                var10_11 = 1;
                var8_7 = ULong.constructor-impl(var8_7 << var10_11);
                var10_12 = 1L;
                ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(v1, ULong.constructor-impl(var8_7 | var10_12));
                ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(output, bankedLevelName);
            } else lbl-1000:
            // 2 sources

            {
                ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(output, ULong.constructor-impl(bankedLevelName << 1));
            }
            ExtensibleLongsV1Kt.writeExtensibleLongV1(output, record.getLevel().intValue());
            this.specifiedLevelDetails.add(ULong.box-impl(bankedLevelName));
        }
        v3 = output;
        v4 = record.getLoggerName();
        Intrinsics.checkNotNullExpressionValue(v4, "getLoggerName(...)");
        ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(v3, this.bankedWord-I7RO_PI(v4));
        ExtensibleLongsV1Kt.writeExtensibleLongV1(output, record.getLongThreadID());
        recordIndex = this.writtenMessages.indexOf(record.getMessage());
        if (recordIndex == -1) {
            $this$publish_u24lambda_u242 = var10_13 = CollectionsKt.createListBuilder();
            $i$a$-buildList-BankedFileHandler$publish$broken$1 = false;
            alpha = Normalizer.normalize(record.getMessage(), Normalizer.Form.NFC);
            this.breaker.setText(alpha);
            from = this.breaker.first();
            while ((next = this.breaker.next()) != -1) {
                Intrinsics.checkNotNull(alpha);
                word = StringsKt.substring(alpha, new IntRange(from, next - 1));
                if (StringsKt.isBlank(word) == false) {
                    $this$publish_u24lambda_u242.add(word);
                }
                from = next;
            }
            broken = CollectionsKt.build(var10_13);
            ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(output, ULong.constructor-impl(ULong.constructor-impl(broken.size()) << 1));
            $this$forEach$iv = broken;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                $i$a$-forEach-BankedFileHandler$publish$2 = false;
                ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(output, this.bankedWord-I7RO_PI(it));
            }
            v5 = record.getMessage();
            Intrinsics.checkNotNullExpressionValue(v5, "getMessage(...)");
            this.writtenMessages.add(v5);
        } else {
            ExtensibleLongsV1Kt.writeExtensibleULongV1-2TYgG_w(output, ULong.constructor-impl(ULong.constructor-impl(ULong.constructor-impl(recordIndex) << 1) | 1L));
        }
        this.content.write(ByteBuffer.wrap(output.toByteArray()));
    }

    @Override
    public void flush() {
        this.bank.force(false);
        this.content.force(false);
        this.timestamp.force(false);
    }

    @Override
    public void close() {
        this.flush();
        this.bank.close();
        this.content.close();
        this.timestamp.close();
        this.closed = true;
    }

    static {
        Pair[] pairArray = new Pair[]{englishHuffman, japaneseHuffman};
        huffmen = CollectionsKt.listOf(pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015R#\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR)\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u00050\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/logging/BankedFileHandler$Companion;", "", "<init>", "()V", "englishHuffman", "Lkotlin/Pair;", "Lorg/bread_experts_group/coder/format/parse/huffman/HuffmanBranch;", "", "", "getEnglishHuffman", "()Lkotlin/Pair;", "japaneseHuffman", "getJapaneseHuffman", "huffmen", "", "getHuffmen", "()Ljava/util/List;", "readMemoryBank", "", "", "bank", "Ljava/nio/channels/FileChannel;", "bread_server_lib"})
    @SourceDebugExtension(value={"SMAP\nBankedFileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BankedFileHandler.kt\norg/bread_experts_group/logging/BankedFileHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,204:1\n295#2,2:205\n*S KotlinDebug\n*F\n+ 1 BankedFileHandler.kt\norg/bread_experts_group/logging/BankedFileHandler$Companion\n*L\n59#1:205,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<HuffmanBranch<Character>, Integer> getEnglishHuffman() {
            return englishHuffman;
        }

        @NotNull
        public final Pair<HuffmanBranch<Character>, Integer> getJapaneseHuffman() {
            return japaneseHuffman;
        }

        @NotNull
        public final List<Pair<HuffmanBranch<Character>, Integer>> getHuffmen() {
            return huffmen;
        }

        @NotNull
        public final List<String> readMemoryBank(@NotNull FileChannel bank) {
            List<String> list;
            Intrinsics.checkNotNullParameter(bank, "bank");
            List<String> $this$readMemoryBank_u24lambda_u242 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            while (bank.position() < bank.size()) {
                Object v2;
                boolean bl2;
                ByteBuffer contentBacked;
                int compressionMethod;
                block6: {
                    byte[] byArray;
                    long initialPosition = bank.position();
                    ByteBuffer backed = ByteBuffer.allocate(11);
                    bank.read(backed);
                    Intrinsics.checkNotNullExpressionValue(backed.array(), "array(...)");
                    ByteArrayInputStream data = new ByteArrayInputStream(byArray);
                    long size = ExtensibleLongsV1Kt.readExtensibleULongV1(data);
                    if (Long.compareUnsigned(size, ULong.constructor-impl((long)UInt.constructor-impl(Integer.MAX_VALUE) & 0xFFFFFFFFL)) > 0) {
                        throw new UnsupportedOperationException("Size is too big! [" + ULong.toString-impl(size) + "]");
                    }
                    compressionMethod = data.read();
                    bank.position(initialPosition + (long)(backed.capacity() - data.available()));
                    contentBacked = ByteBuffer.allocate((int)size);
                    bank.read(contentBacked);
                    if (compressionMethod == 0) {
                        byte[] byArray2 = contentBacked.array();
                        Intrinsics.checkNotNullExpressionValue(byArray2, "array(...)");
                        bl2 = $this$readMemoryBank_u24lambda_u242.add(StringsKt.decodeToString(byArray2));
                        continue;
                    }
                    Iterable $this$firstOrNull$iv = Companion.getHuffmen();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl3 = false;
                        int type = ((Number)pair.component2()).intValue();
                        if (!(type == (compressionMethod & 0x1F))) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                Pair pair = v2;
                if (pair != null) {
                    byte[] type;
                    Pair pair2 = pair;
                    boolean bl4 = false;
                    HuffmanBranch huffman = (HuffmanBranch)pair2.component1();
                    int unused = compressionMethod >> 5;
                    Intrinsics.checkNotNullExpressionValue(contentBacked.array(), "array(...)");
                    BitInputStream input = new BitInputStream(new ByteArrayInputStream(type));
                    Object decoded = "";
                    while (input.available() - unused > 0) {
                        decoded = (String)decoded + huffman.next(input);
                    }
                    bl2 = $this$readMemoryBank_u24lambda_u242.add((String)decoded);
                    continue;
                }
                throw new UnsupportedOperationException("Compression method [" + compressionMethod + "]");
            }
            return CollectionsKt.toMutableList(CollectionsKt.build(list));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

