/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.logging;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.logging.BankedFileHandler;
import org.bread_experts_group.logging.ColoredLevel;
import org.bread_experts_group.logging.ansi_colorspace.ANSI16;
import org.bread_experts_group.logging.ansi_colorspace.ANSI16Color;
import org.bread_experts_group.stream.ExtensibleLongsV1Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020!J\u0006\u0010.\u001a\u00020/R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001d\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001d0)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0017\u00a8\u00060"}, d2={"Lorg/bread_experts_group/logging/BankedFileReader;", "", "bankPath", "Ljava/nio/file/Path;", "contentPath", "timestampPath", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "fromHandler", "Lorg/bread_experts_group/logging/BankedFileHandler;", "(Lorg/bread_experts_group/logging/BankedFileHandler;)V", "bank", "Ljava/nio/channels/FileChannel;", "getBank", "()Ljava/nio/channels/FileChannel;", "content", "getContent", "timestamp", "getTimestamp", "memoryBank", "", "", "getMemoryBank", "()Ljava/util/List;", "timestamps", "", "Lkotlin/ULong;", "getTimestamps", "createLevel", "Ljava/util/logging/Level;", "name", "resourceBundle", "value", "", "nanos", "", "getNanos", "()J", "setNanos", "(J)V", "savedLevels", "", "getSavedLevels", "()Ljava/util/Map;", "messages", "getMessages", "nextRecord", "Ljava/util/logging/LogRecord;", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nBankedFileReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BankedFileReader.kt\norg/bread_experts_group/logging/BankedFileReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class BankedFileReader {
    @NotNull
    private final FileChannel bank;
    @NotNull
    private final FileChannel content;
    @NotNull
    private final FileChannel timestamp;
    @NotNull
    private final List<String> memoryBank;
    @NotNull
    private final List<ULong> timestamps;
    private long nanos;
    @NotNull
    private final Map<ULong, Level> savedLevels;
    @NotNull
    private final List<String> messages;

    /*
     * WARNING - void declaration
     */
    public BankedFileReader(@NotNull Path bankPath, @NotNull Path contentPath, @NotNull Path timestampPath) {
        Intrinsics.checkNotNullParameter(bankPath, "bankPath");
        Intrinsics.checkNotNullParameter(contentPath, "contentPath");
        Intrinsics.checkNotNullParameter(timestampPath, "timestampPath");
        Object object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ};
        FileChannel fileChannel = FileChannel.open(bankPath, object);
        Intrinsics.checkNotNullExpressionValue(fileChannel, "open(...)");
        this.bank = fileChannel;
        object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ};
        FileChannel fileChannel2 = FileChannel.open(contentPath, object);
        Intrinsics.checkNotNullExpressionValue(fileChannel2, "open(...)");
        this.content = fileChannel2;
        object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ};
        FileChannel fileChannel3 = FileChannel.open(timestampPath, object);
        Intrinsics.checkNotNullExpressionValue(fileChannel3, "open(...)");
        this.timestamp = fileChannel3;
        this.memoryBank = BankedFileHandler.Companion.readMemoryBank(this.bank);
        List list = CollectionsKt.createListBuilder();
        object = list;
        BankedFileReader bankedFileReader = this;
        boolean bl = false;
        this.timestamp.position(10L);
        while (this.timestamp.position() < this.timestamp.size()) {
            void $this$timestamps_u24lambda_u240;
            byte[] byArray;
            long initialPosition = this.timestamp.position();
            ByteBuffer backed = ByteBuffer.allocate(10);
            this.timestamp.read(backed);
            Intrinsics.checkNotNullExpressionValue(backed.array(), "array(...)");
            ByteArrayInputStream data = new ByteArrayInputStream(byArray);
            $this$timestamps_u24lambda_u240.add(ULong.box-impl(ExtensibleLongsV1Kt.readExtensibleULongV1(data)));
            this.timestamp.position(initialPosition + (long)(backed.capacity() - data.available()));
        }
        bankedFileReader.timestamps = CollectionsKt.build(list);
        this.savedLevels = new LinkedHashMap();
        this.messages = new ArrayList();
    }

    public BankedFileReader(@NotNull BankedFileHandler fromHandler) {
        Intrinsics.checkNotNullParameter(fromHandler, "fromHandler");
        this(fromHandler.getBankPath(), fromHandler.getContentPath(), fromHandler.getTimestampPath());
    }

    @NotNull
    public final FileChannel getBank() {
        return this.bank;
    }

    @NotNull
    public final FileChannel getContent() {
        return this.content;
    }

    @NotNull
    public final FileChannel getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final List<String> getMemoryBank() {
        return this.memoryBank;
    }

    @NotNull
    public final List<ULong> getTimestamps() {
        return this.timestamps;
    }

    @NotNull
    public final Level createLevel(@NotNull String name, @Nullable String resourceBundle, int value) {
        Level level;
        Intrinsics.checkNotNullParameter(name, "name");
        try {
            level = Level.parse(name);
            Intrinsics.checkNotNull(level);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            level = new ColoredLevel(name, new ANSI16Color(ANSI16.MAGENTA, false, 2, null), value, resourceBundle);
        }
        return level;
    }

    public final long getNanos() {
        return this.nanos;
    }

    public final void setNanos(long l) {
        this.nanos = l;
    }

    @NotNull
    public final Map<ULong, Level> getSavedLevels() {
        return this.savedLevels;
    }

    @NotNull
    public final List<String> getMessages() {
        return this.messages;
    }

    @NotNull
    public final LogRecord nextRecord() {
        String string;
        Level level;
        long initialPosition = this.content.position();
        ByteBuffer data = ByteBuffer.allocate(90);
        this.content.read(data);
        byte[] byArray = data.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        byte[] byArray2 = byArray;
        ByteArrayInputStream stream = new ByteArrayInputStream(byArray2);
        long it = this.timestamps.get((int)ExtensibleLongsV1Kt.readExtensibleULongV1(stream)).unbox-impl();
        boolean bl = false;
        this.nanos += ExtensibleLongsV1Kt.readExtensibleLongV1(stream);
        Instant time = Instant.ofEpochSecond(it, this.nanos);
        long levelDescriptor = ExtensibleLongsV1Kt.readExtensibleULongV1(stream);
        long levelIndex = ULong.constructor-impl(levelDescriptor >>> 1);
        if (ULong.constructor-impl(levelDescriptor & 1L) == 1L) {
            Level level2;
            long nameIndex = ExtensibleLongsV1Kt.readExtensibleULongV1(stream);
            Level it2 = level2 = this.createLevel(this.memoryBank.get((int)nameIndex), this.memoryBank.get((int)levelIndex), (int)ExtensibleLongsV1Kt.readExtensibleLongV1(stream));
            boolean bl2 = false;
            this.savedLevels.put(ULong.box-impl(nameIndex), it2);
            level = level2;
        } else {
            level = this.savedLevels.get(ULong.box-impl(levelIndex));
            if (level == null) {
                Level level3;
                Level it3 = level3 = this.createLevel(this.memoryBank.get((int)levelIndex), null, (int)ExtensibleLongsV1Kt.readExtensibleLongV1(stream));
                boolean bl3 = false;
                this.savedLevels.put(ULong.box-impl(levelIndex), it3);
                level = level3;
            }
        }
        Level level4 = level;
        String loggerName = this.memoryBank.get((int)ExtensibleLongsV1Kt.readExtensibleULongV1(stream));
        long threadID = ExtensibleLongsV1Kt.readExtensibleLongV1(stream);
        long messageDescriptor = ExtensibleLongsV1Kt.readExtensibleULongV1(stream);
        int messageLength = (int)ULong.constructor-impl(messageDescriptor >>> 1);
        this.content.position(initialPosition + (long)(data.capacity() - stream.available()));
        if (ULong.constructor-impl(messageDescriptor & 1L) == 0L) {
            StringBuilder stringBuilder;
            ByteBuffer messageData = ByteBuffer.allocate(messageLength * 10);
            byte[] byArray3 = messageData.array();
            Intrinsics.checkNotNullExpressionValue(byArray3, "array(...)");
            byte[] byArray4 = byArray3;
            ByteArrayInputStream messageStream = new ByteArrayInputStream(byArray4);
            long dataPosition = this.content.position();
            this.content.read(messageData);
            StringBuilder $this$nextRecord_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl4 = false;
            int n = 0;
            while (n < messageLength) {
                int it4 = n++;
                boolean bl5 = false;
                $this$nextRecord_u24lambda_u245.append(this.memoryBank.get((int)ExtensibleLongsV1Kt.readExtensibleULongV1(messageStream)));
                $this$nextRecord_u24lambda_u245.append(' ');
            }
            String message = stringBuilder.toString();
            this.messages.add(message);
            this.content.position(dataPosition + (long)(messageData.capacity() - messageStream.available()));
            string = message;
        } else {
            string = this.messages.get(messageLength);
        }
        String message = string;
        LogRecord record = new LogRecord(level4, message);
        record.setInstant(time);
        record.setLoggerName(loggerName);
        record.setLongThreadID(threadID);
        record.setSourceMethodName("readback");
        return record;
    }
}

