/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.logging;

import java.io.PrintStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.bread_experts_group.logging.ANSIString;
import org.bread_experts_group.logging.ANSITerminalControlKt;
import org.bread_experts_group.logging.ColoredLevel;
import org.bread_experts_group.logging.ansi_colorspace.ANSI16;
import org.bread_experts_group.logging.ansi_colorspace.ANSI16Color;
import org.bread_experts_group.logging.ansi_colorspace.ANSIColorSpace;
import org.bread_experts_group.resource.LoggerResource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ:\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/bread_experts_group/logging/ColoredHandler;", "Ljava/util/logging/Handler;", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "stackTraceOnlyInLoggingModule", "", "towards", "Ljava/io/PrintStream;", "<init>", "(Ljava/time/format/DateTimeFormatter;ZLjava/io/PrintStream;)V", "getDateTimeFormatter", "()Ljava/time/format/DateTimeFormatter;", "setDateTimeFormatter", "(Ljava/time/format/DateTimeFormatter;)V", "getStackTraceOnlyInLoggingModule", "()Z", "setStackTraceOnlyInLoggingModule", "(Z)V", "getTowards", "()Ljava/io/PrintStream;", "setTowards", "(Ljava/io/PrintStream;)V", "closed", "createExceptionMessage", "", "record", "Ljava/util/logging/LogRecord;", "prefix", "Lorg/bread_experts_group/logging/ANSIString;", "spaced", "thrown", "", "hitThrown", "", "publish", "", "flush", "close", "Companion", "bread_server_lib"})
public final class ColoredHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DateTimeFormatter dateTimeFormatter;
    private boolean stackTraceOnlyInLoggingModule;
    @NotNull
    private PrintStream towards;
    private boolean closed;
    private static int levelNamePad;
    private static boolean coloring;
    @NotNull
    private static final Set<Long> recentlyLogged;

    public ColoredHandler(@NotNull DateTimeFormatter dateTimeFormatter, boolean stackTraceOnlyInLoggingModule, @NotNull PrintStream towards) {
        Intrinsics.checkNotNullParameter(dateTimeFormatter, "dateTimeFormatter");
        Intrinsics.checkNotNullParameter(towards, "towards");
        this.dateTimeFormatter = dateTimeFormatter;
        this.stackTraceOnlyInLoggingModule = stackTraceOnlyInLoggingModule;
        this.towards = towards;
    }

    public /* synthetic */ ColoredHandler(DateTimeFormatter dateTimeFormatter, boolean bl, PrintStream printStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("MM/dd HH:mm:ss.SSSSSS");
            Intrinsics.checkNotNullExpressionValue(dateTimeFormatter2, "ofPattern(...)");
            dateTimeFormatter = dateTimeFormatter2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream2, "out");
            printStream = printStream2;
        }
        this(dateTimeFormatter, bl, printStream);
    }

    @NotNull
    public final DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public final void setDateTimeFormatter(@NotNull DateTimeFormatter dateTimeFormatter) {
        Intrinsics.checkNotNullParameter(dateTimeFormatter, "<set-?>");
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public final boolean getStackTraceOnlyInLoggingModule() {
        return this.stackTraceOnlyInLoggingModule;
    }

    public final void setStackTraceOnlyInLoggingModule(boolean bl) {
        this.stackTraceOnlyInLoggingModule = bl;
    }

    @NotNull
    public final PrintStream getTowards() {
        return this.towards;
    }

    public final void setTowards(@NotNull PrintStream printStream) {
        Intrinsics.checkNotNullParameter(printStream, "<set-?>");
        this.towards = printStream;
    }

    /*
     * WARNING - void declaration
     */
    private final String createExceptionMessage(LogRecord record, ANSIString prefix, String spaced, Throwable thrown, Set<? extends Throwable> hitThrown) {
        Object object;
        block3: {
            Object object2;
            ANSIString aNSIString;
            block5: {
                block4: {
                    void it;
                    block2: {
                        if (!hitThrown.contains(thrown)) break block2;
                        object = " =\u2042= CYCLE THROWN CAUSE DETECTED =\u2042= ";
                        break block3;
                    }
                    aNSIString = ANSITerminalControlKt.ansi(arg_0 -> ColoredHandler.createExceptionMessage$lambda$14(record, thrown, this, prefix, spaced, arg_0));
                    object2 = thrown.getCause();
                    if (object2 == null) break block4;
                    Throwable throwable = object2;
                    ANSIString aNSIString2 = aNSIString;
                    boolean bl = false;
                    char c2 = '\n';
                    String string = this.createExceptionMessage(record, prefix, spaced, (Throwable)it, SetsKt.plus(hitThrown, thrown));
                    String string2 = c2 + string;
                    aNSIString = aNSIString2;
                    object2 = string2;
                    if (string2 != null) break block5;
                }
                object2 = "";
            }
            object = aNSIString + (String)object2;
        }
        return object;
    }

    static /* synthetic */ String createExceptionMessage$default(ColoredHandler coloredHandler, LogRecord logRecord, ANSIString aNSIString, String string, Throwable throwable, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            Throwable throwable2 = logRecord.getThrown();
            Intrinsics.checkNotNullExpressionValue(throwable2, "getThrown(...)");
            throwable = throwable2;
        }
        if ((n & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        return coloredHandler.createExceptionMessage(logRecord, aNSIString, string, throwable, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@NotNull LogRecord record) {
        String string;
        Intrinsics.checkNotNullParameter(record, "record");
        if (!recentlyLogged.add(record.getSequenceNumber())) {
            return;
        }
        if (this.closed) {
            throw new IllegalStateException("ColoredHandler closed");
        }
        ANSIString prefix = ANSITerminalControlKt.ansi(arg_0 -> ColoredHandler.publish$lambda$23(record, this, arg_0));
        String spaced = StringsKt.repeat(" ", prefix.getLength());
        String string2 = record.getMessage();
        Intrinsics.checkNotNullExpressionValue(string2, "getMessage(...)");
        String paddedMessage = StringsKt.replace(string2, "\n", "\n" + spaced, true);
        if (record.getThrown() != null) {
            String initialMessage = prefix + paddedMessage;
            string = initialMessage + "\n" + ColoredHandler.createExceptionMessage$default(this, record, prefix, spaced, null, null, 24, null);
        } else {
            string = prefix + paddedMessage;
        }
        String fullMessage = string;
        PrintStream printStream = this.towards;
        synchronized (printStream) {
            boolean bl = false;
            this.towards.println(fullMessage);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private static final String createExceptionMessage$lambda$14$lambda$13$traceString(Ref.IntRef truncatedCount) {
        return "<" + truncatedCount.element + " excluded trace" + (truncatedCount.element > 1 ? Character.valueOf('s') : "") + ">";
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$logTruncated$lambda$0(Ref.IntRef $truncatedCount, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append("\n" + ColoredHandler.createExceptionMessage$lambda$14$lambda$13$traceString($truncatedCount));
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$logTruncated(Ref.IntRef truncatedCount, ANSIString $this_color) {
        Unit unit;
        if (truncatedCount.element > 0) {
            $this_color.color(new ANSI16Color(ANSI16.LIGHT_GRAY, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$logTruncated$lambda$0(truncatedCount, arg_0));
            truncatedCount.element = 0;
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$3$lambda$2(String $exceptionName, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append($exceptionName);
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$3(Ref.IntRef $truncatedCount, ANSIString $prefix, String $exceptionName, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        int additionalOffset = 0;
        if ($truncatedCount.element > 0) {
            String string;
            String it = string = ColoredHandler.createExceptionMessage$lambda$14$lambda$13$traceString($truncatedCount);
            boolean bl = false;
            additionalOffset = it.length();
            $this$color.append(it);
        }
        $this$color.append(StringsKt.repeat(" ", Math.max(0, $prefix.getLength() - $exceptionName.length() - 3 - additionalOffset)));
        $this$color.append('[');
        $this$color.color(new ANSI16Color(ANSI16.RED, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$lambda$3$lambda$2($exceptionName, arg_0));
        $this$color.append(']');
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$4(List $exceptionMessage, String $spaced, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append((String)$exceptionMessage.get(0));
        if ($exceptionMessage.size() > 1) {
            char c2 = '\n';
            String string = (String)$exceptionMessage.get(1);
            $this$color.append(StringsKt.replace(c2 + string, "\n", "\n" + $spaced, true));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$5(ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append('.');
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$7$lambda$6(ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append(':');
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$7(StackTraceElement $trace, Ref.IntRef $moduleNamePad, Ref.IntRef $moduleVersionPad, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        String string = $trace.getModuleName();
        if (string == null) {
            string = "";
        }
        $this$color.append(StringsKt.padEnd$default(string, $moduleNamePad.element, '\u0000', 2, null));
        $this$color.color(new ANSI16Color(ANSI16.LIGHT_GRAY, false, 2, null), ColoredHandler::createExceptionMessage$lambda$14$lambda$13$lambda$7$lambda$6);
        String string2 = $trace.getModuleVersion();
        if (string2 == null) {
            string2 = "";
        }
        $this$color.append(StringsKt.padEnd$default(string2, $moduleVersionPad.element, '\u0000', 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$9$lambda$8(ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append(" | ");
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$9(StackTraceElement $trace, Ref.IntRef $filePad, Ref.IntRef $classLoadPad, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        String string = $trace.getFileName();
        if (string == null) {
            string = "";
        }
        $this$color.append(StringsKt.padEnd$default(string, $filePad.element, '\u0000', 2, null));
        $this$color.color(new ANSI16Color(ANSI16.LIGHT_GRAY, false, 2, null), ColoredHandler::createExceptionMessage$lambda$14$lambda$13$lambda$9$lambda$8);
        String string2 = $trace.getClassLoaderName();
        if (string2 == null) {
            string2 = "";
        }
        $this$color.append(StringsKt.padEnd$default(string2, $classLoadPad.element, '\u0000', 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$10(StackTraceElement $trace, Ref.IntRef $classNamePad, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        String string = $trace.getClassName();
        Intrinsics.checkNotNullExpressionValue(string, "getClassName(...)");
        $this$color.append(StringsKt.padEnd$default(string, $classNamePad.element, '\u0000', 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$11(StackTraceElement $trace, Ref.IntRef $methodNamePad, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        String string = $trace.getMethodName();
        Intrinsics.checkNotNullExpressionValue(string, "getMethodName(...)");
        $this$color.append(StringsKt.padEnd$default(string, $methodNamePad.element, '\u0000', 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13$lambda$12(StackTraceElement $trace, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append(String.valueOf($trace.getLineNumber()));
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14$lambda$13(LogRecord $record, Throwable $thrown, ColoredHandler this$0, ANSIString $prefix, String $spaced, ANSIString $this$color) {
        String string;
        String exceptionName;
        String string2;
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        try {
            string2 = $record.getSourceClassName() == null ? null : $this$color.getClass().getClassLoader().loadClass($record.getSourceClassName()).getModule().getName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            string2 = null;
        }
        String fromModuleName = string2;
        StackTraceElement[] stack = $thrown.getStackTrace();
        Ref.IntRef moduleNamePad = new Ref.IntRef();
        Ref.IntRef moduleVersionPad = new Ref.IntRef();
        Ref.IntRef filePad = new Ref.IntRef();
        Ref.IntRef classLoadPad = new Ref.IntRef();
        Ref.IntRef classNamePad = new Ref.IntRef();
        Ref.IntRef methodNamePad = new Ref.IntRef();
        Ref.IntRef truncatedCount = new Ref.IntRef();
        boolean firstTruncatedSet = false;
        Iterator<StackTraceElement> iterator2 = ArrayIteratorKt.iterator(stack);
        while (iterator2.hasNext()) {
            String classLoaderName;
            String fileName;
            StackTraceElement trace = iterator2.next();
            if (this$0.stackTraceOnlyInLoggingModule && !Intrinsics.areEqual(trace.getModuleName(), fromModuleName)) {
                if (firstTruncatedSet) continue;
                int n = truncatedCount.element;
                truncatedCount.element = n + 1;
                continue;
            }
            firstTruncatedSet = true;
            if (trace.getClassName().length() > classNamePad.element) {
                classNamePad.element = trace.getClassName().length();
            }
            if (trace.getMethodName().length() > methodNamePad.element) {
                methodNamePad.element = trace.getMethodName().length();
            }
            if (trace.getModuleName() != null && trace.getModuleName().length() > moduleNamePad.element) {
                moduleNamePad.element = trace.getModuleName().length();
            }
            if (trace.getModuleVersion() != null && trace.getModuleVersion().length() > moduleVersionPad.element) {
                moduleVersionPad.element = trace.getModuleVersion().length();
            }
            if ((fileName = trace.getFileName()) != null && fileName.length() > filePad.element) {
                filePad.element = fileName.length();
            }
            if ((classLoaderName = trace.getClassLoaderName()) == null || classLoaderName.length() <= classLoadPad.element) continue;
            classLoadPad.element = classLoaderName.length();
        }
        int traceIndex = 0;
        String string3 = $thrown.getClass().getCanonicalName();
        if (string3 == null) {
            string3 = exceptionName = "???";
        }
        if ((string = $thrown.getLocalizedMessage()) == null) {
            string = "<no message>";
        }
        Object object = string;
        char[] cArray = new char[]{'\n'};
        char[] cArray2 = cArray;
        List<String> exceptionMessage = StringsKt.split((CharSequence)object, cArray2, true, 2);
        $this$color.color(new ANSI16Color(ANSI16.LIGHT_GRAY, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$lambda$3(truncatedCount, $prefix, exceptionName, arg_0));
        $this$color.append(' ');
        $this$color.color(new ANSI16Color(ANSI16.YELLOW, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$lambda$4(exceptionMessage, $spaced, arg_0));
        object = ArrayIteratorKt.iterator(stack);
        while (object.hasNext()) {
            StackTraceElement trace = (StackTraceElement)object.next();
            if (truncatedCount.element > 0) {
                int n = truncatedCount.element;
                truncatedCount.element = n + -1;
                continue;
            }
            if (this$0.stackTraceOnlyInLoggingModule && !Intrinsics.areEqual(trace.getModuleName(), fromModuleName)) {
                int n = truncatedCount.element;
                truncatedCount.element = n + 1;
                ++traceIndex;
                continue;
            }
            ColoredHandler.createExceptionMessage$lambda$14$lambda$13$logTruncated(truncatedCount, $this$color);
            $this$color.append('\n');
            if (traceIndex == 0) {
                $this$color.color(new ANSI16Color(ANSI16.RED, false, 2, null), ColoredHandler::createExceptionMessage$lambda$14$lambda$13$lambda$5);
            } else {
                $this$color.append('^');
            }
            $this$color.append(" [");
            if (trace.getModuleName() != null || trace.getModuleVersion() != null) {
                $this$color.append('[');
                $this$color.color(new ANSI16Color(ANSI16.BLUE, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$lambda$7(trace, moduleNamePad, moduleVersionPad, arg_0));
                $this$color.append("] ");
            } else {
                $this$color.append(StringsKt.repeat(" ", moduleNamePad.element + moduleVersionPad.element + 4));
            }
            $this$color.color(new ANSI16Color(ANSI16.CYAN, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$lambda$9(trace, filePad, classLoadPad, arg_0));
            $this$color.append("] ");
            $this$color.color(new ANSI16Color(ANSI16.GREEN, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$lambda$10(trace, classNamePad, arg_0));
            $this$color.append('.');
            $this$color.color(new ANSI16Color(trace.isNativeMethod() ? ANSI16.MAGENTA : ANSI16.DEFAULT, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$lambda$11(trace, methodNamePad, arg_0));
            if (trace.getLineNumber() > -1) {
                $this$color.append(';');
                $this$color.color(new ANSI16Color(ANSI16.YELLOW, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13$lambda$12(trace, arg_0));
            }
            ++traceIndex;
        }
        ColoredHandler.createExceptionMessage$lambda$14$lambda$13$logTruncated(truncatedCount, $this$color);
        return Unit.INSTANCE;
    }

    private static final Unit createExceptionMessage$lambda$14(LogRecord $record, Throwable $thrown, ColoredHandler this$0, ANSIString $prefix, String $spaced, ANSIString $this$ansi) {
        Intrinsics.checkNotNullParameter($this$ansi, "$this$ansi");
        $this$ansi.setSetResets(coloring);
        $this$ansi.color(new ANSI16Color(ANSI16.LIGHT_GRAY, false, 2, null), arg_0 -> ColoredHandler.createExceptionMessage$lambda$14$lambda$13($record, $thrown, this$0, $prefix, $spaced, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit publish$lambda$23$lambda$22$lambda$16(LogRecord $record, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        String string = $record.getLevel().getLocalizedName();
        Intrinsics.checkNotNullExpressionValue(string, "getLocalizedName(...)");
        $this$color.append(StringsKt.padEnd$default(string, levelNamePad, '\u0000', 2, null));
        if ($record.getLevel().getLocalizedName().length() > levelNamePad) {
            levelNamePad = $record.getLevel().getLocalizedName().length();
        }
        return Unit.INSTANCE;
    }

    private static final Unit publish$lambda$23$lambda$22$lambda$17(ColoredHandler this$0, LogRecord $record, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        String string = this$0.dateTimeFormatter.format(ZonedDateTime.ofInstant($record.getInstant(), ZoneId.systemDefault()));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        $this$color.append(string);
        return Unit.INSTANCE;
    }

    private static final Unit publish$lambda$23$lambda$22$lambda$18(LogRecord $record, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        String string = $record.getLoggerName();
        Intrinsics.checkNotNullExpressionValue(string, "getLoggerName(...)");
        $this$color.append(string);
        return Unit.INSTANCE;
    }

    private static final Unit publish$lambda$23$lambda$22$lambda$21$lambda$20$lambda$19(LogRecord $record, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append(String.valueOf($record.getLongThreadID()));
        return Unit.INSTANCE;
    }

    private static final Unit publish$lambda$23$lambda$22$lambda$21$lambda$20(LogRecord $record, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append('[');
        $this$color.color(new ANSI16Color(ANSI16.CYAN, false, 2, null), arg_0 -> ColoredHandler.publish$lambda$23$lambda$22$lambda$21$lambda$20$lambda$19($record, arg_0));
        $this$color.append(']');
        return Unit.INSTANCE;
    }

    private static final Unit publish$lambda$23$lambda$22$lambda$21(LogRecord $record, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        String string = $record.getSourceMethodName();
        Intrinsics.checkNotNullExpressionValue(string, "getSourceMethodName(...)");
        $this$color.append(string);
        $this$color.color(new ANSI16Color(ANSI16.LIGHT_GRAY, false, 2, null), arg_0 -> ColoredHandler.publish$lambda$23$lambda$22$lambda$21$lambda$20($record, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit publish$lambda$23$lambda$22(LogRecord $record, ColoredHandler this$0, ANSIString $this$color) {
        Intrinsics.checkNotNullParameter($this$color, "$this$color");
        $this$color.append('[');
        Level level = $record.getLevel();
        $this$color.color(Intrinsics.areEqual(level, Level.FINEST) ? (ANSIColorSpace)new ANSI16Color(ANSI16.DARK_GRAY, false, 2, null) : (Intrinsics.areEqual(level, Level.FINER) ? (ANSIColorSpace)new ANSI16Color(ANSI16.LIGHT_GRAY, false, 2, null) : (Intrinsics.areEqual(level, Level.FINE) ? (ANSIColorSpace)new ANSI16Color(ANSI16.DEFAULT, false, 2, null) : (Intrinsics.areEqual(level, Level.INFO) ? (ANSIColorSpace)new ANSI16Color(ANSI16.CYAN, false, 2, null) : (Intrinsics.areEqual(level, Level.WARNING) ? (ANSIColorSpace)new ANSI16Color(ANSI16.YELLOW, false, 2, null) : (Intrinsics.areEqual(level, Level.SEVERE) ? (ANSIColorSpace)new ANSI16Color(ANSI16.RED, false, 2, null) : (level instanceof ColoredLevel ? ((ColoredLevel)level).getColor() : (ANSIColorSpace)new ANSI16Color(ANSI16.MAGENTA, false, 2, null))))))), arg_0 -> ColoredHandler.publish$lambda$23$lambda$22$lambda$16($record, arg_0));
        $this$color.append(" | ");
        $this$color.color(new ANSI16Color(ANSI16.YELLOW, false, 2, null), arg_0 -> ColoredHandler.publish$lambda$23$lambda$22$lambda$17(this$0, $record, arg_0));
        $this$color.append(" | ");
        $this$color.color(new ANSI16Color(ANSI16.DEFAULT, false, 2, null), arg_0 -> ColoredHandler.publish$lambda$23$lambda$22$lambda$18($record, arg_0));
        $this$color.append(" | ");
        $this$color.color(new ANSI16Color(ANSI16.DEFAULT, false, 2, null), arg_0 -> ColoredHandler.publish$lambda$23$lambda$22$lambda$21($record, arg_0));
        $this$color.append(']');
        return Unit.INSTANCE;
    }

    private static final Unit publish$lambda$23(LogRecord $record, ColoredHandler this$0, ANSIString $this$ansi) {
        Intrinsics.checkNotNullParameter($this$ansi, "$this$ansi");
        $this$ansi.setSetResets(coloring);
        $this$ansi.color(new ANSI16Color(ANSI16.LIGHT_GRAY, false, 2, null), arg_0 -> ColoredHandler.publish$lambda$23$lambda$22($record, this$0, arg_0));
        $this$ansi.append(' ');
        return Unit.INSTANCE;
    }

    public ColoredHandler() {
        this(null, false, null, 7, null);
    }

    static {
        Iterator iterator2 = ((Iterable)EntriesMappings.entries$0).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        System.Logger.Level it = (System.Logger.Level)((Object)iterator2.next());
        boolean bl = false;
        int n = Level.parse(String.valueOf(it.getSeverity())).getLocalizedName().length();
        while (iterator2.hasNext()) {
            System.Logger.Level it2 = (System.Logger.Level)((Object)iterator2.next());
            $i$a$-maxOf-ColoredHandler$Companion$levelNamePad$1 = false;
            int n2 = Level.parse(String.valueOf(it2.getSeverity())).getLocalizedName().length();
            if (n >= n2) continue;
            n = n2;
        }
        levelNamePad = n;
        coloring = true;
        recentlyLogged = new LinkedHashSet();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/bread_experts_group/logging/ColoredHandler$Companion;", "", "<init>", "()V", "levelNamePad", "", "coloring", "", "getColoring", "()Z", "setColoring", "(Z)V", "newLogger", "Ljava/util/logging/Logger;", "name", "", "level", "Ljava/util/logging/Level;", "newLoggerResourced", "key", "recentlyLogged", "", "", "getRecentlyLogged", "()Ljava/util/Set;", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getColoring() {
            return coloring;
        }

        public final void setColoring(boolean bl) {
            coloring = bl;
        }

        @NotNull
        public final Logger newLogger(@NotNull String name, @NotNull Level level) {
            Logger logger;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(level, "level");
            Logger it = logger = Logger.getLogger(name);
            boolean bl = false;
            it.setUseParentHandlers(false);
            it.addHandler(new ColoredHandler(null, false, null, 7, null));
            it.setLevel(level);
            Logger logger2 = logger;
            Intrinsics.checkNotNullExpressionValue(logger2, "also(...)");
            return logger2;
        }

        public static /* synthetic */ Logger newLogger$default(Companion companion, String string, Level level, int n, Object object) {
            if ((n & 2) != 0) {
                Level level2 = Logger.getLogger("").getLevel();
                Intrinsics.checkNotNullExpressionValue(level2, "getLevel(...)");
                level = level2;
            }
            return companion.newLogger(string, level);
        }

        @NotNull
        public final Logger newLoggerResourced(@NotNull String key, @NotNull Level level) {
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(level, "level");
            String string = LoggerResource.Companion.get$default(LoggerResource.Companion, null, 1, null).getString(key);
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            return org.bread_experts_group.logging.ColoredHandler$Companion.newLogger$default(this, string, null, 2, null);
        }

        public static /* synthetic */ Logger newLoggerResourced$default(Companion companion, String string, Level level, int n, Object object) {
            if ((n & 2) != 0) {
                Level level2 = Logger.getLogger("").getLevel();
                Intrinsics.checkNotNullExpressionValue(level2, "getLevel(...)");
                level = level2;
            }
            return companion.newLoggerResourced(string, level);
        }

        @NotNull
        public final Set<Long> getRecentlyLogged() {
            return recentlyLogged;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<System.Logger.Level> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])System.Logger.Level.values());
        }
    }
}

