/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public record TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Set<Block> logTarget, Set<Block> leavesTarget, BlockPredicate growableOn, BlockPredicate leavesPlacementFilter, int maxLogDepth, List<TreeDecorator> treeDecorators, Set<Block> placeFromNBT, boolean isSapling, Orientation orientation) implements FeatureConfiguration
{
    public static final Codec<Set<Block>> BLOCK_SET_CODEC = Codec.list((Codec)BuiltInRegistries.f_256975_.m_194605_()).xmap(ObjectOpenHashSet::new, ArrayList::new);
    public static final Codec<TreeFromStructureNBTConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.fieldOf("base_location").forGetter(TreeFromStructureNBTConfig::baseLocation), (App)ResourceLocation.f_135803_.fieldOf("canopy_location").forGetter(TreeFromStructureNBTConfig::canopyLocation), (App)IntProvider.f_146531_.fieldOf("height").forGetter(TreeFromStructureNBTConfig::height), (App)BlockStateProvider.f_68747_.fieldOf("log_provider").forGetter(TreeFromStructureNBTConfig::logProvider), (App)BlockStateProvider.f_68747_.fieldOf("leaves_provider").forGetter(TreeFromStructureNBTConfig::leavesProvider), (App)BLOCK_SET_CODEC.fieldOf("log_target").forGetter(TreeFromStructureNBTConfig::logTarget), (App)BLOCK_SET_CODEC.fieldOf("leaves_target").forGetter(TreeFromStructureNBTConfig::leavesTarget), (App)BlockPredicate.f_190392_.fieldOf("can_grow_on_filter").forGetter(TreeFromStructureNBTConfig::growableOn), (App)BlockPredicate.f_190392_.fieldOf("can_leaves_place_filter").forGetter(TreeFromStructureNBTConfig::leavesPlacementFilter), (App)Codec.INT.optionalFieldOf("max_log_depth", (Object)5).forGetter(TreeFromStructureNBTConfig::maxLogDepth), (App)TreeDecorator.f_70021_.listOf().optionalFieldOf("decorators", new ArrayList()).forGetter(TreeFromStructureNBTConfig::treeDecorators), (App)BLOCK_SET_CODEC.fieldOf("place_from_nbt").forGetter(TreeFromStructureNBTConfig::placeFromNBT), (App)Codec.BOOL.optionalFieldOf("sapling", (Object)false).forGetter(TreeFromStructureNBTConfig::isSapling), (App)Orientation.CODEC.optionalFieldOf("orientation", (Object)Orientation.STANDARD).forGetter(TreeFromStructureNBTConfig::orientation)).apply((Applicative)builder, TreeFromStructureNBTConfig::new));

    @Deprecated(forRemoval=true, since="Use Builder")
    public TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Collection<Block> logTarget, List<Block> leavesTarget, TagKey<Block> growableOn, int maxLogDepth, List<TreeDecorator> treeDecorators) {
        this(baseLocation, canopyLocation, height, logProvider, leavesProvider, (Set<Block>)new ObjectOpenHashSet(logTarget), (Set<Block>)new ObjectOpenHashSet(leavesTarget), BlockPredicate.m_204677_(growableOn), BlockPredicate.m_190419_(), maxLogDepth, treeDecorators, Set.of(), false, Orientation.STANDARD);
    }

    @Deprecated(forRemoval=true, since="Use Builder")
    public TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Block logTarget, Block leavesTarget, TagKey<Block> growableOn, int maxLogDepth, List<TreeDecorator> treeDecorators) {
        this(baseLocation, canopyLocation, height, logProvider, leavesProvider, Collections.singleton(logTarget), Collections.singleton(leavesTarget), BlockPredicate.m_204677_(growableOn), BlockPredicate.m_190419_(), maxLogDepth, treeDecorators, Set.of(), false, Orientation.STANDARD);
    }

    @Deprecated(forRemoval=true, since="Use Builder")
    public TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Block logTarget, Block leavesTarget, TagKey<Block> growableOn, int maxLogDepth) {
        this(baseLocation, canopyLocation, height, logProvider, leavesProvider, Collections.singleton(logTarget), Collections.singleton(leavesTarget), BlockPredicate.m_204677_(growableOn), BlockPredicate.m_190419_(), maxLogDepth, (List<TreeDecorator>)ImmutableList.of(), Set.of(), false, Orientation.STANDARD);
    }

    @Deprecated(forRemoval=true, since="Use Builder")
    public TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Supplier<? extends Block> logTarget, Supplier<? extends Block> leavesTarget, TagKey<Block> growableOn, int maxLogDepth, List<TreeDecorator> treeDecorators) {
        this(baseLocation, canopyLocation, height, logProvider, leavesProvider, logTarget.get(), leavesTarget.get(), growableOn, maxLogDepth, treeDecorators);
    }

    @Deprecated(forRemoval=true, since="Use Builder class")
    public TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Collection<Block> logTarget, List<Block> leavesTarget, TagKey<Block> growableOn, int maxLogDepth, List<TreeDecorator> treeDecorators, boolean isSapling) {
        this(baseLocation, canopyLocation, height, logProvider, leavesProvider, (Set<Block>)new ObjectOpenHashSet(logTarget), (Set<Block>)new ObjectOpenHashSet(leavesTarget), BlockPredicate.m_204677_(growableOn), BlockPredicate.m_190419_(), maxLogDepth, treeDecorators, Set.of(), isSapling, Orientation.STANDARD);
    }

    @Deprecated(forRemoval=true, since="Use Builder class")
    public TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Block logTarget, Block leavesTarget, TagKey<Block> growableOn, int maxLogDepth, List<TreeDecorator> treeDecorators, boolean isSapling) {
        this(baseLocation, canopyLocation, height, logProvider, leavesProvider, Collections.singleton(logTarget), Collections.singleton(leavesTarget), BlockPredicate.m_204677_(growableOn), BlockPredicate.m_190419_(), maxLogDepth, treeDecorators, Set.of(), isSapling, Orientation.STANDARD);
    }

    @Deprecated(forRemoval=true, since="Use Builder class")
    public TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Block logTarget, Block leavesTarget, TagKey<Block> growableOn, int maxLogDepth, boolean isSapling) {
        this(baseLocation, canopyLocation, height, logProvider, leavesProvider, Collections.singleton(logTarget), Collections.singleton(leavesTarget), BlockPredicate.m_204677_(growableOn), BlockPredicate.m_190419_(), maxLogDepth, (List<TreeDecorator>)ImmutableList.of(), Set.of(), isSapling, Orientation.STANDARD);
    }

    @Deprecated(forRemoval=true, since="Use Builder class")
    public TreeFromStructureNBTConfig(ResourceLocation baseLocation, ResourceLocation canopyLocation, IntProvider height, BlockStateProvider logProvider, BlockStateProvider leavesProvider, Supplier<? extends Block> logTarget, Supplier<? extends Block> leavesTarget, TagKey<Block> growableOn, int maxLogDepth, List<TreeDecorator> treeDecorators, boolean isSapling) {
        this(baseLocation, canopyLocation, height, logProvider, leavesProvider, logTarget.get(), leavesTarget.get(), growableOn, maxLogDepth, treeDecorators, isSapling);
    }

    public static enum Orientation {
        STANDARD,
        UPSIDE_DOWN,
        SIDEWAYS;

        public static final Codec<Orientation> CODEC;

        static {
            CODEC = Codec.STRING.xmap(s -> Orientation.valueOf(s.toUpperCase()), s -> s.name().toUpperCase());
        }
    }

    public static class Builder {
        @Nullable
        private ResourceLocation baseLocation;
        @Nullable
        private ResourceLocation canopyLocation;
        @Nullable
        private IntProvider height;
        @Nullable
        private BlockStateProvider logProvider;
        @Nullable
        private BlockStateProvider leavesProvider;
        @Nullable
        private Set<Block> logTarget;
        @Nullable
        private Set<Block> leavesTarget;
        private BlockPredicate growableOn = BlockPredicate.m_190419_();
        private BlockPredicate leavesPlacementFilter = BlockPredicate.m_190419_();
        private int maxLogDepth = 5;
        private List<TreeDecorator> treeDecorators = new ArrayList<TreeDecorator>();
        private Set<Block> placeFromNBT = new HashSet<Block>();
        private boolean isSapling = false;
        private Orientation orientation = Orientation.STANDARD;

        public Builder baseLocation(ResourceLocation baseLocation) {
            this.baseLocation = baseLocation;
            return this;
        }

        public Builder canopyLocation(ResourceLocation canopyLocation) {
            this.canopyLocation = canopyLocation;
            return this;
        }

        public Builder height(IntProvider height) {
            this.height = height;
            return this;
        }

        public Builder logProvider(BlockStateProvider logProvider) {
            this.logProvider = logProvider;
            return this;
        }

        public Builder leavesProvider(BlockStateProvider leavesProvider) {
            this.leavesProvider = leavesProvider;
            return this;
        }

        public Builder logTarget(Set<Block> logTarget) {
            this.logTarget = logTarget;
            return this;
        }

        public Builder leavesTarget(Set<Block> leavesTarget) {
            this.leavesTarget = leavesTarget;
            return this;
        }

        public Builder growableOn(BlockPredicate growableOn) {
            this.growableOn = growableOn;
            return this;
        }

        public Builder leavesPlacementFilter(BlockPredicate leavesPlacementFilter) {
            this.leavesPlacementFilter = leavesPlacementFilter;
            return this;
        }

        public Builder maxLogDepth(int maxLogDepth) {
            this.maxLogDepth = maxLogDepth;
            return this;
        }

        public Builder treeDecorators(List<TreeDecorator> treeDecorators) {
            this.treeDecorators = treeDecorators;
            return this;
        }

        public Builder placeFromNBT(Set<Block> placeFromNBT) {
            this.placeFromNBT = placeFromNBT;
            return this;
        }

        public Builder isSapling(boolean isSapling) {
            this.isSapling = isSapling;
            return this;
        }

        public Builder orientation(Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        public TreeFromStructureNBTConfig build() {
            if (this.baseLocation == null) {
                throw new IllegalStateException("Base location cannot be null");
            }
            if (this.canopyLocation == null) {
                throw new IllegalStateException("Canopy location cannot be null");
            }
            if (this.height == null) {
                throw new IllegalStateException("Height cannot be null");
            }
            if (this.logProvider == null) {
                throw new IllegalStateException("Log provider cannot be null");
            }
            if (this.leavesProvider == null) {
                throw new IllegalStateException("Leaves provider cannot be null");
            }
            if (this.logTarget == null) {
                throw new IllegalStateException("Log target cannot be null");
            }
            if (this.leavesTarget == null) {
                throw new IllegalStateException("Leaves target cannot be null");
            }
            return new TreeFromStructureNBTConfig(this.baseLocation, this.canopyLocation, this.height, this.logProvider, this.leavesProvider, this.logTarget, this.leavesTarget, this.growableOn, this.leavesPlacementFilter, this.maxLogDepth, this.treeDecorators, this.placeFromNBT, this.isSapling, this.orientation);
        }
    }
}

