/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators.TYGTreeDecoratorTypes;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class TYGLeavesVineDecorator
extends TreeDecorator {
    public static final MapCodec<TYGLeavesVineDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuiltInRegistries.BLOCK.byNameCodec().flatXmap(TYGLeavesVineDecorator.mustExtendVineBlock(), TYGLeavesVineDecorator.mustExtendVineBlock()).fieldOf("vine_block").forGetter(TYGLeavesVineDecorator2 -> TYGLeavesVineDecorator2.vineBlock), (App)Codec.FLOAT.fieldOf("probability").forGetter(TYGLeavesVineDecorator2 -> Float.valueOf(TYGLeavesVineDecorator2.probability))).apply((Applicative)builder, (vineBlock, probability) -> new TYGLeavesVineDecorator((VineBlock)vineBlock, probability.floatValue())));
    private final VineBlock vineBlock;
    private final float probability;

    static Function<Block, DataResult<Block>> mustExtendVineBlock() {
        return block -> block instanceof VineBlock ? DataResult.success((Object)block) : DataResult.error(() -> String.format("\"%s\" is not an instance of `VineBlock`.", BuiltInRegistries.BLOCK.getKey(block)));
    }

    public TYGLeavesVineDecorator(VineBlock vineBlock, float probability) {
        this.vineBlock = vineBlock;
        this.probability = probability;
    }

    @NotNull
    protected TreeDecoratorType<?> type() {
        return TYGTreeDecoratorTypes.LEAVE_VINE.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        context.leaves().forEach(pos -> {
            BlockPos pos1;
            if (randomSource.nextFloat() <= this.probability && context.isAir(pos1 = pos.west())) {
                this.addHangingVine(pos1, VineBlock.EAST, context);
            }
            if (randomSource.nextFloat() <= this.probability && context.isAir(pos1 = pos.east())) {
                this.addHangingVine(pos1, VineBlock.WEST, context);
            }
            if (randomSource.nextFloat() <= this.probability && context.isAir(pos1 = pos.north())) {
                this.addHangingVine(pos1, VineBlock.SOUTH, context);
            }
            if (randomSource.nextFloat() <= this.probability && context.isAir(pos1 = pos.south())) {
                this.addHangingVine(pos1, VineBlock.NORTH, context);
            }
        });
    }

    private void addHangingVine(BlockPos pos, BooleanProperty booleanProperty, TreeDecorator.Context context) {
        this.placeVine(context, pos, booleanProperty);
        pos = pos.below();
        for (int count = 4; context.isAir(pos) && count > 0; --count) {
            this.placeVine(context, pos, booleanProperty);
            pos = pos.below();
        }
    }

    public void placeVine(TreeDecorator.Context context, BlockPos blockPos, BooleanProperty booleanProperty) {
        context.setBlock(blockPos, (BlockState)this.vineBlock.defaultBlockState().setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(true)));
    }
}

