/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.mixin.chunk;

import dev.corgitaco.ohthetreesyoullgrow.world.level.chunk.RandomTickScheduler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SerializableChunkData.class})
public class SerializableChunkDataMixin {
    @Shadow
    @Final
    private CompoundTag structureData;

    @Inject(method={"copyOf(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;)Lnet/minecraft/world/level/chunk/storage/SerializableChunkData;"}, at={@At(value="RETURN")})
    private static void writeScheduledRandomTicks(ServerLevel level, ChunkAccess chunk, CallbackInfoReturnable<SerializableChunkData> cir) {
        SerializableChunkData returnValue = (SerializableChunkData)cir.getReturnValue();
        if (returnValue != null) {
            CompoundTag compoundTag = returnValue.structureData();
            List<BlockPos> scheduledRandomTicks = ((RandomTickScheduler)chunk).getScheduledRandomTicks();
            if (!scheduledRandomTicks.isEmpty()) {
                CompoundTag corgiLibTag = new CompoundTag();
                ListTag listTag = new ListTag();
                for (BlockPos scheduledRandomTick : scheduledRandomTicks) {
                    listTag.add((Object)new IntArrayTag(new int[]{scheduledRandomTick.getX(), scheduledRandomTick.getY(), scheduledRandomTick.getZ()}));
                }
                corgiLibTag.put("scheduled_random_ticks", (Tag)listTag);
                compoundTag.put("ohthetreesyoullgrow", (Tag)corgiLibTag);
            }
        }
    }

    @Inject(method={"read(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/ai/village/poi/PoiManager;Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Lnet/minecraft/world/level/ChunkPos;)Lnet/minecraft/world/level/chunk/ProtoChunk;"}, at={@At(value="RETURN")})
    private void readScheduledRandomTicks(ServerLevel level, PoiManager poiManager, RegionStorageInfo regionStorageInfo, ChunkPos pos, CallbackInfoReturnable<ProtoChunk> cir) {
        if (this.structureData.contains("ohthetreesyoullgrow")) {
            CompoundTag corgiLibTag = this.structureData.getCompoundOrEmpty("ohthetreesyoullgrow");
            if (corgiLibTag.contains("scheduled_random_ticks")) {
                for (Tag scheduledTick : corgiLibTag.getListOrEmpty("scheduled_random_ticks")) {
                    int[] intArrayTag = ((IntArrayTag)scheduledTick).getAsIntArray();
                    ((RandomTickScheduler)cir.getReturnValue()).getScheduledRandomTicks().add(new BlockPos(intArrayTag[0], intArrayTag[1], intArrayTag[2]));
                }
            }
            this.structureData.remove("ohthetreesyoullgrow");
        }
    }
}

