/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.configs.Message;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.ActivatorEIFeature;
import com.ssomar.executableitems.listeners.optimize.OptimizedSlotsVerification;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.messages.SendMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class EventsManager {
    private static final Boolean DEBUG = false;
    private static EventsManager instance;

    public static EventsManager getInstance() {
        if (instance == null) {
            instance = new EventsManager();
        }
        return instance;
    }

    public void activeOptionAllPlayer(EventInfo eInfo) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            eInfo.setPlayer(Optional.of(p));
            this.activeOptionForPlayer(p, eInfo);
        }
    }

    public void activeOption(EventInfo eInfo) {
        Player p = eInfo.getPlayer().orElse(null);
        if (p != null) {
            this.activeOptionForPlayer(p, eInfo);
        } else {
            SsomarDev.testMsg((String)"Player is null", (boolean)DEBUG);
        }
    }

    public void activeOptionForPlayer(Player p, EventInfo eInfo) {
        Object is;
        int slot;
        PlayerInventory pInv = p.getInventory();
        ItemStack[] invContents = pInv.getContents();
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>(OptimizedSlotsVerification.getInstance().getDetailedSlotsOptimized(eInfo.getOption(), pInv.getHeldItemSlot()));
        if (DEBUG.booleanValue() && eInfo.getOption().isLoopOption()) {
            return;
        }
        ArrayList<Integer> nonEmptySlots = new ArrayList<Integer>();
        Iterator iterator = possibleSlots.iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            if (SCore.is1v11Less() && slot >= 36) {
                is = slot == 39 ? pInv.getHelmet() : (slot == 38 ? pInv.getChestplate() : (slot == 37 ? pInv.getLeggings() : (slot == 36 ? pInv.getBoots() : null)));
            } else {
                try {
                    is = invContents[slot];
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (is == null) continue;
            nonEmptySlots.add(slot);
        }
        iterator = nonEmptySlots.iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            pInv = p.getInventory();
            if (SCore.is1v11Less() && slot >= 36) {
                is = slot == 39 ? pInv.getHelmet() : (slot == 38 ? pInv.getChestplate() : (slot == 37 ? pInv.getLeggings() : (slot == 36 ? pInv.getBoots() : null)));
            } else {
                try {
                    is = pInv.getItem(slot);
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (is == null) continue;
            if (DEBUG.booleanValue()) {
                if (eInfo.getOption().isLoopOption()) {
                    return;
                }
                SsomarDev.testMsg((String)("slot: " + slot + " is: " + is.getType() + " >> " + is.getAmount()), (boolean)DEBUG);
            }
            this.activeOptionForPlayerForItemStack(p, (ItemStack)is, slot, eInfo);
        }
    }

    public void activeOptionForPlayerForItemStack(Player p, @NotNull ItemStack is, int slot, EventInfo eInfo) {
        ExecutableItemObject ei;
        if (eInfo.getWhitelistActivators().isEmpty()) {
            ei = new ExecutableItemObject(is, true);
        } else {
            ArrayList<String> eiInWhitelist = new ArrayList<String>();
            for (SActivator activator : eInfo.getWhitelistActivators()) {
                if (eiInWhitelist.contains(activator.getParentObjectId())) continue;
                eiInWhitelist.add(activator.getParentObjectId());
            }
            ei = new ExecutableItemObject(is, eiInWhitelist, true);
        }
        if (!ei.isValid()) {
            return;
        }
        ExecutableItem config = ei.getConfig();
        boolean permVerif = false;
        boolean worldVerif = false;
        boolean ownerVerif = false;
        int actActivated = 0;
        boolean oneProvenanceItemActivated = false;
        for (SActivator activator : config.getActivators().getActivators(eInfo.getOption(), eInfo.getWhitelistActivatorsId(), eInfo.getWhitelistActivators())) {
            ActivatorEIFeature activatorEIFeature = (ActivatorEIFeature)activator;
            if (activatorEIFeature.getContainsCustomBreakCommand().getValue().booleanValue() && eInfo.isFromCustomBreakCommand()) continue;
            SsomarDev.testMsg((String)"act Opt 1", (boolean)DEBUG);
            boolean mustBeAProjectileLaunchWithTheSameEI = false;
            for (Object obj : activator.getFeatures()) {
                FeatureInterface feature = (FeatureInterface)obj;
                if (!(feature instanceof BooleanFeature) || !feature.getName().equals("mustBeAProjectileLaunchWithTheSameEI")) continue;
                mustBeAProjectileLaunchWithTheSameEI = ((BooleanFeature)feature).getValue();
                break;
            }
            if (mustBeAProjectileLaunchWithTheSameEI) {
                if (!eInfo.getProjectileProvenance().isPresent()) continue;
                SsomarDev.testMsg((String)("Projectile provenance: " + (String)eInfo.getProjectileProvenance().get()), (boolean)DEBUG);
                if (!((String)eInfo.getProjectileProvenance().get()).equals(config.getId())) continue;
                oneProvenanceItemActivated = true;
            }
            SsomarDev.testMsg((String)"act Opt 2", (boolean)DEBUG);
            if (permVerif || config.hasItemPerm(p, false)) {
                permVerif = true;
            }
            if (!worldVerif && !this.isValidWorld(p, config)) {
                return;
            }
            worldVerif = true;
            SsomarDev.testMsg((String)"act Opt 3", (boolean)DEBUG);
            if (ownerVerif || EventsManager.isValidOwner(p, ei, false)) {
                ownerVerif = true;
            }
            SsomarDev.testMsg((String)"act Opt 4", (boolean)DEBUG);
            SsomarDev.testMsg((String)"act Opt 5", (boolean)DEBUG);
            boolean mainHand = p.getInventory().getHeldItemSlot() == slot && (!SCore.is1v11Less() && p.getInventory().getItemInMainHand().isSimilar(p.getInventory().getItem(slot)) || SCore.is1v11Less() && p.getInventory().getItemInHand().isSimilar(p.getInventory().getItem(slot)));
            EventInfo updateEInfo = eInfo.clone();
            updateEInfo.setMainHand(mainHand || eInfo.isForceMainHand());
            updateEInfo.setSlot(Optional.ofNullable(slot));
            if (actActivated == 0) {
                ei.loadExecutableItemInfos();
            }
            activator.runWithException((Object)ei, updateEInfo);
            ++actActivated;
        }
        if (oneProvenanceItemActivated) {
            eInfo.setProjectileProvenance(Optional.empty());
        }
    }

    public boolean isValidWorld(Player p, ExecutableItem item) {
        if (GeneralConfig.getInstance().getWhitelistItemsPerWorld().containsKey(p.getWorld().getName())) {
            List<String> validItems = GeneralConfig.getInstance().getWhitelistItemsPerWorld().get(p.getWorld().getName());
            if (!validItems.contains(item.getId())) {
                return false;
            }
        } else if (!GeneralConfig.getInstance().getWhitelistWorlds().isEmpty()) {
            boolean valid = false;
            for (String str : GeneralConfig.getInstance().getWhitelistWorlds()) {
                World world;
                Optional worldOptional = AllWorldManager.getWorld((String)str);
                if (!worldOptional.isPresent() || (world = (World)worldOptional.get()) != p.getWorld()) continue;
                valid = true;
                break;
            }
            if (!valid) {
                return false;
            }
        } else {
            for (String str : GeneralConfig.getInstance().getDisableWorlds()) {
                World world;
                Optional worldOptional = AllWorldManager.getWorld((String)str);
                if (!worldOptional.isPresent() || (world = (World)worldOptional.get()) != p.getWorld()) continue;
                return false;
            }
        }
        return item.getWhitelistedWorlds().isValidWorld(p.getWorld());
    }

    public static boolean isValidOwner(Player p, ExecutableItemObject ei, boolean showError) {
        UUID uuid = ei.getInternalData().getOwnerUUID();
        ExecutableItem config = ei.getConfig();
        if (!p.isOp() && config.getCanBeUsedOnlyByTheOwnerFeatures().getCanBeUsedOnlyByTheOwner().getValue().booleanValue()) {
            ei.loadExecutableItemInfos();
            if (uuid == null || !p.getUniqueId().equals(uuid)) {
                if (showError) {
                    SendMessage.sendMessageNoPlch((Player)p, (String)MessageMain.getInstance().getMessage((Plugin)ExecutableItems.plugin, (MessageInterface)Message.INVALID_OWNER));
                }
                return false;
            }
        }
        return true;
    }
}

