/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.item;

import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.EventsManager;
import com.ssomar.executableitems.listeners.item.DropFix;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.api.executableitems.events.RemoveItemInPlayerInventoryEvent;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;

public class ItemLeaveInventoryListener
implements Listener {
    public static ItemLeaveInventoryListener instance;
    private Map<UUID, DropFix> dropFixMap = new HashMap<UUID, DropFix>();

    public ItemLeaveInventoryListener() {
        instance = this;
    }

    @EventHandler
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent e) {
        ItemFrame itemFrame;
        Player p = e.getPlayer();
        ItemStack itemHand = null;
        itemHand = !SCore.is1v12Less() ? p.getInventory().getItem(e.getHand()) : (SCore.is1v8() ? p.getInventory().getItemInHand() : p.getInventory().getItemInMainHand());
        ExecutableItemObject ei = new ExecutableItemObject(itemHand);
        if (ei.isValid() && e.getRightClicked() instanceof ItemFrame && (itemFrame = (ItemFrame)e.getRightClicked()).getItem().getType() == Material.AIR) {
            int slot = e.getHand().ordinal();
            slot = slot == 1 ? 40 : p.getInventory().getHeldItemSlot();
            ItemLeaveInventoryListener.activeItemLeaveInventory(itemHand, slot, p, (Event)e);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent e) {
        InventoryAction action = e.getAction();
        ClickType clickType = e.getClick();
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (e.getInventory().getHolder() instanceof Player) {
            p = (Player)e.getInventory().getHolder();
        }
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            ArrayList<InventoryAction> actionList = new ArrayList<InventoryAction>();
            actionList.add(InventoryAction.PICKUP_ALL);
            actionList.add(InventoryAction.PICKUP_ONE);
            actionList.add(InventoryAction.PICKUP_HALF);
            actionList.add(InventoryAction.MOVE_TO_OTHER_INVENTORY);
            actionList.add(InventoryAction.SWAP_WITH_CURSOR);
            if (actionList.contains(action)) {
                ItemLeaveInventoryListener.activeItemLeaveInventory(e.getCurrentItem(), e.getSlot(), p, (Event)e);
            } else if (action.equals((Object)InventoryAction.HOTBAR_SWAP) || action.equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD)) {
                if (clickType.equals((Object)ClickType.NUMBER_KEY)) {
                    int n = e.getHotbarButton();
                    ItemLeaveInventoryListener.activeItemLeaveInventory(e.getCurrentItem(), e.getSlot(), p, (Event)e);
                    ItemLeaveInventoryListener.activeItemLeaveInventory(p.getInventory().getItem(n), n, p, (Event)e);
                }
            } else if (action.equals((Object)InventoryAction.DROP_ALL_SLOT) || action.equals((Object)InventoryAction.DROP_ONE_SLOT)) {
                ItemLeaveInventoryListener.activeItemLeaveInventory(e.getCurrentItem(), e.getSlot(), p, (Event)e);
            }
        } else if ((action.equals((Object)InventoryAction.HOTBAR_SWAP) || action.equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD)) && clickType.equals((Object)ClickType.NUMBER_KEY)) {
            int n = e.getHotbarButton();
            ItemLeaveInventoryListener.activeItemLeaveInventory(p.getInventory().getItem(n), n, p, (Event)e);
        }
        if (!SCore.is1v12Less() && clickType.equals((Object)ClickType.SWAP_OFFHAND)) {
            ItemStack offHandItem = p.getInventory().getItemInOffHand();
            ItemLeaveInventoryListener.activeItemLeaveInventory(e.getCurrentItem(), e.getSlot(), p, (Event)e);
            ItemLeaveInventoryListener.activeItemLeaveInventory(offHandItem, 40, p, (Event)e);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDropEventCustom(PlayerDropItemEvent e) {
        DropFix dropFix;
        if (this.dropFixMap.containsKey(e.getPlayer().getUniqueId()) && (dropFix = this.dropFixMap.get(e.getPlayer().getUniqueId())).getItemStack().isSimilar(e.getItemDrop().getItemStack())) {
            ItemLeaveInventoryListener.activeItemLeaveInventory(dropFix.getItemStack(), dropFix.getSlot(), e.getPlayer(), (Event)e);
            this.dropFixMap.remove(e.getPlayer().getUniqueId());
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDeathEvent(PlayerDeathEvent e) {
        if (!e.getKeepInventory()) {
            Player p = e.getEntity();
            ItemStack[] inv = (ItemStack[])p.getInventory().getContents().clone();
            for (int size = 0; size < p.getInventory().getContents().length; ++size) {
                ItemStack item = p.getInventory().getItem(size);
                if (item == null) continue;
                ExecutableItemObject ei = new ExecutableItemObject(item);
                ExecutableItem infoItem = null;
                if (ei.isValid()) {
                    ei.loadExecutableItemInfos();
                    infoItem = ei.getConfig();
                }
                if (infoItem == null || infoItem.getKeepItemOnDeath().getValue().booleanValue()) continue;
                ItemLeaveInventoryListener.activeItemLeaveInventory(item, size, p, (Event)e);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerItemBreakEvent(PlayerItemBreakEvent e) {
        ItemLeaveInventoryListener.activeItemLeaveInventory(e.getBrokenItem(), e.getPlayer().getInventory().first(e.getBrokenItem()), e.getPlayer(), (Event)e);
    }

    @EventHandler
    public void onRemoveItemInPlayerInventoryEvent(RemoveItemInPlayerInventoryEvent e) {
        ItemLeaveInventoryListener.activeItemLeaveInventory(e.getItem(), e.getSlot(), e.getPlayer(), (Event)e);
    }

    public static void activeItemLeaveInventory(ItemStack item, int slot, Player player, Event e) {
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            SsomarDev.testMsg((String)"ITEM NULL", (boolean)true);
            return;
        }
        SsomarDev.testMsg((String)"ITEM NOT NULL", (boolean)true);
        EventInfo eInfo = new EventInfo(e);
        eInfo.setPlayer(Optional.of(player));
        if (slot == player.getInventory().getHeldItemSlot()) {
            eInfo.setForceMainHand(true);
        }
        eInfo.setOption((SOption)Option.EI_LEAVE_THE_PLAYER_INVENTORY);
        EventsManager.getInstance().activeOptionForPlayerForItemStack(player, item, slot, eInfo);
        SsomarDev.testMsg((String)("LEAVE INVENTORY > slot: " + slot + " item: " + item.getType()), (boolean)true);
    }

    public static ItemLeaveInventoryListener getInstance() {
        if (instance == null) {
            instance = new ItemLeaveInventoryListener();
        }
        return instance;
    }

    public Map<UUID, DropFix> getDropFixMap() {
        return this.dropFixMap;
    }
}

