/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.listeners.player.custom;

import com.ssomar.executableitems.executableitems.activators.Option;
import com.ssomar.executableitems.listeners.EventsManager;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.utils.emums.DetailedInput;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Input;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInputEvent;

public class PlayerInputListener
implements Listener {
    private static PlayerInputListener instance;
    public Map<Player, Input> lastInputs;

    public PlayerInputListener() {
        instance = this;
        this.lastInputs = new HashMap<Player, Input>();
    }

    @EventHandler
    public void onPlayerInputEvent(PlayerInputEvent e) {
        EventInfo eInfo = new EventInfo((Event)e);
        eInfo.setPlayer(Optional.of(e.getPlayer()));
        Input input = e.getInput();
        eInfo.setOption((SOption)Option.PLAYER_INPUT);
        if (this.lastInputs.containsKey(e.getPlayer())) {
            Input lastInput = this.lastInputs.get(e.getPlayer());
            if (input.isLeft() != lastInput.isLeft()) {
                if (input.isLeft()) {
                    this.sendInputTrigger(eInfo, DetailedInput.LEFT_PRESS);
                } else {
                    this.sendInputTrigger(eInfo, DetailedInput.LEFT_RELEASE);
                }
            }
            if (input.isRight() != lastInput.isRight()) {
                if (input.isRight()) {
                    this.sendInputTrigger(eInfo, DetailedInput.RIGHT_PRESS);
                } else {
                    this.sendInputTrigger(eInfo, DetailedInput.RIGHT_RELEASE);
                }
            }
            if (input.isForward() != lastInput.isForward()) {
                if (input.isForward()) {
                    this.sendInputTrigger(eInfo, DetailedInput.FORWARD_PRESS);
                } else {
                    this.sendInputTrigger(eInfo, DetailedInput.FORWARD_RELEASE);
                }
            }
            if (input.isBackward() != lastInput.isBackward()) {
                if (input.isBackward()) {
                    this.sendInputTrigger(eInfo, DetailedInput.BACKWARD_PRESS);
                } else {
                    this.sendInputTrigger(eInfo, DetailedInput.BACKWARD_RELEASE);
                }
            }
            if (input.isJump() != lastInput.isJump()) {
                if (input.isJump()) {
                    this.sendInputTrigger(eInfo, DetailedInput.JUMP_PRESS);
                } else {
                    this.sendInputTrigger(eInfo, DetailedInput.JUMP_RELEASE);
                }
            }
            if (input.isSneak() != lastInput.isSneak()) {
                if (input.isSneak()) {
                    this.sendInputTrigger(eInfo, DetailedInput.SNEAK_PRESS);
                } else {
                    this.sendInputTrigger(eInfo, DetailedInput.SNEAK_RELEASE);
                }
            }
            if (input.isSprint() != lastInput.isSprint()) {
                if (input.isSprint()) {
                    this.sendInputTrigger(eInfo, DetailedInput.SPRINT_PRESS);
                } else {
                    this.sendInputTrigger(eInfo, DetailedInput.SPRINT_RELEASE);
                }
            }
        } else {
            if (input.isLeft()) {
                this.sendInputTrigger(eInfo, DetailedInput.LEFT_PRESS);
            } else {
                this.sendInputTrigger(eInfo, DetailedInput.LEFT_RELEASE);
            }
            if (input.isRight()) {
                this.sendInputTrigger(eInfo, DetailedInput.RIGHT_PRESS);
            } else {
                this.sendInputTrigger(eInfo, DetailedInput.RIGHT_RELEASE);
            }
            if (input.isForward()) {
                this.sendInputTrigger(eInfo, DetailedInput.FORWARD_PRESS);
            } else {
                this.sendInputTrigger(eInfo, DetailedInput.FORWARD_RELEASE);
            }
            if (input.isBackward()) {
                this.sendInputTrigger(eInfo, DetailedInput.BACKWARD_PRESS);
            } else {
                this.sendInputTrigger(eInfo, DetailedInput.BACKWARD_RELEASE);
            }
            if (input.isJump()) {
                this.sendInputTrigger(eInfo, DetailedInput.JUMP_PRESS);
            } else {
                this.sendInputTrigger(eInfo, DetailedInput.JUMP_RELEASE);
            }
            if (input.isSneak()) {
                this.sendInputTrigger(eInfo, DetailedInput.SNEAK_PRESS);
            } else {
                this.sendInputTrigger(eInfo, DetailedInput.SNEAK_RELEASE);
            }
            if (input.isSprint()) {
                this.sendInputTrigger(eInfo, DetailedInput.SPRINT_PRESS);
            } else {
                this.sendInputTrigger(eInfo, DetailedInput.SPRINT_RELEASE);
            }
        }
        this.lastInputs.put(e.getPlayer(), input);
    }

    public void sendInputTrigger(EventInfo eventInfo, DetailedInput input) {
        EventInfo clone = eventInfo.clone();
        clone.setDetailedInput(Optional.of(input));
        EventsManager.getInstance().activeOption(clone);
    }

    public static PlayerInputListener getInstance() {
        if (instance == null) {
            instance = new PlayerInputListener();
        }
        return instance;
    }
}

