/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.features.custom.displayConditions.DisplayConditionsFeatures;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.display.DisplayModule;
import com.ssomar.score.utils.display.DisplayPriority;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EIDisplayModule
extends DisplayModule {
    private static EIDisplayModule instance;

    public EIDisplayModule() {
        super((SPlugin)ExecutableItems.plugin, DisplayPriority.HIGHEST);
    }

    public boolean display(@NotNull ItemStack itemStack, @Nullable Player player) {
        ExecutableItemObject eio = new ExecutableItemObject(itemStack);
        if (!eio.isValid()) {
            return false;
        }
        ExecutableItem ei = eio.getConfig();
        DisplayConditionsFeatures dcf = ei.getDisplayConditions();
        if (dcf.getEnableFeature().getValue().booleanValue()) {
            ArrayList<String> errors = new ArrayList<String>();
            if (!dcf.verify(player, eio, errors)) {
                DynamicMeta dMeta = new DynamicMeta(itemStack.getItemMeta());
                eio.refreshName(dMeta);
                eio.refreshLore(dMeta, errors);
                itemStack.setItemMeta(dMeta.getMeta());
            } else {
                DynamicMeta dMeta = new DynamicMeta(itemStack.getItemMeta());
                eio.refreshName(dMeta);
                eio.refreshLore(dMeta);
                itemStack.setItemMeta(dMeta.getMeta());
            }
            return true;
        }
        return false;
    }

    public static EIDisplayModule getInstance() {
        if (instance == null) {
            instance = new EIDisplayModule();
        }
        return instance;
    }
}

