/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ItemStackToExecutableItemConverter;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.executableitems.pack.ExecutableItemsPack;
import com.ssomar.score.SCore;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class GenerationCommand {
    private CommandSender cs;
    private final JSONParser jsonParser = new JSONParser();

    public boolean run(CommandSender sender, String[] args) {
        this.cs = sender;
        if (args.length >= 1) {
            String prompt = "";
            for (String arg : args) {
                prompt = prompt + arg + " ";
            }
            prompt = prompt.trim();
            prompt = StringConverter.decoloredString((String)prompt);
            SendMessage.sendMessageNoPlch((CommandSender)this.cs, (String)("&aGenerating texture for prompt: " + prompt));
            final String finalPrompt = prompt;
            BukkitRunnable runnable = new BukkitRunnable(this){
                final /* synthetic */ GenerationCommand this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    try {
                        URL url = new URL("https://api.ssomar.com/api/texture");
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Content-Type", "application/json");
                        conn.setRequestProperty("x-api-key", "xxx");
                        conn.setConnectTimeout(30000);
                        conn.setReadTimeout(600000);
                        conn.setDoOutput(true);
                        String jsonInputString = "{\"input\": \"" + finalPrompt.replace("\"", "\\\"") + "\"}";
                        try (OutputStream os = conn.getOutputStream();){
                            os.write(jsonInputString.getBytes(StandardCharsets.UTF_8));
                            os.flush();
                        }
                        long startTime = System.currentTimeMillis();
                        SendMessage.sendMessageNoPlch((CommandSender)this.this$0.cs, (String)"&7Request sent, waiting for response...");
                        int responseCode = conn.getResponseCode();
                        SendMessage.sendMessageNoPlch((CommandSender)this.this$0.cs, (String)("&7Response code: " + responseCode));
                        if (responseCode == 200) {
                            String response = this.this$0.readInputStream(conn.getInputStream());
                            JSONObject jsonResponse = (JSONObject)this.this$0.jsonParser.parse(response);
                            this.this$0.processModerationResult((Player)this.this$0.cs, jsonResponse);
                        } else {
                            String error = this.this$0.readInputStream(conn.getErrorStream());
                            SendMessage.sendMessageNoPlch((CommandSender)this.this$0.cs, (String)("&cError: " + error));
                        }
                    }
                    catch (SocketTimeoutException e) {
                        SendMessage.sendMessageNoPlch((CommandSender)this.this$0.cs, (String)"&cTimeout while connecting to API. The server took too long to respond.");
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            SCore.schedulerHook.runAsyncTask((Runnable)runnable, 0L);
        }
        return true;
    }

    private void processModerationResult(Player player, JSONObject jsonResponse) {
        try {
            String b64Image = (String)jsonResponse.getOrDefault((Object)"b64Image", (Object)"");
            String displayConfig = (String)jsonResponse.getOrDefault((Object)"displayConfig", (Object)"");
            JSONObject displayerConf = (JSONObject)this.jsonParser.parse(displayConfig);
            int random = (int)(Math.random() * 1000000.0);
            String outputPath = ExecutableItems.plugin.getPlugin().getDataFolder().getPath() + File.separator + "__textures__";
            File outputDir = null;
            File folder = new File(outputPath);
            File[] files = folder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    outputDir = new File(file.getAbsolutePath() + "/assets/ei");
                    break;
                }
            }
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            String fileName = random + ".png";
            File outputFile = new File(outputDir + File.separator + "textures" + File.separator + "item", fileName);
            outputFile.getParentFile().mkdirs();
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                byte[] imageBytes = Base64.getDecoder().decode(b64Image);
                fos.write(imageBytes);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"parent", (Object)"minecraft:item/handheld");
            HashMap<String, String> textures = new HashMap<String, String>();
            textures.put("layer0", "ei:item/" + random);
            jsonObject.put((Object)"textures", textures);
            String jsonFileName = random + ".json";
            File jsonFile = new File(outputDir + File.separator + "models" + File.separator + "item", jsonFileName);
            jsonFile.getParentFile().mkdirs();
            if (!jsonFile.exists()) {
                jsonFile.createNewFile();
            }
            try (FileWriter fileWriter = new FileWriter(jsonFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                HashMap<String, Object> jsonMap = new HashMap<String, Object>();
                jsonMap.put("parent", jsonObject.get((Object)"parent"));
                jsonMap.put("textures", jsonObject.get((Object)"textures"));
                fileWriter.write(gson.toJson(jsonMap));
            }
            JSONObject jsonObject2 = new JSONObject();
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("type", "minecraft:model");
            model.put("model", "ei:item/" + random);
            jsonObject2.put((Object)"model", model);
            File modelDef = new File(outputDir + File.separator + "items", jsonFileName);
            modelDef.getParentFile().mkdirs();
            if (!modelDef.exists()) {
                modelDef.createNewFile();
            }
            try (FileWriter fileWriter = new FileWriter(modelDef);){
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                HashMap<String, Object> jsonMap = new HashMap<String, Object>();
                jsonMap.put("model", jsonObject2.get((Object)"model"));
                fileWriter.write(gson.toJson(jsonMap));
            }
            SendMessage.sendMessageNoPlch((CommandSender)this.cs, (String)("&aTexture generated successfully! File: " + fileName));
            if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.selfHostPack.name())) {
                ExecutableItemsPack.unregisterPack();
                ExecutableItemsPack.registerPack();
            }
            ExecutableItem i = ItemStackToExecutableItemConverter.convert(new ItemStack(Material.STICK));
            i.setId(random + "");
            i.setPath("plugins/ExecutableItems/items/" + random + ".yml");
            i.getItemModel().setValue(Optional.of("ei:" + random));
            i.save();
            ExecutableItemsManager.getInstance().addLoadedObject((SObject)i);
            ItemStack item = i.buildItem(1, Optional.of(player));
            player.getInventory().addItem(new ItemStack[]{item});
        }
        catch (Exception ex) {
            System.err.println("Error processing moderation result: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private String readInputStream(InputStream is) throws Exception {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }
}

