/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.executableitems;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureForItemNewPaperComponents;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.custom.attributes.attribute.AttributeFullOptionsFeature;
import com.ssomar.score.features.custom.enchantments.enchantment.EnchantmentWithLevelFeature;
import com.ssomar.score.features.custom.nbttags.NBTTags;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.AttributeSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class ItemStackToExecutableItemConverter {
    public static ExecutableItem convert(ItemStack item) {
        ExecutableItem result = new ExecutableItem("NewExecutableItem", "/items");
        if (item == null) {
            return result;
        }
        for (FeatureInterface featureInterface : result.getFeatures()) {
            if (!(featureInterface instanceof FeatureForItemNewPaperComponents)) continue;
            FeatureForItemNewPaperComponents featureForItem = (FeatureForItemNewPaperComponents)featureInterface;
            featureForItem.loadFromItem(FeatureForItemArgs.create((ItemStack)item));
        }
        result.getUsageFeatures().getIsRefreshableClean().setValue(true);
        Material material = item.getType();
        if (!material.equals((Object)Material.AIR)) {
            result.getMaterial().setValue(Optional.of(material));
            short durability = item.getDurability();
            if (durability != 0) {
                result.getDurability().getDurability().setValue(Optional.of(item.getType().getMaxDurability() - durability));
            }
            int attributeCpt = 0;
            if (SCore.is1v19Plus() && material.isItem()) {
                result.getAttributes().getKeepDefaultAttributes().setValue(true);
                result.getAttributes().getIgnoreKeepDefaultAttributesFeature().setValue(false);
            }
            if (item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                for (FeatureInterface feature : result.getFeatures()) {
                    if (!(feature instanceof FeatureForItem)) continue;
                    FeatureForItem featureForItem = (FeatureForItem)feature;
                    featureForItem.loadFromItemMeta(FeatureForItemArgs.create((ItemMeta)meta, (Material)material));
                }
                result.getDisplayName().setValue(meta.getDisplayName());
                if (meta.hasLore()) {
                    result.getLore().setValues(new ArrayList(meta.getLore()));
                } else {
                    result.getLore().setValues(new ArrayList());
                }
                if (!SCore.is1v8() && meta.isUnbreakable()) {
                    result.getUnbreakable().setValue(true);
                }
                if (SCore.is1v21v2Plus()) {
                    if (meta.hasItemModel()) {
                        result.getItemModel().setValue(Optional.of(meta.getItemModel().toString()));
                    }
                    if (meta.hasTooltipStyle()) {
                        result.getTooltipStyle().setValue(Optional.of(meta.getTooltipStyle().toString()));
                    }
                }
                if (!SCore.is1v13Less()) {
                    if (SCore.is1v21v4Plus()) {
                        String value = "";
                        CustomModelDataComponent customModelDataComponent = meta.getCustomModelDataComponent();
                        for (String s : customModelDataComponent.getStrings()) {
                            value = value + s + ";";
                        }
                        for (Float f : customModelDataComponent.getFloats()) {
                            value = value + f + ";";
                        }
                        for (Boolean b : customModelDataComponent.getFlags()) {
                            value = value + b + ";";
                        }
                        if (!value.isEmpty()) {
                            value = value.substring(0, value.length() - 1);
                        }
                        result.getCustomModelData().setValue(Optional.of(value));
                    } else if (meta.hasCustomModelData()) {
                        result.getCustomModelData().setValue(Optional.of(meta.getCustomModelData() + ""));
                    }
                }
                if (SCore.is1v20v5Plus() && meta.hasMaxStackSize()) {
                    result.getCustomStackSize().setValue(Optional.of(meta.getMaxStackSize()));
                }
                if (meta.hasEnchants()) {
                    Map enchants = meta.getEnchants();
                    int i = 0;
                    for (Enchantment e : meta.getEnchants().keySet()) {
                        EnchantmentWithLevelFeature enchantmentWithLevelFeature = new EnchantmentWithLevelFeature((FeatureParentInterface)result.getEnchantments(), "enchantment" + i);
                        enchantmentWithLevelFeature.getEnchantment().setValue(Optional.of(e));
                        enchantmentWithLevelFeature.getLevel().setValue(Optional.of((Integer)enchants.get(e)));
                        result.getEnchantments().getEnchantments().put("enchantment" + i, enchantmentWithLevelFeature);
                        ++i;
                    }
                }
                if (!SCore.is1v13Less() && meta.hasAttributeModifiers()) {
                    Map attributes = meta.getAttributeModifiers().asMap();
                    for (Attribute a : attributes.keySet()) {
                        for (AttributeModifier aM : (Collection)attributes.get(a)) {
                            if (aM.getName().contains("EI-ID")) continue;
                            AttributeFullOptionsFeature attributeFullOptionsFeature = new AttributeFullOptionsFeature((FeatureParentInterface)result.getAttributes(), "attribute" + attributeCpt);
                            attributeFullOptionsFeature.getAttribute().setValue(Optional.of(a));
                            attributeFullOptionsFeature.getOperation().setValue(Optional.of(aM.getOperation()));
                            attributeFullOptionsFeature.getAmount().setValue(Optional.of(aM.getAmount()));
                            attributeFullOptionsFeature.getAttributeName().setValue(aM.getName());
                            try {
                                attributeFullOptionsFeature.getUuid().setValue(aM.getUniqueId());
                            }
                            catch (Exception e) {
                                attributeFullOptionsFeature.getUuid().setValue(UUID.randomUUID());
                            }
                            if (aM.getSlot() == null) {
                                attributeFullOptionsFeature.getSlot().setValue(Optional.of(AttributeSlot.ALL_SLOTS));
                            } else {
                                attributeFullOptionsFeature.getSlot().setValue(Optional.of(AttributeSlot.valueOf((String)aM.getSlot().name().toUpperCase())));
                            }
                            result.getAttributes().getAttributes().put("attribute" + attributeCpt, attributeFullOptionsFeature);
                            ++attributeCpt;
                        }
                    }
                }
                if (result.getFeatures().contains(result.getArmorColor())) {
                    if (meta instanceof LeatherArmorMeta) {
                        LeatherArmorMeta aMeta = (LeatherArmorMeta)meta;
                        result.getArmorColor().setValue(Optional.ofNullable(aMeta.getColor().asRGB()));
                    }
                } else if (result.getFeatures().contains(result.getPotionSettings())) {
                    result.getPotionSettings().load((SPlugin)ExecutableItems.plugin, item, !ExecutableItems.plugin.isLotOfWork());
                }
            }
            try {
                if (!SCore.is1v13Less()) {
                    NBTTags nbtTags = new NBTTags((FeatureParentInterface)result);
                    if (!ExecutableItems.plugin.isLotOfWork()) {
                        nbtTags.load(item);
                    }
                    result.setNbt(nbtTags);
                }
            }
            catch (Exception e) {
                SsomarDev.testMsg((String)("Error while loading NBT tags from item: " + item), (boolean)true);
            }
        }
        return result;
    }
}

