/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems;

import com.ssomar.executableitems.EIDisplayModule;
import com.ssomar.executableitems.MetricsLite;
import com.ssomar.executableitems.commands.CommandsClass;
import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.configs.Message;
import com.ssomar.executableitems.configs.api.PlaceholderAPI;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemLoader;
import com.ssomar.executableitems.listeners.EventsHandler;
import com.ssomar.executableitems.listeners.PlayerDeath;
import com.ssomar.executableitems.listeners.optimize.OptimizedEventsHandler;
import com.ssomar.executableitems.listeners.optimize.OptimizedSlotsVerification;
import com.ssomar.executableitems.pack.ExecutableItemsPack;
import com.ssomar.executableitems.usedapi.PlaceholderAPIExecutableItemsExpansion;
import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.load.ExecutableItemsPostLoadEvent;
import com.ssomar.score.config.Config;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.display.Display;
import com.ssomar.score.utils.display.DisplayModule;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.messages.SendMessage;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ExecutableItems
extends JavaPlugin
implements SPlugin {
    public static final String NAME = "ExecutableItems";
    public static final String NAME_COLOR = "&bExecutableItems";
    public static final String NAME_COLOR_WITH_BRACKETS = "&b[ExecutableItems]";
    public static ExecutableItems plugin;
    private CommandsClass commandClass;
    private boolean reloading = false;

    public static ExecutableItems getPluginSt() {
        return plugin;
    }

    public void onEnable() {
        File backupfolder;
        plugin = this;
        this.sendPluginName();
        this.commandClass = new CommandsClass(this);
        plugin.saveDefaultConfig();
        if (this.isLotOfWork() && SCore.is1v11Less()) {
            plugin.getServer().getLogger().severe("[ExecutableItems] ExecutableItems for 1.11 and less is only for the premium version !");
            this.sendPluginName();
            SCore.plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        Plugin sCore = Bukkit.getPluginManager().getPlugin("SCore");
        if (sCore != null) {
            boolean validVersion = false;
            File[] validVersions = new ArrayList();
            validVersions.add("42.42.42");
            validVersions.add("5.25.5.28");
            validVersions.add("5.25.6.30");
            validVersions.add("5.25.7.5");
            validVersions.add("5.25.7.8");
            validVersions.add("5.25.7.12");
            validVersions.add("5.25.7.18");
            validVersions.add("5.25.7.19");
            validVersions.add("5.25.7.26");
            validVersions.add("5.25.7.28");
            validVersions.add("5.25.7.31");
            validVersions.add("5.25.8.7");
            validVersions.add("5.25.8.13");
            validVersions.add("5.25.8.15");
            validVersions.add("5.25.8.17");
            validVersions.add("5.25.8.20");
            validVersions.add("5.25.8.25");
            validVersions.add("5.25.8.26");
            validVersions.add("5.25.8.27");
            validVersions.add("5.25.8.31");
            validVersions.add("5.25.9.7");
            validVersions.add("5.25.9.13");
            validVersions.add("5.25.9.14");
            validVersions.add("5.25.9.18");
            validVersions.add("5.25.9.21");
            validVersions.add("5.25.9.24");
            validVersions.add("5.25.9.28");
            validVersions.add("5.25.9.30");
            validVersions.add("5.25.10.5");
            validVersions.add("5.25.10.9");
            validVersions.add("5.25.10.12");
            try {
                String scoreVersion = sCore.getDescription().getVersion();
                scoreVersion = scoreVersion.substring(scoreVersion.indexOf(".") + 1);
                String eiVersion = this.getDescription().getVersion();
                eiVersion = eiVersion.substring(eiVersion.indexOf(".") + 1);
                validVersion = scoreVersion.compareTo(eiVersion) >= 0;
            }
            catch (Exception scoreVersion) {
                // empty catch block
            }
            if (!validVersion) {
                plugin.getServer().getLogger().severe("[ExecutableItems] To make this version of EI work you may need to update SCore !");
                plugin.getServer().getLogger().severe("[ExecutableItems] Example if you have EI version X.25.7.23 you need SCore Y.25.7.23 or higher");
            }
            if (!SCore.is1v12Less()) {
                Display.registerDisplayModule((DisplayModule)EIDisplayModule.getInstance());
            }
        }
        if (SCore.is1v13Less() && !SCore.hasNBTAPI) {
            plugin.getServer().getLogger().severe("[ExecutableItems] To make EI work in 1.8 / 1.12 / 1.13 you need to have the plugin NBTAPI ! ( https://www.spigotmc.org/resources/nbt-api.7939/ ) ");
            this.sendPluginName();
            SCore.plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        EventsHandler.getInstance().setup(this);
        GeneralConfig.getInstance();
        if (SCore.is1v21v4Plus() && GeneralConfig.getInstance().isDownloadTexturesPackAtTheNextLoading()) {
            ExecutableItemsPack.downloadPack((CommandSender)Bukkit.getConsoleSender(), true);
            ExecutableItemsPack.unzipPack();
        }
        if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.selfHostPack.name())) {
            ExecutableItemsPack.registerPack();
        }
        if ((backupfolder = new File(ExecutableItems.getPluginSt().getDataFolder() + "/backups")).exists() && backupfolder.isDirectory()) {
            for (File f : backupfolder.listFiles()) {
                try {
                    String name = f.getName();
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy_MM_dd-HH_mm_ss");
                    LocalDateTime now = LocalDateTime.now();
                    if (!LocalDateTime.from(dtf.parse(name)).plusDays(GeneralConfig.getInstance().getIntSetting(GeneralConfig.Setting.deleteBackupsAfterDays.name(), 100000)).isBefore(now)) continue;
                    for (File f2 : f.listFiles()) {
                        f2.delete();
                    }
                    f.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        ExecutableItemLoader.getInstance().setCreateBackup(true);
        ExecutableItemLoader.getInstance().load();
        MessageMain.getInstance().loadMessagesOf((Plugin)plugin, MessageInterface.getMessagesEnum((MessageInterface[])Message.values()));
        this.getCommand("ei").setExecutor((CommandExecutor)this.commandClass);
        int pluginId = 7233;
        MetricsLite metrics = new MetricsLite((Plugin)this, pluginId);
        Utils.sendConsoleMsg((String)("&bExecutableItems &7Items with display conditions : &e " + EIDisplayModule.getInstance().getLoadedIDsString()));
        this.sendPluginName();
        Bukkit.getPluginManager().callEvent((Event)new ExecutableItemsPostLoadEvent());
        if (SCore.hasPlaceholderAPI) {
            new PlaceholderAPIExecutableItemsExpansion(this).register();
        }
    }

    public void onReload(final boolean PluginCommand2, boolean async, final Runnable runAfter, Optional<Player> player) {
        if (this.reloading) {
            SendMessage.sendMessageNoPlch((Player)player.orElse(null), (String)"&bExecutableItems &cThe plugin is already reloading !");
            Utils.sendConsoleMsg((String)"&bExecutableItems &cThe plugin is already reloading !");
            return;
        }
        this.reloading = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ExecutableItems.this.sendPluginName();
                plugin.saveDefaultConfig();
                OptimizedEventsHandler.getInstance().reload();
                OptimizedSlotsVerification.getInstance().reload();
                ExecutableItemLoader.getInstance().reload();
                GeneralConfig.getInstance().reload();
                MessageMain.getInstance().loadMessagesOf((Plugin)plugin, MessageInterface.getMessagesEnum((MessageInterface[])Message.values()));
                if (PluginCommand2) {
                    // empty if block
                }
                Utils.sendConsoleMsg((String)("&bExecutableItems &7Items with display conditions : &e " + EIDisplayModule.getInstance().getLoadedIDsString()));
                ExecutableItems.this.sendPluginName();
                if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.enableGarbageCollectorAfterReload.name())) {
                    System.gc();
                }
                ExecutableItems.this.reloading = false;
                if (runAfter != null) {
                    runAfter.run();
                }
            }
        };
        if (async) {
            SCore.schedulerHook.runAsyncTask(runnable, 0L);
        } else {
            SCore.schedulerHook.runTask(runnable, 0L);
        }
    }

    public void sendPluginName() {
        if (this.isLotOfWork()) {
            Utils.sendConsoleMsg((String)"&7================ &bExecutableItems &7================");
        } else {
            Utils.sendConsoleMsg((String)"&7========&e*&7======== &bExecutableItems &7========&e*&7========");
        }
    }

    public void onDisable() {
        PlayerDeath.getInstance().serverStop();
        Plugin SCore2 = Bukkit.getPluginManager().getPlugin("SCore");
        if (SCore2 != null && SCore2.isEnabled()) {
            ExecutableItemsPack.unregisterPack();
        }
    }

    public String getNameDesign() {
        return NAME_COLOR;
    }

    public String getNameDesignWithBrackets() {
        return NAME_COLOR_WITH_BRACKETS;
    }

    public String getObjectName() {
        return "items";
    }

    public String getObjectNameForPermission(SObject sObject) {
        if (sObject instanceof ExecutableItem) {
            return "item";
        }
        return "item";
    }

    public ExecutableItems getPlugin() {
        return plugin;
    }

    public String getShortName() {
        return "EI";
    }

    public String getNameWithBrackets() {
        return "[ExecutableItems]";
    }

    public boolean isLotOfWork() {
        return PlaceholderAPI.isLotOfWork();
    }

    public int getMaxSObjectsLimit() {
        return 500;
    }

    public Config getPluginConfig() {
        return GeneralConfig.getInstance();
    }
}

