/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.commands;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.commands.DebugMode;
import com.ssomar.executableitems.commands.GenerationCommand;
import com.ssomar.executableitems.commands.RefreshCommand;
import com.ssomar.executableitems.commands.SearchCommand;
import com.ssomar.executableitems.commands.VariableModificationCommand;
import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.configs.api.PlaceholderAPI;
import com.ssomar.executableitems.editor.ExecutableItemsEditor;
import com.ssomar.executableitems.executableitems.BlockToExecutableItemConverter;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.ExecutableItemLoader;
import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.executableitems.executableitems.ItemStackToExecutableItemConverter;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.executableitems.listeners.EventsManager;
import com.ssomar.executableitems.listeners.optimize.OptimizedEventsHandler;
import com.ssomar.executableitems.pack.ExecutableItemsPack;
import com.ssomar.score.SCore;
import com.ssomar.score.actionbar.ActionbarCommands;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.api.executableitems.events.RemoveItemInPlayerInventoryEvent;
import com.ssomar.score.commands.score.CommandsClassAbstract;
import com.ssomar.score.commands.score.DropCommand;
import com.ssomar.score.commands.score.GiveCommand;
import com.ssomar.score.commands.score.GiveFolderCommand;
import com.ssomar.score.commands.score.PathCommand;
import com.ssomar.score.commands.score.clear.ClearCommand;
import com.ssomar.score.commands.score.clear.ClearType;
import com.ssomar.score.editor.SaveSessionPathManager;
import com.ssomar.score.features.custom.variables.real.VariableReal;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.OptionGlobal;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.logging.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CommandsClass
extends CommandsClassAbstract<ExecutableItems> {
    private GiveCommand<ExecutableItems, ExecutableItemsManager, ExecutableItem> giveCommand;
    private GiveFolderCommand<ExecutableItems, ExecutableItemsManager, ExecutableItem> giveFolderCommand;
    private DropCommand<ExecutableItems, ExecutableItemsManager, ExecutableItem> dropCommand;
    private PathCommand<ExecutableItems, ExecutableItemsManager, ExecutableItem> pathCommand;

    public CommandsClass(ExecutableItems main) {
        super((SPlugin)main);
        this.addCommand("reload");
        this.addCommand("create");
        this.addCommand("create-from-block");
        this.addCommand("show");
        this.addCommand("editor");
        this.addCommand("refresh");
        this.addCommand("edit");
        this.addCommand("take");
        this.addCommand("drop");
        this.addCommand("clear");
        this.addCommand("actionbar");
        this.addCommand("delete");
        this.addCommand("inspect");
        this.addCommand("unowned");
        this.addCommand("checkevents");
        this.addCommand("default_items");
        this.addCommand("set_owner");
        this.addCommand("modification");
        this.addCommand("console-modification");
        this.addCommand("debug");
        this.addCommand("search");
        this.addCommand("projectiles");
        this.addCommand("util-set-keepdefaultattributes-all-ei");
        this.addCommand("run-custom-trigger");
        this.addCommand("refresh-pack");
        this.addCommand("download-default-pack");
        this.giveCommand = new GiveCommand((SPlugin)ExecutableItems.plugin, (SObjectManager)ExecutableItemsManager.getInstance());
        this.addCommands(this.giveCommand.getCommands());
        this.giveFolderCommand = new GiveFolderCommand((SPlugin)ExecutableItems.plugin, (SObjectWithFileManager)ExecutableItemsManager.getInstance());
        this.addCommands(this.giveFolderCommand.getCommands());
        this.dropCommand = new DropCommand((SPlugin)ExecutableItems.plugin, (SObjectManager)ExecutableItemsManager.getInstance());
        this.addCommands(this.dropCommand.getCommands());
        this.pathCommand = new PathCommand((SPlugin)ExecutableItems.plugin, (SObjectManager)ExecutableItemsManager.getInstance());
        this.addCommands(this.pathCommand.getCommands());
    }

    public void runCommand(CommandSender sender, Player player, String command, String[] args, String typedCommand) {
        block32 : switch (command) {
            case "test": {
                if (player == null) break;
                PlayerInventory inv = player.getInventory();
                for (int i = 0; i < inv.getSize(); ++i) {
                    ItemStack item = inv.getItem(i);
                    for (int x = 0; x < 10000; ++x) {
                        ExecutableItemObject ei = new ExecutableItemObject(item);
                        if (!ei.isValid()) continue;
                        ei.loadExecutableItemInfos();
                    }
                }
                player.sendMessage("done");
                break;
            }
            case "reload": {
                if (args.length < 1) {
                    this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7Reloading...");
                    Utils.sendConsoleMsg((String)(((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7Reloading..."));
                    Runnable r = () -> {
                        this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7has been reloaded !");
                        Utils.sendConsoleMsg((String)(((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7Successfully reloaded !"));
                    };
                    ((ExecutableItems)this.getSPlugin()).onReload(true, true, r, Optional.ofNullable(player));
                    break;
                }
                String idToReload = args[0];
                if (idToReload.contains("folder:")) {
                    String folderName = idToReload.replace("folder:", "");
                    if (ExecutableItemLoader.getInstance().reloadFolder(folderName)) {
                        this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7The folder &e" + folderName + " &7has been reloaded !");
                        break;
                    }
                    this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cThe folder &6" + folderName + " &cdoes not exist !");
                    break;
                }
                if (ExecutableItemsManager.getInstance().isValidID(idToReload)) {
                    ExecutableItemsManager.getInstance().reloadObject(idToReload);
                    this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7ExecutableItem &e" + idToReload + " &7has been reloaded !");
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cThe ID &6" + idToReload + " &cspecified is not valid !");
                break;
            }
            case "debug": {
                if (player != null) {
                    if (DebugMode.getInstance().getPlayersInDebugMode().contains(player)) {
                        DebugMode.getInstance().getPlayersInDebugMode().remove(player);
                        this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7debug mode &cdisabled &7!");
                        break;
                    }
                    DebugMode.getInstance().getPlayersInDebugMode().add(player);
                    this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7debug mode &aenabled &7!");
                    break;
                }
                if (DebugMode.getInstance().isEnabledInConsole()) {
                    DebugMode.getInstance().setEnabledInConsole(false);
                    this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7debug mode &cdisabled &7!");
                    break;
                }
                DebugMode.getInstance().setEnabledInConsole(true);
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7debug mode &aenabled &7!");
                break;
            }
            case "checkevents": {
                OptimizedEventsHandler.getInstance().displayOptimisation();
                ExecutableItems.plugin.getServer().getLogger().info("================ [ExecutableItems with custom recognition] ================");
                ExecutableItems.plugin.getServer().getLogger().info("Custom recognition takes performance: ");
                ExecutableItems.plugin.getServer().getLogger().info("Many items: can cause problems if you have a many EI and many players.");
                ExecutableItems.plugin.getServer().getLogger().info("0 items: better performance");
                ExecutableItems.plugin.getServer().getLogger().info("Use only custom recognition when its really necessary = better performance");
                ExecutableItems.plugin.getServer().getLogger().info("");
                ExecutableItems.plugin.getServer().getLogger().info("EI with custom recognition >> " + ExecutableItemsManager.getInstance().getObjectsWithCustomRecognition().size());
                ExecutableItems.plugin.getServer().getLogger().info("================ [ExecutableItems with custom recognition] ================");
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7Check events sent in your console !");
                break;
            }
            case "default_items": {
                ExecutableItemLoader.getInstance().createDefaultObjectsFile(!PlaceholderAPI.isLotOfWork(), true);
                Runnable r = () -> this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7ExecutableItems regenerates the default items, check them in the &e/ei show &7!");
                ((ExecutableItems)this.getSPlugin()).onReload(true, true, r, Optional.ofNullable(player));
                break;
            }
            case "download-default-pack": {
                ExecutableItemsPack.downloadPack(sender, false);
                ExecutableItemsPack.unzipPack();
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7Default pack downloaded and unzipped !");
                if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.selfHostPack.name())) {
                    ExecutableItemsPack.unregisterPack();
                    ExecutableItemsPack.registerPack();
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cYou need to set selfHostPack: true in the config.yml");
                return;
            }
            case "inspect": {
                if (player == null) break;
                ItemStack item = player.getInventory().getItemInMainHand();
                ExecutableItemObject ei = new ExecutableItemObject(item);
                if (ei.isValid()) {
                    ei.loadExecutableItemInfos();
                    this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &aItem information :");
                    this.getSm().sendMessage(sender, "&6>> &eItem usage: &6" + ei.getUsage());
                    Optional<UUID> ownerOpt = Optional.ofNullable(ei.getInternalData().getOwnerUUID());
                    if (ownerOpt.isPresent()) {
                        UUID uuid = ownerOpt.get();
                        this.getSm().sendMessage(sender, "&6>> &eItem owner (UUID): &6" + uuid);
                        try {
                            this.getSm().sendMessage(sender, "&6>> &eItem owner (name): &6" + Bukkit.getOfflinePlayer((UUID)uuid).getName());
                        }
                        catch (Exception exception) {}
                    } else {
                        this.getSm().sendMessage(sender, "&6>> &eItem owner (UUID): &cNo owner");
                        this.getSm().sendMessage(sender, "&6>> &eItem owner (name): &cNo owner");
                    }
                    this.getSm().sendMessage(sender, "&6>> &eItem id: &6" + ei.getConfig().getId());
                    for (VariableReal vR : ei.getInternalData().getVariableRealsList()) {
                        this.getSm().sendMessage(sender, "&6>> &eVar &aSCORE-" + ((String)vR.getConfig().getVariableName().getValue().get()).toUpperCase() + ": &6" + vR.getValue());
                    }
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cError no info for this item, it's not an EI");
                break;
            }
            case "create": {
                if (player == null) break;
                if (args.length == 1) {
                    if (ExecutableItemLoader.getInstance().getAllObjectsLowerCases().contains(args[0])) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cError this id already exist re-enter &6/ei create ID &c(ID is the id you want for your new item)");
                        break;
                    }
                    if (ExecutableItemsManager.getInstance().getLoadedObjects().size() >= ExecutableItemsManager.getInstance().getFileLoader().getMaxFreeObjects() && PlaceholderAPI.isLotOfWork()) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cREQUIRE PREMIUM: to add more than &6" + ExecutableItemLoader.getInstance().getMaxFreeObjects() + " items &cyou need the premium version");
                        return;
                    }
                    ItemStack item = SCore.is1v11Less() ? player.getItemInHand() : player.getInventory().getItemInMainHand();
                    ExecutableItem i = ItemStackToExecutableItemConverter.convert(item);
                    i.setId(args[0]);
                    i.setPath("plugins/ExecutableItems/items/" + args[0] + ".yml");
                    i.save();
                    ExecutableItemsManager.getInstance().addLoadedObject((SObject)i);
                    i.openEditor(player);
                    break;
                }
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7To create a new item you need to enter &e/ei create ID &7(ID is the id you want for your new item)");
                break;
            }
            case "create-from-block": {
                if (player == null) break;
                if (args.length == 1) {
                    if (ExecutableItemLoader.getInstance().getAllObjectsLowerCases().contains(args[0])) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cError this id already exist re-enter &6/ei create-from-block ID &c(ID is the id you want for your new item)");
                        break;
                    }
                    if (ExecutableItemsManager.getInstance().getLoadedObjects().size() >= ExecutableItemLoader.getInstance().getMaxFreeObjects() && PlaceholderAPI.isLotOfWork()) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cREQUIRE PREMIUM: to add more than &6" + ExecutableItemLoader.getInstance().getMaxFreeObjects() + " items &cyou need the premium version");
                        return;
                    }
                    Block block = player.getTargetBlock(null, 10);
                    ExecutableItem i = BlockToExecutableItemConverter.convert(block);
                    i.setId(args[0]);
                    i.setPath("plugins/ExecutableItems/items/" + args[0] + ".yml");
                    i.save();
                    ExecutableItemsManager.getInstance().addLoadedObject((SObject)i);
                    i.openEditor(player);
                    break;
                }
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7To create a new item you need to enter &e/ei create-from-block ID &7(ID is the id you want for your new item)");
                break;
            }
            case "take": {
                if (args.length >= 2) {
                    Player target = sender.getServer().getPlayerExact(args[0]);
                    if (target == null) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cInvalid player for &6" + args[0] + "&c, verify that the player exist !");
                        return;
                    }
                    if (!ExecutableItemLoader.getInstance().getAllObjects().contains(args[1])) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cThis ExecutableItems doesn't exist please enter a good ID &6/ei take {playerName} {itemID} {quantity}");
                        return;
                    }
                    int quantity = 1;
                    if (args.length == 3) {
                        try {
                            quantity = Integer.valueOf(args[2]);
                        }
                        catch (Exception ignored) {
                            this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cInvalid quantity for &6" + args[2] + "&c, verify that the quantity is a number !");
                        }
                    }
                    PlayerInventory inv = target.getInventory();
                    int slot = 0;
                    for (ItemStack is : inv.getContents()) {
                        ExecutableItem executableItem;
                        Optional<ExecutableItemInterface> eiOpt;
                        if (quantity == 0) break block32;
                        if (is != null && (eiOpt = ExecutableItemsManager.getInstance().getExecutableItem(is)).isPresent() && (executableItem = (ExecutableItem)eiOpt.get()).getId().equals(args[1])) {
                            RemoveItemInPlayerInventoryEvent eventToCall = new RemoveItemInPlayerInventoryEvent(target, is, slot);
                            Bukkit.getPluginManager().callEvent((Event)eventToCall);
                            if (is.getAmount() <= quantity) {
                                quantity -= is.getAmount();
                                is.setAmount(0);
                            } else {
                                is.setAmount(is.getAmount() - quantity);
                                quantity = 0;
                            }
                        }
                        ++slot;
                    }
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cInvalid command, look the example: &6/ei take {playerName} {itemID} {quantity}");
                break;
            }
            case "show": 
            case "editor": {
                if (player == null) break;
                NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new ExecutableItemsEditor());
                break;
            }
            case "edit": {
                if (player == null) break;
                SaveSessionPathManager.getInstance().clearPlayerSessionPath(player);
                if (args.length > 0) {
                    try {
                        Optional ei = ExecutableItemsManager.getInstance().getLoadedObjectWithID(args[0]);
                        if (ei.isPresent()) {
                            ((ExecutableItem)((Object)ei.get())).openEditor(player);
                            break;
                        }
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cThis ExecutableItem &6" + args[0] + " &cdoesn't exist");
                    }
                    catch (NullPointerException e) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cError > Invalid ItemID &6/ei edit {ItemID}");
                    }
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cError > Invalid ItemID &6/ei edit {ItemID}");
                break;
            }
            case "search": {
                SearchCommand sc = new SearchCommand();
                if (!sc.verify(sender, args)) break;
                sc.run();
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7The results has been also displayed in your console.");
                break;
            }
            case "generate": {
                GenerationCommand gc = new GenerationCommand();
                if (!gc.run(sender, args)) break;
                break;
            }
            case "refresh-pack": {
                if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.selfHostPack.name())) {
                    ExecutableItemsPack.unregisterPack();
                    ExecutableItemsPack.registerPack();
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cYou need to set selfHostPack: true in the config.yml");
                return;
            }
            case "refresh": {
                new RefreshCommand(sender, args);
                break;
            }
            case "clear": {
                ClearCommand.clearCmd((SPlugin)ExecutableItems.plugin, (CommandSender)sender, (String[])args);
                break;
            }
            case "actionbar": {
                if (sender instanceof Player) {
                    if (args.length == 1) {
                        ActionbarCommands.manageCommand((Player)((Player)sender), (String)args[0]);
                        break;
                    }
                    this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &6/ei actionbar on &cor &6/ei actionbar off");
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cThis is only an In-game command !");
                break;
            }
            case "delete": {
                if (args.length == 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cTo confirm the delete type &6/ei delete {itemID} confirm");
                        return;
                    }
                    Optional eiOpt = ExecutableItemsManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (eiOpt.isPresent()) {
                        ExecutableItemsManager.getInstance().deleteObject(args[0]);
                        this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7Item &e" + args[0] + " &7deleted");
                        if (player == null) break;
                        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new ExecutableItemsEditor());
                        break;
                    }
                    this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cItem &6" + args[0] + " &cnot found");
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cTo confirm the delete type &6/ei delete {itemID} confirm");
                break;
            }
            case "unowned": {
                ExecutableItemObject ei;
                if (player == null) break;
                ItemStack item = player.getInventory().getItemInMainHand();
                if (item != null && !item.getType().equals((Object)Material.AIR) && (ei = new ExecutableItemObject(item)).isValid()) {
                    ei.loadExecutableItemInfos();
                    ei.reloadOwner(null);
                }
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7You have clear the owner of this item !");
                break;
            }
            case "set_owner": {
                if (player == null) break;
                if (PlaceholderAPI.isLotOfWork()) {
                    this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cREQUIRE PREMIUM: to add an owner to an ExecutableItem !");
                    return;
                }
                ItemStack item = player.getInventory().getItemInMainHand();
                ExecutableItemObject ei = new ExecutableItemObject(item);
                if (ei.isValid()) {
                    ei.loadExecutableItemInfos();
                    if (args.length == 1) {
                        OfflinePlayer p = Bukkit.getServer().getOfflinePlayer(args[0]);
                        if (p != null && p.hasPlayedBefore()) {
                            Optional<String> error = ei.reloadOwner(p);
                            if (error.isPresent()) {
                                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cERROR: &6" + error.get());
                                return;
                            }
                            this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7Owner edited on this item ! &7(You can check with &e/ei inspect&7)");
                            return;
                        }
                        this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cERROR invalid player name: &6" + args[0]);
                        break;
                    }
                    this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cERROR invalid argument: &6/ei set_owner {playerName}");
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cERROR the item in your hand is not an ExecutableItem !");
                break;
            }
            case "modification": {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    VariableModificationCommand modifCmd = new VariableModificationCommand(command, args, p);
                    modifCmd.run();
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cThis is only an In-game command ! Use &6/ei console-modification");
                break;
            }
            case "console-modification": {
                if (!(sender instanceof Player)) {
                    VariableModificationCommand modifCmd = new VariableModificationCommand(command, args, null);
                    modifCmd.run();
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + ((ExecutableItems)this.getSPlugin()).getNameWithBrackets() + " &cThis is only a console command ! Use &6/ei modification");
                break;
            }
            case "projectiles": {
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7To open the editor of custom projectiles type: &e/score projectiles");
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7To create a new custom projectile type: &e/score projectiles-create");
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7To delete a custom projectile type: &e/score projectiles-delete");
                break;
            }
            case "util-set-keepdefaultattributes-all-ei": {
                boolean keepDefaultAttributes = true;
                if (args.length == 1) {
                    keepDefaultAttributes = Boolean.parseBoolean(args[0]);
                } else {
                    this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7To set all ExecutableItems to keep default attributes: &e/ei util-set-keepdefaultattributes-all-ei {true/false}");
                }
                for (ExecutableItem ei : ExecutableItemsManager.getInstance().getLoadedObjects()) {
                    ei.getAttributes().getIgnoreKeepDefaultAttributesFeature().setValue(false);
                    ei.getAttributes().getKeepDefaultAttributes().setValue(keepDefaultAttributes);
                    ei.save();
                }
                this.getSm().sendMessage(sender, ((ExecutableItems)this.getSPlugin()).getNameDesign() + " &7All ExecutableItems have been set to keep default attributes: &e" + keepDefaultAttributes);
                break;
            }
            case "run-custom-trigger": {
                ArrayList<String> trigger = new ArrayList<String>();
                Optional<Object> player1 = Optional.empty();
                Optional<Object> slot = Optional.empty();
                HashMap<String, String> otherArgs = new HashMap<String, String>();
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("trigger:")) {
                        String string = args[i].replace("trigger:", "");
                        if (string.startsWith("[") && string.endsWith("]")) {
                            String[] triggers;
                            String string3 = string.replace("[", "");
                            string3 = string3.replace("]", "");
                            for (String t : triggers = string3.split(",")) {
                                trigger.add(t);
                            }
                            continue;
                        }
                        trigger.add(string);
                        continue;
                    }
                    if (args[i].startsWith("player:")) {
                        String string = args[i].replace("player:", "");
                        player1 = Optional.ofNullable(Bukkit.getPlayer((String)string));
                        continue;
                    }
                    if (args[i].startsWith("slot:")) {
                        slot = Optional.of(Integer.parseInt(args[i].replace("slot:", "")));
                        continue;
                    }
                    otherArgs.put("%arg" + otherArgs.size() + "%", args[i]);
                }
                String allArgs = "";
                for (String arg : args) {
                    allArgs = allArgs + arg + " ";
                }
                if (!allArgs.isEmpty()) {
                    allArgs = allArgs.substring(0, allArgs.length() - 1);
                }
                otherArgs.put("%all_args%", allArgs);
                EventInfo eventInfo = new EventInfo(null);
                eventInfo.setOption((SOption)OptionGlobal.CUSTOM_TRIGGER);
                eventInfo.setWhitelistActivatorsId(trigger);
                eventInfo.setPlaceholders(otherArgs);
                if (player1.isPresent()) {
                    eventInfo.setPlayer(player1);
                    if (slot.isPresent()) {
                        int realSlot = (Integer)slot.get();
                        ItemStack item = null;
                        if (realSlot == -1) {
                            realSlot = ((Player)player1.get()).getInventory().getHeldItemSlot();
                        }
                        item = ((Player)player1.get()).getInventory().getItem(realSlot);
                        EventsManager.getInstance().activeOptionForPlayerForItemStack((Player)player1.get(), item, realSlot, eventInfo);
                        break;
                    }
                    EventsManager.getInstance().activeOption(eventInfo);
                    break;
                }
                EventsManager.getInstance().activeOptionAllPlayer(eventInfo);
                break;
            }
            default: {
                this.giveCommand.run(sender, command, args, typedCommand);
                this.giveFolderCommand.run(sender, command, args, typedCommand);
                this.dropCommand.run(sender, command, args, typedCommand);
                this.pathCommand.run(sender, command, args, typedCommand);
            }
        }
    }

    public List<String> getOnTabCompleteArguments(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (args.length >= 2) {
            switch (args[0]) {
                case "clear": {
                    if (args.length != 3) break;
                    for (ClearType type : ClearType.values()) {
                        arguments.add(type.name());
                    }
                    return arguments;
                }
                case "refresh": {
                    if (args.length == 3) {
                        return ExecutableItemsManager.getInstance().getLoadedObjectsWith(args[2]);
                    }
                    if (args.length < 4) break;
                    for (ResetSetting resetSetting : ResetSetting.values()) {
                        arguments.add(resetSetting.name());
                    }
                    return arguments;
                }
                case "take": {
                    if (args.length == 3) {
                        return ExecutableItemsManager.getInstance().getLoadedObjectsWith(args[2]);
                    }
                    if (args.length != 4) break;
                    arguments.addAll(CommandsClass.getArgumentsQuantity());
                    return arguments;
                }
                case "edit": {
                    if (args.length != 2) break;
                    return ExecutableItemsManager.getInstance().getLoadedObjectsWith(args[1]);
                }
                case "actionbar": {
                    if (args.length != 2) break;
                    arguments.add("on");
                    arguments.add("off");
                    return arguments;
                }
                case "modification": 
                case "console-modification": {
                    if (args.length == 2) {
                        arguments.add("set");
                        arguments.add("modification");
                        return arguments;
                    }
                    if (args.length != 3) break;
                    arguments.add("usage");
                    arguments.add("variable");
                    return arguments;
                }
                case "reload": {
                    if (args.length != 2) break;
                    arguments.addAll(ExecutableItemsManager.getInstance().getLoadedObjectsWith(args[1]));
                    for (String str : ExecutableItemLoader.getInstance().getAllFoldersName()) {
                        arguments.add("folder:" + str);
                    }
                    return arguments;
                }
                case "delete": {
                    if (args.length == 2) {
                        return ExecutableItemsManager.getInstance().getLoadedObjectsWith(args[1]);
                    }
                    if (args.length == 3) {
                        arguments.add("confirm");
                        return arguments;
                    }
                }
                default: {
                    arguments.addAll(this.giveCommand.getArguments(args[0], args));
                    arguments.addAll(this.giveFolderCommand.getArguments(args[0], args));
                    arguments.addAll(this.dropCommand.getArguments(args[0], args));
                    arguments.addAll(this.pathCommand.getArguments(args[0], args));
                    if (arguments.isEmpty()) break;
                    return arguments;
                }
            }
        }
        return new ArrayList<String>();
    }
}

