/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.dialogs;

import io.papermc.paper.dialog.Dialog;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class ChatDialogLink {
    private final Map<UUID, Dialog> pending = new ConcurrentHashMap<UUID, Dialog>();
    private final ScheduledExecutorService sweeper = Executors.newSingleThreadScheduledExecutor();

    public ChatDialogLink() {
        this.sweeper.scheduleAtFixedRate(() -> {
            if (this.pending.size() > 5000) {
                this.pending.clear();
            }
        }, 2L, 2L, TimeUnit.MINUTES);
    }

    public void sendItemAnnouncement(Player player, ItemStack stack, Dialog dialog) {
        TextComponent itemName = Component.text((String)"Test");
        Component base = ((TextComponent)((TextComponent)Component.text((String)"You received ").append(itemName.colorIfAbsent((TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append(this.configureButton(player, dialog));
        player.sendMessage(base);
    }

    public Component configureButton(Player player, Dialog dialog) {
        Component btn = Component.text((String)"[Configure]", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.UNDERLINED}).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Open item settings")));
        return btn.clickEvent(ClickEvent.showDialog((DialogLike)dialog));
    }

    public boolean handleOpenDialogCommand(Player player, String tokenStr) {
        try {
            UUID token = UUID.fromString(tokenStr);
            Dialog dialog = this.pending.remove(token);
            if (dialog == null) {
                return false;
            }
            player.showDialog((DialogLike)dialog);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public void shutdown() {
        this.sweeper.shutdown();
    }
}

