/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.executableitems.executableitems;

import com.ssomar.executableitems.ExecutableItems;
import com.ssomar.executableitems.configs.GeneralConfig;
import com.ssomar.executableitems.configs.api.PlaceholderAPI;
import com.ssomar.executableitems.executableitems.ConfigConverter;
import com.ssomar.executableitems.executableitems.ExecutableItem;
import com.ssomar.executableitems.executableitems.manager.ExecutableItemsManager;
import com.ssomar.executableitems.utils.ZipUtility;
import com.ssomar.score.events.loop.LoopManager;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ExecutableItemLoader
extends SObjectWithFileLoader<ExecutableItem> {
    private static final String EI_PACK_1 = "EI_PACK_1";
    private static final String EI_PACK_2 = "EI_PACK_2";
    private static ExecutableItemLoader instance;
    private boolean createBackup = false;

    public ExecutableItemLoader() {
        super((SPlugin)ExecutableItems.plugin, "/com/ssomar/executableitems/configs/items/", (SObjectWithFileManager)ExecutableItemsManager.getInstance(), 500);
    }

    public static ExecutableItemLoader getInstance() {
        if (instance == null) {
            instance = new ExecutableItemLoader();
        }
        return instance;
    }

    public void load() {
        LoopManager.getInstance().resetLoopActivators((SPlugin)ExecutableItems.plugin);
        ExecutableItemsManager.getInstance().setDefaultObjects(new ArrayList());
        if (!GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.disableTestItems.name())) {
            if (PlaceholderAPI.isLotOfWork()) {
                this.loadDefaultPremiumObjects();
            }
            this.loadDefaultEncodedPremiumObjects(this.getPremiumPackObjectsName());
        }
        ExecutableItemsManager.getInstance().setLoadedObjects(new ArrayList());
        this.resetCpt();
        File itemsDirectory = new File(ExecutableItems.getPluginSt().getDataFolder() + "/items");
        if (itemsDirectory.exists()) {
            if (this.createBackup && !GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.disableBackup.name())) {
                ZipUtility zipUtility = new ZipUtility();
                try {
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy_MM_dd-HH_mm_ss");
                    LocalDateTime now = LocalDateTime.now();
                    new File(ExecutableItems.getPluginSt().getDataFolder() + "/backups/" + dtf.format(now)).mkdirs();
                    zipUtility.zip(new String[]{itemsDirectory.getPath()}, ExecutableItems.getPluginSt().getDataFolder() + "/backups/" + dtf.format(now) + "/backup.zip");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.createBackup = false;
            }
            this.loadObjectsInFolder(itemsDirectory, !PlaceholderAPI.isLotOfWork());
            Utils.sendConsoleMsg((String)("&bExecutableItems &7Amount of Executable Items configurations loaded: &e" + this.getCpt()));
        } else {
            this.createDefaultObjectsFile(!PlaceholderAPI.isLotOfWork());
            this.load();
        }
    }

    public Map<String, List<String>> getPremiumPackObjectsName() {
        HashMap<String, List<String>> defaultItems = new HashMap<String, List<String>>();
        return defaultItems;
    }

    public void configVersionsConverter(File file) {
        ConfigConverter.updateTo(file);
    }

    public Optional<ExecutableItem> getObject(FileConfiguration itemConfig, String id, boolean showError, boolean isPremiumLoading, String path) {
        ArrayList<String> errors = new ArrayList<String>();
        ExecutableItem item = new ExecutableItem(id, path);
        errors.addAll(item.load(ExecutableItems.plugin, (ConfigurationSection)itemConfig, isPremiumLoading));
        if (showError) {
            for (String s : errors) {
                Utils.sendConsoleMsg((String)("&bExecutableItems " + StringConverter.coloredString((String)s)));
            }
        }
        return Optional.ofNullable(item);
    }

    public boolean isCreateBackup() {
        return this.createBackup;
    }

    public void setCreateBackup(boolean createBackup) {
        this.createBackup = createBackup;
    }
}

